-- "$Header: act3.vhd@@/main/4 $"
-- Actel Vital 95 library
library IEEE;
use IEEE.STD_LOGIC_1164.all;

library IEEE;
use IEEE.VITAL_Timing.all;

package COMPONENTS is

constant DefaultTimingChecksOn : Boolean := True;
constant DefaultXGenerationOn : Boolean := False;
constant DefaultXon : Boolean := False;
constant DefaultMsgOn : Boolean := True;

component AND2
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component AND2A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component AND2B
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component AND3
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component AND3A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component AND3B
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component AND3C
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component AND4
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component AND4A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component AND4B
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component AND4C
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component AND4D
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component AND5B
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_E_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component AO1
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component AO10
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_E_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component AO11
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component AO1A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component AO1B
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component AO1C
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component AO1D
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component AO1E
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component AO2
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component AO2A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component AO2B
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component AO2C
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component AO2D
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component AO2E
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component AO3
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component AO3A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component AO3B
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component AO3C
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component AO4A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component AO5A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component AO6
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component AO6A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component AO7
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_E_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component AO8
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_E_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component AO9
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_E_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component AOI1
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component AOI1A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component AOI1B
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component AOI1C
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component AOI1D
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component AOI2A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component AOI2B
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component AOI3A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component AOI4
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component AOI4A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component AX1
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component AX1A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component AX1B
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component AX1C
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component BBHS
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_E_PAD                      :	VitalDelayType01z := 
               (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns);
      tpd_D_PAD                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_PAD_Y                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PAD                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      PAD                            :	inout STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component BBHSA
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_E_PAD                      :	VitalDelayType01z := 
               (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns);
      tpd_D_PAD                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_IDE_Y                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_PAD_Y                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_IDE                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PAD                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      IDE                            :	in    STD_ULOGIC;
      PAD                            :	inout STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component BBLSA
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_E_PAD                      :	VitalDelayType01z := 
               (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns);
      tpd_D_PAD                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_IDE_Y                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_PAD_Y                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_IDE                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PAD                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      IDE                            :	in    STD_ULOGIC;
      PAD                            :	inout STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component BBUFTH
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_E_PAD                      :	VitalDelayType01z := 
               (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns);
      tpd_D_PAD                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_PAD_Y                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PAD                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      PAD                            :	inout STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component BBUFTL
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_E_PAD                      :	VitalDelayType01z := 
               (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns);
      tpd_D_PAD                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_PAD_Y                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PAD                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      PAD                            :	inout STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component BIBUF
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_E_PAD                      :	VitalDelayType01z := 
               (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns);
      tpd_D_PAD                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_PAD_Y                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PAD                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      PAD                            :	inout STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component BIECTH
	GENERIC (
		--
		-- PinToPinDelay Generics Declaration(s)
		tpd_IOPCL_Q          : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input IOPCL to output Q
		tpd_CLK_Q            : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input CLK to output Q
		tpd_D_PAD            : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input D to output PAD
		tpd_E_PAD            : VitalDelayType01z := (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns); -- Path delay from input E to output PAD

		--
		-- Interconnect Path Delay Generics Declaration(s)
		tipd_CLK             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port CLK
		tipd_D               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port D
		tipd_E               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port E
		tipd_IDE             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port IDE
		tipd_IOPCL           : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port IOPCL
		tipd_PAD             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port PAD
		--
		-- Setup Generics Declaration(s)
		tsetup_PAD_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between PAD and CLK
		tsetup_IDE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between IDE and CLK
		--
		-- Hold Generics Declaration(s)
		thold_PAD_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between PAD and CLK
		thold_IDE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between IDE and CLK
		thold_IOPCL_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Removal time between IOPCL and CLK
		--
		-- Recovery Generics Declaration(s)
		trecovery_IOPCL_CLK_posedge_posedge : VitalDelayType   := 0.000 ns;	-- Recovery time between IOPCL and CLK
		--
		-- Period Check Generics Declaration(s)
		tperiod_CLK_posedge          : VitalDelayType   := 0.000 ns;	-- Minimum period time for CLK
		tpw_CLK_posedge      : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for CLK
		tpw_CLK_negedge      : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for CLK
		tperiod_IOPCL        : VitalDelayType   := 0.000 ns;	-- Minimum period time for IOPCL
		tpw_IOPCL_posedge    : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for IOPCL
		tpw_IOPCL_negedge    : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for IOPCL
		--
		-- InstancePath Will Accompany Any Assertion Messages in the Model
		InstancePath         : STRING           := "*";
		--
		-- 'X' generation control parameter for timing checks and path delay
		XOn                  : BOOLEAN          := TRUE;
		--
		-- Assertion messages generation control parameter for violation of timing checks
		MsgOn                : BOOLEAN          := TRUE;
		--
		-- VitalTimingCheck Switch
		TimingChecksOn       : BOOLEAN          := TRUE
	);
	PORT (
		CLK                 : IN      STD_ULOGIC := 'X';
		D                   : IN      STD_ULOGIC := 'X';
		E                   : IN      STD_ULOGIC := 'X';
		IDE                 : IN      STD_ULOGIC := 'X';
		IOPCL               : IN      STD_ULOGIC := 'X';
		PAD                 : INOUT   STD_ULOGIC := 'X';
		Q                   : OUT     STD_ULOGIC := 'X'
		
	);
	--
	--
end component; 

component BIECTL
	GENERIC (
		--
		-- PinToPinDelay Generics Declaration(s)
		tpd_IOPCL_Q          : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input IOPCL to output Q
		tpd_CLK_Q            : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input CLK to output Q
		tpd_D_PAD            : VitalDelayType01 := (1.000 ns, 1.000 ns); 	-- Path delay from input D to output PAD
		tpd_E_PAD            : VitalDelayType01z := (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns); -- Path delay from input E to output PAD

		--
		-- Interconnect Path Delay Generics Declaration(s)
		tipd_CLK             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port CLK
		tipd_D               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port D
		tipd_E               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port E
		tipd_IDE             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port IDE
		tipd_IOPCL           : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port IOPCL
		tipd_PAD             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port PAD
		--
		-- Setup Generics Declaration(s)
		tsetup_PAD_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between PAD and CLK
		tsetup_IDE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between IDE and CLK
		--
		-- Hold Generics Declaration(s)
		thold_PAD_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between PAD and CLK
		thold_IDE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between IDE and CLK
		thold_IOPCL_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Removal time between IOPCL and CLK
		--
		-- Recovery Generics Declaration(s)
		trecovery_IOPCL_CLK_posedge_posedge : VitalDelayType   := 0.000 ns;	-- Recovery time between IOPCL and CLK
		--
		-- Period Check Generics Declaration(s)
		tperiod_CLK_posedge          : VitalDelayType   := 0.000 ns;	-- Minimum period time for CLK
		tpw_CLK_posedge      : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for CLK
		tpw_CLK_negedge      : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for CLK
		tperiod_IOPCL        : VitalDelayType   := 0.000 ns;	-- Minimum period time for IOPCL
		tpw_IOPCL_posedge    : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for IOPCL
		tpw_IOPCL_negedge    : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for IOPCL
		--
		-- InstancePath Will Accompany Any Assertion Messages in the Model
		InstancePath         : STRING           := "*";
		--
		-- 'X' generation control parameter for timing checks and path delay
		XOn                  : BOOLEAN          := TRUE;
		--
		-- Assertion messages generation control parameter for violation of timing checks
		MsgOn                : BOOLEAN          := TRUE;
		--
		-- VitalTimingCheck Switch
		TimingChecksOn       : BOOLEAN          := TRUE
	);
	PORT (
		CLK                 : IN      STD_ULOGIC := 'X';
		D                   : IN      STD_ULOGIC := 'X';
		E                   : IN      STD_ULOGIC := 'X';
		IDE                 : IN      STD_ULOGIC := 'X';
		IOPCL               : IN      STD_ULOGIC := 'X';
		PAD                 : INOUT   STD_ULOGIC := 'X';
		Q                   : OUT     STD_ULOGIC := 'X'
		
	);
	--
	--
end component; 

component BIEPTH
	GENERIC (
		--
		-- PinToPinDelay Generics Declaration(s)
		tpd_IOPCL_Q          : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input IOPCL to output Q
		tpd_CLK_Q            : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input CLK to output Q
		tpd_D_PAD            : VitalDelayType01 := (1.000 ns, 1.000 ns); 	-- Path delay from input D to output PAD
		tpd_E_PAD            : VitalDelayType01z := (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns); -- Path delay from input E to output PAD

		--
		-- Interconnect Path Delay Generics Declaration(s)
		tipd_CLK             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port CLK
		tipd_D               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port D
		tipd_E               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port E
		tipd_IDE             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port IDE
		tipd_IOPCL           : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port IOPCL
		tipd_PAD             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port PAD
		--
		-- Setup Generics Declaration(s)
		tsetup_PAD_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between PAD and CLK
		tsetup_IDE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between IDE and CLK
		--
		-- Hold Generics Declaration(s)
		thold_PAD_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between PAD and CLK
		thold_IDE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between IDE and CLK
		thold_IOPCL_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between IOPCL and CLK
		--
		-- Recovery Generics Declaration(s)
		trecovery_IOPCL_CLK_posedge_posedge : VitalDelayType   := 0.000 ns;	-- Recovery time between IOPCL and CLK
		--
		-- Period Check Generics Declaration(s)
		tperiod_CLK_posedge          : VitalDelayType   := 0.000 ns;	-- Minimum period time for CLK
		tpw_CLK_posedge      : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for CLK
		tpw_CLK_negedge      : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for CLK
		tperiod_IOPCL        : VitalDelayType   := 0.000 ns;	-- Minimum period time for IOPCL
		tpw_IOPCL_posedge    : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for IOPCL
		tpw_IOPCL_negedge    : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for IOPCL
		--
		-- InstancePath Will Accompany Any Assertion Messages in the Model
		InstancePath         : STRING           := "*";
		--
		-- 'X' generation control parameter for timing checks and path delay
		XOn                  : BOOLEAN          := TRUE;
		--
		-- Assertion messages generation control parameter for violation of timing checks
		MsgOn                : BOOLEAN          := TRUE;
		--
		-- VitalTimingCheck Switch
		TimingChecksOn       : BOOLEAN          := TRUE
	);
	PORT (
		CLK                 : IN      STD_ULOGIC := 'X';
		D                   : IN      STD_ULOGIC := 'X';
		E                   : IN      STD_ULOGIC := 'X';
		IDE                 : IN      STD_ULOGIC := 'X';
		IOPCL               : IN      STD_ULOGIC := 'X';
		PAD                 : INOUT   STD_ULOGIC := 'X';
		Q                   : OUT     STD_ULOGIC := 'X'
		
	);
	--
	--
end component; 

component BIEPTL
	GENERIC (
		--
		-- PinToPinDelay Generics Declaration(s)
		tpd_IOPCL_Q          : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input IOPCL to output Q
		tpd_CLK_Q            : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input CLK to output Q
		tpd_D_PAD            : VitalDelayType01 := (1.000 ns, 1.000 ns); 	-- Path delay from input D to output PAD
		tpd_E_PAD            : VitalDelayType01z := (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns); -- Path delay from input E to output PAD

		--
		-- Interconnect Path Delay Generics Declaration(s)
		tipd_CLK             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port CLK
		tipd_D               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port D
		tipd_E               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port E
		tipd_IDE             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port IDE
		tipd_IOPCL           : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port IOPCL
		tipd_PAD             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port PAD
		--
		-- Setup Generics Declaration(s)
		tsetup_PAD_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between PAD and CLK
		tsetup_IDE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between IDE and CLK
		--
		-- Hold Generics Declaration(s)
		thold_PAD_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between PAD and CLK
		thold_IDE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between IDE and CLK
		thold_IOPCL_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between IOPCL and CLK
		--
		-- Recovery Generics Declaration(s)
		trecovery_IOPCL_CLK_posedge_posedge : VitalDelayType   := 0.000 ns;	-- Recovery time between IOPCL and CLK
		--
		-- Period Check Generics Declaration(s)
		tperiod_CLK_posedge          : VitalDelayType   := 0.000 ns;	-- Minimum period time for CLK
		tpw_CLK_posedge      : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for CLK
		tpw_CLK_negedge      : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for CLK
		tperiod_IOPCL        : VitalDelayType   := 0.000 ns;	-- Minimum period time for IOPCL
		tpw_IOPCL_posedge    : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for IOPCL
		tpw_IOPCL_negedge    : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for IOPCL
		--
		-- InstancePath Will Accompany Any Assertion Messages in the Model
		InstancePath         : STRING           := "*";
		--
		-- 'X' generation control parameter for timing checks and path delay
		XOn                  : BOOLEAN          := TRUE;
		--
		-- Assertion messages generation control parameter for violation of timing checks
		MsgOn                : BOOLEAN          := TRUE;
		--
		-- VitalTimingCheck Switch
		TimingChecksOn       : BOOLEAN          := TRUE
	);
	PORT (
		CLK                 : IN      STD_ULOGIC := 'X';
		D                   : IN      STD_ULOGIC := 'X';
		E                   : IN      STD_ULOGIC := 'X';
		IDE                 : IN      STD_ULOGIC := 'X';
		IOPCL               : IN      STD_ULOGIC := 'X';
		PAD                 : INOUT   STD_ULOGIC := 'X';
		Q                   : OUT     STD_ULOGIC := 'X'
		
	);
	--
	--
end component; 

component BRECTH
	GENERIC (
		--
		-- PinToPinDelay Generics Declaration(s)
		tpd_PAD_Y            : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input PAD to output Y
		tpd_IOPCL_PAD        : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input IOPCL to output PAD
		tpd_CLK_PAD          : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input CLK to output PAD
		tpd_E_PAD            : VitalDelayType01z := (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns); -- Path delay from input E to output PAD

		--
		-- Interconnect Path Delay Generics Declaration(s)
		tipd_CLK             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port CLK
		tipd_D               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port D
		tipd_E               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port E
		tipd_IOPCL           : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port IOPCL
		tipd_ODE             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port ODE
		tipd_PAD             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port PAD
		--
		-- Setup Generics Declaration(s)
		tsetup_D_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between D and CLK
		tsetup_ODE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between ODE and CLK
		--
		-- Hold Generics Declaration(s)
		thold_D_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between D and CLK
		thold_ODE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between ODE and CLK
		thold_IOPCL_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between IOPCL and CLK
		--
		-- Recovery Generics Declaration(s)
		trecovery_IOPCL_CLK_posedge_posedge : VitalDelayType   := 0.000 ns;	-- Recovery time between IOPCL and CLK
		--
		-- Period Check Generics Declaration(s)
		tperiod_CLK_posedge          : VitalDelayType   := 0.000 ns;	-- Minimum period time for CLK
		tpw_CLK_posedge      : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for CLK
		tpw_CLK_negedge      : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for CLK
		tperiod_IOPCL        : VitalDelayType   := 0.000 ns;	-- Minimum period time for IOPCL
		tpw_IOPCL_posedge    : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for IOPCL
		tpw_IOPCL_negedge    : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for IOPCL
		--
		-- InstancePath Will Accompany Any Assertion Messages in the Model
		InstancePath         : STRING           := "*";
		--
		-- 'X' generation control parameter for timing checks and path delay
		XOn                  : BOOLEAN          := TRUE;
		--
		-- Assertion messages generation control parameter for violation of timing checks
		MsgOn                : BOOLEAN          := TRUE;
		--
		-- VitalTimingCheck Switch
		TimingChecksOn       : BOOLEAN          := TRUE
	);
	PORT (
		CLK                 : IN      STD_ULOGIC := 'X';
		D                   : IN      STD_ULOGIC := 'X';
		E                   : IN      STD_ULOGIC := 'X';
		IOPCL               : IN      STD_ULOGIC := 'X';
		ODE                 : IN      STD_ULOGIC := 'X';
		PAD                 : INOUT   STD_ULOGIC := 'X';
		Y                   : OUT     STD_ULOGIC := 'X'
		
	);
	--
	--
end component; 

component BRECTL
	GENERIC (
		--
		-- PinToPinDelay Generics Declaration(s)
		tpd_PAD_Y            : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input PAD to output Y
		tpd_IOPCL_PAD        : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input IOPCL to output PAD
		tpd_CLK_PAD          : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input CLK to output PAD
		tpd_E_PAD            : VitalDelayType01z := (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns); -- Path delay from input E to output PAD

		--
		-- Interconnect Path Delay Generics Declaration(s)
		tipd_CLK             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port CLK
		tipd_D               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port D
		tipd_E               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port E
		tipd_IOPCL           : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port IOPCL
		tipd_ODE             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port ODE
		tipd_PAD             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port PAD
		--
		-- Setup Generics Declaration(s)
		tsetup_D_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between D and CLK
		tsetup_ODE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between ODE and CLK
		--
		-- Hold Generics Declaration(s)
		thold_D_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between D and CLK
		thold_ODE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between ODE and CLK
		thold_IOPCL_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between IOPCL and CLK
		--
		-- Recovery Generics Declaration(s)
		trecovery_IOPCL_CLK_posedge_posedge : VitalDelayType   := 0.000 ns;	-- Recovery time between IOPCL and CLK
		--
		-- Period Check Generics Declaration(s)
		tperiod_CLK_posedge          : VitalDelayType   := 0.000 ns;	-- Minimum period time for CLK
		tpw_CLK_posedge      : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for CLK
		tpw_CLK_negedge      : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for CLK
		tperiod_IOPCL        : VitalDelayType   := 0.000 ns;	-- Minimum period time for IOPCL
		tpw_IOPCL_posedge    : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for IOPCL
		tpw_IOPCL_negedge    : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for IOPCL
		--
		-- InstancePath Will Accompany Any Assertion Messages in the Model
		InstancePath         : STRING           := "*";
		--
		-- 'X' generation control parameter for timing checks and path delay
		XOn                  : BOOLEAN          := TRUE;
		--
		-- Assertion messages generation control parameter for violation of timing checks
		MsgOn                : BOOLEAN          := TRUE;
		--
		-- VitalTimingCheck Switch
		TimingChecksOn       : BOOLEAN          := TRUE
	);
	PORT (
		CLK                 : IN      STD_ULOGIC := 'X';
		D                   : IN      STD_ULOGIC := 'X';
		E                   : IN      STD_ULOGIC := 'X';
		IOPCL               : IN      STD_ULOGIC := 'X';
		ODE                 : IN      STD_ULOGIC := 'X';
		PAD                 : INOUT   STD_ULOGIC := 'X';
		Y                   : OUT     STD_ULOGIC := 'X'
		
	);
	--
	--
end component; 

component BREPTH
	GENERIC (
		--
		-- PinToPinDelay Generics Declaration(s)
		tpd_PAD_Y            : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input PAD to output Y
		tpd_IOPCL_PAD        : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input IOPCL to output PAD
		tpd_CLK_PAD          : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input CLK to output PAD
		tpd_E_PAD            : VitalDelayType01z := (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns); -- Path delay from input E to output PAD

		--
		-- Interconnect Path Delay Generics Declaration(s)
		tipd_CLK             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port CLK
		tipd_D               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port D
		tipd_E               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port E
		tipd_IOPCL           : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port IOPCL
		tipd_ODE             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port ODE
		tipd_PAD             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port PAD
		--
		-- Setup Generics Declaration(s)
		tsetup_D_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between D and CLK
		tsetup_ODE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between ODE and CLK
		--
		-- Hold Generics Declaration(s)
		thold_D_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between D and CLK
		thold_ODE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between ODE and CLK
		thold_IOPCL_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between IOPCL and CLK
		--
		-- Recovery Generics Declaration(s)
		trecovery_IOPCL_CLK_posedge_posedge : VitalDelayType   := 0.000 ns;	-- Recovery time between IOPCL and CLK
		--
		-- Period Check Generics Declaration(s)
		tperiod_CLK_posedge          : VitalDelayType   := 0.000 ns;	-- Minimum period time for CLK
		tpw_CLK_posedge      : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for CLK
		tpw_CLK_negedge      : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for CLK
		tperiod_IOPCL        : VitalDelayType   := 0.000 ns;	-- Minimum period time for IOPCL
		tpw_IOPCL_posedge    : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for IOPCL
		tpw_IOPCL_negedge    : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for IOPCL
		--
		-- InstancePath Will Accompany Any Assertion Messages in the Model
		InstancePath         : STRING           := "*";
		--
		-- 'X' generation control parameter for timing checks and path delay
		XOn                  : BOOLEAN          := TRUE;
		--
		-- Assertion messages generation control parameter for violation of timing checks
		MsgOn                : BOOLEAN          := TRUE;
		--
		-- VitalTimingCheck Switch
		TimingChecksOn       : BOOLEAN          := TRUE
	);
	PORT (
		CLK                 : IN      STD_ULOGIC := 'X';
		D                   : IN      STD_ULOGIC := 'X';
		E                   : IN      STD_ULOGIC := 'X';
		IOPCL               : IN      STD_ULOGIC := 'X';
		ODE                 : IN      STD_ULOGIC := 'X';
		PAD                 : INOUT   STD_ULOGIC := 'X';
		Y                   : OUT     STD_ULOGIC := 'X'
		
	);
	--
	--
end component; 

component BREPTL
	GENERIC (
		--
		-- PinToPinDelay Generics Declaration(s)
		tpd_PAD_Y            : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input PAD to output Y
		tpd_IOPCL_PAD        : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input IOPCL to output PAD
		tpd_CLK_PAD          : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input CLK to output PAD
		tpd_E_PAD            : VitalDelayType01z := (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns); -- Path delay from input E to output PAD

		--
		-- Interconnect Path Delay Generics Declaration(s)
		tipd_CLK             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port CLK
		tipd_D               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port D
		tipd_E               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port E
		tipd_IOPCL           : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port IOPCL
		tipd_ODE             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port ODE
		tipd_PAD             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port PAD
		--
		-- Setup Generics Declaration(s)
		tsetup_D_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between D and CLK
		tsetup_ODE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between ODE and CLK
		--
		-- Hold Generics Declaration(s)
		thold_D_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between D and CLK
		thold_ODE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between ODE and CLK
		thold_IOPCL_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between IOPCL and CLK
		--
		-- Recovery Generics Declaration(s)
		trecovery_IOPCL_CLK_posedge_posedge : VitalDelayType   := 0.000 ns;	-- Recovery time between IOPCL and CLK
		--
		-- Period Check Generics Declaration(s)
		tperiod_CLK_posedge          : VitalDelayType   := 0.000 ns;	-- Minimum period time for CLK
		tpw_CLK_posedge      : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for CLK
		tpw_CLK_negedge      : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for CLK
		tperiod_IOPCL        : VitalDelayType   := 0.000 ns;	-- Minimum period time for IOPCL
		tpw_IOPCL_posedge    : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for IOPCL
		tpw_IOPCL_negedge    : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for IOPCL
		--
		-- InstancePath Will Accompany Any Assertion Messages in the Model
		InstancePath         : STRING           := "*";
		--
		-- 'X' generation control parameter for timing checks and path delay
		XOn                  : BOOLEAN          := TRUE;
		--
		-- Assertion messages generation control parameter for violation of timing checks
		MsgOn                : BOOLEAN          := TRUE;
		--
		-- VitalTimingCheck Switch
		TimingChecksOn       : BOOLEAN          := TRUE
	);
	PORT (
		CLK                 : IN      STD_ULOGIC := 'X';
		D                   : IN      STD_ULOGIC := 'X';
		E                   : IN      STD_ULOGIC := 'X';
		IOPCL               : IN      STD_ULOGIC := 'X';
		ODE                 : IN      STD_ULOGIC := 'X';
		PAD                 : INOUT   STD_ULOGIC := 'X';
		Y                   : OUT     STD_ULOGIC := 'X'
		
	);
	--
	--
end component; 

component BUFA
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component BUFD
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component BUFF
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component CLKBIBUF
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_E_PAD                      :	VitalDelayType01z := 
               (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns);
      tpd_D_PAD                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_PAD_Y                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PAD                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      PAD                            :	inout STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component CLKBUF
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_PAD_Y                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_PAD                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      PAD                            :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component CLKINT
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component CM7
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_S11_Y                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_S10_Y                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_S0_Y                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D3_Y                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D2_Y                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D1_Y                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D0_Y                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S10                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S11                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D0                             :	in    STD_ULOGIC;
      D1                             :	in    STD_ULOGIC;
      D2                             :	in    STD_ULOGIC;
      D3                             :	in    STD_ULOGIC;
      S0                             :	in    STD_ULOGIC;
      S10                            :	in    STD_ULOGIC;
      S11                            :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component CM8
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_S11_Y                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_S10_Y                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_S01_Y                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_S00_Y                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D3_Y                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D2_Y                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D1_Y                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D0_Y                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S00                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S01                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S10                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S11                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D0                             :	in    STD_ULOGIC;
      D1                             :	in    STD_ULOGIC;
      D2                             :	in    STD_ULOGIC;
      D3                             :	in    STD_ULOGIC;
      S00                            :	in    STD_ULOGIC;
      S01                            :	in    STD_ULOGIC;
      S10                            :	in    STD_ULOGIC;
      S11                            :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component CS1
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_S_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component CS2
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_S_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component CY2A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_B1_Y                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B0_Y                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A1_Y                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A0_Y                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_A1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A0                             :	in    STD_ULOGIC;
      A1                             :	in    STD_ULOGIC;
      B0                             :	in    STD_ULOGIC;
      B1                             :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component CY2B
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_B1_Y                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B0_Y                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A1_Y                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A0_Y                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_A1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A0                             :	in    STD_ULOGIC;
      A1                             :	in    STD_ULOGIC;
      B0                             :	in    STD_ULOGIC;
      B1                             :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component DECETH
	GENERIC (
		--
		-- PinToPinDelay Generics Declaration(s)
		tpd_IOPCL_Q          : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input IOPCL to output Q
		tpd_CLK_Q            : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input CLK to output Q
		tpd_PAD_Q            : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input PAD to output Q
		tpd_IOPCL_PAD        : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input IOPCL to output PAD
		tpd_CLK_PAD          : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input CLK to output PAD
		tpd_E_PAD            : VitalDelayType01z := (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns); -- Path delay from input E to output PAD

		--
		-- Interconnect Path Delay Generics Declaration(s)
		tipd_CLK             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port CLK
		tipd_D               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port D
		tipd_E               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port E
		tipd_IDE             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port IDE
		tipd_IOPCL           : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port IOPCL
		tipd_ODE             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port ODE
		tipd_PAD             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port PAD
		--
		-- Setup Generics Declaration(s)
		tsetup_D_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between D and CLK
		tsetup_PAD_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between PAD and CLK
		tsetup_IDE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between IDE and CLK
		tsetup_ODE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between ODE and CLK
		--
		-- Hold Generics Declaration(s)
		thold_D_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between D and CLK
		thold_PAD_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between PAD and CLK
		thold_IDE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between IDE and CLK
		thold_ODE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between ODE and CLK
		thold_IOPCL_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Removal time between IOPCL and CLK
		--
		-- Recovery Generics Declaration(s)
		trecovery_IOPCL_CLK_posedge_posedge : VitalDelayType   := 0.000 ns;	-- Recovery time between IOPCL and CLK
		--
		-- Period Check Generics Declaration(s)
		tperiod_CLK_posedge          : VitalDelayType   := 0.000 ns;	-- Minimum period time for CLK
		tpw_CLK_posedge      : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for CLK
		tpw_CLK_negedge      : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for CLK
		tperiod_IOPCL        : VitalDelayType   := 0.000 ns;	-- Minimum period time for IOPCL
		tpw_IOPCL_posedge    : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for IOPCL
		tpw_IOPCL_negedge    : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for IOPCL
		--
		-- InstancePath Will Accompany Any Assertion Messages in the Model
		InstancePath         : STRING           := "*";
		--
		-- 'X' generation control parameter for timing checks and path delay
		XOn                  : BOOLEAN          := TRUE;
		--
		-- Assertion messages generation control parameter for violation of timing checks
		MsgOn                : BOOLEAN          := TRUE;
		--
		-- VitalTimingCheck Switch
		TimingChecksOn       : BOOLEAN          := TRUE
	);
	PORT (
		CLK                 : IN      STD_ULOGIC := 'X';
		D                   : IN      STD_ULOGIC := 'X';
		E                   : IN      STD_ULOGIC := 'X';
		IDE                 : IN      STD_ULOGIC := 'X';
		IOPCL               : IN      STD_ULOGIC := 'X';
		ODE                 : IN      STD_ULOGIC := 'X';
		PAD                 : INOUT   STD_ULOGIC := 'X';
		Q                   : OUT     STD_ULOGIC := 'X'
		
	);
	--
	--
end component; 

component DECETL
	GENERIC (
		--
		-- PinToPinDelay Generics Declaration(s)
		tpd_IOPCL_Q          : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input IOPCL to output Q
		tpd_CLK_Q            : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input CLK to output Q
		tpd_PAD_Q            : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input PAD to output Q
		tpd_IOPCL_PAD        : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input IOPCL to output PAD
		tpd_CLK_PAD          : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input CLK to output PAD
		tpd_E_PAD            : VitalDelayType01z := (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns); -- Path delay from input E to output PAD

		--
		-- Interconnect Path Delay Generics Declaration(s)
		tipd_CLK             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port CLK
		tipd_D               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port D
		tipd_E               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port E
		tipd_IDE             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port IDE
		tipd_IOPCL           : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port IOPCL
		tipd_ODE             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port ODE
		tipd_PAD             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port PAD
		--
		-- Setup Generics Declaration(s)
		tsetup_D_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between D and CLK
		tsetup_PAD_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between PAD and CLK
		tsetup_IDE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between IDE and CLK
		tsetup_ODE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between ODE and CLK
		--
		-- Hold Generics Declaration(s)
		thold_D_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between D and CLK
		thold_PAD_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between PAD and CLK
		thold_IDE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between IDE and CLK
		thold_ODE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between ODE and CLK
		thold_IOPCL_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Removal time between IOPCL and CLK
		--
		-- Recovery Generics Declaration(s)
		trecovery_IOPCL_CLK_posedge_posedge : VitalDelayType   := 0.000 ns;	-- Recovery time between IOPCL and CLK
		--
		-- Period Check Generics Declaration(s)
		tperiod_CLK_posedge          : VitalDelayType   := 0.000 ns;	-- Minimum period time for CLK
		tpw_CLK_posedge      : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for CLK
		tpw_CLK_negedge      : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for CLK
		tperiod_IOPCL        : VitalDelayType   := 0.000 ns;	-- Minimum period time for IOPCL
		tpw_IOPCL_posedge    : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for IOPCL
		tpw_IOPCL_negedge    : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for IOPCL
		--
		-- InstancePath Will Accompany Any Assertion Messages in the Model
		InstancePath         : STRING           := "*";
		--
		-- 'X' generation control parameter for timing checks and path delay
		XOn                  : BOOLEAN          := TRUE;
		--
		-- Assertion messages generation control parameter for violation of timing checks
		MsgOn                : BOOLEAN          := TRUE;
		--
		-- VitalTimingCheck Switch
		TimingChecksOn       : BOOLEAN          := TRUE
	);
	PORT (
		CLK                 : IN      STD_ULOGIC := 'X';
		D                   : IN      STD_ULOGIC := 'X';
		E                   : IN      STD_ULOGIC := 'X';
		IDE                 : IN      STD_ULOGIC := 'X';
		IOPCL               : IN      STD_ULOGIC := 'X';
		ODE                 : IN      STD_ULOGIC := 'X';
		PAD                 : INOUT   STD_ULOGIC := 'X';
		Q                   : OUT     STD_ULOGIC := 'X'
		
	);
	--
	--
end component; 

component DEPETH
	GENERIC (
		--
		-- PinToPinDelay Generics Declaration(s)
		tpd_IOPCL_Q          : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input IOPCL to output Q
		tpd_CLK_Q            : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input CLK to output Q
		tpd_PAD_Q            : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input PAD to output Q
		tpd_IOPCL_PAD        : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input IOPCL to output PAD
		tpd_CLK_PAD          : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input CLK to output PAD
		tpd_E_PAD            : VitalDelayType01z := (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns); -- Path delay from input E to output PAD

		--
		-- Interconnect Path Delay Generics Declaration(s)
		tipd_CLK             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port CLK
		tipd_D               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port D
		tipd_E               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port E
		tipd_IDE             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port IDE
		tipd_IOPCL           : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port IOPCL
		tipd_ODE             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port ODE
		tipd_PAD             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port PAD
		--
		-- Setup Generics Declaration(s)
		tsetup_D_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between D and CLK
		tsetup_PAD_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between PAD and CLK
		tsetup_IDE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between IDE and CLK
		tsetup_ODE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between ODE and CLK
		--
		-- Hold Generics Declaration(s)
		thold_D_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between D and CLK
		thold_PAD_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between PAD and CLK
		thold_IDE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between IDE and CLK
		thold_ODE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between ODE and CLK
		thold_IOPCL_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between IOPCL and CLK
		--
		-- Recovery Generics Declaration(s)
		trecovery_IOPCL_CLK_posedge_posedge : VitalDelayType   := 0.000 ns;	-- Recovery time between IOPCL and CLK
		--
		-- Period Check Generics Declaration(s)
		tperiod_CLK_posedge          : VitalDelayType   := 0.000 ns;	-- Minimum period time for CLK
		tpw_CLK_posedge      : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for CLK
		tpw_CLK_negedge      : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for CLK
		tperiod_IOPCL        : VitalDelayType   := 0.000 ns;	-- Minimum period time for IOPCL
		tpw_IOPCL_posedge    : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for IOPCL
		tpw_IOPCL_negedge    : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for IOPCL
		--
		-- InstancePath Will Accompany Any Assertion Messages in the Model
		InstancePath         : STRING           := "*";
		--
		-- 'X' generation control parameter for timing checks and path delay
		XOn                  : BOOLEAN          := TRUE;
		--
		-- Assertion messages generation control parameter for violation of timing checks
		MsgOn                : BOOLEAN          := TRUE;
		--
		-- VitalTimingCheck Switch
		TimingChecksOn       : BOOLEAN          := TRUE
	);
	PORT (
		CLK                 : IN      STD_ULOGIC := 'X';
		D                   : IN      STD_ULOGIC := 'X';
		E                   : IN      STD_ULOGIC := 'X';
		IDE                 : IN      STD_ULOGIC := 'X';
		IOPCL               : IN      STD_ULOGIC := 'X';
		ODE                 : IN      STD_ULOGIC := 'X';
		PAD                 : INOUT   STD_ULOGIC := 'X';
		Q                   : OUT     STD_ULOGIC := 'X'
		
	);
	--
	--
end component; 

component DEPETL
	GENERIC (
		--
		-- PinToPinDelay Generics Declaration(s)
		tpd_IOPCL_Q          : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input IOPCL to output Q
		tpd_CLK_Q            : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input CLK to output Q
		tpd_PAD_Q            : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input PAD to output Q
		tpd_IOPCL_PAD        : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input IOPCL to output PAD
		tpd_CLK_PAD          : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input CLK to output PAD
		tpd_E_PAD            : VitalDelayType01z := (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns); -- Path delay from input E to output PAD

		--
		-- Interconnect Path Delay Generics Declaration(s)
		tipd_CLK             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port CLK
		tipd_D               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port D
		tipd_E               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port E
		tipd_IDE             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port IDE
		tipd_IOPCL           : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port IOPCL
		tipd_ODE             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port ODE
		tipd_PAD             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port PAD
		--
		-- Setup Generics Declaration(s)
		tsetup_D_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between D and CLK
		tsetup_PAD_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between PAD and CLK
		tsetup_IDE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between IDE and CLK
		tsetup_ODE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between ODE and CLK
		--
		-- Hold Generics Declaration(s)
		thold_D_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between D and CLK
		thold_PAD_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between PAD and CLK
		thold_IDE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between IDE and CLK
		thold_ODE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between ODE and CLK
		thold_IOPCL_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between IOPCL and CLK
		--
		-- Recovery Generics Declaration(s)
		trecovery_IOPCL_CLK_posedge_posedge : VitalDelayType   := 0.000 ns;	-- Recovery time between IOPCL and CLK
		--
		-- Period Check Generics Declaration(s)
		tperiod_CLK_posedge          : VitalDelayType   := 0.000 ns;	-- Minimum period time for CLK
		tpw_CLK_posedge      : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for CLK
		tpw_CLK_negedge      : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for CLK
		tperiod_IOPCL        : VitalDelayType   := 0.000 ns;	-- Minimum period time for IOPCL
		tpw_IOPCL_posedge    : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for IOPCL
		tpw_IOPCL_negedge    : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for IOPCL
		--
		-- InstancePath Will Accompany Any Assertion Messages in the Model
		InstancePath         : STRING           := "*";
		--
		-- 'X' generation control parameter for timing checks and path delay
		XOn                  : BOOLEAN          := TRUE;
		--
		-- Assertion messages generation control parameter for violation of timing checks
		MsgOn                : BOOLEAN          := TRUE;
		--
		-- VitalTimingCheck Switch
		TimingChecksOn       : BOOLEAN          := TRUE
	);
	PORT (
		CLK                 : IN      STD_ULOGIC := 'X';
		D                   : IN      STD_ULOGIC := 'X';
		E                   : IN      STD_ULOGIC := 'X';
		IDE                 : IN      STD_ULOGIC := 'X';
		IOPCL               : IN      STD_ULOGIC := 'X';
		ODE                 : IN      STD_ULOGIC := 'X';
		PAD                 : INOUT   STD_ULOGIC := 'X';
		Q                   : OUT     STD_ULOGIC := 'X'
		
	);
	--
	--
end component; 

component DF1
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DF1_CC
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DF1A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLK_QN                     :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      QN                             :	out   STD_ULOGIC);
end component; 

component DF1A_CC
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLK_QN                     :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      QN                             :	out   STD_ULOGIC);
end component; 

component DF1B
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DF1B_CC
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DF1C
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLK_QN                     :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      QN                             :	out   STD_ULOGIC);
end component; 

component DF1C_CC
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLK_QN                     :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      QN                             :	out   STD_ULOGIC);
end component; 

component DFC1
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLR_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_CLR_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      trecovery_CLR_CLK_negedge_posedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLR_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DFC1_CC
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLR_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_CLR_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      trecovery_CLR_CLK_negedge_posedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLR_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DFC1A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLR_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_CLR_CLK_noedge_negedge                  :	VitalDelayType := 0.000 ns;
      trecovery_CLR_CLK_negedge_negedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_negedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLR_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DFC1A_CC
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLR_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_CLR_CLK_noedge_negedge                  :	VitalDelayType := 0.000 ns;
      trecovery_CLR_CLK_negedge_negedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_negedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLR_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DFC1B
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLR_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_CLR_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      trecovery_CLR_CLK_posedge_posedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tpw_CLR_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DFC1B_CC
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLR_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_CLR_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      trecovery_CLR_CLK_posedge_posedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tpw_CLR_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DFC1D
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLR_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_CLR_CLK_noedge_negedge                  :	VitalDelayType := 0.000 ns;
      trecovery_CLR_CLK_posedge_negedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_negedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tpw_CLR_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DFC1D_CC
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLR_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_CLR_CLK_noedge_negedge                  :	VitalDelayType := 0.000 ns;
      trecovery_CLR_CLK_posedge_negedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_negedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tpw_CLR_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DFC1E
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLR_QN                     :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_QN                     :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_CLR_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      trecovery_CLR_CLK_posedge_posedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tpw_CLR_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      QN                             :	out   STD_ULOGIC);
end component; 

component DFC1G
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLR_QN                     :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_QN                     :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_CLR_CLK_noedge_negedge                  :	VitalDelayType := 0.000 ns;
      trecovery_CLR_CLK_posedge_negedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_negedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tpw_CLR_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      QN                             :	out   STD_ULOGIC);
end component; 

component DFE
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_E_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_E_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DFE_CC
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_E_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_E_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DFE1B
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_E_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_E_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DFE1B_CC
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_E_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_E_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DFE1C
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_E_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_E_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      tperiod_CLK_negedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DFE1C_CC
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_E_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_E_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      tperiod_CLK_negedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DFE3A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLR_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_E_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_E_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_CLR_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      trecovery_CLR_CLK_posedge_posedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tpw_CLR_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DFE3B
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLR_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_E_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_E_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_CLR_CLK_noedge_negedge                  :	VitalDelayType := 0.000 ns;
      trecovery_CLR_CLK_posedge_negedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_negedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tpw_CLR_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DFE3C
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLR_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_E_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_E_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_CLR_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      trecovery_CLR_CLK_posedge_posedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tpw_CLR_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DFE3D
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLR_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_E_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_E_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_CLR_CLK_noedge_negedge                  :	VitalDelayType := 0.000 ns;
      trecovery_CLR_CLK_posedge_negedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_negedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tpw_CLR_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DFEA
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_E_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_E_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      tperiod_CLK_negedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DFEA_CC
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_E_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_E_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      tperiod_CLK_negedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DFM
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_A_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_A_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_B_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_B_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_S_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_S_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DFM_CC
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_A_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_A_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_B_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_B_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_S_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_S_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DFM1B
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLK_QN                     :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_A_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_A_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_B_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_B_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_S_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_S_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      QN                             :	out   STD_ULOGIC);
end component; 

component DFM1B_CC
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLK_QN                     :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_A_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_A_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_B_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_B_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_S_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_S_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      QN                             :	out   STD_ULOGIC);
end component; 

component DFM1C
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLK_QN                     :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_A_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_A_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_B_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_B_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_S_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_S_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      tperiod_CLK_negedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      QN                             :	out   STD_ULOGIC);
end component; 

component DFM1C_CC
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLK_QN                     :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_A_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_A_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_B_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_B_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_S_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_S_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      tperiod_CLK_negedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      QN                             :	out   STD_ULOGIC);
end component; 

component DFM3
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLR_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_A_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_A_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_B_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_B_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_S_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_S_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_CLR_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      trecovery_CLR_CLK_negedge_posedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLR_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DFM3B
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLR_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_A_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_A_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_B_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_B_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_S_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_S_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_CLR_CLK_noedge_negedge                  :	VitalDelayType := 0.000 ns;
      trecovery_CLR_CLK_posedge_negedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_negedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tpw_CLR_negedge                :	VitalDelayType := 0.000 ns;
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DFM3E
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLR_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_A_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_A_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_B_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_B_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_S_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_S_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_CLR_CLK_noedge_negedge                  :	VitalDelayType := 0.000 ns;
      trecovery_CLR_CLK_negedge_negedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_negedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLR_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DFM4C
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_PRE_QN                     :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_QN                     :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_A_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_A_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_B_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_B_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_S_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_S_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_PRE_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      trecovery_PRE_CLK_posedge_posedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tpw_PRE_negedge                :	VitalDelayType := 0.000 ns;
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PRE                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      PRE                            :	in    STD_ULOGIC;
      QN                             :	out   STD_ULOGIC);
end component; 

component DFM4D
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_PRE_QN                     :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_QN                     :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_A_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_A_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_B_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_B_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_S_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_S_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_PRE_CLK_noedge_negedge                  :	VitalDelayType := 0.000 ns;
      trecovery_PRE_CLK_posedge_negedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_negedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tpw_PRE_negedge                :	VitalDelayType := 0.000 ns;
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PRE                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      PRE                            :	in    STD_ULOGIC;
      QN                             :	out   STD_ULOGIC);
end component; 

component DFM6A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLR_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      thold_D0_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      tsetup_D0_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      thold_D1_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      tsetup_D1_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      thold_D2_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      tsetup_D2_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      thold_D3_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      tsetup_D3_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      thold_S0_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      tsetup_S0_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      thold_S1_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      tsetup_S1_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      thold_CLR_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      trecovery_CLR_CLK_posedge_posedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tpw_CLR_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D0                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D1                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D2                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D3                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_S0                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_S1                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (1.000 ns, 1.000 ns));

   port(
      D0                             :	in    STD_ULOGIC;
      D1                             :	in    STD_ULOGIC;
      D2                             :	in    STD_ULOGIC;
      D3                             :	in    STD_ULOGIC;
      S0                             :	in    STD_ULOGIC;
      S1                             :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DFM6B
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLR_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      thold_D0_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      tsetup_D0_CLK_noedge_negedge                  :	VitalDelayType := 0.000 ns;
      thold_D1_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      tsetup_D1_CLK_noedge_negedge                  :	VitalDelayType := 0.000 ns;
      thold_D2_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      tsetup_D2_CLK_noedge_negedge                  :	VitalDelayType := 0.000 ns;
      thold_D3_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      tsetup_D3_CLK_noedge_negedge                  :	VitalDelayType := 0.000 ns;
      thold_S0_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      tsetup_S0_CLK_noedge_negedge                  :	VitalDelayType := 0.000 ns;
      thold_S1_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      tsetup_S1_CLK_noedge_negedge                  :	VitalDelayType := 0.000 ns;
      thold_CLR_CLK_noedge_negedge                  :	VitalDelayType := 0.000 ns;
      trecovery_CLR_CLK_posedge_negedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_negedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tpw_CLR_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D0                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D1                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D2                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D3                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_S0                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_S1                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (1.000 ns, 1.000 ns));

   port(
      D0                             :	in    STD_ULOGIC;
      D1                             :	in    STD_ULOGIC;
      D2                             :	in    STD_ULOGIC;
      D3                             :	in    STD_ULOGIC;
      S0                             :	in    STD_ULOGIC;
      S1                             :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DFM7A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLR_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      thold_D0_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      tsetup_D0_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      thold_D1_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      tsetup_D1_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      thold_D2_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      tsetup_D2_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      thold_D3_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      tsetup_D3_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      thold_S0_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      tsetup_S0_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      thold_S10_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      tsetup_S10_CLK_noedge_posedge                 :	VitalDelayType := 0.000 ns;
      thold_S11_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      tsetup_S11_CLK_noedge_posedge                 :	VitalDelayType := 0.000 ns;
      thold_CLR_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      trecovery_CLR_CLK_posedge_posedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tpw_CLR_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D0                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D1                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D2                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D3                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_S0                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_S10                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_S11                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (1.000 ns, 1.000 ns));

   port(
      D0                             :	in    STD_ULOGIC;
      D1                             :	in    STD_ULOGIC;
      D2                             :	in    STD_ULOGIC;
      D3                             :	in    STD_ULOGIC;
      S0                             :	in    STD_ULOGIC;
      S10                            :	in    STD_ULOGIC;
      S11                            :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DFM7B
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLR_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      thold_D0_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      tsetup_D0_CLK_noedge_negedge                  :	VitalDelayType := 0.000 ns;
      thold_D1_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      tsetup_D1_CLK_noedge_negedge                  :	VitalDelayType := 0.000 ns;
      thold_D2_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      tsetup_D2_CLK_noedge_negedge                  :	VitalDelayType := 0.000 ns;
      thold_D3_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      tsetup_D3_CLK_noedge_negedge                  :	VitalDelayType := 0.000 ns;
      thold_S0_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      tsetup_S0_CLK_noedge_negedge                  :	VitalDelayType := 0.000 ns;
      thold_S10_CLK_noedge_negedge                  :	VitalDelayType := 0.000 ns;
      tsetup_S10_CLK_noedge_negedge                 :	VitalDelayType := 0.000 ns;
      thold_S11_CLK_noedge_negedge                  :	VitalDelayType := 0.000 ns;
      tsetup_S11_CLK_noedge_negedge                 :	VitalDelayType := 0.000 ns;
      thold_CLR_CLK_noedge_negedge                  :	VitalDelayType := 0.000 ns;
      trecovery_CLR_CLK_posedge_negedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_negedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tpw_CLR_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D0                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D1                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D2                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D3                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_S0                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_S10                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_S11                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (1.000 ns, 1.000 ns));

   port(
      D0                             :	in    STD_ULOGIC;
      D1                             :	in    STD_ULOGIC;
      D2                             :	in    STD_ULOGIC;
      D3                             :	in    STD_ULOGIC;
      S0                             :	in    STD_ULOGIC;
      S10                            :	in    STD_ULOGIC;
      S11                            :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DFM8A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLR_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      thold_D0_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      tsetup_D0_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      thold_D1_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      tsetup_D1_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      thold_D2_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      tsetup_D2_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      thold_D3_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      tsetup_D3_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      thold_S00_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      tsetup_S00_CLK_noedge_posedge                 :	VitalDelayType := 0.000 ns;
      thold_S01_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      tsetup_S01_CLK_noedge_posedge                 :	VitalDelayType := 0.000 ns;
      thold_S10_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      tsetup_S10_CLK_noedge_posedge                 :	VitalDelayType := 0.000 ns;
      thold_S11_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      tsetup_S11_CLK_noedge_posedge                 :	VitalDelayType := 0.000 ns;
      thold_CLR_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      trecovery_CLR_CLK_posedge_posedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tpw_CLR_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D0                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D1                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D2                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D3                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_S00                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_S01                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_S10                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_S11                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (1.000 ns, 1.000 ns));

   port(
      D0                             :	in    STD_ULOGIC;
      D1                             :	in    STD_ULOGIC;
      D2                             :	in    STD_ULOGIC;
      D3                             :	in    STD_ULOGIC;
      S00                            :	in    STD_ULOGIC;
      S01                            :	in    STD_ULOGIC;
      S10                            :	in    STD_ULOGIC;
      S11                            :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DFM8B
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLR_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D0_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      tsetup_D0_CLK_noedge_negedge                  :	VitalDelayType := 0.000 ns;
      thold_D1_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      tsetup_D1_CLK_noedge_negedge                  :	VitalDelayType := 0.000 ns;
      thold_D2_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      tsetup_D2_CLK_noedge_negedge                  :	VitalDelayType := 0.000 ns;
      thold_D3_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      tsetup_D3_CLK_noedge_negedge                  :	VitalDelayType := 0.000 ns;
      thold_S00_CLK_noedge_negedge                  :	VitalDelayType := 0.000 ns;
      tsetup_S00_CLK_noedge_negedge                 :	VitalDelayType := 0.000 ns;
      thold_S01_CLK_noedge_negedge                  :	VitalDelayType := 0.000 ns;
      tsetup_S01_CLK_noedge_negedge                 :	VitalDelayType := 0.000 ns;
      thold_S10_CLK_noedge_negedge                  :	VitalDelayType := 0.000 ns;
      tsetup_S10_CLK_noedge_negedge                 :	VitalDelayType := 0.000 ns;
      thold_S11_CLK_noedge_negedge                  :	VitalDelayType := 0.000 ns;
      tsetup_S11_CLK_noedge_negedge                 :	VitalDelayType := 0.000 ns;
      thold_CLR_CLK_noedge_negedge                  :	VitalDelayType := 0.000 ns;
      trecovery_CLR_CLK_posedge_negedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tpw_CLR_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S00                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S01                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S10                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S11                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D0                             :	in    STD_ULOGIC;
      D1                             :	in    STD_ULOGIC;
      D2                             :	in    STD_ULOGIC;
      D3                             :	in    STD_ULOGIC;
      S00                            :	in    STD_ULOGIC;
      S01                            :	in    STD_ULOGIC;
      S10                            :	in    STD_ULOGIC;
      S11                            :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DFMA
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_A_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_A_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_B_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_B_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_S_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_S_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      tperiod_CLK_negedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DFMA_CC
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_A_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_A_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_B_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_B_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_S_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_S_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      tperiod_CLK_negedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DFMB
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLR_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_A_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_A_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_B_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_B_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_S_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_S_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_CLR_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      trecovery_CLR_CLK_posedge_posedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tpw_CLR_negedge                :	VitalDelayType := 0.000 ns;
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DFME1A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_A_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_A_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_B_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_B_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_S_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_S_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_E_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_E_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DFP1
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_PRE_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_PRE_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      trecovery_PRE_CLK_negedge_posedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_PRE_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PRE                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      PRE                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DFP1_CC
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_PRE_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_PRE_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      trecovery_PRE_CLK_negedge_posedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_PRE_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PRE                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      PRE                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DFP1A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_PRE_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_PRE_CLK_noedge_negedge                  :	VitalDelayType := 0.000 ns;
      trecovery_PRE_CLK_negedge_negedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_negedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_PRE_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PRE                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      PRE                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DFP1A_CC
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_PRE_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_PRE_CLK_noedge_negedge                  :	VitalDelayType := 0.000 ns;
      trecovery_PRE_CLK_negedge_negedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_negedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_PRE_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PRE                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      PRE                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DFP1B
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_PRE_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_PRE_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      trecovery_PRE_CLK_posedge_posedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tpw_PRE_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PRE                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      PRE                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DFP1B_CC
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_PRE_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_PRE_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      trecovery_PRE_CLK_posedge_posedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tpw_PRE_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PRE                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      PRE                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DFP1C
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_PRE_QN                     :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_QN                     :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_PRE_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      trecovery_PRE_CLK_negedge_posedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_PRE_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PRE                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      PRE                            :	in    STD_ULOGIC;
      QN                             :	out   STD_ULOGIC);
end component; 

component DFP1D
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_PRE_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_PRE_CLK_noedge_negedge                  :	VitalDelayType := 0.000 ns;
      trecovery_PRE_CLK_posedge_negedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_negedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tpw_PRE_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PRE                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      PRE                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DFP1D_CC
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_PRE_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_PRE_CLK_noedge_negedge                  :	VitalDelayType := 0.000 ns;
      trecovery_PRE_CLK_posedge_negedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_negedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tpw_PRE_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PRE                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      PRE                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DFP1E
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_PRE_QN                     :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_QN                     :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_PRE_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      trecovery_PRE_CLK_posedge_posedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tpw_PRE_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PRE                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      PRE                            :	in    STD_ULOGIC;
      QN                             :	out   STD_ULOGIC);
end component; 

component DFP1F
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_PRE_QN                     :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_QN                     :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_PRE_CLK_noedge_negedge                  :	VitalDelayType := 0.000 ns;
      trecovery_PRE_CLK_negedge_negedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_negedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_PRE_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PRE                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      PRE                            :	in    STD_ULOGIC;
      QN                             :	out   STD_ULOGIC);
end component; 

component DFP1G
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_PRE_QN                     :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_QN                     :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_PRE_CLK_noedge_negedge                  :	VitalDelayType := 0.000 ns;
      trecovery_PRE_CLK_posedge_negedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_negedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tpw_PRE_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PRE                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      PRE                            :	in    STD_ULOGIC;
      QN                             :	out   STD_ULOGIC);
end component; 

component DFPC
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_PRE_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLR_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_PRE_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      trecovery_PRE_CLK_negedge_posedge              :	VitalDelayType := 0.000 ns;
      thold_CLR_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      trecovery_CLR_CLK_posedge_posedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_PRE_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tpw_CLR_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PRE                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      PRE                            :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DFPC_CC
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_PRE_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLR_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_PRE_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      trecovery_PRE_CLK_negedge_posedge              :	VitalDelayType := 0.000 ns;
      thold_CLR_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      trecovery_CLR_CLK_posedge_posedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_PRE_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tpw_CLR_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PRE                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      PRE                            :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DFPCA
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_PRE_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLR_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_PRE_CLK_noedge_negedge                  :	VitalDelayType := 0.000 ns;
      trecovery_PRE_CLK_negedge_negedge              :	VitalDelayType := 0.000 ns;
      thold_CLR_CLK_noedge_negedge                  :	VitalDelayType := 0.000 ns;
      trecovery_CLR_CLK_posedge_negedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_negedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_PRE_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tpw_CLR_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PRE                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      PRE                            :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DFPCA_CC
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_PRE_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLR_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_PRE_CLK_noedge_negedge                  :	VitalDelayType := 0.000 ns;
      trecovery_PRE_CLK_negedge_negedge              :	VitalDelayType := 0.000 ns;
      thold_CLR_CLK_noedge_negedge                  :	VitalDelayType := 0.000 ns;
      trecovery_CLR_CLK_posedge_negedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_negedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_PRE_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tpw_CLR_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PRE                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      PRE                            :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DL1
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_G_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_G_noedge_negedge                      :	VitalDelayType := 0.000 ns;
      tsetup_D_G_noedge_negedge                     :	VitalDelayType := 0.000 ns;
      tpw_G_posedge                  :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_G                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      G                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DL1A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_QN                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_G_QN                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_G_noedge_negedge                      :	VitalDelayType := 0.000 ns;
      tsetup_D_G_noedge_negedge                     :	VitalDelayType := 0.000 ns;
      tpw_G_posedge                  :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_G                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      G                              :	in    STD_ULOGIC;
      QN                             :	out   STD_ULOGIC);
end component; 

component DL1B
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_G_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_G_noedge_posedge                      :	VitalDelayType := 0.000 ns;
      tsetup_D_G_noedge_posedge                     :	VitalDelayType := 0.000 ns;
      tpw_G_negedge                  :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_G                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      G                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DL1C
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_QN                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_G_QN                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_G_noedge_posedge                      :	VitalDelayType := 0.000 ns;
      tsetup_D_G_noedge_posedge                     :	VitalDelayType := 0.000 ns;
      tpw_G_negedge                  :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_G                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      G                              :	in    STD_ULOGIC;
      QN                             :	out   STD_ULOGIC);
end component; 

component DL2A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_G_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_PRE_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLR_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_G_noedge_negedge                      :	VitalDelayType := 0.000 ns;
      tsetup_D_G_noedge_negedge                     :	VitalDelayType := 0.000 ns;
      thold_PRE_G_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      trecovery_PRE_G_negedge_negedge                :	VitalDelayType := 0.000 ns;
      thold_CLR_G_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      trecovery_CLR_G_posedge_negedge                :	VitalDelayType := 0.000 ns;
      tperiod_G_negedge              :	VitalDelayType := 0.000 ns;
      tpw_G_posedge                  :	VitalDelayType := 0.000 ns;
      tpw_PRE_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLR_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_G                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PRE                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      G                              :	in    STD_ULOGIC;
      PRE                            :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DL2B
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_QN                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_G_QN                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_PRE_QN                     :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLR_QN                     :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_G_noedge_posedge                      :	VitalDelayType := 0.000 ns;
      tsetup_D_G_noedge_posedge                     :	VitalDelayType := 0.000 ns;
      thold_PRE_G_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      trecovery_PRE_G_posedge_posedge                :	VitalDelayType := 0.000 ns;
      thold_CLR_G_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      trecovery_CLR_G_negedge_posedge                :	VitalDelayType := 0.000 ns;
      tperiod_G_posedge              :	VitalDelayType := 0.000 ns;
      tpw_CLR_posedge                :	VitalDelayType := 0.000 ns;
      tpw_G_negedge                  :	VitalDelayType := 0.000 ns;
      tpw_PRE_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_G                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PRE                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      G                              :	in    STD_ULOGIC;
      PRE                            :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      QN                             :	out   STD_ULOGIC);
end component; 

component DL2C
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_G_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_PRE_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLR_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_G_noedge_posedge                      :	VitalDelayType := 0.000 ns;
      tsetup_D_G_noedge_posedge                     :	VitalDelayType := 0.000 ns;
      thold_PRE_G_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      trecovery_PRE_G_negedge_posedge                :	VitalDelayType := 0.000 ns;
      thold_CLR_G_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      trecovery_CLR_G_posedge_posedge                :	VitalDelayType := 0.000 ns;
      tperiod_G_posedge              :	VitalDelayType := 0.000 ns;
      tpw_PRE_posedge                :	VitalDelayType := 0.000 ns;
      tpw_G_negedge                  :	VitalDelayType := 0.000 ns;
      tpw_CLR_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_G                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PRE                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      G                              :	in    STD_ULOGIC;
      PRE                            :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DL2D
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_QN                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_G_QN                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_PRE_QN                     :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLR_QN                     :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_G_noedge_negedge                      :	VitalDelayType := 0.000 ns;
      tsetup_D_G_noedge_negedge                     :	VitalDelayType := 0.000 ns;
      thold_PRE_G_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      trecovery_PRE_G_posedge_negedge                :	VitalDelayType := 0.000 ns;
      thold_CLR_G_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      trecovery_CLR_G_negedge_negedge                :	VitalDelayType := 0.000 ns;
      tperiod_G_negedge              :	VitalDelayType := 0.000 ns;
      tpw_G_posedge                  :	VitalDelayType := 0.000 ns;
      tpw_CLR_posedge                :	VitalDelayType := 0.000 ns;
      tpw_PRE_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_G                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PRE                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      G                              :	in    STD_ULOGIC;
      PRE                            :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      QN                             :	out   STD_ULOGIC);
end component; 

component DLC
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_G_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLR_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_G_noedge_negedge                      :	VitalDelayType := 0.000 ns;
      tsetup_D_G_noedge_negedge                     :	VitalDelayType := 0.000 ns;
      thold_CLR_G_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      trecovery_CLR_G_posedge_negedge                :	VitalDelayType := 0.000 ns;
      tperiod_G_negedge              :	VitalDelayType := 0.000 ns;
      tpw_G_posedge                  :	VitalDelayType := 0.000 ns;
      tpw_CLR_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_G                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      G                              :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DLC1
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_G_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLR_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_G_noedge_negedge                      :	VitalDelayType := 0.000 ns;
      tsetup_D_G_noedge_negedge                     :	VitalDelayType := 0.000 ns;
      thold_CLR_G_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      trecovery_CLR_G_negedge_negedge                :	VitalDelayType := 0.000 ns;
      tperiod_G_negedge              :	VitalDelayType := 0.000 ns;
      tpw_G_posedge                  :	VitalDelayType := 0.000 ns;
      tpw_CLR_posedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_G                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      G                              :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DLC1A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_G_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLR_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_G_noedge_posedge                      :	VitalDelayType := 0.000 ns;
      tsetup_D_G_noedge_posedge                     :	VitalDelayType := 0.000 ns;
      thold_CLR_G_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      trecovery_CLR_G_negedge_posedge                :	VitalDelayType := 0.000 ns;
      tperiod_G_posedge              :	VitalDelayType := 0.000 ns;
      tpw_CLR_posedge                :	VitalDelayType := 0.000 ns;
      tpw_G_negedge                  :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_G                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      G                              :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DLC1F
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_QN                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_G_QN                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLR_QN                     :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_G_noedge_negedge                      :	VitalDelayType := 0.000 ns;
      tsetup_D_G_noedge_negedge                     :	VitalDelayType := 0.000 ns;
      thold_CLR_G_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      trecovery_CLR_G_negedge_negedge                :	VitalDelayType := 0.000 ns;
      tperiod_G_negedge              :	VitalDelayType := 0.000 ns;
      tpw_G_posedge                  :	VitalDelayType := 0.000 ns;
      tpw_CLR_posedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_G                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      G                              :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      QN                             :	out   STD_ULOGIC);
end component; 

component DLC1G
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_QN                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_G_QN                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLR_QN                     :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_G_noedge_posedge                      :	VitalDelayType := 0.000 ns;
      tsetup_D_G_noedge_posedge                     :	VitalDelayType := 0.000 ns;
      thold_CLR_G_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      trecovery_CLR_G_negedge_posedge                :	VitalDelayType := 0.000 ns;
      tperiod_G_posedge              :	VitalDelayType := 0.000 ns;
      tpw_CLR_posedge                :	VitalDelayType := 0.000 ns;
      tpw_G_negedge                  :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_G                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      G                              :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      QN                             :	out   STD_ULOGIC);
end component; 

component DLCA
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_G_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLR_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_G_noedge_posedge                      :	VitalDelayType := 0.000 ns;
      tsetup_D_G_noedge_posedge                     :	VitalDelayType := 0.000 ns;
      thold_CLR_G_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      trecovery_CLR_G_posedge_posedge                :	VitalDelayType := 0.000 ns;
      tperiod_G_posedge              :	VitalDelayType := 0.000 ns;
      tpw_G_negedge                  :	VitalDelayType := 0.000 ns;
      tpw_CLR_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_G                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      G                              :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DLE
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_E_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_G_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_G_noedge_negedge                      :	VitalDelayType := 0.000 ns;
      thold_D_E_noedge_negedge                      :	VitalDelayType := 0.000 ns;
      tsetup_D_G_noedge_negedge                     :	VitalDelayType := 0.000 ns;
      tsetup_D_E_noedge_negedge                     :	VitalDelayType := 0.000 ns;
      tperiod_G_negedge              :	VitalDelayType := 0.000 ns;
      tpw_E_posedge                  :	VitalDelayType := 0.000 ns;
      tpw_G_posedge                  :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_G                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      G                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DLE1D
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_QN                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_E_QN                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_G_QN                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_G_noedge_posedge                      :	VitalDelayType := 0.000 ns;
      thold_D_E_noedge_posedge                      :	VitalDelayType := 0.000 ns;
      tsetup_D_G_noedge_posedge                     :	VitalDelayType := 0.000 ns;
      tsetup_D_E_noedge_posedge                     :	VitalDelayType := 0.000 ns;
      tperiod_G_posedge              :	VitalDelayType := 0.000 ns;
      tpw_E_negedge                  :	VitalDelayType := 0.000 ns;
      tpw_G_negedge                  :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_G                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      G                              :	in    STD_ULOGIC;
      QN                             :	out   STD_ULOGIC);
end component; 

component DLE2B
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_E_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_G_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLR_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_G_noedge_posedge                      :	VitalDelayType := 0.000 ns;
      thold_D_E_noedge_posedge                      :	VitalDelayType := 0.000 ns;
      tsetup_D_G_noedge_posedge                     :	VitalDelayType := 0.000 ns;
      tsetup_D_E_noedge_posedge                     :	VitalDelayType := 0.000 ns;
      thold_CLR_G_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      thold_CLR_E_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      trecovery_CLR_G_posedge_posedge                :	VitalDelayType := 0.000 ns;
      trecovery_CLR_E_posedge_posedge                :	VitalDelayType := 0.000 ns;
      tperiod_G_posedge              :	VitalDelayType := 0.000 ns;
      tpw_E_negedge                  :	VitalDelayType := 0.000 ns;
      tpw_G_negedge                  :	VitalDelayType := 0.000 ns;
      tpw_CLR_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_G                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      G                              :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DLE2C
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_E_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_G_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLR_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_G_noedge_posedge                      :	VitalDelayType := 0.000 ns;
      thold_D_E_noedge_posedge                      :	VitalDelayType := 0.000 ns;
      tsetup_D_G_noedge_posedge                     :	VitalDelayType := 0.000 ns;
      tsetup_D_E_noedge_posedge                     :	VitalDelayType := 0.000 ns;
      thold_CLR_G_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      thold_CLR_E_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      trecovery_CLR_G_negedge_posedge                :	VitalDelayType := 0.000 ns;
      trecovery_CLR_E_negedge_posedge                :	VitalDelayType := 0.000 ns;
      tperiod_G_posedge              :	VitalDelayType := 0.000 ns;
      tpw_CLR_posedge                :	VitalDelayType := 0.000 ns;
      tpw_E_negedge                  :	VitalDelayType := 0.000 ns;
      tpw_G_negedge                  :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_G                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      G                              :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DLE3B
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_E_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_G_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_PRE_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_G_noedge_posedge                      :	VitalDelayType := 0.000 ns;
      thold_D_E_noedge_posedge                      :	VitalDelayType := 0.000 ns;
      tsetup_D_G_noedge_posedge                     :	VitalDelayType := 0.000 ns;
      tsetup_D_E_noedge_posedge                     :	VitalDelayType := 0.000 ns;
      thold_PRE_G_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      thold_PRE_E_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      trecovery_PRE_G_negedge_posedge                :	VitalDelayType := 0.000 ns;
      trecovery_PRE_E_negedge_posedge                :	VitalDelayType := 0.000 ns;
      tperiod_G_posedge              :	VitalDelayType := 0.000 ns;
      tpw_PRE_posedge                :	VitalDelayType := 0.000 ns;
      tpw_E_negedge                  :	VitalDelayType := 0.000 ns;
      tpw_G_negedge                  :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_G                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PRE                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      G                              :	in    STD_ULOGIC;
      PRE                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DLE3C
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_E_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_G_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_PRE_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_G_noedge_posedge                      :	VitalDelayType := 0.000 ns;
      thold_D_E_noedge_posedge                      :	VitalDelayType := 0.000 ns;
      tsetup_D_G_noedge_posedge                     :	VitalDelayType := 0.000 ns;
      tsetup_D_E_noedge_posedge                     :	VitalDelayType := 0.000 ns;
      thold_PRE_G_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      thold_PRE_E_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      trecovery_PRE_G_posedge_posedge                :	VitalDelayType := 0.000 ns;
      trecovery_PRE_E_posedge_posedge                :	VitalDelayType := 0.000 ns;
      tperiod_G_posedge              :	VitalDelayType := 0.000 ns;
      tpw_E_negedge                  :	VitalDelayType := 0.000 ns;
      tpw_G_negedge                  :	VitalDelayType := 0.000 ns;
      tpw_PRE_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_G                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PRE                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      G                              :	in    STD_ULOGIC;
      PRE                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DLEA
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_E_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_G_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_E_noedge_posedge                      :	VitalDelayType := 0.000 ns;
      tsetup_D_E_noedge_posedge                     :	VitalDelayType := 0.000 ns;
      thold_D_G_noedge_negedge                      :	VitalDelayType := 0.000 ns;
      tsetup_D_G_noedge_negedge                     :	VitalDelayType := 0.000 ns;
      tperiod_G_negedge              :	VitalDelayType := 0.000 ns;
      tpw_G_posedge                  :	VitalDelayType := 0.000 ns;
      tpw_E_negedge                  :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_G                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      G                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DLEB
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_E_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_G_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_E_noedge_negedge                      :	VitalDelayType := 0.000 ns;
      tsetup_D_E_noedge_negedge                     :	VitalDelayType := 0.000 ns;
      thold_D_G_noedge_posedge                      :	VitalDelayType := 0.000 ns;
      tsetup_D_G_noedge_posedge                     :	VitalDelayType := 0.000 ns;
      tperiod_G_posedge              :	VitalDelayType := 0.000 ns;
      tpw_E_posedge                  :	VitalDelayType := 0.000 ns;
      tpw_G_negedge                  :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_G                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      G                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DLEC
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_E_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_G_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_G_noedge_posedge                      :	VitalDelayType := 0.000 ns;
      thold_D_E_noedge_posedge                      :	VitalDelayType := 0.000 ns;
      tsetup_D_G_noedge_posedge                     :	VitalDelayType := 0.000 ns;
      tsetup_D_E_noedge_posedge                     :	VitalDelayType := 0.000 ns;
      tperiod_G_posedge              :	VitalDelayType := 0.000 ns;
      tpw_E_negedge                  :	VitalDelayType := 0.000 ns;
      tpw_G_negedge                  :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_G                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      G                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DLM
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_A_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_S_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_G_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_A_G_noedge_negedge                      :	VitalDelayType := 0.000 ns;
      tsetup_A_G_noedge_negedge                     :	VitalDelayType := 0.000 ns;
      thold_B_G_noedge_negedge                      :	VitalDelayType := 0.000 ns;
      tsetup_B_G_noedge_negedge                     :	VitalDelayType := 0.000 ns;
      thold_S_G_noedge_negedge                      :	VitalDelayType := 0.000 ns;
      tsetup_S_G_noedge_negedge                     :	VitalDelayType := 0.000 ns;
      tperiod_G_negedge              :	VitalDelayType := 0.000 ns;
      tpw_G_posedge                  :	VitalDelayType := 0.000 ns;
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_G                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      G                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DLM2
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_A_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_B_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_G_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CLR_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      thold_A_G_noedge_negedge                      :	VitalDelayType := 0.000 ns;
      tsetup_A_G_noedge_negedge                     :	VitalDelayType := 0.000 ns;
      thold_B_G_noedge_negedge                      :	VitalDelayType := 0.000 ns;
      tsetup_B_G_noedge_negedge                     :	VitalDelayType := 0.000 ns;
      thold_S_G_noedge_negedge                      :	VitalDelayType := 0.000 ns;
      tsetup_S_G_noedge_negedge                     :	VitalDelayType := 0.000 ns;
      thold_CLR_G_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      trecovery_CLR_G_posedge_negedge                :	VitalDelayType := 0.000 ns;
      tperiod_G_negedge              :	VitalDelayType := 0.000 ns;
      tpw_G_posedge                  :	VitalDelayType := 0.000 ns;
      tpw_CLR_negedge                :	VitalDelayType := 0.000 ns;
      tipd_A                         :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_B                         :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_S                         :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_G                         :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (1.000 ns, 1.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      G                              :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DLM2B
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_A_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_B_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_G_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CLR_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      thold_A_G_noedge_posedge                      :	VitalDelayType := 0.000 ns;
      tsetup_A_G_noedge_posedge                     :	VitalDelayType := 0.000 ns;
      thold_B_G_noedge_posedge                      :	VitalDelayType := 0.000 ns;
      tsetup_B_G_noedge_posedge                     :	VitalDelayType := 0.000 ns;
      thold_S_G_noedge_posedge                      :	VitalDelayType := 0.000 ns;
      tsetup_S_G_noedge_posedge                     :	VitalDelayType := 0.000 ns;
      thold_CLR_G_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      trecovery_CLR_G_posedge_posedge                :	VitalDelayType := 0.000 ns;
      tperiod_G_posedge              :	VitalDelayType := 0.000 ns;
      tpw_G_negedge                  :	VitalDelayType := 0.000 ns;
      tpw_CLR_negedge                :	VitalDelayType := 0.000 ns;
      tipd_A                         :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_B                         :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_S                         :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_G                         :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (1.000 ns, 1.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      G                              :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DLM3
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D0_Q                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_D1_Q                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_D2_Q                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_D3_Q                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S0_Q                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S1_Q                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_G_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      thold_D0_G_noedge_negedge                     :	VitalDelayType := 0.000 ns;
      tsetup_D0_G_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      thold_D1_G_noedge_negedge                     :	VitalDelayType := 0.000 ns;
      tsetup_D1_G_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      thold_D2_G_noedge_negedge                     :	VitalDelayType := 0.000 ns;
      tsetup_D2_G_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      thold_D3_G_noedge_negedge                     :	VitalDelayType := 0.000 ns;
      tsetup_D3_G_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      thold_S0_G_noedge_negedge                     :	VitalDelayType := 0.000 ns;
      tsetup_S0_G_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      thold_S1_G_noedge_negedge                     :	VitalDelayType := 0.000 ns;
      tsetup_S1_G_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tperiod_G_negedge              :	VitalDelayType := 0.000 ns;
      tpw_G_posedge                  :	VitalDelayType := 0.000 ns;
      tipd_D0                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D1                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D2                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D3                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_S0                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_S1                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_G                         :	VitalDelayType01 := (1.000 ns, 1.000 ns));

   port(
      D0                             :	in    STD_ULOGIC;
      D1                             :	in    STD_ULOGIC;
      D2                             :	in    STD_ULOGIC;
      D3                             :	in    STD_ULOGIC;
      S0                             :	in    STD_ULOGIC;
      S1                             :	in    STD_ULOGIC;
      G                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DLM3A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D0_Q                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_D1_Q                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_D2_Q                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_D3_Q                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S0_Q                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S1_Q                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_G_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      thold_D0_G_noedge_posedge                     :	VitalDelayType := 0.000 ns;
      tsetup_D0_G_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      thold_D1_G_noedge_posedge                     :	VitalDelayType := 0.000 ns;
      tsetup_D1_G_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      thold_D2_G_noedge_posedge                     :	VitalDelayType := 0.000 ns;
      tsetup_D2_G_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      thold_D3_G_noedge_posedge                     :	VitalDelayType := 0.000 ns;
      tsetup_D3_G_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      thold_S0_G_noedge_posedge                     :	VitalDelayType := 0.000 ns;
      tsetup_S0_G_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      thold_S1_G_noedge_posedge                     :	VitalDelayType := 0.000 ns;
      tsetup_S1_G_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tperiod_G_posedge              :	VitalDelayType := 0.000 ns;
      tpw_G_negedge                  :	VitalDelayType := 0.000 ns;
      tipd_D0                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D1                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D2                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D3                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_S0                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_S1                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_G                         :	VitalDelayType01 := (1.000 ns, 1.000 ns));

   port(
      D0                             :	in    STD_ULOGIC;
      D1                             :	in    STD_ULOGIC;
      D2                             :	in    STD_ULOGIC;
      D3                             :	in    STD_ULOGIC;
      S0                             :	in    STD_ULOGIC;
      S1                             :	in    STD_ULOGIC;
      G                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DLM4
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D0_Q                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_D1_Q                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_D2_Q                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_D3_Q                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S0_Q                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S10_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S11_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_G_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      thold_D0_G_noedge_negedge                     :	VitalDelayType := 0.000 ns;
      tsetup_D0_G_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      thold_D1_G_noedge_negedge                     :	VitalDelayType := 0.000 ns;
      tsetup_D1_G_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      thold_D2_G_noedge_negedge                     :	VitalDelayType := 0.000 ns;
      tsetup_D2_G_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      thold_D3_G_noedge_negedge                     :	VitalDelayType := 0.000 ns;
      tsetup_D3_G_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      thold_S0_G_noedge_negedge                     :	VitalDelayType := 0.000 ns;
      tsetup_S0_G_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      thold_S10_G_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_S10_G_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_S11_G_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_S11_G_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      tperiod_G_negedge              :	VitalDelayType := 0.000 ns;
      tpw_G_posedge                  :	VitalDelayType := 0.000 ns;
      tipd_D0                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D1                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D2                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D3                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_S0                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_S10                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_S11                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_G                         :	VitalDelayType01 := (1.000 ns, 1.000 ns));

   port(
      D0                             :	in    STD_ULOGIC;
      D1                             :	in    STD_ULOGIC;
      D2                             :	in    STD_ULOGIC;
      D3                             :	in    STD_ULOGIC;
      S0                             :	in    STD_ULOGIC;
      S10                            :	in    STD_ULOGIC;
      S11                            :	in    STD_ULOGIC;
      G                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DLM4A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D0_Q                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_D1_Q                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_D2_Q                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_D3_Q                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S0_Q                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S10_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S11_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_G_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      thold_D0_G_noedge_posedge                     :	VitalDelayType := 0.000 ns;
      tsetup_D0_G_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      thold_D1_G_noedge_posedge                     :	VitalDelayType := 0.000 ns;
      tsetup_D1_G_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      thold_D2_G_noedge_posedge                     :	VitalDelayType := 0.000 ns;
      tsetup_D2_G_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      thold_D3_G_noedge_posedge                     :	VitalDelayType := 0.000 ns;
      tsetup_D3_G_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      thold_S0_G_noedge_posedge                     :	VitalDelayType := 0.000 ns;
      tsetup_S0_G_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      thold_S10_G_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_S10_G_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_S11_G_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_S11_G_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      tperiod_G_posedge              :	VitalDelayType := 0.000 ns;
      tpw_G_negedge                  :	VitalDelayType := 0.000 ns;
      tipd_D0                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D1                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D2                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D3                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_S0                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_S10                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_S11                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_G                         :	VitalDelayType01 := (1.000 ns, 1.000 ns));

   port(
      D0                             :	in    STD_ULOGIC;
      D1                             :	in    STD_ULOGIC;
      D2                             :	in    STD_ULOGIC;
      D3                             :	in    STD_ULOGIC;
      S0                             :	in    STD_ULOGIC;
      S10                            :	in    STD_ULOGIC;
      S11                            :	in    STD_ULOGIC;
      G                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DLM8A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D0_Q                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_D1_Q                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_D2_Q                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_D3_Q                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S00_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S01_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S10_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S11_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_G_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CLR_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      thold_D0_G_noedge_negedge                     :	VitalDelayType := 0.000 ns;
      tsetup_D0_G_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      thold_D1_G_noedge_negedge                     :	VitalDelayType := 0.000 ns;
      tsetup_D1_G_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      thold_D2_G_noedge_negedge                     :	VitalDelayType := 0.000 ns;
      tsetup_D2_G_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      thold_D3_G_noedge_negedge                     :	VitalDelayType := 0.000 ns;
      tsetup_D3_G_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      thold_S00_G_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_S00_G_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_S01_G_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_S01_G_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_S10_G_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_S10_G_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_S11_G_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_S11_G_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_CLR_G_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      trecovery_CLR_G_posedge_negedge                :	VitalDelayType := 0.000 ns;
      tperiod_G_negedge              :	VitalDelayType := 0.000 ns;
      tpw_G_posedge                  :	VitalDelayType := 0.000 ns;
      tpw_CLR_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D0                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D1                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D2                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D3                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_S00                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_S01                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_S10                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_S11                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_G                         :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (1.000 ns, 1.000 ns));

   port(
      D0                             :	in    STD_ULOGIC;
      D1                             :	in    STD_ULOGIC;
      D2                             :	in    STD_ULOGIC;
      D3                             :	in    STD_ULOGIC;
      S00                            :	in    STD_ULOGIC;
      S01                            :	in    STD_ULOGIC;
      S10                            :	in    STD_ULOGIC;
      S11                            :	in    STD_ULOGIC;
      G                              :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DLM8B
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D0_Q                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_D1_Q                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_D2_Q                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_D3_Q                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S00_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S01_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S10_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S11_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_G_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CLR_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      thold_D0_G_noedge_posedge                     :	VitalDelayType := 0.000 ns;
      tsetup_D0_G_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      thold_D1_G_noedge_posedge                     :	VitalDelayType := 0.000 ns;
      tsetup_D1_G_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      thold_D2_G_noedge_posedge                     :	VitalDelayType := 0.000 ns;
      tsetup_D2_G_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      thold_D3_G_noedge_posedge                     :	VitalDelayType := 0.000 ns;
      tsetup_D3_G_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      thold_S00_G_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_S00_G_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_S01_G_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_S01_G_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_S10_G_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_S10_G_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_S11_G_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_S11_G_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_CLR_G_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      trecovery_CLR_G_posedge_posedge                :	VitalDelayType := 0.000 ns;
      tperiod_G_posedge              :	VitalDelayType := 0.000 ns;
      tpw_G_negedge                  :	VitalDelayType := 0.000 ns;
      tpw_CLR_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D0                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D1                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D2                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D3                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_S00                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_S01                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_S10                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_S11                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_G                         :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (1.000 ns, 1.000 ns));

   port(
      D0                             :	in    STD_ULOGIC;
      D1                             :	in    STD_ULOGIC;
      D2                             :	in    STD_ULOGIC;
      D3                             :	in    STD_ULOGIC;
      S00                            :	in    STD_ULOGIC;
      S01                            :	in    STD_ULOGIC;
      S10                            :	in    STD_ULOGIC;
      S11                            :	in    STD_ULOGIC;
      G                              :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DLMA
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_A_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_S_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_G_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_A_G_noedge_posedge                      :	VitalDelayType := 0.000 ns;
      tsetup_A_G_noedge_posedge                     :	VitalDelayType := 0.000 ns;
      thold_B_G_noedge_posedge                      :	VitalDelayType := 0.000 ns;
      tsetup_B_G_noedge_posedge                     :	VitalDelayType := 0.000 ns;
      thold_S_G_noedge_posedge                      :	VitalDelayType := 0.000 ns;
      tsetup_S_G_noedge_posedge                     :	VitalDelayType := 0.000 ns;
      tperiod_G_posedge              :	VitalDelayType := 0.000 ns;
      tpw_G_negedge                  :	VitalDelayType := 0.000 ns;
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_G                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      G                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DLME1A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_A_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_S_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_E_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_G_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_A_G_noedge_posedge                      :	VitalDelayType := 0.000 ns;
      thold_A_E_noedge_posedge                      :	VitalDelayType := 0.000 ns;
      tsetup_A_G_noedge_posedge                     :	VitalDelayType := 0.000 ns;
      tsetup_A_E_noedge_posedge                     :	VitalDelayType := 0.000 ns;
      thold_B_G_noedge_posedge                      :	VitalDelayType := 0.000 ns;
      thold_B_E_noedge_posedge                      :	VitalDelayType := 0.000 ns;
      tsetup_B_G_noedge_posedge                     :	VitalDelayType := 0.000 ns;
      tsetup_B_E_noedge_posedge                     :	VitalDelayType := 0.000 ns;
      thold_S_G_noedge_posedge                      :	VitalDelayType := 0.000 ns;
      thold_S_E_noedge_posedge                      :	VitalDelayType := 0.000 ns;
      tsetup_S_G_noedge_posedge                     :	VitalDelayType := 0.000 ns;
      tsetup_S_E_noedge_posedge                     :	VitalDelayType := 0.000 ns;
      tperiod_G_posedge              :	VitalDelayType := 0.000 ns;
      tpw_E_negedge                  :	VitalDelayType := 0.000 ns;
      tpw_G_negedge                  :	VitalDelayType := 0.000 ns;
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_G                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      G                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DLP1
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_G_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_PRE_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_G_noedge_negedge                      :	VitalDelayType := 0.000 ns;
      tsetup_D_G_noedge_negedge                     :	VitalDelayType := 0.000 ns;
      thold_PRE_G_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      trecovery_PRE_G_negedge_negedge                :	VitalDelayType := 0.000 ns;
      tperiod_G_negedge              :	VitalDelayType := 0.000 ns;
      tpw_G_posedge                  :	VitalDelayType := 0.000 ns;
      tpw_PRE_posedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_G                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PRE                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      G                              :	in    STD_ULOGIC;
      PRE                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DLP1A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_G_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_PRE_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_G_noedge_posedge                      :	VitalDelayType := 0.000 ns;
      tsetup_D_G_noedge_posedge                     :	VitalDelayType := 0.000 ns;
      thold_PRE_G_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      trecovery_PRE_G_negedge_posedge                :	VitalDelayType := 0.000 ns;
      tperiod_G_posedge              :	VitalDelayType := 0.000 ns;
      tpw_PRE_posedge                :	VitalDelayType := 0.000 ns;
      tpw_G_negedge                  :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_G                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PRE                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      G                              :	in    STD_ULOGIC;
      PRE                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DLP1B
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_G_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_PRE_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_G_noedge_negedge                      :	VitalDelayType := 0.000 ns;
      tsetup_D_G_noedge_negedge                     :	VitalDelayType := 0.000 ns;
      thold_PRE_G_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      trecovery_PRE_G_posedge_negedge                :	VitalDelayType := 0.000 ns;
      tperiod_G_negedge              :	VitalDelayType := 0.000 ns;
      tpw_G_posedge                  :	VitalDelayType := 0.000 ns;
      tpw_PRE_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_G                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PRE                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      G                              :	in    STD_ULOGIC;
      PRE                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DLP1C
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_G_Q                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_PRE_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_G_noedge_posedge                      :	VitalDelayType := 0.000 ns;
      tsetup_D_G_noedge_posedge                     :	VitalDelayType := 0.000 ns;
      thold_PRE_G_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      trecovery_PRE_G_posedge_posedge                :	VitalDelayType := 0.000 ns;
      tperiod_G_posedge              :	VitalDelayType := 0.000 ns;
      tpw_G_negedge                  :	VitalDelayType := 0.000 ns;
      tpw_PRE_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_G                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PRE                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      G                              :	in    STD_ULOGIC;
      PRE                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component DLP1D
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_QN                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_G_QN                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_PRE_QN                     :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_G_noedge_negedge                      :	VitalDelayType := 0.000 ns;
      tsetup_D_G_noedge_negedge                     :	VitalDelayType := 0.000 ns;
      thold_PRE_G_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      trecovery_PRE_G_posedge_negedge                :	VitalDelayType := 0.000 ns;
      tperiod_G_negedge              :	VitalDelayType := 0.000 ns;
      tpw_G_posedge                  :	VitalDelayType := 0.000 ns;
      tpw_PRE_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_G                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PRE                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      G                              :	in    STD_ULOGIC;
      PRE                            :	in    STD_ULOGIC;
      QN                             :	out   STD_ULOGIC);
end component; 

component DLP1E
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_QN                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_G_QN                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_PRE_QN                     :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_G_noedge_posedge                      :	VitalDelayType := 0.000 ns;
      tsetup_D_G_noedge_posedge                     :	VitalDelayType := 0.000 ns;
      thold_PRE_G_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      trecovery_PRE_G_posedge_posedge                :	VitalDelayType := 0.000 ns;
      tperiod_G_posedge              :	VitalDelayType := 0.000 ns;
      tpw_G_negedge                  :	VitalDelayType := 0.000 ns;
      tpw_PRE_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_G                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PRE                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      G                              :	in    STD_ULOGIC;
      PRE                            :	in    STD_ULOGIC;
      QN                             :	out   STD_ULOGIC);
end component; 

component FA1A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CI_S                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_S                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_S                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CI_CO                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_CO                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_CO                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CI                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      CI                             :	in    STD_ULOGIC;
      S                              :	out   STD_ULOGIC;
      CO                             :	out   STD_ULOGIC);
end component; 

component FA1B
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CI_S                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_S                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_S                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CI_CO                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_CO                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_CO                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CI                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      CI                             :	in    STD_ULOGIC;
      S                              :	out   STD_ULOGIC;
      CO                             :	out   STD_ULOGIC);
end component; 

component FA2A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CI_S                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_S                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A1_S                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A0_S                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CI_CO                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_CO                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A1_CO                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A0_CO                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_A1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CI                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A0                             :	in    STD_ULOGIC;
      A1                             :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      CI                             :	in    STD_ULOGIC;
      S                              :	out   STD_ULOGIC;
      CO                             :	out   STD_ULOGIC);
end component; 

component FECTH
	GENERIC (
		--
		-- PinToPinDelay Generics Declaration(s)
		tpd_IOPCL_PAD        : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input IOPCL to output PAD
		tpd_IOPCL_Y          : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input IOPCL to output Y
		tpd_CLK_PAD          : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input CLK to output PAD
		tpd_CLK_Y            : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input CLK to output Y
		tpd_E_PAD            : VitalDelayType01z := (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns); -- Path delay from input E to output PAD

		--
		-- Interconnect Path Delay Generics Declaration(s)
		tipd_CLK             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port CLK
		tipd_D               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port D
		tipd_E               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port E
                tipd_IOPCL           : VitalDelayType01 := (0.000 ns, 0.000 ns);        -- Input wire delay on port IOPCL
		tipd_ODE             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port ODE
		--
		-- Setup Generics Declaration(s)
		tsetup_D_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between D and CLK
		tsetup_ODE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between ODE and CLK
		--
		-- Hold Generics Declaration(s)
		thold_D_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between D and CLK
		thold_ODE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between ODE and CLK
		thold_IOPCL_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between IOPCL and CLK
		--
		-- Recovery Generics Declaration(s)
		trecovery_IOPCL_CLK_posedge_posedge : VitalDelayType   := 0.000 ns;	-- Recovery time between IOPCL and CLK
		--
		-- Period Check Generics Declaration(s)
		tperiod_CLK_posedge          : VitalDelayType   := 0.000 ns;	-- Minimum period time for CLK
		tpw_CLK_posedge      : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for CLK
		tpw_CLK_negedge      : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for CLK
		tperiod_IOPCL        : VitalDelayType   := 0.000 ns;	-- Minimum period time for IOPCL
		tpw_IOPCL_posedge    : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for IOPCL
		tpw_IOPCL_negedge    : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for IOPCL
		--
		-- InstancePath Will Accompany Any Assertion Messages in the Model
		InstancePath         : STRING           := "*";
		--
		-- 'X' generation control parameter for timing checks and path delay
		XOn                  : BOOLEAN          := TRUE;
		--
		-- Assertion messages generation control parameter for violation of timing checks
		MsgOn                : BOOLEAN          := TRUE;
		--
		-- VitalTimingCheck Switch
		TimingChecksOn       : BOOLEAN          := TRUE
	);
	PORT (
		CLK                 : IN      STD_ULOGIC := 'X';
		D                   : IN      STD_ULOGIC := 'X';
		E                   : IN      STD_ULOGIC := 'X';
		IOPCL               : IN      STD_ULOGIC := 'X';
		ODE                 : IN      STD_ULOGIC := 'X';
		PAD                 : OUT     STD_ULOGIC := 'X';
		Y                   : OUT     STD_ULOGIC := 'X'
		
	);
	--
	--
end component; 

component FECTL
	GENERIC (
		--
		-- PinToPinDelay Generics Declaration(s)
		tpd_IOPCL_PAD        : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input IOPCL to output PAD
		tpd_IOPCL_Y          : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input IOPCL to output Y
		tpd_CLK_PAD          : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input CLK to output PAD
		tpd_CLK_Y            : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input CLK to output Y
		tpd_E_PAD            : VitalDelayType01z := (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns); -- Path delay from input E to output PAD

		--
		-- Interconnect Path Delay Generics Declaration(s)
		tipd_CLK             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port CLK
		tipd_D               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port D
		tipd_E               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port E
                tipd_IOPCL           : VitalDelayType01 := (0.000 ns, 0.000 ns);        -- Input wire delay on port IOPCL
		tipd_ODE             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port ODE
		--
		-- Setup Generics Declaration(s)
		tsetup_D_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between D and CLK
		tsetup_ODE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between ODE and CLK
		--
		-- Hold Generics Declaration(s)
		thold_D_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between D and CLK
		thold_ODE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between ODE and CLK
		thold_IOPCL_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between IOPCL and CLK
		--
		-- Recovery Generics Declaration(s)
		trecovery_IOPCL_CLK_posedge_posedge : VitalDelayType   := 0.000 ns;	-- Recovery time between IOPCL and CLK
		--
		-- Period Check Generics Declaration(s)
		tperiod_CLK_posedge          : VitalDelayType   := 0.000 ns;	-- Minimum period time for CLK
		tpw_CLK_posedge      : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for CLK
		tpw_CLK_negedge      : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for CLK
		tperiod_IOPCL        : VitalDelayType   := 0.000 ns;	-- Minimum period time for IOPCL
		tpw_IOPCL_posedge    : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for IOPCL
		tpw_IOPCL_negedge    : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for IOPCL
		--
		-- InstancePath Will Accompany Any Assertion Messages in the Model
		InstancePath         : STRING           := "*";
		--
		-- 'X' generation control parameter for timing checks and path delay
		XOn                  : BOOLEAN          := TRUE;
		--
		-- Assertion messages generation control parameter for violation of timing checks
		MsgOn                : BOOLEAN          := TRUE;
		--
		-- VitalTimingCheck Switch
		TimingChecksOn       : BOOLEAN          := TRUE
	);
	PORT (
		CLK                 : IN      STD_ULOGIC := 'X';
		D                   : IN      STD_ULOGIC := 'X';
		E                   : IN      STD_ULOGIC := 'X';
		IOPCL               : IN      STD_ULOGIC := 'X';
		ODE                 : IN      STD_ULOGIC := 'X';
		PAD                 : OUT     STD_ULOGIC := 'X';
		Y                   : OUT     STD_ULOGIC := 'X'
		
	);
	--
	--
end component; 

component FECTMH
	GENERIC (
		--
		-- PinToPinDelay Generics Declaration(s)
		tpd_PAD_Y            : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input PAD to output Y
		tpd_M_Y              : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input M to output Y
		tpd_IOPCL_PAD        : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input IOPCL to output PAD
		tpd_IOPCL_Y          : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input IOPCL to output Y
		tpd_CLK_PAD          : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input CLK to output PAD
		tpd_CLK_Y            : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input CLK to output Y
		tpd_E_PAD            : VitalDelayType01z := (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns); -- Path delay from input E to output PAD

		--
		-- Interconnect Path Delay Generics Declaration(s)
		tipd_CLK             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port CLK
		tipd_D               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port D
		tipd_E               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port E
		tipd_M               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port M
		tipd_IOPCL           : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port IOPCL
		tipd_ODE             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port ODE
		tipd_PAD             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port PAD
		--
		-- Setup Generics Declaration(s)
		tsetup_D_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between D and CLK
		tsetup_ODE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between ODE and CLK
		--
		-- Hold Generics Declaration(s)
		thold_D_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between D and CLK
		thold_ODE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between ODE and CLK
		thold_IOPCL_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between IOPCL and CLK
		--
		-- Recovery Generics Declaration(s)
		trecovery_IOPCL_CLK_posedge_posedge : VitalDelayType   := 0.000 ns;	-- Recovery time between IOPCL and CLK
		--
		-- Period Check Generics Declaration(s)
		tperiod_CLK_posedge          : VitalDelayType   := 0.000 ns;	-- Minimum period time for CLK
		tpw_CLK_posedge      : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for CLK
		tpw_CLK_negedge      : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for CLK
		tperiod_IOPCL        : VitalDelayType   := 0.000 ns;	-- Minimum period time for IOPCL
		tpw_IOPCL_posedge    : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for IOPCL
		tpw_IOPCL_negedge    : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for IOPCL
		--
		-- InstancePath Will Accompany Any Assertion Messages in the Model
		InstancePath         : STRING           := "*";
		--
		-- 'X' generation control parameter for timing checks and path delay
		XOn                  : BOOLEAN          := TRUE;
		--
		-- Assertion messages generation control parameter for violation of timing checks
		MsgOn                : BOOLEAN          := TRUE;
		--
		-- VitalTimingCheck Switch
		TimingChecksOn       : BOOLEAN          := TRUE
	);
	PORT (
		CLK                 : IN      STD_ULOGIC := 'X';
		D                   : IN      STD_ULOGIC := 'X';
		E                   : IN      STD_ULOGIC := 'X';
		M                   : IN      STD_ULOGIC := 'X';
		IOPCL               : IN      STD_ULOGIC := 'X';
		ODE                 : IN      STD_ULOGIC := 'X';
		PAD                 : INOUT   STD_ULOGIC := 'X';
		Y                   : OUT     STD_ULOGIC := 'X'
		
	);
	--
	--
end component; 

component FECTML
	GENERIC (
		--
		-- PinToPinDelay Generics Declaration(s)
		tpd_PAD_Y            : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input PAD to output Y
		tpd_M_Y              : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input M to output Y
		tpd_IOPCL_PAD        : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input IOPCL to output PAD
		tpd_IOPCL_Y          : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input IOPCL to output Y
		tpd_CLK_PAD          : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input CLK to output PAD
		tpd_CLK_Y            : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input CLK to output Y
		tpd_E_PAD            : VitalDelayType01z := (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns); -- Path delay from input E to output PAD

		--
		-- Interconnect Path Delay Generics Declaration(s)
		tipd_CLK             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port CLK
		tipd_D               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port D
		tipd_E               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port E
		tipd_M               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port M
		tipd_IOPCL           : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port IOPCL
		tipd_ODE             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port ODE
		tipd_PAD             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port PAD
		--
		-- Setup Generics Declaration(s)
		tsetup_D_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between D and CLK
		tsetup_ODE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between ODE and CLK
		--
		-- Hold Generics Declaration(s)
		thold_D_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between D and CLK
		thold_ODE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between ODE and CLK
		thold_IOPCL_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between IOPCL and CLK
		--
		-- Recovery Generics Declaration(s)
		trecovery_IOPCL_CLK_posedge_posedge : VitalDelayType   := 0.000 ns;	-- Recovery time between IOPCL and CLK
		--
		-- Period Check Generics Declaration(s)
		tperiod_CLK_posedge          : VitalDelayType   := 0.000 ns;	-- Minimum period time for CLK
		tpw_CLK_posedge      : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for CLK
		tpw_CLK_negedge      : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for CLK
		tperiod_IOPCL        : VitalDelayType   := 0.000 ns;	-- Minimum period time for IOPCL
		tpw_IOPCL_posedge    : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for IOPCL
		tpw_IOPCL_negedge    : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for IOPCL
		--
		-- InstancePath Will Accompany Any Assertion Messages in the Model
		InstancePath         : STRING           := "*";
		--
		-- 'X' generation control parameter for timing checks and path delay
		XOn                  : BOOLEAN          := TRUE;
		--
		-- Assertion messages generation control parameter for violation of timing checks
		MsgOn                : BOOLEAN          := TRUE;
		--
		-- VitalTimingCheck Switch
		TimingChecksOn       : BOOLEAN          := TRUE
	);
	PORT (
		CLK                 : IN      STD_ULOGIC := 'X';
		D                   : IN      STD_ULOGIC := 'X';
		E                   : IN      STD_ULOGIC := 'X';
		M                   : IN      STD_ULOGIC := 'X';
		IOPCL               : IN      STD_ULOGIC := 'X';
		ODE                 : IN      STD_ULOGIC := 'X';
		PAD                 : INOUT   STD_ULOGIC := 'X';
		Y                   : OUT     STD_ULOGIC := 'X'
		
	);
	--
	--
end component; 

component FEPTH
	GENERIC (
		--
		-- PinToPinDelay Generics Declaration(s)
		tpd_IOPCL_PAD        : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input IOPCL to output PAD
		tpd_IOPCL_Y          : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input IOPCL to output Y
		tpd_CLK_PAD          : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input CLK to output PAD
		tpd_CLK_Y            : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input CLK to output Y
		tpd_E_PAD            : VitalDelayType01z := (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns); -- Path delay from input E to output PAD

		--
		-- Interconnect Path Delay Generics Declaration(s)
		tipd_CLK             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port CLK
		tipd_D               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port D
		tipd_E               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port E
		tipd_IOPCL           : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port IOPCL
		tipd_ODE             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port ODE
		--
		-- Setup Generics Declaration(s)
		tsetup_D_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between D and CLK
		tsetup_ODE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between ODE and CLK
		--
		-- Hold Generics Declaration(s)
		thold_D_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between D and CLK
		thold_ODE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between ODE and CLK
		thold_IOPCL_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between IOPCL and CLK
		--
		-- Recovery Generics Declaration(s)
		trecovery_IOPCL_CLK_posedge_posedge : VitalDelayType   := 0.000 ns;	-- Recovery time between IOPCL and CLK
		--
		-- Period Check Generics Declaration(s)
		tperiod_CLK_posedge          : VitalDelayType   := 0.000 ns;	-- Minimum period time for CLK
		tpw_CLK_posedge      : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for CLK
		tpw_CLK_negedge      : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for CLK
		tperiod_IOPCL        : VitalDelayType   := 0.000 ns;	-- Minimum period time for IOPCL
		tpw_IOPCL_posedge    : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for IOPCL
		tpw_IOPCL_negedge    : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for IOPCL
		--
		-- InstancePath Will Accompany Any Assertion Messages in the Model
		InstancePath         : STRING           := "*";
		--
		-- 'X' generation control parameter for timing checks and path delay
		XOn                  : BOOLEAN          := TRUE;
		--
		-- Assertion messages generation control parameter for violation of timing checks
		MsgOn                : BOOLEAN          := TRUE;
		--
		-- VitalTimingCheck Switch
		TimingChecksOn       : BOOLEAN          := TRUE
	);
	PORT (
		CLK                 : IN      STD_ULOGIC := 'X';
		D                   : IN      STD_ULOGIC := 'X';
		E                   : IN      STD_ULOGIC := 'X';
		IOPCL               : IN      STD_ULOGIC := 'X';
		ODE                 : IN      STD_ULOGIC := 'X';
		PAD                 : OUT     STD_ULOGIC := 'X';
		Y                   : OUT     STD_ULOGIC := 'X'
		
	);
	--
	--
end component; 

component FEPTL
	GENERIC (
		--
		-- PinToPinDelay Generics Declaration(s)
		tpd_IOPCL_PAD        : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input IOPCL to output PAD
		tpd_IOPCL_Y          : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input IOPCL to output Y
		tpd_CLK_PAD          : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input CLK to output PAD
		tpd_CLK_Y            : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input CLK to output Y
		tpd_E_PAD            : VitalDelayType01z := (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns); -- Path delay from input E to output PAD

		--
		-- Interconnect Path Delay Generics Declaration(s)
		tipd_CLK             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port CLK
		tipd_D               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port D
		tipd_E               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port E
		tipd_IOPCL           : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port IOPCL
		tipd_ODE             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port ODE
		--
		-- Setup Generics Declaration(s)
		tsetup_D_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between D and CLK
		tsetup_ODE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between ODE and CLK
		--
		-- Hold Generics Declaration(s)
		thold_D_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between D and CLK
		thold_ODE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between ODE and CLK
		thold_IOPCL_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between IOPCL and CLK
		--
		-- Recovery Generics Declaration(s)
		trecovery_IOPCL_CLK_posedge_posedge : VitalDelayType   := 0.000 ns;	-- Recovery time between IOPCL and CLK
		--
		-- Period Check Generics Declaration(s)
		tperiod_CLK_posedge          : VitalDelayType   := 0.000 ns;	-- Minimum period time for CLK
		tpw_CLK_posedge      : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for CLK
		tpw_CLK_negedge      : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for CLK
		tperiod_IOPCL        : VitalDelayType   := 0.000 ns;	-- Minimum period time for IOPCL
		tpw_IOPCL_posedge    : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for IOPCL
		tpw_IOPCL_negedge    : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for IOPCL
		--
		-- InstancePath Will Accompany Any Assertion Messages in the Model
		InstancePath         : STRING           := "*";
		--
		-- 'X' generation control parameter for timing checks and path delay
		XOn                  : BOOLEAN          := TRUE;
		--
		-- Assertion messages generation control parameter for violation of timing checks
		MsgOn                : BOOLEAN          := TRUE;
		--
		-- VitalTimingCheck Switch
		TimingChecksOn       : BOOLEAN          := TRUE
	);
	PORT (
		CLK                 : IN      STD_ULOGIC := 'X';
		D                   : IN      STD_ULOGIC := 'X';
		E                   : IN      STD_ULOGIC := 'X';
		IOPCL               : IN      STD_ULOGIC := 'X';
		ODE                 : IN      STD_ULOGIC := 'X';
		PAD                 : OUT     STD_ULOGIC := 'X';
		Y                   : OUT     STD_ULOGIC := 'X'
		
	);
	--
	--
end component; 

component FEPTMH
	GENERIC (
		--
		-- PinToPinDelay Generics Declaration(s)
		tpd_PAD_Y            : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input PAD to output Y
		tpd_M_Y              : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input M to output Y
		tpd_IOPCL_PAD        : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input IOPCL to output PAD
		tpd_IOPCL_Y          : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input IOPCL to output Y
		tpd_CLK_PAD          : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input CLK to output PAD
		tpd_CLK_Y            : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input CLK to output Y
		tpd_E_PAD            : VitalDelayType01z := (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns); -- Path delay from input E to output PAD

		--
		-- Interconnect Path Delay Generics Declaration(s)
		tipd_CLK             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port CLK
		tipd_D               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port D
		tipd_E               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port E
		tipd_M               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port M
		tipd_IOPCL           : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port IOPCL
		tipd_ODE             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port ODE
		tipd_PAD             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port PAD
		--
		-- Setup Generics Declaration(s)
		tsetup_D_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between D and CLK
		tsetup_ODE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between ODE and CLK
		--
		-- Hold Generics Declaration(s)
		thold_D_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between D and CLK
		thold_ODE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between ODE and CLK
		thold_IOPCL_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between IOPCL and CLK
		--
		-- Recovery Generics Declaration(s)
		trecovery_IOPCL_CLK_posedge_posedge : VitalDelayType   := 0.000 ns;	-- Recovery time between IOPCL and CLK
		--
		-- Period Check Generics Declaration(s)
		tperiod_CLK_posedge          : VitalDelayType   := 0.000 ns;	-- Minimum period time for CLK
		tpw_CLK_posedge      : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for CLK
		tpw_CLK_negedge      : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for CLK
		tperiod_IOPCL        : VitalDelayType   := 0.000 ns;	-- Minimum period time for IOPCL
		tpw_IOPCL_posedge    : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for IOPCL
		tpw_IOPCL_negedge    : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for IOPCL
		--
		-- InstancePath Will Accompany Any Assertion Messages in the Model
		InstancePath         : STRING           := "*";
		--
		-- 'X' generation control parameter for timing checks and path delay
		XOn                  : BOOLEAN          := TRUE;
		--
		-- Assertion messages generation control parameter for violation of timing checks
		MsgOn                : BOOLEAN          := TRUE;
		--
		-- VitalTimingCheck Switch
		TimingChecksOn       : BOOLEAN          := TRUE
	);
	PORT (
		CLK                 : IN      STD_ULOGIC := 'X';
		D                   : IN      STD_ULOGIC := 'X';
		E                   : IN      STD_ULOGIC := 'X';
		M                   : IN      STD_ULOGIC := 'X';
		IOPCL               : IN      STD_ULOGIC := 'X';
		ODE                 : IN      STD_ULOGIC := 'X';
		PAD                 : INOUT   STD_ULOGIC := 'X';
		Y                   : OUT     STD_ULOGIC := 'X'
		
	);
	--
	--
end component; 

component FEPTML
	GENERIC (
		--
		-- PinToPinDelay Generics Declaration(s)
		tpd_PAD_Y            : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input PAD to output Y
		tpd_M_Y              : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input M to output Y
		tpd_IOPCL_PAD        : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input IOPCL to output PAD
		tpd_IOPCL_Y          : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input IOPCL to output Y
		tpd_CLK_PAD          : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input CLK to output PAD
		tpd_CLK_Y            : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input CLK to output Y
		tpd_E_PAD            : VitalDelayType01z := (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns); -- Path delay from input E to output PAD

		--
		-- Interconnect Path Delay Generics Declaration(s)
		tipd_CLK             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port CLK
		tipd_D               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port D
		tipd_E               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port E
		tipd_M               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port M
		tipd_IOPCL           : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port IOPCL
		tipd_ODE             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port ODE
		tipd_PAD             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port PAD
		--
		-- Setup Generics Declaration(s)
		tsetup_D_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between D and CLK
		tsetup_ODE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between ODE and CLK
		--
		-- Hold Generics Declaration(s)
		thold_D_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between D and CLK
		thold_ODE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between ODE and CLK
		thold_IOPCL_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between IOPCL and CLK
		--
		-- Recovery Generics Declaration(s)
		trecovery_IOPCL_CLK_posedge_posedge : VitalDelayType   := 0.000 ns;	-- Recovery time between IOPCL and CLK
		--
		-- Period Check Generics Declaration(s)
		tperiod_CLK_posedge          : VitalDelayType   := 0.000 ns;	-- Minimum period time for CLK
		tpw_CLK_posedge      : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for CLK
		tpw_CLK_negedge      : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for CLK
		tperiod_IOPCL        : VitalDelayType   := 0.000 ns;	-- Minimum period time for IOPCL
		tpw_IOPCL_posedge    : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for IOPCL
		tpw_IOPCL_negedge    : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for IOPCL
		--
		-- InstancePath Will Accompany Any Assertion Messages in the Model
		InstancePath         : STRING           := "*";
		--
		-- 'X' generation control parameter for timing checks and path delay
		XOn                  : BOOLEAN          := TRUE;
		--
		-- Assertion messages generation control parameter for violation of timing checks
		MsgOn                : BOOLEAN          := TRUE;
		--
		-- VitalTimingCheck Switch
		TimingChecksOn       : BOOLEAN          := TRUE
	);
	PORT (
		CLK                 : IN      STD_ULOGIC := 'X';
		D                   : IN      STD_ULOGIC := 'X';
		E                   : IN      STD_ULOGIC := 'X';
		M                   : IN      STD_ULOGIC := 'X';
		IOPCL               : IN      STD_ULOGIC := 'X';
		ODE                 : IN      STD_ULOGIC := 'X';
		PAD                 : INOUT   STD_ULOGIC := 'X';
		Y                   : OUT     STD_ULOGIC := 'X'
		
	);
	--
	--
end component; 

component GAND2
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_G_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_G                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      G                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component GMX4
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_G_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_S0_Y                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D3_Y                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D2_Y                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D1_Y                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D0_Y                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_G                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D0                             :	in    STD_ULOGIC;
      D1                             :	in    STD_ULOGIC;
      D2                             :	in    STD_ULOGIC;
      D3                             :	in    STD_ULOGIC;
      S0                             :	in    STD_ULOGIC;
      G                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component GNAND2
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_G_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_G                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      G                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component GND
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True);

   port(
      Y                              :	out   STD_ULOGIC := '0');
end component; 

component GNOR2
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_G_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_G                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      G                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component GOR2
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_G_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_G                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      G                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component GXOR2
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_G_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_G                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      G                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component HA1
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_B_CO                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_CO                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_S                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_S                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      CO                             :	out   STD_ULOGIC;
      S                              :	out   STD_ULOGIC);
end component; 

component HA1A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_B_CO                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_CO                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_S                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_S                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      CO                             :	out   STD_ULOGIC;
      S                              :	out   STD_ULOGIC);
end component; 

component HA1B
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_B_CO                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_CO                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_S                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_S                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      CO                             :	out   STD_ULOGIC;
      S                              :	out   STD_ULOGIC);
end component; 

component HA1C
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_B_CO                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_CO                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_S                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_S                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      CO                             :	out   STD_ULOGIC;
      S                              :	out   STD_ULOGIC);
end component; 

component HCLKBUF
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_PAD_Y                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_PAD                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      PAD                            :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component IBUF
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_PAD_Y                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_PAD                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      PAD                            :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component INBUF
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_PAD_Y                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_PAD                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      PAD                            :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component INV
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component INVA
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component INVD
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component IOCLKBUF
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_PAD_Y                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_PAD                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      PAD                            :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component IODFE
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_posedge     :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_posedge    :	VitalDelayType := 0.000 ns;
      thold_E_CLK_noedge_posedge     :	VitalDelayType := 0.000 ns;
      tsetup_E_CLK_noedge_posedge    :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component IODFEC
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_IOPCL_Q                    :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_E_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_E_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_IOPCL_CLK_noedge_posedge                :	VitalDelayType := 0.000 ns;
      trecovery_IOPCL_CLK_posedge_posedge            :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tpw_IOPCL_negedge              :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_IOPCL                     :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      IOPCL                          :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component IODFEP
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_IOPCL_Q                    :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_E_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_E_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_IOPCL_CLK_noedge_posedge                :	VitalDelayType := 0.000 ns;
      trecovery_IOPCL_CLK_posedge_posedge            :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_IOPCL_negedge              :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_IOPCL                     :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      IOPCL                          :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component IOPCLBUF
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_PAD_Y                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_PAD                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      PAD                            :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component IREC
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_IOPCL_Q                    :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_IDE_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      tsetup_IDE_CLK_noedge_posedge                 :	VitalDelayType := 0.000 ns;
      thold_IOPCL_CLK_noedge_posedge                :	VitalDelayType := 0.000 ns;
      trecovery_IOPCL_CLK_posedge_posedge            :	VitalDelayType := 0.000 ns;
      thold_PAD_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      tsetup_PAD_CLK_noedge_posedge                 :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tpw_IOPCL_negedge              :	VitalDelayType := 0.000 ns;
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_IDE                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_IOPCL                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PAD                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      CLK                            :	in    STD_ULOGIC;
      IDE                            :	in    STD_ULOGIC;
      IOPCL                          :	in    STD_ULOGIC;
      PAD                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component IREP
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_IOPCL_Q                    :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_IDE_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      tsetup_IDE_CLK_noedge_posedge                 :	VitalDelayType := 0.000 ns;
      thold_IOPCL_CLK_noedge_posedge                :	VitalDelayType := 0.000 ns;
      trecovery_IOPCL_CLK_posedge_posedge            :	VitalDelayType := 0.000 ns;
      thold_PAD_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      tsetup_PAD_CLK_noedge_posedge                 :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tpw_IOPCL_negedge              :	VitalDelayType := 0.000 ns;
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_IDE                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_IOPCL                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PAD                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      CLK                            :	in    STD_ULOGIC;
      IDE                            :	in    STD_ULOGIC;
      IOPCL                          :	in    STD_ULOGIC;
      PAD                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component JKF
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_J_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_J_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_K_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_K_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_J                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_K                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      J                              :	in    STD_ULOGIC;
      K                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component JKF1B
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_J_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_J_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_K_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_K_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_J                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_K                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      J                              :	in    STD_ULOGIC;
      K                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component JKF2A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLR_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_J_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_J_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_K_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_K_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_CLR_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      trecovery_CLR_CLK_posedge_posedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tpw_CLR_negedge                :	VitalDelayType := 0.000 ns;
      tipd_J                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_K                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      J                              :	in    STD_ULOGIC;
      K                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component JKF2B
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLR_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_J_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_J_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_K_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_K_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_CLR_CLK_noedge_negedge                  :	VitalDelayType := 0.000 ns;
      trecovery_CLR_CLK_posedge_negedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_negedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tpw_CLR_negedge                :	VitalDelayType := 0.000 ns;
      tipd_J                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_K                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      J                              :	in    STD_ULOGIC;
      K                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component JKF2C
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLR_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_J_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_J_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_K_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_K_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_CLR_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      trecovery_CLR_CLK_negedge_posedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLR_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_J                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_K                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      J                              :	in    STD_ULOGIC;
      K                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component JKF2D
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLR_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_J_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_J_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_K_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_K_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_CLR_CLK_noedge_negedge                  :	VitalDelayType := 0.000 ns;
      trecovery_CLR_CLK_negedge_negedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_negedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLR_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_J                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_K                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      J                              :	in    STD_ULOGIC;
      K                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component MAJ3
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component MX2
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_S_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component MX2A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_S_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component MX2B
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_S_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component MX2C
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_S_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component MX4
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_S1_Y                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_S0_Y                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D3_Y                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D2_Y                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D1_Y                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D0_Y                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D0                             :	in    STD_ULOGIC;
      D1                             :	in    STD_ULOGIC;
      D2                             :	in    STD_ULOGIC;
      D3                             :	in    STD_ULOGIC;
      S0                             :	in    STD_ULOGIC;
      S1                             :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component MXC1
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_S_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component MXT
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_S1_Y                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_S0B_Y                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_S0A_Y                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D3_Y                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D2_Y                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D1_Y                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D0_Y                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S0A                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S0B                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D0                             :	in    STD_ULOGIC;
      D1                             :	in    STD_ULOGIC;
      D2                             :	in    STD_ULOGIC;
      D3                             :	in    STD_ULOGIC;
      S0A                            :	in    STD_ULOGIC;
      S0B                            :	in    STD_ULOGIC;
      S1                             :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component NAND2
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component NAND2A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component NAND2B
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component NAND3
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component NAND3A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component NAND3B
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component NAND3C
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component NAND4
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component NAND4A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component NAND4B
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component NAND4C
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component NAND4D
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component NAND5C
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_E_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component NOR2
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component NOR2A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component NOR2B
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component NOR3
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component NOR3A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component NOR3B
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component NOR3C
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component NOR4
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component NOR4A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component NOR4B
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component NOR4C
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component NOR4D
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component NOR5C
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_E_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component OA1
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component OA1A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component OA1B
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component OA1C
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component OA2
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component OA2A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component OA3
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component OA3A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component OA3B
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component OA4
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component OA4A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component OA5
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component OAI1
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component OAI2A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component OAI3
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component OAI3A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component OBHS
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_PAD                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      PAD                            :	out   STD_ULOGIC);
end component; 

component OBUFTH
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_E_PAD                      :	VitalDelayType01z := 
               (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns);
      tpd_D_PAD                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      PAD                            :	out   STD_ULOGIC);
end component; 

component OBUFTL
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_E_PAD                      :	VitalDelayType01z := 
               (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns);
      tpd_D_PAD                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      PAD                            :	out   STD_ULOGIC);
end component; 

component OR2
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component OR2A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component OR2B
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component OR3
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component OR3A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component OR3B
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component OR3C
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component OR4
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component OR4A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component OR4B
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component OR4C
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component OR4D
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component OR5B
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_E_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component ORECTH
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_IOPCL_PAD                  :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_E_PAD                      :	VitalDelayType01z := 
               (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns);
      tpd_CLK_PAD                    :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_IOPCL_CLK_noedge_posedge                :	VitalDelayType := 0.000 ns;
      trecovery_IOPCL_CLK_posedge_posedge            :	VitalDelayType := 0.000 ns;
      thold_ODE_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      tsetup_ODE_CLK_noedge_posedge                 :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tpw_IOPCL_negedge              :	VitalDelayType := 0.000 ns;
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_IOPCL                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_ODE                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      CLK                            :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      IOPCL                          :	in    STD_ULOGIC;
      ODE                            :	in    STD_ULOGIC;
      PAD                            :	out   STD_ULOGIC);
end component; 

component ORECTL
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_IOPCL_PAD                  :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_E_PAD                      :	VitalDelayType01z := 
               (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns);
      tpd_CLK_PAD                    :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_IOPCL_CLK_noedge_posedge                :	VitalDelayType := 0.000 ns;
      trecovery_IOPCL_CLK_posedge_posedge            :	VitalDelayType := 0.000 ns;
      thold_ODE_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      tsetup_ODE_CLK_noedge_posedge                 :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tpw_IOPCL_negedge              :	VitalDelayType := 0.000 ns;
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_IOPCL                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_ODE                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      CLK                            :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      IOPCL                          :	in    STD_ULOGIC;
      ODE                            :	in    STD_ULOGIC;
      PAD                            :	out   STD_ULOGIC);
end component; 

component OREPTH
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_IOPCL_PAD                  :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_E_PAD                      :	VitalDelayType01z := 
               (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns);
      tpd_CLK_PAD                    :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_IOPCL_CLK_noedge_posedge                :	VitalDelayType := 0.000 ns;
      trecovery_IOPCL_CLK_posedge_posedge            :	VitalDelayType := 0.000 ns;
      thold_ODE_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      tsetup_ODE_CLK_noedge_posedge                 :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tpw_IOPCL_negedge              :	VitalDelayType := 0.000 ns;
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_IOPCL                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_ODE                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      CLK                            :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      IOPCL                          :	in    STD_ULOGIC;
      ODE                            :	in    STD_ULOGIC;
      PAD                            :	out   STD_ULOGIC);
end component; 

component OREPTL
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_IOPCL_PAD                  :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_E_PAD                      :	VitalDelayType01z := 
               (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns);
      tpd_CLK_PAD                    :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_IOPCL_CLK_noedge_posedge                :	VitalDelayType := 0.000 ns;
      trecovery_IOPCL_CLK_posedge_posedge            :	VitalDelayType := 0.000 ns;
      thold_ODE_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      tsetup_ODE_CLK_noedge_posedge                 :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tpw_IOPCL_negedge              :	VitalDelayType := 0.000 ns;
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_IOPCL                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_ODE                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      CLK                            :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      IOPCL                          :	in    STD_ULOGIC;
      ODE                            :	in    STD_ULOGIC;
      PAD                            :	out   STD_ULOGIC);
end component; 

component OUTBUF
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_PAD                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      PAD                            :	out   STD_ULOGIC);
end component; 

component TBHS
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_E_PAD                      :	VitalDelayType01z := 
               (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns);
      tpd_D_PAD                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      PAD                            :	out   STD_ULOGIC);
end component; 

component TF1A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLR_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_T_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_T_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_CLR_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      trecovery_CLR_CLK_posedge_posedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tpw_CLR_negedge                :	VitalDelayType := 0.000 ns;
      tipd_T                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      T                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component TF1B
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLR_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_T_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_T_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_CLR_CLK_noedge_negedge                  :	VitalDelayType := 0.000 ns;
      trecovery_CLR_CLK_posedge_negedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_negedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tpw_CLR_negedge                :	VitalDelayType := 0.000 ns;
      tipd_T                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      T                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
end component; 

component TRIBUFF
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_E_PAD                      :	VitalDelayType01z := 
               (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns);
      tpd_D_PAD                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      PAD                            :	out   STD_ULOGIC);
end component; 

component VCC
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True);

   port(
      Y                              :	out   STD_ULOGIC := '1');
end component; 

component XA1
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component XA1A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component XNOR2
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component XO1
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component XO1A
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component XOR2
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

end COMPONENTS;

----------------------------------------------------------------
-- 
-- 
----------------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.all;

library IEEE;
use IEEE.VITAL_Timing.all;
use IEEE.VITAL_Primitives.all;

package VTABLES is

   CONSTANT L : VitalTableSymbolType := '0';
   CONSTANT H : VitalTableSymbolType := '1';
   CONSTANT x : VitalTableSymbolType := '-';
   CONSTANT S : VitalTableSymbolType := 'S';
   CONSTANT R : VitalTableSymbolType := '/';
   CONSTANT U : VitalTableSymbolType := 'X';
   CONSTANT V : VitalTableSymbolType := 'B'; -- valid clock signal (non-rising)

   CONSTANT DF1_Q_tab : VitalStateTableType := (
    ( L,  L,  H,  x,  L ),
    ( L,  H,  H,  x,  H ),
    ( H,  x,  x,  x,  S ),
    ( x,  x,  L,  x,  S ));

   CONSTANT DF1A_QN_tab : VitalStateTableType := (
    ( L,  L,  H,  x,  H ),
    ( L,  H,  H,  x,  L ),
    ( H,  x,  x,  x,  S ),
    ( x,  x,  L,  x,  S ));

   CONSTANT DFC1_Q_tab : VitalStateTableType := (
    ( L,  L,  H,  x,  x,  L ),
    ( L,  H,  H,  L,  x,  H ),
    ( H,  x,  x,  L,  x,  S ),
    ( x,  x,  L,  L,  x,  S ),
    ( x,  x,  x,  H,  x,  L ));

   CONSTANT DFC1B_Q_tab : VitalStateTableType := (
    ( L,  x,  x,  x,  x,  L ),
    ( H,  L,  H,  H,  x,  H ),
    ( H,  H,  x,  x,  x,  S ),
    ( H,  x,  x,  L,  x,  S ),
    ( x,  L,  L,  H,  x,  L ));

   CONSTANT DFC1E_QN_tab : VitalStateTableType := (
    ( L,  H,  H,  H,  x,  L ),
    ( L,  x,  L,  H,  x,  H ),
    ( H,  H,  x,  x,  x,  S ),
    ( x,  L,  x,  x,  x,  H ),
    ( x,  H,  x,  L,  x,  S ));

   CONSTANT DFE_Q_tab : VitalStateTableType := (
    ( L,  L,  L,  x,  H,  x,  L ),
    ( L,  L,  x,  L,  H,  x,  L ),
    ( L,  H,  H,  x,  H,  x,  H ),
    ( L,  H,  x,  L,  H,  x,  H ),
    ( L,  x,  L,  H,  H,  x,  L ),
    ( L,  x,  H,  H,  H,  x,  H ),
    ( H,  x,  x,  x,  x,  x,  S ),
    ( x,  x,  x,  x,  L,  x,  S ));

   CONSTANT DFE1B_Q_tab : VitalStateTableType := (
    ( L,  L,  L,  x,  H,  x,  L ),
    ( L,  L,  x,  H,  H,  x,  L ),
    ( L,  H,  H,  x,  H,  x,  H ),
    ( L,  H,  x,  H,  H,  x,  H ),
    ( L,  x,  L,  L,  H,  x,  L ),
    ( L,  x,  H,  L,  H,  x,  H ),
    ( H,  x,  x,  x,  x,  x,  S ),
    ( x,  x,  x,  x,  L,  x,  S ));

   CONSTANT DFE3A_Q_tab : VitalStateTableType := (
    ( L,  x,  x,  x,  x,  x,  x,  L ),
    ( H,  L,  H,  H,  x,  H,  x,  H ),
    ( H,  L,  H,  x,  L,  H,  x,  H ),
    ( H,  L,  x,  H,  H,  H,  x,  H ),
    ( H,  H,  x,  x,  x,  x,  x,  S ),
    ( H,  x,  x,  x,  x,  L,  x,  S ),
    ( x,  L,  L,  L,  x,  H,  x,  L ),
    ( x,  L,  L,  x,  L,  H,  x,  L ),
    ( x,  L,  x,  L,  H,  H,  x,  L ));

   CONSTANT DFE3C_Q_tab : VitalStateTableType := (
    ( L,  x,  x,  x,  x,  x,  x,  L ),
    ( H,  L,  H,  H,  x,  H,  x,  H ),
    ( H,  L,  H,  x,  H,  H,  x,  H ),
    ( H,  L,  x,  H,  L,  H,  x,  H ),
    ( H,  H,  x,  x,  x,  x,  x,  S ),
    ( H,  x,  x,  x,  x,  L,  x,  S ),
    ( x,  L,  L,  L,  x,  H,  x,  L ),
    ( x,  L,  L,  x,  H,  H,  x,  L ),
    ( x,  L,  x,  L,  L,  H,  x,  L ));

   CONSTANT DFM1B_QN_tab : VitalStateTableType := (
    ( L,  L,  x,  L,  H,  x,  H ),
    ( L,  L,  x,  H,  H,  x,  L ),
    ( L,  H,  L,  x,  H,  x,  H ),
    ( L,  H,  H,  x,  H,  x,  L ),
    ( L,  x,  L,  L,  H,  x,  H ),
    ( L,  x,  H,  H,  H,  x,  L ),
    ( H,  x,  x,  x,  x,  x,  S ),
    ( x,  x,  x,  x,  L,  x,  S ));

   CONSTANT DFM3_Q_tab : VitalStateTableType := (
    ( L,  L,  L,  x,  H,  x,  x,  L ),
    ( L,  L,  x,  H,  H,  x,  x,  L ),
    ( L,  H,  H,  x,  H,  L,  x,  H ),
    ( L,  H,  x,  H,  H,  L,  x,  H ),
    ( L,  x,  L,  L,  H,  x,  x,  L ),
    ( L,  x,  H,  L,  H,  L,  x,  H ),
    ( H,  x,  x,  x,  x,  L,  x,  S ),
    ( x,  x,  x,  x,  L,  L,  x,  S ),
    ( x,  x,  x,  x,  x,  H,  x,  L ));

   CONSTANT DFM4C_QN_tab : VitalStateTableType := (
    ( L,  x,  x,  x,  x,  x,  x,  L ),
    ( H,  L,  L,  x,  L,  H,  x,  H ),
    ( H,  L,  H,  L,  x,  H,  x,  H ),
    ( H,  L,  x,  L,  L,  H,  x,  H ),
    ( H,  H,  x,  x,  x,  x,  x,  S ),
    ( H,  x,  x,  x,  x,  L,  x,  S ),
    ( x,  L,  L,  x,  H,  H,  x,  L ),
    ( x,  L,  H,  H,  x,  H,  x,  L ),
    ( x,  L,  x,  H,  H,  H,  x,  L ));

   CONSTANT DFM6A_Q_tab : VitalStateTableType := (
    ( L,  x,  x,  x,  x,  x,  x,  x,  x,  x,  L ),
    ( H,  L,  H,  H,  H,  H,  x,  x,  H,  x,  H ),
    ( H,  L,  H,  H,  x,  x,  H,  x,  H,  x,  H ),
    ( H,  L,  H,  x,  H,  x,  x,  H,  H,  x,  H ),
    ( H,  L,  H,  x,  x,  x,  H,  H,  H,  x,  H ),
    ( H,  L,  x,  H,  x,  H,  x,  L,  H,  x,  H ),
    ( H,  L,  x,  H,  x,  x,  H,  L,  H,  x,  H ),
    ( H,  L,  x,  x,  H,  H,  L,  x,  H,  x,  H ),
    ( H,  L,  x,  x,  H,  x,  L,  H,  H,  x,  H ),
    ( H,  L,  x,  x,  x,  H,  L,  L,  H,  x,  H ),
    ( H,  H,  x,  x,  x,  x,  x,  x,  x,  x,  S ),
    ( H,  x,  x,  x,  x,  x,  x,  x,  L,  x,  S ),
    ( x,  L,  L,  L,  L,  L,  x,  x,  H,  x,  L ),
    ( x,  L,  L,  L,  x,  x,  H,  x,  H,  x,  L ),
    ( x,  L,  L,  x,  L,  x,  x,  H,  H,  x,  L ),
    ( x,  L,  L,  x,  x,  x,  H,  H,  H,  x,  L ),
    ( x,  L,  x,  L,  x,  L,  x,  L,  H,  x,  L ),
    ( x,  L,  x,  L,  x,  x,  H,  L,  H,  x,  L ),
    ( x,  L,  x,  x,  L,  L,  L,  x,  H,  x,  L ),
    ( x,  L,  x,  x,  L,  x,  L,  H,  H,  x,  L ),
    ( x,  L,  x,  x,  x,  L,  L,  L,  H,  x,  L ));

   CONSTANT DFM7A_Q_tab : VitalStateTableType := (
    ( L,  x,  x,  x,  x,  x,  x,  x,  x,  x,  x,  L ),
    ( H,  L,  H,  H,  H,  H,  x,  x,  x,  H,  x,  H ),
    ( H,  L,  H,  H,  x,  x,  H,  x,  x,  H,  x,  H ),
    ( H,  L,  H,  H,  x,  x,  x,  H,  x,  H,  x,  H ),
    ( H,  L,  H,  x,  H,  x,  x,  x,  H,  H,  x,  H ),
    ( H,  L,  H,  x,  x,  x,  H,  x,  H,  H,  x,  H ),
    ( H,  L,  H,  x,  x,  x,  x,  H,  H,  H,  x,  H ),
    ( H,  L,  x,  H,  x,  H,  x,  x,  L,  H,  x,  H ),
    ( H,  L,  x,  H,  x,  x,  H,  x,  L,  H,  x,  H ),
    ( H,  L,  x,  H,  x,  x,  x,  H,  L,  H,  x,  H ),
    ( H,  L,  x,  x,  H,  H,  L,  L,  x,  H,  x,  H ),
    ( H,  L,  x,  x,  H,  x,  L,  L,  H,  H,  x,  H ),
    ( H,  L,  x,  x,  x,  H,  L,  L,  L,  H,  x,  H ),
    ( H,  H,  x,  x,  x,  x,  x,  x,  x,  x,  x,  S ),
    ( H,  x,  x,  x,  x,  x,  x,  x,  x,  L,  x,  S ),
    ( x,  L,  L,  L,  L,  L,  x,  x,  x,  H,  x,  L ),
    ( x,  L,  L,  L,  x,  x,  H,  x,  x,  H,  x,  L ),
    ( x,  L,  L,  L,  x,  x,  x,  H,  x,  H,  x,  L ),
    ( x,  L,  L,  x,  L,  x,  x,  x,  H,  H,  x,  L ),
    ( x,  L,  L,  x,  x,  x,  H,  x,  H,  H,  x,  L ),
    ( x,  L,  L,  x,  x,  x,  x,  H,  H,  H,  x,  L ),
    ( x,  L,  x,  L,  x,  L,  x,  x,  L,  H,  x,  L ),
    ( x,  L,  x,  L,  x,  x,  H,  x,  L,  H,  x,  L ),
    ( x,  L,  x,  L,  x,  x,  x,  H,  L,  H,  x,  L ),
    ( x,  L,  x,  x,  L,  L,  L,  L,  x,  H,  x,  L ),
    ( x,  L,  x,  x,  L,  x,  L,  L,  H,  H,  x,  L ),
    ( x,  L,  x,  x,  x,  L,  L,  L,  L,  H,  x,  L ));

   CONSTANT DFM8A_Q_tab : VitalStateTableType := (
    ( L,  x,  x,  x,  x,  x,  x,  x,  x,  x,  x,  x,  L ),
    ( H,  L,  H,  H,  H,  H,  x,  x,  x,  x,  H,  x,  H ),
    ( H,  L,  H,  H,  x,  x,  H,  x,  x,  x,  H,  x,  H ),
    ( H,  L,  H,  H,  x,  x,  x,  H,  x,  x,  H,  x,  H ),
    ( H,  L,  H,  x,  H,  x,  x,  x,  L,  x,  H,  x,  H ),
    ( H,  L,  H,  x,  H,  x,  x,  x,  x,  L,  H,  x,  H ),
    ( H,  L,  H,  x,  x,  x,  H,  x,  L,  x,  H,  x,  H ),
    ( H,  L,  H,  x,  x,  x,  H,  x,  x,  L,  H,  x,  H ),
    ( H,  L,  H,  x,  x,  x,  x,  H,  L,  x,  H,  x,  H ),
    ( H,  L,  H,  x,  x,  x,  x,  H,  x,  L,  H,  x,  H ),
    ( H,  L,  x,  H,  x,  H,  x,  x,  H,  H,  H,  x,  H ),
    ( H,  L,  x,  H,  x,  x,  H,  x,  H,  H,  H,  x,  H ),
    ( H,  L,  x,  H,  x,  x,  x,  H,  H,  H,  H,  x,  H ),
    ( H,  L,  x,  x,  H,  H,  L,  L,  x,  x,  H,  x,  H ),
    ( H,  L,  x,  x,  H,  x,  L,  L,  L,  x,  H,  x,  H ),
    ( H,  L,  x,  x,  H,  x,  L,  L,  x,  L,  H,  x,  H ),
    ( H,  L,  x,  x,  x,  H,  L,  L,  H,  H,  H,  x,  H ),
    ( H,  H,  x,  x,  x,  x,  x,  x,  x,  x,  x,  x,  S ),
    ( H,  x,  x,  x,  x,  x,  x,  x,  x,  x,  L,  x,  S ),
    ( x,  L,  L,  L,  L,  L,  x,  x,  x,  x,  H,  x,  L ),
    ( x,  L,  L,  L,  x,  x,  H,  x,  x,  x,  H,  x,  L ),
    ( x,  L,  L,  L,  x,  x,  x,  H,  x,  x,  H,  x,  L ),
    ( x,  L,  L,  x,  L,  x,  x,  x,  L,  x,  H,  x,  L ),
    ( x,  L,  L,  x,  L,  x,  x,  x,  x,  L,  H,  x,  L ),
    ( x,  L,  L,  x,  x,  x,  H,  x,  L,  x,  H,  x,  L ),
    ( x,  L,  L,  x,  x,  x,  H,  x,  x,  L,  H,  x,  L ),
    ( x,  L,  L,  x,  x,  x,  x,  H,  L,  x,  H,  x,  L ),
    ( x,  L,  L,  x,  x,  x,  x,  H,  x,  L,  H,  x,  L ),
    ( x,  L,  x,  L,  x,  L,  x,  x,  H,  H,  H,  x,  L ),
    ( x,  L,  x,  L,  x,  x,  H,  x,  H,  H,  H,  x,  L ),
    ( x,  L,  x,  L,  x,  x,  x,  H,  H,  H,  H,  x,  L ),
    ( x,  L,  x,  x,  L,  L,  L,  L,  x,  x,  H,  x,  L ),
    ( x,  L,  x,  x,  L,  x,  L,  L,  L,  x,  H,  x,  L ),
    ( x,  L,  x,  x,  L,  x,  L,  L,  x,  L,  H,  x,  L ),
    ( x,  L,  x,  x,  x,  L,  L,  L,  H,  H,  H,  x,  L ));

   CONSTANT DFME1A_Q_tab : VitalStateTableType := (
    ( L,  L,  L,  L,  x,  x,  H,  x,  L ),
    ( L,  L,  L,  x,  H,  x,  H,  x,  L ),
    ( L,  L,  x,  L,  L,  x,  H,  x,  L ),
    ( L,  L,  x,  x,  x,  H,  H,  x,  L ),
    ( L,  H,  H,  H,  x,  x,  H,  x,  H ),
    ( L,  H,  H,  x,  H,  x,  H,  x,  H ),
    ( L,  H,  x,  H,  L,  x,  H,  x,  H ),
    ( L,  H,  x,  x,  x,  H,  H,  x,  H ),
    ( L,  x,  L,  L,  x,  L,  H,  x,  L ),
    ( L,  x,  L,  x,  H,  L,  H,  x,  L ),
    ( L,  x,  H,  H,  x,  L,  H,  x,  H ),
    ( L,  x,  H,  x,  H,  L,  H,  x,  H ),
    ( L,  x,  x,  L,  L,  L,  H,  x,  L ),
    ( L,  x,  x,  H,  L,  L,  H,  x,  H ),
    ( H,  x,  x,  x,  x,  x,  x,  x,  S ),
    ( x,  x,  x,  x,  x,  x,  L,  x,  S ));

   CONSTANT DFP1_Q_tab : VitalStateTableType := (
    ( L,  L,  L,  H,  x,  L ),
    ( L,  H,  x,  H,  x,  H ),
    ( H,  x,  L,  x,  x,  S ),
    ( x,  x,  L,  L,  x,  S ),
    ( x,  x,  H,  x,  x,  H ));

   CONSTANT DFP1B_Q_tab : VitalStateTableType := (
    ( L,  L,  H,  H,  x,  L ),
    ( L,  H,  x,  H,  x,  H ),
    ( H,  x,  H,  x,  x,  S ),
    ( x,  x,  L,  x,  x,  H ),
    ( x,  x,  H,  L,  x,  S ));

   CONSTANT DFP1C_QN_tab : VitalStateTableType := (
    ( L,  L,  H,  L,  x,  H ),
    ( L,  H,  H,  x,  x,  L ),
    ( H,  x,  x,  L,  x,  S ),
    ( x,  x,  L,  L,  x,  S ),
    ( x,  x,  x,  H,  x,  L ));

   CONSTANT DFP1E_QN_tab : VitalStateTableType := (
    ( L,  x,  x,  x,  x,  L ),
    ( H,  L,  L,  H,  x,  H ),
    ( H,  H,  x,  x,  x,  S ),
    ( H,  x,  x,  L,  x,  S ),
    ( x,  L,  H,  H,  x,  L ));

   CONSTANT DFPC_Q_tab : VitalStateTableType := (
    ( L,  x,  x,  x,  x,  x,  L ),
    ( H,  L,  H,  x,  H,  x,  H ),
    ( H,  H,  x,  L,  x,  x,  S ),
    ( H,  x,  x,  L,  L,  x,  S ),
    ( H,  x,  x,  H,  x,  x,  H ),
    ( x,  L,  L,  L,  H,  x,  L ));

   CONSTANT DL1_Q_tab : VitalStateTableType := (
    ( L,  H,  x,  L ),
    ( H,  H,  x,  H ),
    ( x,  L,  x,  S ));

   CONSTANT DL1A_QN_tab : VitalStateTableType := (
    ( L,  H,  x,  H ),
    ( H,  H,  x,  L ),
    ( x,  L,  x,  S ));

   CONSTANT DL1B_Q_tab : VitalStateTableType := (
    ( L,  L,  x,  L ),
    ( L,  H,  x,  H ),
    ( H,  x,  x,  S ));

   CONSTANT DL1C_QN_tab : VitalStateTableType := (
    ( L,  L,  x,  H ),
    ( L,  H,  x,  L ),
    ( H,  x,  x,  S ));

   CONSTANT DL2A_Q_tab : VitalStateTableType := (
    ( L,  x,  x,  x,  x,  L ),
    ( H,  H,  x,  H,  x,  H ),
    ( H,  x,  L,  L,  x,  S ),
    ( H,  x,  H,  x,  x,  H ),
    ( x,  L,  L,  H,  x,  L ));

   CONSTANT DL2B_QN_tab : VitalStateTableType := (
    ( L,  L,  x,  x,  x,  L ),
    ( L,  H,  H,  x,  x,  S ),
    ( L,  x,  L,  H,  x,  L ),
    ( H,  x,  x,  x,  x,  H ),
    ( x,  H,  L,  L,  x,  H ));

   CONSTANT DL2C_Q_tab : VitalStateTableType := (
    ( L,  x,  x,  x,  x,  L ),
    ( H,  L,  H,  x,  x,  H ),
    ( H,  H,  x,  L,  x,  S ),
    ( H,  x,  x,  H,  x,  H ),
    ( x,  L,  L,  L,  x,  L ));

   CONSTANT DL2D_QN_tab : VitalStateTableType := (
    ( L,  L,  x,  x,  x,  L ),
    ( L,  H,  x,  L,  x,  S ),
    ( L,  x,  H,  H,  x,  L ),
    ( H,  x,  x,  x,  x,  H ),
    ( x,  H,  L,  H,  x,  H ));

   CONSTANT DLC_Q_tab : VitalStateTableType := (
    ( L,  x,  x,  x,  L ),
    ( H,  H,  H,  x,  H ),
    ( H,  x,  L,  x,  S ),
    ( x,  L,  H,  x,  L ));

   CONSTANT DLC1_Q_tab : VitalStateTableType := (
    ( L,  H,  x,  x,  L ),
    ( H,  H,  L,  x,  H ),
    ( x,  L,  L,  x,  S ),
    ( x,  x,  H,  x,  L ));

   CONSTANT DLC1A_Q_tab : VitalStateTableType := (
    ( L,  L,  x,  x,  L ),
    ( L,  H,  L,  x,  H ),
    ( H,  x,  L,  x,  S ),
    ( x,  x,  H,  x,  L ));

   CONSTANT DLC1F_QN_tab : VitalStateTableType := (
    ( L,  H,  H,  x,  L ),
    ( L,  x,  L,  x,  S ),
    ( H,  x,  x,  x,  H ),
    ( x,  L,  H,  x,  H ));

   CONSTANT DLC1G_QN_tab : VitalStateTableType := (
    ( L,  L,  H,  x,  L ),
    ( L,  x,  L,  x,  H ),
    ( H,  L,  x,  x,  S ),
    ( x,  H,  x,  x,  H ));

   CONSTANT DLCA_Q_tab : VitalStateTableType := (
    ( L,  x,  x,  x,  L ),
    ( H,  L,  H,  x,  H ),
    ( H,  H,  x,  x,  S ),
    ( x,  L,  L,  x,  L ));

   CONSTANT DLE_Q_tab : VitalStateTableType := (
    ( L,  H,  H,  x,  L ),
    ( H,  H,  H,  x,  H ),
    ( x,  L,  x,  x,  S ),
    ( x,  x,  L,  x,  S ));

   CONSTANT DLE1D_QN_tab : VitalStateTableType := (
    ( L,  L,  L,  x,  H ),
    ( L,  L,  H,  x,  L ),
    ( H,  x,  x,  x,  S ),
    ( x,  H,  x,  x,  S ));

   CONSTANT DLE2B_Q_tab : VitalStateTableType := (
    ( L,  x,  x,  x,  x,  L ),
    ( H,  L,  L,  H,  x,  H ),
    ( H,  H,  x,  x,  x,  S ),
    ( H,  x,  H,  x,  x,  S ),
    ( x,  L,  L,  L,  x,  L ));

   CONSTANT DLE2C_Q_tab : VitalStateTableType := (
    ( L,  L,  L,  x,  x,  L ),
    ( L,  L,  H,  L,  x,  H ),
    ( H,  x,  x,  L,  x,  S ),
    ( x,  H,  x,  L,  x,  S ),
    ( x,  x,  x,  H,  x,  L ));

   CONSTANT DLE3B_Q_tab : VitalStateTableType := (
    ( L,  L,  L,  L,  x,  L ),
    ( L,  L,  H,  x,  x,  H ),
    ( H,  x,  x,  L,  x,  S ),
    ( x,  H,  x,  L,  x,  S ),
    ( x,  x,  x,  H,  x,  H ));

   CONSTANT DLE3C_Q_tab : VitalStateTableType := (
    ( L,  L,  L,  H,  x,  L ),
    ( L,  L,  H,  x,  x,  H ),
    ( H,  x,  x,  H,  x,  S ),
    ( x,  H,  x,  H,  x,  S ),
    ( x,  x,  x,  L,  x,  H ));

   CONSTANT DLEC_Q_tab : VitalStateTableType := (
    ( L,  L,  L,  x,  L ),
    ( L,  L,  H,  x,  H ),
    ( H,  x,  x,  x,  S ),
    ( x,  H,  x,  x,  S ));

   CONSTANT DLM_Q_tab : VitalStateTableType := (
    ( L,  L,  x,  H,  x,  L ),
    ( L,  x,  H,  H,  x,  L ),
    ( H,  H,  x,  H,  x,  H ),
    ( H,  x,  H,  H,  x,  H ),
    ( x,  L,  L,  H,  x,  L ),
    ( x,  H,  L,  H,  x,  H ),
    ( x,  x,  x,  L,  x,  S ));

   CONSTANT DLM2_Q_tab : VitalStateTableType := (
    ( L,  x,  x,  x,  x,  x,  L ),
    ( H,  H,  H,  x,  H,  x,  H ),
    ( H,  H,  x,  H,  H,  x,  H ),
    ( H,  x,  H,  L,  H,  x,  H ),
    ( H,  x,  x,  x,  L,  x,  S ),
    ( x,  L,  L,  x,  H,  x,  L ),
    ( x,  L,  x,  H,  H,  x,  L ),
    ( x,  x,  L,  L,  H,  x,  L ));

   CONSTANT DLM2B_Q_tab : VitalStateTableType := (
    ( L,  x,  x,  x,  x,  x,  L ),
    ( H,  L,  H,  H,  x,  x,  H ),
    ( H,  L,  H,  x,  H,  x,  H ),
    ( H,  L,  x,  H,  L,  x,  H ),
    ( H,  H,  x,  x,  x,  x,  S ),
    ( x,  L,  L,  L,  x,  x,  L ),
    ( x,  L,  L,  x,  H,  x,  L ),
    ( x,  L,  x,  L,  L,  x,  L ));

   CONSTANT DLM3_Q_tab : VitalStateTableType := (
    ( L,  L,  L,  L,  x,  x,  H,  x,  L ),
    ( L,  L,  x,  x,  H,  x,  H,  x,  L ),
    ( L,  x,  L,  x,  x,  H,  H,  x,  L ),
    ( L,  x,  x,  x,  H,  H,  H,  x,  L ),
    ( H,  H,  H,  H,  x,  x,  H,  x,  H ),
    ( H,  H,  x,  x,  H,  x,  H,  x,  H ),
    ( H,  x,  H,  x,  x,  H,  H,  x,  H ),
    ( H,  x,  x,  x,  H,  H,  H,  x,  H ),
    ( x,  L,  x,  L,  x,  L,  H,  x,  L ),
    ( x,  L,  x,  x,  H,  L,  H,  x,  L ),
    ( x,  H,  x,  H,  x,  L,  H,  x,  H ),
    ( x,  H,  x,  x,  H,  L,  H,  x,  H ),
    ( x,  x,  L,  L,  L,  x,  H,  x,  L ),
    ( x,  x,  L,  x,  L,  H,  H,  x,  L ),
    ( x,  x,  H,  H,  L,  x,  H,  x,  H ),
    ( x,  x,  H,  x,  L,  H,  H,  x,  H ),
    ( x,  x,  x,  L,  L,  L,  H,  x,  L ),
    ( x,  x,  x,  H,  L,  L,  H,  x,  H ),
    ( x,  x,  x,  x,  x,  x,  L,  x,  S ));

   CONSTANT DLM3A_Q_tab : VitalStateTableType := (
    ( L,  L,  L,  L,  L,  x,  x,  x,  L ),
    ( L,  L,  L,  x,  x,  H,  x,  x,  L ),
    ( L,  L,  x,  L,  x,  x,  H,  x,  L ),
    ( L,  L,  x,  x,  x,  H,  H,  x,  L ),
    ( L,  H,  H,  H,  H,  x,  x,  x,  H ),
    ( L,  H,  H,  x,  x,  H,  x,  x,  H ),
    ( L,  H,  x,  H,  x,  x,  H,  x,  H ),
    ( L,  H,  x,  x,  x,  H,  H,  x,  H ),
    ( L,  x,  L,  x,  L,  x,  L,  x,  L ),
    ( L,  x,  L,  x,  x,  H,  L,  x,  L ),
    ( L,  x,  H,  x,  H,  x,  L,  x,  H ),
    ( L,  x,  H,  x,  x,  H,  L,  x,  H ),
    ( L,  x,  x,  L,  L,  L,  x,  x,  L ),
    ( L,  x,  x,  L,  x,  L,  H,  x,  L ),
    ( L,  x,  x,  H,  H,  L,  x,  x,  H ),
    ( L,  x,  x,  H,  x,  L,  H,  x,  H ),
    ( L,  x,  x,  x,  L,  L,  L,  x,  L ),
    ( L,  x,  x,  x,  H,  L,  L,  x,  H ),
    ( H,  x,  x,  x,  x,  x,  x,  x,  S ));

   CONSTANT DLM4_Q_tab : VitalStateTableType := (
    ( L,  L,  L,  L,  x,  x,  x,  H,  x,  L ),
    ( L,  L,  x,  x,  H,  x,  x,  H,  x,  L ),
    ( L,  L,  x,  x,  x,  H,  x,  H,  x,  L ),
    ( L,  x,  L,  x,  x,  x,  H,  H,  x,  L ),
    ( L,  x,  x,  x,  H,  x,  H,  H,  x,  L ),
    ( L,  x,  x,  x,  x,  H,  H,  H,  x,  L ),
    ( H,  H,  H,  H,  x,  x,  x,  H,  x,  H ),
    ( H,  H,  x,  x,  H,  x,  x,  H,  x,  H ),
    ( H,  H,  x,  x,  x,  H,  x,  H,  x,  H ),
    ( H,  x,  H,  x,  x,  x,  H,  H,  x,  H ),
    ( H,  x,  x,  x,  H,  x,  H,  H,  x,  H ),
    ( H,  x,  x,  x,  x,  H,  H,  H,  x,  H ),
    ( x,  L,  x,  L,  x,  x,  L,  H,  x,  L ),
    ( x,  L,  x,  x,  H,  x,  L,  H,  x,  L ),
    ( x,  L,  x,  x,  x,  H,  L,  H,  x,  L ),
    ( x,  H,  x,  H,  x,  x,  L,  H,  x,  H ),
    ( x,  H,  x,  x,  H,  x,  L,  H,  x,  H ),
    ( x,  H,  x,  x,  x,  H,  L,  H,  x,  H ),
    ( x,  x,  L,  L,  L,  L,  x,  H,  x,  L ),
    ( x,  x,  L,  x,  L,  L,  H,  H,  x,  L ),
    ( x,  x,  H,  H,  L,  L,  x,  H,  x,  H ),
    ( x,  x,  H,  x,  L,  L,  H,  H,  x,  H ),
    ( x,  x,  x,  L,  L,  L,  L,  H,  x,  L ),
    ( x,  x,  x,  H,  L,  L,  L,  H,  x,  H ),
    ( x,  x,  x,  x,  x,  x,  x,  L,  x,  S ));

   CONSTANT DLM4A_Q_tab : VitalStateTableType := (
    ( L,  L,  L,  L,  L,  x,  x,  x,  x,  L ),
    ( L,  L,  L,  x,  x,  H,  x,  x,  x,  L ),
    ( L,  L,  L,  x,  x,  x,  H,  x,  x,  L ),
    ( L,  L,  x,  L,  x,  x,  x,  H,  x,  L ),
    ( L,  L,  x,  x,  x,  H,  x,  H,  x,  L ),
    ( L,  L,  x,  x,  x,  x,  H,  H,  x,  L ),
    ( L,  H,  H,  H,  H,  x,  x,  x,  x,  H ),
    ( L,  H,  H,  x,  x,  H,  x,  x,  x,  H ),
    ( L,  H,  H,  x,  x,  x,  H,  x,  x,  H ),
    ( L,  H,  x,  H,  x,  x,  x,  H,  x,  H ),
    ( L,  H,  x,  x,  x,  H,  x,  H,  x,  H ),
    ( L,  H,  x,  x,  x,  x,  H,  H,  x,  H ),
    ( L,  x,  L,  x,  L,  x,  x,  L,  x,  L ),
    ( L,  x,  L,  x,  x,  H,  x,  L,  x,  L ),
    ( L,  x,  L,  x,  x,  x,  H,  L,  x,  L ),
    ( L,  x,  H,  x,  H,  x,  x,  L,  x,  H ),
    ( L,  x,  H,  x,  x,  H,  x,  L,  x,  H ),
    ( L,  x,  H,  x,  x,  x,  H,  L,  x,  H ),
    ( L,  x,  x,  L,  L,  L,  L,  x,  x,  L ),
    ( L,  x,  x,  L,  x,  L,  L,  H,  x,  L ),
    ( L,  x,  x,  H,  H,  L,  L,  x,  x,  H ),
    ( L,  x,  x,  H,  x,  L,  L,  H,  x,  H ),
    ( L,  x,  x,  x,  L,  L,  L,  L,  x,  L ),
    ( L,  x,  x,  x,  H,  L,  L,  L,  x,  H ),
    ( H,  x,  x,  x,  x,  x,  x,  x,  x,  S ));

   CONSTANT DLM8A_Q_tab : VitalStateTableType := (
    ( L,  x,  x,  x,  x,  x,  x,  x,  x,  x,  x,  L ),
    ( H,  H,  H,  H,  H,  x,  x,  x,  x,  H,  x,  H ),
    ( H,  H,  H,  x,  x,  H,  x,  x,  x,  H,  x,  H ),
    ( H,  H,  H,  x,  x,  x,  H,  x,  x,  H,  x,  H ),
    ( H,  H,  x,  H,  x,  x,  x,  L,  x,  H,  x,  H ),
    ( H,  H,  x,  H,  x,  x,  x,  x,  L,  H,  x,  H ),
    ( H,  H,  x,  x,  x,  H,  x,  L,  x,  H,  x,  H ),
    ( H,  H,  x,  x,  x,  H,  x,  x,  L,  H,  x,  H ),
    ( H,  H,  x,  x,  x,  x,  H,  L,  x,  H,  x,  H ),
    ( H,  H,  x,  x,  x,  x,  H,  x,  L,  H,  x,  H ),
    ( H,  x,  H,  x,  H,  x,  x,  H,  H,  H,  x,  H ),
    ( H,  x,  H,  x,  x,  H,  x,  H,  H,  H,  x,  H ),
    ( H,  x,  H,  x,  x,  x,  H,  H,  H,  H,  x,  H ),
    ( H,  x,  x,  H,  H,  L,  L,  x,  x,  H,  x,  H ),
    ( H,  x,  x,  H,  x,  L,  L,  L,  x,  H,  x,  H ),
    ( H,  x,  x,  H,  x,  L,  L,  x,  L,  H,  x,  H ),
    ( H,  x,  x,  x,  H,  L,  L,  H,  H,  H,  x,  H ),
    ( H,  x,  x,  x,  x,  x,  x,  x,  x,  L,  x,  S ),
    ( x,  L,  L,  L,  L,  x,  x,  x,  x,  H,  x,  L ),
    ( x,  L,  L,  x,  x,  H,  x,  x,  x,  H,  x,  L ),
    ( x,  L,  L,  x,  x,  x,  H,  x,  x,  H,  x,  L ),
    ( x,  L,  x,  L,  x,  x,  x,  L,  x,  H,  x,  L ),
    ( x,  L,  x,  L,  x,  x,  x,  x,  L,  H,  x,  L ),
    ( x,  L,  x,  x,  x,  H,  x,  L,  x,  H,  x,  L ),
    ( x,  L,  x,  x,  x,  H,  x,  x,  L,  H,  x,  L ),
    ( x,  L,  x,  x,  x,  x,  H,  L,  x,  H,  x,  L ),
    ( x,  L,  x,  x,  x,  x,  H,  x,  L,  H,  x,  L ),
    ( x,  x,  L,  x,  L,  x,  x,  H,  H,  H,  x,  L ),
    ( x,  x,  L,  x,  x,  H,  x,  H,  H,  H,  x,  L ),
    ( x,  x,  L,  x,  x,  x,  H,  H,  H,  H,  x,  L ),
    ( x,  x,  x,  L,  L,  L,  L,  x,  x,  H,  x,  L ),
    ( x,  x,  x,  L,  x,  L,  L,  L,  x,  H,  x,  L ),
    ( x,  x,  x,  L,  x,  L,  L,  x,  L,  H,  x,  L ),
    ( x,  x,  x,  x,  L,  L,  L,  H,  H,  H,  x,  L ));

   CONSTANT DLM8B_Q_tab : VitalStateTableType := (
    ( L,  x,  x,  x,  x,  x,  x,  x,  x,  x,  x,  L ),
    ( H,  L,  H,  H,  H,  H,  x,  x,  x,  x,  x,  H ),
    ( H,  L,  H,  H,  x,  x,  H,  x,  x,  x,  x,  H ),
    ( H,  L,  H,  H,  x,  x,  x,  H,  x,  x,  x,  H ),
    ( H,  L,  H,  x,  H,  x,  x,  x,  L,  x,  x,  H ),
    ( H,  L,  H,  x,  H,  x,  x,  x,  x,  L,  x,  H ),
    ( H,  L,  H,  x,  x,  x,  H,  x,  L,  x,  x,  H ),
    ( H,  L,  H,  x,  x,  x,  H,  x,  x,  L,  x,  H ),
    ( H,  L,  H,  x,  x,  x,  x,  H,  L,  x,  x,  H ),
    ( H,  L,  H,  x,  x,  x,  x,  H,  x,  L,  x,  H ),
    ( H,  L,  x,  H,  x,  H,  x,  x,  H,  H,  x,  H ),
    ( H,  L,  x,  H,  x,  x,  H,  x,  H,  H,  x,  H ),
    ( H,  L,  x,  H,  x,  x,  x,  H,  H,  H,  x,  H ),
    ( H,  L,  x,  x,  H,  H,  L,  L,  x,  x,  x,  H ),
    ( H,  L,  x,  x,  H,  x,  L,  L,  L,  x,  x,  H ),
    ( H,  L,  x,  x,  H,  x,  L,  L,  x,  L,  x,  H ),
    ( H,  L,  x,  x,  x,  H,  L,  L,  H,  H,  x,  H ),
    ( H,  H,  x,  x,  x,  x,  x,  x,  x,  x,  x,  S ),
    ( x,  L,  L,  L,  L,  L,  x,  x,  x,  x,  x,  L ),
    ( x,  L,  L,  L,  x,  x,  H,  x,  x,  x,  x,  L ),
    ( x,  L,  L,  L,  x,  x,  x,  H,  x,  x,  x,  L ),
    ( x,  L,  L,  x,  L,  x,  x,  x,  L,  x,  x,  L ),
    ( x,  L,  L,  x,  L,  x,  x,  x,  x,  L,  x,  L ),
    ( x,  L,  L,  x,  x,  x,  H,  x,  L,  x,  x,  L ),
    ( x,  L,  L,  x,  x,  x,  H,  x,  x,  L,  x,  L ),
    ( x,  L,  L,  x,  x,  x,  x,  H,  L,  x,  x,  L ),
    ( x,  L,  L,  x,  x,  x,  x,  H,  x,  L,  x,  L ),
    ( x,  L,  x,  L,  x,  L,  x,  x,  H,  H,  x,  L ),
    ( x,  L,  x,  L,  x,  x,  H,  x,  H,  H,  x,  L ),
    ( x,  L,  x,  L,  x,  x,  x,  H,  H,  H,  x,  L ),
    ( x,  L,  x,  x,  L,  L,  L,  L,  x,  x,  x,  L ),
    ( x,  L,  x,  x,  L,  x,  L,  L,  L,  x,  x,  L ),
    ( x,  L,  x,  x,  L,  x,  L,  L,  x,  L,  x,  L ),
    ( x,  L,  x,  x,  x,  L,  L,  L,  H,  H,  x,  L ));

   CONSTANT DLMA_Q_tab : VitalStateTableType := (
    ( L,  L,  L,  x,  x,  L ),
    ( L,  L,  x,  H,  x,  L ),
    ( L,  H,  H,  x,  x,  H ),
    ( L,  H,  x,  H,  x,  H ),
    ( L,  x,  L,  L,  x,  L ),
    ( L,  x,  H,  L,  x,  H ),
    ( H,  x,  x,  x,  x,  S ));

   CONSTANT DLME1A_Q_tab : VitalStateTableType := (
    ( L,  L,  L,  L,  x,  x,  L ),
    ( L,  L,  L,  x,  H,  x,  L ),
    ( L,  L,  H,  H,  x,  x,  H ),
    ( L,  L,  H,  x,  H,  x,  H ),
    ( L,  L,  x,  L,  L,  x,  L ),
    ( L,  L,  x,  H,  L,  x,  H ),
    ( H,  x,  x,  x,  x,  x,  S ),
    ( x,  H,  x,  x,  x,  x,  S ));

   CONSTANT DLP1_Q_tab : VitalStateTableType := (
    ( L,  L,  H,  x,  L ),
    ( H,  x,  H,  x,  H ),
    ( x,  L,  L,  x,  S ),
    ( x,  H,  x,  x,  H ));

   CONSTANT DLP1A_Q_tab : VitalStateTableType := (
    ( L,  L,  L,  x,  L ),
    ( L,  H,  x,  x,  H ),
    ( H,  x,  L,  x,  S ),
    ( x,  x,  H,  x,  H ));

   CONSTANT DLP1B_Q_tab : VitalStateTableType := (
    ( L,  H,  H,  x,  L ),
    ( H,  x,  H,  x,  H ),
    ( x,  L,  x,  x,  H ),
    ( x,  H,  L,  x,  S ));

   CONSTANT DLP1C_Q_tab : VitalStateTableType := (
    ( L,  L,  H,  x,  L ),
    ( L,  H,  x,  x,  H ),
    ( H,  x,  H,  x,  S ),
    ( x,  x,  L,  x,  H ));

   CONSTANT DLP1D_QN_tab : VitalStateTableType := (
    ( L,  x,  x,  x,  L ),
    ( H,  L,  H,  x,  H ),
    ( H,  x,  L,  x,  S ),
    ( x,  H,  H,  x,  L ));

   CONSTANT DLP1E_QN_tab : VitalStateTableType := (
    ( L,  x,  x,  x,  L ),
    ( H,  L,  L,  x,  H ),
    ( H,  H,  x,  x,  S ),
    ( x,  L,  H,  x,  L ));

   CONSTANT IODFEP_Q_tab : VitalStateTableType := (
    ( L,  L,  L,  x,  H,  H,  x,  L ),
    ( L,  L,  x,  H,  H,  H,  x,  L ),
    ( L,  H,  H,  x,  x,  H,  x,  H ),
    ( L,  H,  x,  H,  x,  H,  x,  H ),
    ( L,  x,  L,  L,  H,  H,  x,  L ),
    ( L,  x,  H,  L,  x,  H,  x,  H ),
    ( H,  x,  x,  x,  H,  x,  x,  S ),
    ( x,  x,  x,  x,  L,  x,  x,  H ),
    ( x,  x,  x,  x,  H,  L,  x,  S ));

   CONSTANT TF1A_Q_tab : VitalStateTableType := (
    ( L,  x,  x,  x,  x,  x,  L ),
    ( H,  L,  L,  H,  H,  x,  H ),
    ( H,  L,  H,  L,  H,  x,  H ),
    ( H,  H,  x,  x,  x,  x,  S ),
    ( H,  x,  x,  x,  L,  x,  S ),
    ( x,  L,  L,  L,  H,  x,  L ),
    ( x,  L,  H,  H,  H,  x,  L ));


end VTABLES;

---- end of VITAL tables library ----
----- CELL AND2 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AND2 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AND2 : entity is TRUE;
end AND2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of AND2 is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := (B_ipd) AND (A_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (B_ipd'last_event, tpd_B_Y, TRUE),
                 1 => (A_ipd'last_event, tpd_A_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AND2_VITAL of AND2 is
   for VITAL_ACT
   end for;
end CFG_AND2_VITAL;


----- CELL AND2A -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AND2A is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AND2A : entity is TRUE;
end AND2A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of AND2A is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := (B_ipd) AND ((NOT A_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (A_ipd'last_event, tpd_A_Y, TRUE),
                 1 => (B_ipd'last_event, tpd_B_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AND2A_VITAL of AND2A is
   for VITAL_ACT
   end for;
end CFG_AND2A_VITAL;


----- CELL AND2B -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AND2B is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AND2B : entity is TRUE;
end AND2B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of AND2B is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := ((NOT B_ipd)) AND ((NOT A_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (B_ipd'last_event, tpd_B_Y, TRUE),
                 1 => (A_ipd'last_event, tpd_A_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AND2B_VITAL of AND2B is
   for VITAL_ACT
   end for;
end CFG_AND2B_VITAL;


----- CELL AND3 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AND3 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AND3 : entity is TRUE;
end AND3;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of AND3 is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';
   SIGNAL C_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   VitalWireDelay (C_ipd, C, tipd_C);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd, C_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := (B_ipd) AND (A_ipd) AND (C_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (C_ipd'last_event, tpd_C_Y, TRUE),
                 1 => (B_ipd'last_event, tpd_B_Y, TRUE),
                 2 => (A_ipd'last_event, tpd_A_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AND3_VITAL of AND3 is
   for VITAL_ACT
   end for;
end CFG_AND3_VITAL;


----- CELL AND3A -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AND3A is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AND3A : entity is TRUE;
end AND3A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of AND3A is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';
   SIGNAL C_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   VitalWireDelay (C_ipd, C, tipd_C);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd, C_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := (B_ipd) AND ((NOT A_ipd)) AND (C_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (A_ipd'last_event, tpd_A_Y, TRUE),
                 1 => (C_ipd'last_event, tpd_C_Y, TRUE),
                 2 => (B_ipd'last_event, tpd_B_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AND3A_VITAL of AND3A is
   for VITAL_ACT
   end for;
end CFG_AND3A_VITAL;


----- CELL AND3B -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AND3B is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AND3B : entity is TRUE;
end AND3B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of AND3B is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';
   SIGNAL C_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   VitalWireDelay (C_ipd, C, tipd_C);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd, C_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := ((NOT B_ipd)) AND ((NOT A_ipd)) AND (C_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (B_ipd'last_event, tpd_B_Y, TRUE),
                 1 => (A_ipd'last_event, tpd_A_Y, TRUE),
                 2 => (C_ipd'last_event, tpd_C_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AND3B_VITAL of AND3B is
   for VITAL_ACT
   end for;
end CFG_AND3B_VITAL;


----- CELL AND3C -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AND3C is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AND3C : entity is TRUE;
end AND3C;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of AND3C is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';
   SIGNAL C_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   VitalWireDelay (C_ipd, C, tipd_C);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd, C_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := ((NOT B_ipd)) AND ((NOT A_ipd)) AND ((NOT C_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (C_ipd'last_event, tpd_C_Y, TRUE),
                 1 => (B_ipd'last_event, tpd_B_Y, TRUE),
                 2 => (A_ipd'last_event, tpd_A_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AND3C_VITAL of AND3C is
   for VITAL_ACT
   end for;
end CFG_AND3C_VITAL;


----- CELL AND4 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AND4 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AND4 : entity is TRUE;
end AND4;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of AND4 is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';
   SIGNAL C_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   VitalWireDelay (C_ipd, C, tipd_C);
   VitalWireDelay (D_ipd, D, tipd_D);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := (B_ipd) AND (A_ipd) AND (C_ipd) AND (D_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (D_ipd'last_event, tpd_D_Y, TRUE),
                 1 => (C_ipd'last_event, tpd_C_Y, TRUE),
                 2 => (B_ipd'last_event, tpd_B_Y, TRUE),
                 3 => (A_ipd'last_event, tpd_A_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AND4_VITAL of AND4 is
   for VITAL_ACT
   end for;
end CFG_AND4_VITAL;


----- CELL AND4A -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AND4A is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AND4A : entity is TRUE;
end AND4A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of AND4A is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';
   SIGNAL C_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   VitalWireDelay (C_ipd, C, tipd_C);
   VitalWireDelay (D_ipd, D, tipd_D);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := (B_ipd) AND ((NOT A_ipd)) AND (C_ipd) AND (D_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (A_ipd'last_event, tpd_A_Y, TRUE),
                 1 => (D_ipd'last_event, tpd_D_Y, TRUE),
                 2 => (C_ipd'last_event, tpd_C_Y, TRUE),
                 3 => (B_ipd'last_event, tpd_B_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AND4A_VITAL of AND4A is
   for VITAL_ACT
   end for;
end CFG_AND4A_VITAL;


----- CELL AND4B -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AND4B is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AND4B : entity is TRUE;
end AND4B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of AND4B is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';
   SIGNAL C_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   VitalWireDelay (C_ipd, C, tipd_C);
   VitalWireDelay (D_ipd, D, tipd_D);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := ((NOT B_ipd)) AND ((NOT A_ipd)) AND (C_ipd) AND (D_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (B_ipd'last_event, tpd_B_Y, TRUE),
                 1 => (A_ipd'last_event, tpd_A_Y, TRUE),
                 2 => (D_ipd'last_event, tpd_D_Y, TRUE),
                 3 => (C_ipd'last_event, tpd_C_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AND4B_VITAL of AND4B is
   for VITAL_ACT
   end for;
end CFG_AND4B_VITAL;


----- CELL AND4C -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AND4C is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AND4C : entity is TRUE;
end AND4C;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of AND4C is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';
   SIGNAL C_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   VitalWireDelay (C_ipd, C, tipd_C);
   VitalWireDelay (D_ipd, D, tipd_D);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd :=
       ((NOT B_ipd)) AND ((NOT A_ipd)) AND ((NOT C_ipd)) AND (D_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (C_ipd'last_event, tpd_C_Y, TRUE),
                 1 => (B_ipd'last_event, tpd_B_Y, TRUE),
                 2 => (A_ipd'last_event, tpd_A_Y, TRUE),
                 3 => (D_ipd'last_event, tpd_D_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AND4C_VITAL of AND4C is
   for VITAL_ACT
   end for;
end CFG_AND4C_VITAL;


----- CELL AND4D -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AND4D is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AND4D : entity is TRUE;
end AND4D;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of AND4D is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';
   SIGNAL C_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   VitalWireDelay (C_ipd, C, tipd_C);
   VitalWireDelay (D_ipd, D, tipd_D);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd :=
       ((NOT B_ipd)) AND ((NOT A_ipd)) AND ((NOT C_ipd)) AND ((NOT D_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (D_ipd'last_event, tpd_D_Y, TRUE),
                 1 => (C_ipd'last_event, tpd_C_Y, TRUE),
                 2 => (B_ipd'last_event, tpd_B_Y, TRUE),
                 3 => (A_ipd'last_event, tpd_A_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AND4D_VITAL of AND4D is
   for VITAL_ACT
   end for;
end CFG_AND4D_VITAL;


----- CELL AND5B -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AND5B is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_E_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AND5B : entity is TRUE;
end AND5B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of AND5B is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';
   SIGNAL C_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL E_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   VitalWireDelay (C_ipd, C, tipd_C);
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (E_ipd, E, tipd_E);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd, E_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd :=
       ((NOT B_ipd)) AND ((NOT A_ipd)) AND (C_ipd) AND (D_ipd) AND (E_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (B_ipd'last_event, tpd_B_Y, TRUE),
                 1 => (A_ipd'last_event, tpd_A_Y, TRUE),
                 2 => (E_ipd'last_event, tpd_E_Y, TRUE),
                 3 => (D_ipd'last_event, tpd_D_Y, TRUE),
                 4 => (C_ipd'last_event, tpd_C_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AND5B_VITAL of AND5B is
   for VITAL_ACT
   end for;
end CFG_AND5B_VITAL;


----- CELL AO1 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AO1 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AO1 : entity is TRUE;
end AO1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of AO1 is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';
   SIGNAL C_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   VitalWireDelay (C_ipd, C, tipd_C);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd, C_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := (C_ipd) OR ((B_ipd) AND (A_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (C_ipd'last_event, tpd_C_Y, TRUE),
                 1 => (B_ipd'last_event, tpd_B_Y, TRUE),
                 2 => (A_ipd'last_event, tpd_A_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AO1_VITAL of AO1 is
   for VITAL_ACT
   end for;
end CFG_AO1_VITAL;


----- CELL AO10 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AO10 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_E_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AO10 : entity is TRUE;
end AO10;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of AO10 is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';
   SIGNAL C_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL E_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   VitalWireDelay (C_ipd, C, tipd_C);
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (E_ipd, E, tipd_E);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd, E_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := ((E_ipd) OR (D_ipd)) AND ((C_ipd) OR ((B_ipd) AND (A_ipd)));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (E_ipd'last_event, tpd_E_Y, TRUE),
                 1 => (D_ipd'last_event, tpd_D_Y, TRUE),
                 2 => (C_ipd'last_event, tpd_C_Y, TRUE),
                 3 => (B_ipd'last_event, tpd_B_Y, TRUE),
                 4 => (A_ipd'last_event, tpd_A_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AO10_VITAL of AO10 is
   for VITAL_ACT
   end for;
end CFG_AO10_VITAL;


----- CELL AO11 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AO11 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AO11 : entity is TRUE;
end AO11;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of AO11 is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';
   SIGNAL C_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   VitalWireDelay (C_ipd, C, tipd_C);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd, C_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := ((C_ipd) AND ((B_ipd) OR (A_ipd))) OR ((B_ipd) AND (A_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (C_ipd'last_event, tpd_C_Y, TRUE),
                 1 => (B_ipd'last_event, tpd_B_Y, TRUE),
                 2 => (A_ipd'last_event, tpd_A_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AO11_VITAL of AO11 is
   for VITAL_ACT
   end for;
end CFG_AO11_VITAL;


----- CELL AO1A -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AO1A is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AO1A : entity is TRUE;
end AO1A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of AO1A is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';
   SIGNAL C_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   VitalWireDelay (C_ipd, C, tipd_C);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd, C_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := (C_ipd) OR ((B_ipd) AND ((NOT A_ipd)));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (A_ipd'last_event, tpd_A_Y, TRUE),
                 1 => (C_ipd'last_event, tpd_C_Y, TRUE),
                 2 => (B_ipd'last_event, tpd_B_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AO1A_VITAL of AO1A is
   for VITAL_ACT
   end for;
end CFG_AO1A_VITAL;


----- CELL AO1B -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AO1B is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AO1B : entity is TRUE;
end AO1B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of AO1B is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';
   SIGNAL C_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   VitalWireDelay (C_ipd, C, tipd_C);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd, C_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := ((NOT C_ipd)) OR ((B_ipd) AND (A_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (C_ipd'last_event, tpd_C_Y, TRUE),
                 1 => (B_ipd'last_event, tpd_B_Y, TRUE),
                 2 => (A_ipd'last_event, tpd_A_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AO1B_VITAL of AO1B is
   for VITAL_ACT
   end for;
end CFG_AO1B_VITAL;


----- CELL AO1C -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AO1C is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AO1C : entity is TRUE;
end AO1C;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of AO1C is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';
   SIGNAL C_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   VitalWireDelay (C_ipd, C, tipd_C);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd, C_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := ((NOT C_ipd)) OR ((B_ipd) AND ((NOT A_ipd)));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (C_ipd'last_event, tpd_C_Y, TRUE),
                 1 => (A_ipd'last_event, tpd_A_Y, TRUE),
                 2 => (B_ipd'last_event, tpd_B_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AO1C_VITAL of AO1C is
   for VITAL_ACT
   end for;
end CFG_AO1C_VITAL;


----- CELL AO1D -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AO1D is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AO1D : entity is TRUE;
end AO1D;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of AO1D is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';
   SIGNAL C_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   VitalWireDelay (C_ipd, C, tipd_C);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd, C_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := (C_ipd) OR (((NOT B_ipd)) AND ((NOT A_ipd)));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (B_ipd'last_event, tpd_B_Y, TRUE),
                 1 => (A_ipd'last_event, tpd_A_Y, TRUE),
                 2 => (C_ipd'last_event, tpd_C_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AO1D_VITAL of AO1D is
   for VITAL_ACT
   end for;
end CFG_AO1D_VITAL;


----- CELL AO1E -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AO1E is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AO1E : entity is TRUE;
end AO1E;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of AO1E is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';
   SIGNAL C_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   VitalWireDelay (C_ipd, C, tipd_C);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd, C_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := ((NOT C_ipd)) OR (((NOT B_ipd)) AND ((NOT A_ipd)));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (C_ipd'last_event, tpd_C_Y, TRUE),
                 1 => (B_ipd'last_event, tpd_B_Y, TRUE),
                 2 => (A_ipd'last_event, tpd_A_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AO1E_VITAL of AO1E is
   for VITAL_ACT
   end for;
end CFG_AO1E_VITAL;


----- CELL AO2 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AO2 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AO2 : entity is TRUE;
end AO2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of AO2 is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';
   SIGNAL C_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   VitalWireDelay (C_ipd, C, tipd_C);
   VitalWireDelay (D_ipd, D, tipd_D);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := (C_ipd) OR ((B_ipd) AND (A_ipd)) OR (D_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (D_ipd'last_event, tpd_D_Y, TRUE),
                 1 => (C_ipd'last_event, tpd_C_Y, TRUE),
                 2 => (B_ipd'last_event, tpd_B_Y, TRUE),
                 3 => (A_ipd'last_event, tpd_A_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AO2_VITAL of AO2 is
   for VITAL_ACT
   end for;
end CFG_AO2_VITAL;


----- CELL AO2A -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AO2A is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AO2A : entity is TRUE;
end AO2A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of AO2A is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';
   SIGNAL C_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   VitalWireDelay (C_ipd, C, tipd_C);
   VitalWireDelay (D_ipd, D, tipd_D);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := (C_ipd) OR ((B_ipd) AND ((NOT A_ipd))) OR (D_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (A_ipd'last_event, tpd_A_Y, TRUE),
                 1 => (D_ipd'last_event, tpd_D_Y, TRUE),
                 2 => (C_ipd'last_event, tpd_C_Y, TRUE),
                 3 => (B_ipd'last_event, tpd_B_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AO2A_VITAL of AO2A is
   for VITAL_ACT
   end for;
end CFG_AO2A_VITAL;


----- CELL AO2B -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AO2B is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AO2B : entity is TRUE;
end AO2B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of AO2B is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';
   SIGNAL C_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   VitalWireDelay (C_ipd, C, tipd_C);
   VitalWireDelay (D_ipd, D, tipd_D);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := (C_ipd) OR (((NOT B_ipd)) AND ((NOT A_ipd))) OR (D_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (B_ipd'last_event, tpd_B_Y, TRUE),
                 1 => (A_ipd'last_event, tpd_A_Y, TRUE),
                 2 => (D_ipd'last_event, tpd_D_Y, TRUE),
                 3 => (C_ipd'last_event, tpd_C_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AO2B_VITAL of AO2B is
   for VITAL_ACT
   end for;
end CFG_AO2B_VITAL;


----- CELL AO2C -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AO2C is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AO2C : entity is TRUE;
end AO2C;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of AO2C is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';
   SIGNAL C_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   VitalWireDelay (C_ipd, C, tipd_C);
   VitalWireDelay (D_ipd, D, tipd_D);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := ((NOT C_ipd)) OR ((B_ipd) AND ((NOT A_ipd))) OR (D_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (C_ipd'last_event, tpd_C_Y, TRUE),
                 1 => (A_ipd'last_event, tpd_A_Y, TRUE),
                 2 => (D_ipd'last_event, tpd_D_Y, TRUE),
                 3 => (B_ipd'last_event, tpd_B_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AO2C_VITAL of AO2C is
   for VITAL_ACT
   end for;
end CFG_AO2C_VITAL;


----- CELL AO2D -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AO2D is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AO2D : entity is TRUE;
end AO2D;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of AO2D is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';
   SIGNAL C_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   VitalWireDelay (C_ipd, C, tipd_C);
   VitalWireDelay (D_ipd, D, tipd_D);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd :=
       ((NOT C_ipd)) OR (((NOT B_ipd)) AND ((NOT A_ipd))) OR (D_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (C_ipd'last_event, tpd_C_Y, TRUE),
                 1 => (B_ipd'last_event, tpd_B_Y, TRUE),
                 2 => (A_ipd'last_event, tpd_A_Y, TRUE),
                 3 => (D_ipd'last_event, tpd_D_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AO2D_VITAL of AO2D is
   for VITAL_ACT
   end for;
end CFG_AO2D_VITAL;


----- CELL AO2E -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AO2E is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AO2E : entity is TRUE;
end AO2E;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of AO2E is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';
   SIGNAL C_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   VitalWireDelay (C_ipd, C, tipd_C);
   VitalWireDelay (D_ipd, D, tipd_D);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd :=
       ((NOT C_ipd)) OR (((NOT B_ipd)) AND ((NOT A_ipd))) OR ((NOT D_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (D_ipd'last_event, tpd_D_Y, TRUE),
                 1 => (C_ipd'last_event, tpd_C_Y, TRUE),
                 2 => (B_ipd'last_event, tpd_B_Y, TRUE),
                 3 => (A_ipd'last_event, tpd_A_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AO2E_VITAL of AO2E is
   for VITAL_ACT
   end for;
end CFG_AO2E_VITAL;


----- CELL AO3 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AO3 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AO3 : entity is TRUE;
end AO3;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of AO3 is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';
   SIGNAL C_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   VitalWireDelay (C_ipd, C, tipd_C);
   VitalWireDelay (D_ipd, D, tipd_D);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := (D_ipd) OR ((B_ipd) AND ((NOT A_ipd)) AND (C_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (A_ipd'last_event, tpd_A_Y, TRUE),
                 1 => (D_ipd'last_event, tpd_D_Y, TRUE),
                 2 => (C_ipd'last_event, tpd_C_Y, TRUE),
                 3 => (B_ipd'last_event, tpd_B_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AO3_VITAL of AO3 is
   for VITAL_ACT
   end for;
end CFG_AO3_VITAL;


----- CELL AO3A -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AO3A is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AO3A : entity is TRUE;
end AO3A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of AO3A is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';
   SIGNAL C_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   VitalWireDelay (C_ipd, C, tipd_C);
   VitalWireDelay (D_ipd, D, tipd_D);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := (D_ipd) OR ((B_ipd) AND (A_ipd) AND (C_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (D_ipd'last_event, tpd_D_Y, TRUE),
                 1 => (C_ipd'last_event, tpd_C_Y, TRUE),
                 2 => (B_ipd'last_event, tpd_B_Y, TRUE),
                 3 => (A_ipd'last_event, tpd_A_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AO3A_VITAL of AO3A is
   for VITAL_ACT
   end for;
end CFG_AO3A_VITAL;


----- CELL AO3B -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AO3B is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AO3B : entity is TRUE;
end AO3B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of AO3B is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';
   SIGNAL C_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   VitalWireDelay (C_ipd, C, tipd_C);
   VitalWireDelay (D_ipd, D, tipd_D);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := (D_ipd) OR (((NOT B_ipd)) AND ((NOT A_ipd)) AND (C_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (B_ipd'last_event, tpd_B_Y, TRUE),
                 1 => (A_ipd'last_event, tpd_A_Y, TRUE),
                 2 => (D_ipd'last_event, tpd_D_Y, TRUE),
                 3 => (C_ipd'last_event, tpd_C_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AO3B_VITAL of AO3B is
   for VITAL_ACT
   end for;
end CFG_AO3B_VITAL;


----- CELL AO3C -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AO3C is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AO3C : entity is TRUE;
end AO3C;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of AO3C is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';
   SIGNAL C_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   VitalWireDelay (C_ipd, C, tipd_C);
   VitalWireDelay (D_ipd, D, tipd_D);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd :=
       (D_ipd) OR (((NOT B_ipd)) AND ((NOT A_ipd)) AND ((NOT C_ipd)));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (C_ipd'last_event, tpd_C_Y, TRUE),
                 1 => (B_ipd'last_event, tpd_B_Y, TRUE),
                 2 => (A_ipd'last_event, tpd_A_Y, TRUE),
                 3 => (D_ipd'last_event, tpd_D_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AO3C_VITAL of AO3C is
   for VITAL_ACT
   end for;
end CFG_AO3C_VITAL;


----- CELL AO4A -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AO4A is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AO4A : entity is TRUE;
end AO4A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL_ACT of AO4A is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';
   SIGNAL C_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   VitalWireDelay (C_ipd, C, tipd_C);
   VitalWireDelay (D_ipd, D, tipd_D);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd :=
       ((C_ipd) AND (A_ipd) AND (D_ipd)) OR ((B_ipd) AND ((NOT A_ipd)) AND
         (C_ipd)) OR ((C_ipd) AND (B_ipd) AND (D_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (A_ipd'last_event, tpd_A_Y, TRUE),
                 1 => (D_ipd'last_event, tpd_D_Y, TRUE),
                 2 => (C_ipd'last_event, tpd_C_Y, TRUE),
                 3 => (B_ipd'last_event, tpd_B_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AO4A_VITAL of AO4A is
   for VITAL_ACT
   end for;
end CFG_AO4A_VITAL;


----- CELL AO5A -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AO5A is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AO5A : entity is TRUE;
end AO5A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL_ACT of AO5A is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';
   SIGNAL C_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   VitalWireDelay (C_ipd, C, tipd_C);
   VitalWireDelay (D_ipd, D, tipd_D);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd :=
       ((C_ipd) AND (A_ipd)) OR ((B_ipd) AND ((NOT A_ipd))) OR ((C_ipd) AND (B_ipd)) OR (D_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (A_ipd'last_event, tpd_A_Y, TRUE),
                 1 => (D_ipd'last_event, tpd_D_Y, TRUE),
                 2 => (C_ipd'last_event, tpd_C_Y, TRUE),
                 3 => (B_ipd'last_event, tpd_B_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AO5A_VITAL of AO5A is
   for VITAL_ACT
   end for;
end CFG_AO5A_VITAL;


----- CELL AO6 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AO6 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AO6 : entity is TRUE;
end AO6;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of AO6 is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';
   SIGNAL C_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   VitalWireDelay (C_ipd, C, tipd_C);
   VitalWireDelay (D_ipd, D, tipd_D);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := ((D_ipd) AND (C_ipd)) OR ((B_ipd) AND (A_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (D_ipd'last_event, tpd_D_Y, TRUE),
                 1 => (C_ipd'last_event, tpd_C_Y, TRUE),
                 2 => (B_ipd'last_event, tpd_B_Y, TRUE),
                 3 => (A_ipd'last_event, tpd_A_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AO6_VITAL of AO6 is
   for VITAL_ACT
   end for;
end CFG_AO6_VITAL;


----- CELL AO6A -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AO6A is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AO6A : entity is TRUE;
end AO6A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of AO6A is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';
   SIGNAL C_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   VitalWireDelay (C_ipd, C, tipd_C);
   VitalWireDelay (D_ipd, D, tipd_D);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := (((NOT D_ipd)) AND (C_ipd)) OR ((B_ipd) AND (A_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (D_ipd'last_event, tpd_D_Y, TRUE),
                 1 => (C_ipd'last_event, tpd_C_Y, TRUE),
                 2 => (B_ipd'last_event, tpd_B_Y, TRUE),
                 3 => (A_ipd'last_event, tpd_A_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AO6A_VITAL of AO6A is
   for VITAL_ACT
   end for;
end CFG_AO6A_VITAL;


----- CELL AO7 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AO7 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_E_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AO7 : entity is TRUE;
end AO7;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of AO7 is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';
   SIGNAL C_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL E_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   VitalWireDelay (C_ipd, C, tipd_C);
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (E_ipd, E, tipd_E);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd, E_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := (D_ipd) OR ((B_ipd) AND (A_ipd) AND (C_ipd)) OR (E_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (E_ipd'last_event, tpd_E_Y, TRUE),
                 1 => (D_ipd'last_event, tpd_D_Y, TRUE),
                 2 => (C_ipd'last_event, tpd_C_Y, TRUE),
                 3 => (B_ipd'last_event, tpd_B_Y, TRUE),
                 4 => (A_ipd'last_event, tpd_A_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AO7_VITAL of AO7 is
   for VITAL_ACT
   end for;
end CFG_AO7_VITAL;


----- CELL AO8 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AO8 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_E_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AO8 : entity is TRUE;
end AO8;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of AO8 is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';
   SIGNAL C_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL E_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   VitalWireDelay (C_ipd, C, tipd_C);
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (E_ipd, E, tipd_E);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd, E_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd :=
       (((NOT D_ipd)) AND ((NOT C_ipd))) OR ((B_ipd) AND (A_ipd)) OR (E_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (D_ipd'last_event, tpd_D_Y, TRUE),
                 1 => (C_ipd'last_event, tpd_C_Y, TRUE),
                 2 => (E_ipd'last_event, tpd_E_Y, TRUE),
                 3 => (B_ipd'last_event, tpd_B_Y, TRUE),
                 4 => (A_ipd'last_event, tpd_A_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AO8_VITAL of AO8 is
   for VITAL_ACT
   end for;
end CFG_AO8_VITAL;


----- CELL AO9 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AO9 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_E_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AO9 : entity is TRUE;
end AO9;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of AO9 is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';
   SIGNAL C_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL E_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   VitalWireDelay (C_ipd, C, tipd_C);
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (E_ipd, E, tipd_E);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd, E_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := (C_ipd) OR ((B_ipd) AND (A_ipd)) OR (D_ipd) OR (E_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (E_ipd'last_event, tpd_E_Y, TRUE),
                 1 => (D_ipd'last_event, tpd_D_Y, TRUE),
                 2 => (C_ipd'last_event, tpd_C_Y, TRUE),
                 3 => (B_ipd'last_event, tpd_B_Y, TRUE),
                 4 => (A_ipd'last_event, tpd_A_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AO9_VITAL of AO9 is
   for VITAL_ACT
   end for;
end CFG_AO9_VITAL;


----- CELL AOI1 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AOI1 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AOI1 : entity is TRUE;
end AOI1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of AOI1 is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';
   SIGNAL C_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   VitalWireDelay (C_ipd, C, tipd_C);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd, C_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := (NOT ((C_ipd) OR ((B_ipd) AND (A_ipd))));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (C_ipd'last_event, tpd_C_Y, TRUE),
                 1 => (B_ipd'last_event, tpd_B_Y, TRUE),
                 2 => (A_ipd'last_event, tpd_A_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AOI1_VITAL of AOI1 is
   for VITAL_ACT
   end for;
end CFG_AOI1_VITAL;


----- CELL AOI1A -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AOI1A is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AOI1A : entity is TRUE;
end AOI1A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of AOI1A is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';
   SIGNAL C_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   VitalWireDelay (C_ipd, C, tipd_C);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd, C_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := (NOT ((C_ipd) OR ((B_ipd) AND ((NOT A_ipd)))));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (C_ipd'last_event, tpd_C_Y, TRUE),
                 1 => (B_ipd'last_event, tpd_B_Y, TRUE),
                 2 => (A_ipd'last_event, tpd_A_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AOI1A_VITAL of AOI1A is
   for VITAL_ACT
   end for;
end CFG_AOI1A_VITAL;


----- CELL AOI1B -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AOI1B is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AOI1B : entity is TRUE;
end AOI1B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of AOI1B is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';
   SIGNAL C_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   VitalWireDelay (C_ipd, C, tipd_C);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd, C_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := (NOT (((NOT C_ipd)) OR ((B_ipd) AND (A_ipd))));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (B_ipd'last_event, tpd_B_Y, TRUE),
                 1 => (A_ipd'last_event, tpd_A_Y, TRUE),
                 2 => (C_ipd'last_event, tpd_C_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AOI1B_VITAL of AOI1B is
   for VITAL_ACT
   end for;
end CFG_AOI1B_VITAL;


----- CELL AOI1C -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AOI1C is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AOI1C : entity is TRUE;
end AOI1C;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of AOI1C is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';
   SIGNAL C_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   VitalWireDelay (C_ipd, C, tipd_C);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd, C_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := (NOT ((C_ipd) OR (((NOT B_ipd)) AND ((NOT A_ipd)))));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (C_ipd'last_event, tpd_C_Y, TRUE),
                 1 => (B_ipd'last_event, tpd_B_Y, TRUE),
                 2 => (A_ipd'last_event, tpd_A_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AOI1C_VITAL of AOI1C is
   for VITAL_ACT
   end for;
end CFG_AOI1C_VITAL;


----- CELL AOI1D -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AOI1D is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AOI1D : entity is TRUE;
end AOI1D;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of AOI1D is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';
   SIGNAL C_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   VitalWireDelay (C_ipd, C, tipd_C);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd, C_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := (NOT (((NOT C_ipd)) OR (((NOT B_ipd)) AND ((NOT A_ipd)))));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (C_ipd'last_event, tpd_C_Y, TRUE),
                 1 => (B_ipd'last_event, tpd_B_Y, TRUE),
                 2 => (A_ipd'last_event, tpd_A_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AOI1D_VITAL of AOI1D is
   for VITAL_ACT
   end for;
end CFG_AOI1D_VITAL;


----- CELL AOI2A -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AOI2A is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AOI2A : entity is TRUE;
end AOI2A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of AOI2A is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';
   SIGNAL C_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   VitalWireDelay (C_ipd, C, tipd_C);
   VitalWireDelay (D_ipd, D, tipd_D);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := (NOT ((C_ipd) OR ((B_ipd) AND ((NOT A_ipd))) OR (D_ipd)));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (D_ipd'last_event, tpd_D_Y, TRUE),
                 1 => (C_ipd'last_event, tpd_C_Y, TRUE),
                 2 => (B_ipd'last_event, tpd_B_Y, TRUE),
                 3 => (A_ipd'last_event, tpd_A_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AOI2A_VITAL of AOI2A is
   for VITAL_ACT
   end for;
end CFG_AOI2A_VITAL;


----- CELL AOI2B -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AOI2B is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AOI2B : entity is TRUE;
end AOI2B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of AOI2B is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';
   SIGNAL C_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   VitalWireDelay (C_ipd, C, tipd_C);
   VitalWireDelay (D_ipd, D, tipd_D);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd :=
       (NOT (((NOT C_ipd)) OR ((B_ipd) AND ((NOT A_ipd))) OR (D_ipd)));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (D_ipd'last_event, tpd_D_Y, TRUE),
                 1 => (B_ipd'last_event, tpd_B_Y, TRUE),
                 2 => (C_ipd'last_event, tpd_C_Y, TRUE),
                 3 => (A_ipd'last_event, tpd_A_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AOI2B_VITAL of AOI2B is
   for VITAL_ACT
   end for;
end CFG_AOI2B_VITAL;


----- CELL AOI3A -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AOI3A is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AOI3A : entity is TRUE;
end AOI3A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of AOI3A is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';
   SIGNAL C_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   VitalWireDelay (C_ipd, C, tipd_C);
   VitalWireDelay (D_ipd, D, tipd_D);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := ((D_ipd) OR (A_ipd)) AND ((B_ipd) OR (A_ipd) OR (C_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (D_ipd'last_event, tpd_D_Y, TRUE),
                 1 => (C_ipd'last_event, tpd_C_Y, TRUE),
                 2 => (B_ipd'last_event, tpd_B_Y, TRUE),
                 3 => (A_ipd'last_event, tpd_A_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AOI3A_VITAL of AOI3A is
   for VITAL_ACT
   end for;
end CFG_AOI3A_VITAL;


----- CELL AOI4 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AOI4 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AOI4 : entity is TRUE;
end AOI4;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of AOI4 is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';
   SIGNAL C_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   VitalWireDelay (C_ipd, C, tipd_C);
   VitalWireDelay (D_ipd, D, tipd_D);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := (NOT (((D_ipd) AND (C_ipd)) OR ((B_ipd) AND (A_ipd))));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (D_ipd'last_event, tpd_D_Y, TRUE),
                 1 => (C_ipd'last_event, tpd_C_Y, TRUE),
                 2 => (B_ipd'last_event, tpd_B_Y, TRUE),
                 3 => (A_ipd'last_event, tpd_A_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AOI4_VITAL of AOI4 is
   for VITAL_ACT
   end for;
end CFG_AOI4_VITAL;


----- CELL AOI4A -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AOI4A is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AOI4A : entity is TRUE;
end AOI4A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of AOI4A is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';
   SIGNAL C_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   VitalWireDelay (C_ipd, C, tipd_C);
   VitalWireDelay (D_ipd, D, tipd_D);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd :=
       (NOT (((D_ipd) AND ((NOT C_ipd))) OR ((B_ipd) AND (A_ipd))));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (D_ipd'last_event, tpd_D_Y, TRUE),
                 1 => (B_ipd'last_event, tpd_B_Y, TRUE),
                 2 => (A_ipd'last_event, tpd_A_Y, TRUE),
                 3 => (C_ipd'last_event, tpd_C_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AOI4A_VITAL of AOI4A is
   for VITAL_ACT
   end for;
end CFG_AOI4A_VITAL;


----- CELL AX1 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AX1 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AX1 : entity is TRUE;
end AX1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of AX1 is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';
   SIGNAL C_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   VitalWireDelay (C_ipd, C, tipd_C);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd, C_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := (C_ipd) XOR ((B_ipd) AND ((NOT A_ipd)));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (C_ipd'last_event, tpd_C_Y, TRUE),
                 1 => (B_ipd'last_event, tpd_B_Y, TRUE),
                 2 => (A_ipd'last_event, tpd_A_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AX1_VITAL of AX1 is
   for VITAL_ACT
   end for;
end CFG_AX1_VITAL;


----- CELL AX1A -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AX1A is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AX1A : entity is TRUE;
end AX1A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of AX1A is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';
   SIGNAL C_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   VitalWireDelay (C_ipd, C, tipd_C);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd, C_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := (NOT ((C_ipd) XOR ((B_ipd) AND ((NOT A_ipd)))));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (C_ipd'last_event, tpd_C_Y, TRUE),
                 1 => (B_ipd'last_event, tpd_B_Y, TRUE),
                 2 => (A_ipd'last_event, tpd_A_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AX1A_VITAL of AX1A is
   for VITAL_ACT
   end for;
end CFG_AX1A_VITAL;


----- CELL AX1B -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AX1B is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AX1B : entity is TRUE;
end AX1B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of AX1B is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';
   SIGNAL C_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   VitalWireDelay (C_ipd, C, tipd_C);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd, C_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := (C_ipd) XOR (((NOT B_ipd)) AND ((NOT A_ipd)));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (C_ipd'last_event, tpd_C_Y, TRUE),
                 1 => (B_ipd'last_event, tpd_B_Y, TRUE),
                 2 => (A_ipd'last_event, tpd_A_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AX1B_VITAL of AX1B is
   for VITAL_ACT
   end for;
end CFG_AX1B_VITAL;


----- CELL AX1C -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AX1C is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AX1C : entity is TRUE;
end AX1C;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of AX1C is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';
   SIGNAL C_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   VitalWireDelay (C_ipd, C, tipd_C);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd, C_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := (C_ipd) XOR ((B_ipd) AND (A_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (C_ipd'last_event, tpd_C_Y, TRUE),
                 1 => (B_ipd'last_event, tpd_B_Y, TRUE),
                 2 => (A_ipd'last_event, tpd_A_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_AX1C_VITAL of AX1C is
   for VITAL_ACT
   end for;
end CFG_AX1C_VITAL;


----- CELL BBHS -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity BBHS is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_E_PAD                      :	VitalDelayType01z := 
               (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns);
      tpd_D_PAD                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_PAD_Y                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PAD                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      PAD                            :	inout STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of BBHS : entity is TRUE;
end BBHS;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of BBHS is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL E_ipd	 : STD_ULOGIC := 'X';
   SIGNAL PAD_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (E_ipd, E, tipd_E);
   VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS PAD_zd : STD_LOGIC is Results(1);
   ALIAS Y_zd : STD_LOGIC is Results(2);

   -- output glitch detection variables
   VARIABLE PAD_GlitchData	: VitalGlitchDataType;
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      PAD_zd := VitalBUFIF0 (data => D_ipd,
              enable => (NOT E_ipd));
      Y_zd := TO_X01(PAD_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01Z (
       OutSignal => PAD,
       GlitchData => PAD_GlitchData,
       OutSignalName => "PAD",
       OutTemp => PAD_zd,
       Paths => (0 => (E_ipd'last_event, tpd_E_PAD, TRUE),
                 1 => (D_ipd'last_event, VitalExtendToFillDelay(tpd_D_PAD), TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING,
       OutputMap => "UX01ZWLH-");
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (PAD_ipd'last_event, tpd_PAD_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_BBHS_VITAL of BBHS is
   for VITAL_ACT
   end for;
end CFG_BBHS_VITAL;


----- CELL BBHSA -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity BBHSA is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_E_PAD                      :	VitalDelayType01z := 
               (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns);
      tpd_D_PAD                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_IDE_Y                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_PAD_Y                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_IDE                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PAD                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      IDE                            :	in    STD_ULOGIC;
      PAD                            :	inout STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of BBHSA : entity is TRUE;
end BBHSA;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of BBHSA is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL E_ipd	 : STD_ULOGIC := 'X';
   SIGNAL IDE_ipd	 : STD_ULOGIC := 'X';
   SIGNAL PAD_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (E_ipd, E, tipd_E);
   VitalWireDelay (IDE_ipd, IDE, tipd_IDE);
   VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, E_ipd, IDE_ipd, PAD_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS PAD_zd : STD_LOGIC is Results(1);
   ALIAS Y_zd : STD_LOGIC is Results(2);

   -- output glitch detection variables
   VARIABLE PAD_GlitchData	: VitalGlitchDataType;
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      PAD_zd := VitalBUFIF0 (data => D_ipd,
              enable => (NOT E_ipd));
      Y_zd := (PAD_ipd) AND (IDE_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01Z (
       OutSignal => PAD,
       GlitchData => PAD_GlitchData,
       OutSignalName => "PAD",
       OutTemp => PAD_zd,
       Paths => (0 => (E_ipd'last_event, tpd_E_PAD, TRUE),
                 1 => (D_ipd'last_event, VitalExtendToFillDelay(tpd_D_PAD), TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING,
       OutputMap => "UX01ZWLH-");
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (IDE_ipd'last_event, tpd_IDE_Y, TRUE),
                 1 => (PAD_ipd'last_event, tpd_PAD_Y, TRUE),
                 2 => (D_ipd'last_event, tpd_D_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_BBHSA_VITAL of BBHSA is
   for VITAL_ACT
   end for;
end CFG_BBHSA_VITAL;


----- CELL BBLSA -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity BBLSA is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_E_PAD                      :	VitalDelayType01z := 
               (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns);
      tpd_D_PAD                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_IDE_Y                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_PAD_Y                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_IDE                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PAD                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      IDE                            :	in    STD_ULOGIC;
      PAD                            :	inout STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of BBLSA : entity is TRUE;
end BBLSA;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of BBLSA is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL E_ipd	 : STD_ULOGIC := 'X';
   SIGNAL IDE_ipd	 : STD_ULOGIC := 'X';
   SIGNAL PAD_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (E_ipd, E, tipd_E);
   VitalWireDelay (IDE_ipd, IDE, tipd_IDE);
   VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, E_ipd, IDE_ipd, PAD_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS PAD_zd : STD_LOGIC is Results(1);
   ALIAS Y_zd : STD_LOGIC is Results(2);

   -- output glitch detection variables
   VARIABLE PAD_GlitchData	: VitalGlitchDataType;
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      PAD_zd := VitalBUFIF0 (data => D_ipd,
              enable => (NOT E_ipd));
      Y_zd := (PAD_ipd) AND (IDE_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01Z (
       OutSignal => PAD,
       GlitchData => PAD_GlitchData,
       OutSignalName => "PAD",
       OutTemp => PAD_zd,
       Paths => (0 => (E_ipd'last_event, tpd_E_PAD, TRUE),
                 1 => (D_ipd'last_event, VitalExtendToFillDelay(tpd_D_PAD), TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING,
       OutputMap => "UX01ZWLH-");
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (IDE_ipd'last_event, tpd_IDE_Y, TRUE),
                 1 => (PAD_ipd'last_event, tpd_PAD_Y, TRUE),
                 2 => (D_ipd'last_event, tpd_D_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_BBLSA_VITAL of BBLSA is
   for VITAL_ACT
   end for;
end CFG_BBLSA_VITAL;


----- CELL BBUFTH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity BBUFTH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_E_PAD                      :	VitalDelayType01z := 
               (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns);
      tpd_D_PAD                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_PAD_Y                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PAD                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      PAD                            :	inout STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of BBUFTH : entity is TRUE;
end BBUFTH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of BBUFTH is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL E_ipd	 : STD_ULOGIC := 'X';
   SIGNAL PAD_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (E_ipd, E, tipd_E);
   VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS PAD_zd : STD_LOGIC is Results(1);
   ALIAS Y_zd : STD_LOGIC is Results(2);

   -- output glitch detection variables
   VARIABLE PAD_GlitchData	: VitalGlitchDataType;
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      PAD_zd := VitalBUFIF0 (data => D_ipd,
              enable => (NOT E_ipd));
      Y_zd := TO_X01(PAD_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01Z (
       OutSignal => PAD,
       GlitchData => PAD_GlitchData,
       OutSignalName => "PAD",
       OutTemp => PAD_zd,
       Paths => (0 => (E_ipd'last_event, tpd_E_PAD, TRUE),
                 1 => (D_ipd'last_event, VitalExtendToFillDelay(tpd_D_PAD), TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING,
       OutputMap => "UX01ZWLH-");
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (PAD_ipd'last_event, tpd_PAD_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_BBUFTH_VITAL of BBUFTH is
   for VITAL_ACT
   end for;
end CFG_BBUFTH_VITAL;


----- CELL BBUFTL -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity BBUFTL is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_E_PAD                      :	VitalDelayType01z := 
               (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns);
      tpd_D_PAD                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_PAD_Y                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PAD                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      PAD                            :	inout STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of BBUFTL : entity is TRUE;
end BBUFTL;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of BBUFTL is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL E_ipd	 : STD_ULOGIC := 'X';
   SIGNAL PAD_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (E_ipd, E, tipd_E);
   VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS PAD_zd : STD_LOGIC is Results(1);
   ALIAS Y_zd : STD_LOGIC is Results(2);

   -- output glitch detection variables
   VARIABLE PAD_GlitchData	: VitalGlitchDataType;
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      PAD_zd := VitalBUFIF0 (data => D_ipd,
              enable => (NOT E_ipd));
      Y_zd := TO_X01(PAD_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01Z (
       OutSignal => PAD,
       GlitchData => PAD_GlitchData,
       OutSignalName => "PAD",
       OutTemp => PAD_zd,
       Paths => (0 => (E_ipd'last_event, tpd_E_PAD, TRUE),
                 1 => (D_ipd'last_event, VitalExtendToFillDelay(tpd_D_PAD), TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING,
       OutputMap => "UX01ZWLH-");
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (PAD_ipd'last_event, tpd_PAD_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_BBUFTL_VITAL of BBUFTL is
   for VITAL_ACT
   end for;
end CFG_BBUFTL_VITAL;


----- CELL BIBUF -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity BIBUF is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_E_PAD                      :	VitalDelayType01z := 
               (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns);
      tpd_D_PAD                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_PAD_Y                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PAD                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      PAD                            :	inout STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of BIBUF : entity is TRUE;
end BIBUF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of BIBUF is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL E_ipd	 : STD_ULOGIC := 'X';
   SIGNAL PAD_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (E_ipd, E, tipd_E);
   VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS PAD_zd : STD_LOGIC is Results(1);
   ALIAS Y_zd : STD_LOGIC is Results(2);

   -- output glitch detection variables
   VARIABLE PAD_GlitchData	: VitalGlitchDataType;
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      PAD_zd := VitalBUFIF0 (data => D_ipd,
              enable => (NOT E_ipd));
      Y_zd := TO_X01(PAD_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01Z (
       OutSignal => PAD,
       GlitchData => PAD_GlitchData,
       OutSignalName => "PAD",
       OutTemp => PAD_zd,
       Paths => (0 => (E_ipd'last_event, tpd_E_PAD, TRUE),
                 1 => (D_ipd'last_event, VitalExtendToFillDelay(tpd_D_PAD), TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING,
       OutputMap => "UX01ZWLH-");
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (PAD_ipd'last_event, tpd_PAD_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_BIBUF_VITAL of BIBUF is
   for VITAL_ACT
   end for;
end CFG_BIBUF_VITAL;


















----- CELL BIECTH -----
LIBRARY   IEEE;
USE       IEEE.std_logic_1164.all;
USE       IEEE.VITAL_Timing.all;
USE       IEEE.VITAL_Primitives.all;
	
entity BIECTH IS
	GENERIC (
		--
		-- PinToPinDelay Generics Declaration(s)
		tpd_IOPCL_Q          : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input IOPCL to output Q
		tpd_CLK_Q            : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input CLK to output Q
		tpd_D_PAD            : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input D to output PAD
		tpd_E_PAD            : VitalDelayType01z := (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns); -- Path delay from input E to output PAD

		--
		-- Interconnect Path Delay Generics Declaration(s)
		tipd_CLK             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port CLK
		tipd_D               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port D
		tipd_E               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port E
		tipd_IDE             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port IDE
		tipd_IOPCL           : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port IOPCL
		tipd_PAD             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port PAD
		--
		-- Setup Generics Declaration(s)
		tsetup_PAD_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between PAD and CLK
		tsetup_IDE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between IDE and CLK
		--
		-- Hold Generics Declaration(s)
		thold_PAD_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between PAD and CLK
		thold_IDE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between IDE and CLK
		thold_IOPCL_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Removal time between IOPCL and CLK
		--
		-- Recovery Generics Declaration(s)
		trecovery_IOPCL_CLK_posedge_posedge : VitalDelayType   := 0.000 ns;	-- Recovery time between IOPCL and CLK
		--
		-- Period Check Generics Declaration(s)
		tperiod_CLK_posedge          : VitalDelayType   := 0.000 ns;	-- Minimum period time for CLK
		tpw_CLK_posedge      : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for CLK
		tpw_CLK_negedge      : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for CLK
		tperiod_IOPCL        : VitalDelayType   := 0.000 ns;	-- Minimum period time for IOPCL
		tpw_IOPCL_posedge    : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for IOPCL
		tpw_IOPCL_negedge    : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for IOPCL
		--
		-- InstancePath Will Accompany Any Assertion Messages in the Model
		InstancePath         : STRING           := "*";
		--
		-- 'X' generation control parameter for timing checks and path delay
		XOn                  : BOOLEAN          := TRUE;
		--
		-- Assertion messages generation control parameter for violation of timing checks
		MsgOn                : BOOLEAN          := TRUE;
		--
		-- VitalTimingCheck Switch
		TimingChecksOn       : BOOLEAN          := TRUE
	);
	PORT (
		CLK                 : IN      STD_ULOGIC := 'X';
		D                   : IN      STD_ULOGIC := 'X';
		E                   : IN      STD_ULOGIC := 'X';
		IDE                 : IN      STD_ULOGIC := 'X';
		IOPCL               : IN      STD_ULOGIC := 'X';
		PAD                 : INOUT   STD_ULOGIC := 'X';
		Q                   : OUT     STD_ULOGIC := 'X'
		
	);
	--
	attribute Vital_Level0 OF BIECTH : ENTITY IS TRUE;
	--
end BIECTH;

ARCHITECTURE VITAL_ACT OF BIECTH IS
	--
	ATTRIBUTE Vital_Level1 OF VITAL_ACT : ARCHITECTURE IS TRUE;
	--
	--
	--Internal Delay Signals - delayed be the interconnect path delay
	SIGNAL    CLK_ipd                   : STD_ULOGIC := 'U';
	SIGNAL    D_ipd                     : STD_ULOGIC := 'U';
	SIGNAL    E_ipd                     : STD_ULOGIC := 'U';
	SIGNAL    IDE_ipd                   : STD_ULOGIC := 'U';
	SIGNAL    IOPCL_ipd                 : STD_ULOGIC := 'U';
	SIGNAL    PAD_ipd                   : STD_ULOGIC := 'U';
	
	BEGIN
	-----------------------------------------------
	-- Input Path Delay Section
	-----------------------------------------------
	WireDelay : BLOCK
	BEGIN
		VitalWireDelay (
				OutSig             => CLK_ipd,
				InSig              => CLK,
				twire              => tipd_CLK
		);
		VitalWireDelay (
				OutSig             => D_ipd,
				InSig              => D,
				twire              => tipd_D
		);
		VitalWireDelay (
				OutSig             => E_ipd,
				InSig              => E,
				twire              => tipd_E
		);
		VitalWireDelay (
				OutSig             => IDE_ipd,
				InSig              => IDE,
				twire              => tipd_IDE
		);
		VitalWireDelay (
				OutSig             => IOPCL_ipd,
				InSig              => IOPCL,
				twire              => tipd_IOPCL
		);
		VitalWireDelay (
				OutSig             => PAD_ipd,
				InSig              => PAD,
				twire              => tipd_PAD
		);
	
	END BLOCK WireDelay;
	
	-----------------------------------------------
	-- Behavior Section
	-----------------------------------------------
	VITALBehavior : PROCESS (CLK_ipd, D_ipd, E_ipd, IDE_ipd, IOPCL_ipd, PAD_ipd	
	                        )
		--
		-- Variable(s) for internal use in VitalPeriodPulseCheck
		VARIABLE  CLK_PeriodData            : VitalPeriodDataType := VitalPeriodDataInit;
		VARIABLE  IOPCL_PeriodData          : VitalPeriodDataType := VitalPeriodDataInit;
		--
		-- Variable(s) for internal use in VitalRecoveryRemovalCheck
		VARIABLE  IOPCL_CLK_TimingDataRR    : VitalTimingDataType := VitalTimingDataInit;
		--
		-- Variable(s) for internal use in VitalSetupHoldCheck
		VARIABLE  PAD_CLK_TimingDataSH      : VitalTimingDataType := VitalTimingDataInit;
		VARIABLE  IDE_CLK_TimingDataSH      : VitalTimingDataType := VitalTimingDataInit;
		--
		-- Variable(s) used in VitalPathDelay to Store GlitchData
		VARIABLE  Q_GlitchData              : VitalGlitchDataType;
		VARIABLE  PAD_GlitchData            : VitalGlitchDataType;
		--
		-- Variable(s) generated by VitalTimingCheck violation flags and/or user
		VARIABLE  SHVF_D_CLK                : STD_ULOGIC := '0';
		VARIABLE  SHVF_PAD_CLK              : STD_ULOGIC := '0';
		VARIABLE  SHVF_IDE_CLK              : STD_ULOGIC := '0';
		VARIABLE  PDVF_CLK                  : STD_ULOGIC := '0';
		VARIABLE  PDVF_IOPCL                : STD_ULOGIC := '0';
		VARIABLE  RRVF_IOPCL_CLK            : STD_ULOGIC := '0';
		VARIABLE  Violation                 : STD_ULOGIC := 'X';
		VARIABLE  DFE3CStateReg             : STD_LOGIC_VECTOR(0 DOWNTO 0) := (OTHERS => 'X');
		VARIABLE  IQ                        : STD_LOGIC_VECTOR(0 DOWNTO 0) := (OTHERS => 'X');
		VARIABLE  BIECTH_TABStateReg        : STD_LOGIC_VECTOR(0 DOWNTO 0) := (OTHERS => 'X');
		--
		-- Variable(s) used in VitalStateTable to store functional result
		VARIABLE  DFE3C_Result              : STD_LOGIC_VECTOR(2 DOWNTO 1) := (OTHERS => 'X');
		VARIABLE  BIECTH_TAB_Result         : STD_LOGIC_VECTOR(2 DOWNTO 1) := (OTHERS => 'X');
		--
		-- Variable(s) used in VitalTruthTable to store functional result
		VARIABLE  BIECTH_TTAB_Result        : STD_LOGIC_VECTOR(1 DOWNTO 1) := (OTHERS => 'X');
		--
		-- Variable(s) used in VitalStateTable to keep track of the previous values
		VARIABLE  PrevData_DFE3C            : STD_LOGIC_VECTOR(0 TO 4);
		VARIABLE  PrevData_BIECTH_TAB       : STD_LOGIC_VECTOR(0 TO 4);
		--
		-- Variable(s) used in VitalStateTable and VitalPropagatePathDelay
		VARIABLE  Q_zd                      : STD_ULOGIC;
		VARIABLE  PAD_zd                    : STD_ULOGIC;
		VARIABLE  IDE_delayed               : STD_ULOGIC;
		VARIABLE  PAD_delayed               : STD_ULOGIC;
		--
		-- State Table : BIECTH_TAB Declaration
		CONSTANT  BIECTH_TAB : VitalStateTableType (1 to 14, 1 to 8) := (
                --Vio, Clr, Clk,   d,   e, prev, next 
		( '0', '0', '-', '-', '-',  '-',  '0',  '0' ),
		( '0', '1', '/', '0', '0',  '-',  '0',  '0' ),
		( '0', '1', '/', '1', '0',  '-',  '1',  '1' ),
		( '0', '1', '/', '0', '-',  '0',  '0',  '0' ),
		( '0', '1', '-', '0', '-',  '0',  '0',  '0' ),
		( '0', '-', '-', '0', '-',  '0',  '0',  '0' ),
		( '0', '-', '-', '-', '1',  '0',  '0',  '0' ),
		( '0', '1', '/', '1', '-',  '1',  '1',  '1' ),
		( '0', '1', '-', '1', '-',  '1',  '1',  '1' ),
		( '0', '1', '/', '-', '1',  '-',  'S',  'S' ),
		( '0', '1', 'F', '-', '-',  '-',  'S',  'S' ),
		( '0', '1', 'S', '-', '-',  '-',  'S',  'S' ),
		( '0', '1', '-', '-', '1',  '-',  'S',  'S' ),
		( 'X', '-', '-', '-', '-',  '-',  'X',  'X' ) );
	
	BEGIN
		-----------------------------------------------
		-- Timing Check Section
		-----------------------------------------------
		IF (TimingChecksOn) THEN
			-- Perform Setup/Hold Check
			--	TestSignal : PAD
			--	RefSignal  : CLK
			VitalSetupHoldCheck (
				Violation          => SHVF_PAD_CLK,
				TimingData         => PAD_CLK_TimingDataSH,
				TestSignal         => PAD_ipd,
				TestSignalName     => "PAD",
				TestDelay          => 0 ns,
				RefSignal          => CLK_ipd,
				RefSignalName      => "CLK",
				RefDelay           => 0 ns,
				SetupHigh          => tsetup_PAD_CLK_noedge_posedge,
				SetupLow           => tsetup_PAD_CLK_noedge_posedge,
				HoldHigh           => thold_PAD_CLK_noedge_posedge,
				HoldLow            => thold_PAD_CLK_noedge_posedge,
				CheckEnabled       => TO_X01 ( ( NOT IOPCL_ipd ) OR IDE_ipd ) /= '1',
				RefTransition      => '/',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalSetupHoldCheck
			-- Perform Setup/Hold Check
			--	TestSignal : IDE
			--	RefSignal  : CLK
			VitalSetupHoldCheck (
				Violation          => SHVF_IDE_CLK,
				TimingData         => IDE_CLK_TimingDataSH,
				TestSignal         => IDE_ipd,
				TestSignalName     => "IDE",
				TestDelay          => 0 ns,
				RefSignal          => CLK_ipd,
				RefSignalName      => "CLK",
				RefDelay           => 0 ns,
				SetupHigh          => tsetup_IDE_CLK_noedge_posedge,
				SetupLow           => tsetup_IDE_CLK_noedge_posedge,
				HoldHigh           => thold_IDE_CLK_noedge_posedge,
				HoldLow            => thold_IDE_CLK_noedge_posedge,
				CheckEnabled       => TO_X01 ( ( NOT IOPCL_ipd ) ) /= '1',
				RefTransition      => '/',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalSetupHoldCheck
			-- Perform Recovery/Removal Check
			--	TestSignal : IOPCL
			--	RefSignal  : CLK
			VitalRecoveryRemovalCheck (
				Violation          => RRVF_IOPCL_CLK,
				TimingData         => IOPCL_CLK_TimingDataRR,
				TestSignal         => IOPCL_ipd,
				TestSignalName     => "IOPCL",
				TestDelay          => 0 ns,
				RefSignal          => CLK_ipd,
				RefSignalName      => "CLK",
				RefDelay           => 0 ns,
				Recovery           => trecovery_IOPCL_CLK_posedge_posedge,
				Removal            => thold_IOPCL_CLK_noedge_posedge,
				ActiveLow          => TRUE,
				CheckEnabled       => TRUE,
				RefTransition      => '/',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalRecoveryRemovalCheck
			-- Perform Minimum and Maximum Periodicity and Pulse Check
			--TestSignal : CLK
			VitalPeriodPulseCheck (
				Violation          => PDVF_CLK,
				PeriodData         => CLK_PeriodData,
				TestSignal         => CLK_ipd,
				TestSignalName     => "CLK",
				TestDelay          => 0 ns,
				Period             => tperiod_CLK_posedge,
				PulseWidthHigh     => tpw_CLK_posedge,
				PulseWidthLow      => tpw_CLK_negedge,
				CheckEnabled       => TO_X01 ( ( NOT IOPCL_ipd ) ) /= '1',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalPeriodPulseCheck
			-- Perform Minimum and Maximum Periodicity and Pulse Check
			--TestSignal : IOPCL
			VitalPeriodPulseCheck (
				Violation          => PDVF_IOPCL,
				PeriodData         => IOPCL_PeriodData,
				TestSignal         => IOPCL_ipd,
				TestSignalName     => "IOPCL",
				TestDelay          => 0 ns,
				Period             => tperiod_IOPCL,
				PulseWidthHigh     => tpw_IOPCL_posedge,
				PulseWidthLow      => tpw_IOPCL_negedge,
				CheckEnabled       => TRUE,
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalPeriodPulseCheck
		
		END IF;	--Timing Check Section
		
		-----------------------------------------------
		-- Functionality Section
		-----------------------------------------------
		

		Violation                 := PDVF_CLK or PDVF_IOPCL or RRVF_IOPCL_CLK or 
				SHVF_D_CLK or SHVF_IDE_CLK or SHVF_PAD_CLK ;
		--
		--Implement Functionality for State Table : BIECTH_TAB
		VitalStateTable (
				StateTable         => BIECTH_TAB,
				DataIn             => (Violation, IOPCL_ipd, CLK_ipd, PAD_delayed, IDE_delayed),
				NumStates          => 1,
				Result             => BIECTH_TAB_Result,
				PreviousDataIn     => PrevData_BIECTH_TAB
		);	--End VitalStateTable
		BIECTH_TABStateReg(0)     := BIECTH_TAB_Result(2);
		Q_zd                      := BIECTH_TAB_Result(1);
		--
		PAD_zd := VitalBUFIF0 (data => D_ipd, enable => (NOT E_ipd));
		IDE_delayed := IDE_ipd;
		PAD_delayed := PAD_ipd;


		
		
		-----------------------------------------------
		-- Path Delay Section
		-----------------------------------------------
		VitalPathDelay01 (
				OutSignal          => Q,
				OutSignalName      => "Q",
				OutTemp            => Q_zd,
				DefaultDelay       => VitalZeroDelay01,
				MsgSeverity        => WARNING,
				Paths              => (
				                 0 => (
							InputChangeTime => IOPCL_ipd'LAST_EVENT,
							PathDelay       => tpd_IOPCL_Q,
							PathCondition   => TRUE
				                      ),
				                 1 => (
							InputChangeTime => CLK_ipd'LAST_EVENT,
							PathDelay       => tpd_CLK_Q,
							PathCondition   => TRUE
				                      )
				                      ),
				GlitchData         => Q_GlitchData,
				Mode               => OnDetect,
				XOn                => XOn,
				MsgOn              => MsgOn
		);	--End VitalPathDelay
		VitalPathDelay01Z (
				OutSignal          => PAD,
				OutSignalName      => "PAD",
				OutTemp            => PAD_zd,
				DefaultDelay       => VitalZeroDelay01Z,
				MsgSeverity        => WARNING,
				Paths              => (
				                 0 => (
							InputChangeTime => D_ipd'LAST_EVENT,
							PathDelay       => VitalExtendToFillDelay(tpd_D_PAD),
							PathCondition   => TRUE
				                      ),
				                 1 => (
							InputChangeTime => E_ipd'LAST_EVENT,
							PathDelay       => tpd_E_PAD,
							PathCondition   => TRUE
				                      )
				                      ),
				GlitchData         => PAD_GlitchData,
				Mode               => OnDetect,
				XOn                => XOn,
				MsgOn              => MsgOn,
				OutputMap          => "UX01ZWLH-"
		);	--End VitalPathDelay
		
	END PROCESS VITALBehavior;

END VITAL_ACT;

configuration CFG_BIECTH_VITAL of BIECTH is
   for VITAL_ACT
   end for;
end CFG_BIECTH_VITAL;
----- CELL BIECTL -----
LIBRARY   IEEE;
USE       IEEE.std_logic_1164.all;
USE       IEEE.VITAL_Timing.all;
USE       IEEE.VITAL_Primitives.all;
	
entity BIECTL IS
	GENERIC (
		--
		-- PinToPinDelay Generics Declaration(s)
		tpd_IOPCL_Q          : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input IOPCL to output Q
		tpd_CLK_Q            : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input CLK to output Q
		tpd_D_PAD            : VitalDelayType01 := (1.000 ns, 1.000 ns); 	-- Path delay from input D to output PAD
		tpd_E_PAD            : VitalDelayType01z := (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns); -- Path delay from input E to output PAD

		--
		-- Interconnect Path Delay Generics Declaration(s)
		tipd_CLK             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port CLK
		tipd_D               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port D
		tipd_E               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port E
		tipd_IDE             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port IDE
		tipd_IOPCL           : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port IOPCL
		tipd_PAD             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port PAD
		--
		-- Setup Generics Declaration(s)
		tsetup_PAD_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between PAD and CLK
		tsetup_IDE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between IDE and CLK
		--
		-- Hold Generics Declaration(s)
		thold_PAD_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between PAD and CLK
		thold_IDE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between IDE and CLK
		thold_IOPCL_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Removal time between IOPCL and CLK
		--
		-- Recovery Generics Declaration(s)
		trecovery_IOPCL_CLK_posedge_posedge : VitalDelayType   := 0.000 ns;	-- Recovery time between IOPCL and CLK
		--
		-- Period Check Generics Declaration(s)
		tperiod_CLK_posedge          : VitalDelayType   := 0.000 ns;	-- Minimum period time for CLK
		tpw_CLK_posedge      : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for CLK
		tpw_CLK_negedge      : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for CLK
		tperiod_IOPCL        : VitalDelayType   := 0.000 ns;	-- Minimum period time for IOPCL
		tpw_IOPCL_posedge    : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for IOPCL
		tpw_IOPCL_negedge    : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for IOPCL
		--
		-- InstancePath Will Accompany Any Assertion Messages in the Model
		InstancePath         : STRING           := "*";
		--
		-- 'X' generation control parameter for timing checks and path delay
		XOn                  : BOOLEAN          := TRUE;
		--
		-- Assertion messages generation control parameter for violation of timing checks
		MsgOn                : BOOLEAN          := TRUE;
		--
		-- VitalTimingCheck Switch
		TimingChecksOn       : BOOLEAN          := TRUE
	);
	PORT (
		CLK                 : IN      STD_ULOGIC := 'X';
		D                   : IN      STD_ULOGIC := 'X';
		E                   : IN      STD_ULOGIC := 'X';
		IDE                 : IN      STD_ULOGIC := 'X';
		IOPCL               : IN      STD_ULOGIC := 'X';
		PAD                 : INOUT   STD_ULOGIC := 'X';
		Q                   : OUT     STD_ULOGIC := 'X'
		
	);
	--
	attribute Vital_Level0 OF BIECTL : ENTITY IS TRUE;
	--
end BIECTL;

ARCHITECTURE VITAL_ACT OF BIECTL IS
	--
	ATTRIBUTE Vital_Level1 OF VITAL_ACT : ARCHITECTURE IS TRUE;
	--
	--
	--Internal Delay Signals - delayed be the interconnect path delay
	SIGNAL    CLK_ipd                   : STD_ULOGIC := 'U';
	SIGNAL    D_ipd                     : STD_ULOGIC := 'U';
	SIGNAL    E_ipd                     : STD_ULOGIC := 'U';
	SIGNAL    IDE_ipd                   : STD_ULOGIC := 'U';
	SIGNAL    IOPCL_ipd                 : STD_ULOGIC := 'U';
	SIGNAL    PAD_ipd                   : STD_ULOGIC := 'U';
	
	BEGIN
	-----------------------------------------------
	-- Input Path Delay Section
	-----------------------------------------------
	WireDelay : BLOCK
	BEGIN
		VitalWireDelay (
				OutSig             => CLK_ipd,
				InSig              => CLK,
				twire              => tipd_CLK
		);
		VitalWireDelay (
				OutSig             => D_ipd,
				InSig              => D,
				twire              => tipd_D
		);
		VitalWireDelay (
				OutSig             => E_ipd,
				InSig              => E,
				twire              => tipd_E
		);
		VitalWireDelay (
				OutSig             => IDE_ipd,
				InSig              => IDE,
				twire              => tipd_IDE
		);
		VitalWireDelay (
				OutSig             => IOPCL_ipd,
				InSig              => IOPCL,
				twire              => tipd_IOPCL
		);
		VitalWireDelay (
				OutSig             => PAD_ipd,
				InSig              => PAD,
				twire              => tipd_PAD
		);
	
	END BLOCK WireDelay;
	
	-----------------------------------------------
	-- Behavior Section
	-----------------------------------------------
	VITALBehavior : PROCESS (CLK_ipd, D_ipd, E_ipd, IDE_ipd, IOPCL_ipd, PAD_ipd	
	                        )
		--
		-- Variable(s) for internal use in VitalPeriodPulseCheck
		VARIABLE  CLK_PeriodData            : VitalPeriodDataType := VitalPeriodDataInit;
		VARIABLE  IOPCL_PeriodData          : VitalPeriodDataType := VitalPeriodDataInit;
		--
		-- Variable(s) for internal use in VitalRecoveryRemovalCheck
		VARIABLE  IOPCL_CLK_TimingDataRR    : VitalTimingDataType := VitalTimingDataInit;
		--
		-- Variable(s) for internal use in VitalSetupHoldCheck
		VARIABLE  PAD_CLK_TimingDataSH      : VitalTimingDataType := VitalTimingDataInit;
		VARIABLE  IDE_CLK_TimingDataSH      : VitalTimingDataType := VitalTimingDataInit;
		--
		-- Variable(s) used in VitalPathDelay to Store GlitchData
		VARIABLE  Q_GlitchData              : VitalGlitchDataType;
		VARIABLE  PAD_GlitchData            : VitalGlitchDataType;
		--
		-- Variable(s) generated by VitalTimingCheck violation flags and/or user
		VARIABLE  SHVF_D_CLK                : STD_ULOGIC := '0';
		VARIABLE  SHVF_PAD_CLK              : STD_ULOGIC := '0';
		VARIABLE  SHVF_IDE_CLK              : STD_ULOGIC := '0';
		VARIABLE  PDVF_CLK                  : STD_ULOGIC := '0';
		VARIABLE  PDVF_IOPCL                : STD_ULOGIC := '0';
		VARIABLE  RRVF_IOPCL_CLK            : STD_ULOGIC := '0';
		VARIABLE  Violation                 : STD_ULOGIC := 'X';
		VARIABLE  DFE3CStateReg             : STD_LOGIC_VECTOR(0 DOWNTO 0) := (OTHERS => 'X');
		VARIABLE  IQ                        : STD_LOGIC_VECTOR(0 DOWNTO 0) := (OTHERS => 'X');
		VARIABLE  BIECTL_TABStateReg        : STD_LOGIC_VECTOR(0 DOWNTO 0) := (OTHERS => 'X');
		--
		-- Variable(s) used in VitalStateTable to store functional result
		VARIABLE  DFE3C_Result              : STD_LOGIC_VECTOR(2 DOWNTO 1) := (OTHERS => 'X');
		VARIABLE  BIECTL_TAB_Result         : STD_LOGIC_VECTOR(2 DOWNTO 1) := (OTHERS => 'X');
		--
		-- Variable(s) used in VitalTruthTable to store functional result
		VARIABLE  BIECTL_TTAB_Result        : STD_LOGIC_VECTOR(1 DOWNTO 1) := (OTHERS => 'X');
		--
		-- Variable(s) used in VitalStateTable to keep track of the previous values
		VARIABLE  PrevData_DFE3C            : STD_LOGIC_VECTOR(0 TO 4);
		VARIABLE  PrevData_BIECTL_TAB       : STD_LOGIC_VECTOR(0 TO 4);
		--
		-- Variable(s) used in VitalStateTable and VitalPropagatePathDelay
		VARIABLE  Q_zd                      : STD_ULOGIC;
		VARIABLE  PAD_zd                    : STD_ULOGIC;
		VARIABLE  IDE_delayed               : STD_ULOGIC;
		VARIABLE  PAD_delayed               : STD_ULOGIC;
		--
		-- State Table : BIECTL_TAB Declaration
		CONSTANT  BIECTL_TAB : VitalStateTableType (1 to 14, 1 to 8) := (
                --Vio, Clr, Clk,   d,   e, prev, next 
		( '0', '0', '-', '-', '-',  '-',  '0',  '0' ),
		( '0', '1', '/', '0', '0',  '-',  '0',  '0' ),
		( '0', '1', '/', '1', '0',  '-',  '1',  '1' ),
		( '0', '1', '/', '0', '-',  '0',  '0',  '0' ),
		( '0', '1', '-', '0', '-',  '0',  '0',  '0' ),
		( '0', '-', '-', '0', '-',  '0',  '0',  '0' ),
		( '0', '-', '-', '-', '1',  '0',  '0',  '0' ),
		( '0', '1', '/', '1', '-',  '1',  '1',  '1' ),
		( '0', '1', '-', '1', '-',  '1',  '1',  '1' ),
		( '0', '1', '/', '-', '1',  '-',  'S',  'S' ),
		( '0', '1', 'F', '-', '-',  '-',  'S',  'S' ),
		( '0', '1', 'S', '-', '-',  '-',  'S',  'S' ),
		( '0', '1', '-', '-', '1',  '-',  'S',  'S' ),
		( 'X', '-', '-', '-', '-',  '-',  'X',  'X' ) );
	
	BEGIN
		-----------------------------------------------
		-- Timing Check Section
		-----------------------------------------------
		IF (TimingChecksOn) THEN
			-- Perform Setup/Hold Check
			--	TestSignal : PAD
			--	RefSignal  : CLK
			VitalSetupHoldCheck (
				Violation          => SHVF_PAD_CLK,
				TimingData         => PAD_CLK_TimingDataSH,
				TestSignal         => PAD_ipd,
				TestSignalName     => "PAD",
				TestDelay          => 0 ns,
				RefSignal          => CLK_ipd,
				RefSignalName      => "CLK",
				RefDelay           => 0 ns,
				SetupHigh          => tsetup_PAD_CLK_noedge_posedge,
				SetupLow           => tsetup_PAD_CLK_noedge_posedge,
				HoldHigh           => thold_PAD_CLK_noedge_posedge,
				HoldLow            => thold_PAD_CLK_noedge_posedge,
				CheckEnabled       => TO_X01 ( ( NOT IOPCL_ipd ) OR IDE_ipd ) /= '1',
				RefTransition      => '/',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalSetupHoldCheck
			-- Perform Setup/Hold Check
			--	TestSignal : IDE
			--	RefSignal  : CLK
			VitalSetupHoldCheck (
				Violation          => SHVF_IDE_CLK,
				TimingData         => IDE_CLK_TimingDataSH,
				TestSignal         => IDE_ipd,
				TestSignalName     => "IDE",
				TestDelay          => 0 ns,
				RefSignal          => CLK_ipd,
				RefSignalName      => "CLK",
				RefDelay           => 0 ns,
				SetupHigh          => tsetup_IDE_CLK_noedge_posedge,
				SetupLow           => tsetup_IDE_CLK_noedge_posedge,
				HoldHigh           => thold_IDE_CLK_noedge_posedge,
				HoldLow            => thold_IDE_CLK_noedge_posedge,
				CheckEnabled       => TO_X01 ( ( NOT IOPCL_ipd ) ) /= '1',
				RefTransition      => '/',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalSetupHoldCheck
			-- Perform Recovery/Removal Check
			--	TestSignal : IOPCL
			--	RefSignal  : CLK
			VitalRecoveryRemovalCheck (
				Violation          => RRVF_IOPCL_CLK,
				TimingData         => IOPCL_CLK_TimingDataRR,
				TestSignal         => IOPCL_ipd,
				TestSignalName     => "IOPCL",
				TestDelay          => 0 ns,
				RefSignal          => CLK_ipd,
				RefSignalName      => "CLK",
				RefDelay           => 0 ns,
				Recovery           => trecovery_IOPCL_CLK_posedge_posedge,
				Removal            => thold_IOPCL_CLK_noedge_posedge,
				ActiveLow          => TRUE,
				CheckEnabled       => TRUE,
				RefTransition      => '/',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalRecoveryRemovalCheck
			-- Perform Minimum and Maximum Periodicity and Pulse Check
			--TestSignal : CLK
			VitalPeriodPulseCheck (
				Violation          => PDVF_CLK,
				PeriodData         => CLK_PeriodData,
				TestSignal         => CLK_ipd,
				TestSignalName     => "CLK",
				TestDelay          => 0 ns,
				Period             => tperiod_CLK_posedge,
				PulseWidthHigh     => tpw_CLK_posedge,
				PulseWidthLow      => tpw_CLK_negedge,
				CheckEnabled       => TO_X01 ( ( NOT IOPCL_ipd ) ) /= '1',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalPeriodPulseCheck
			-- Perform Minimum and Maximum Periodicity and Pulse Check
			--TestSignal : IOPCL
			VitalPeriodPulseCheck (
				Violation          => PDVF_IOPCL,
				PeriodData         => IOPCL_PeriodData,
				TestSignal         => IOPCL_ipd,
				TestSignalName     => "IOPCL",
				TestDelay          => 0 ns,
				Period             => tperiod_IOPCL,
				PulseWidthHigh     => tpw_IOPCL_posedge,
				PulseWidthLow      => tpw_IOPCL_negedge,
				CheckEnabled       => TRUE,
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalPeriodPulseCheck
		
		END IF;	--Timing Check Section
		
		-----------------------------------------------
		-- Functionality Section
		-----------------------------------------------
		

		Violation                 := PDVF_CLK or PDVF_IOPCL or RRVF_IOPCL_CLK or 
				SHVF_D_CLK or SHVF_IDE_CLK or SHVF_PAD_CLK ;
		--
		--Implement Functionality for State Table : BIECTL_TAB
		VitalStateTable (
				StateTable         => BIECTL_TAB,
				DataIn             => (Violation, IOPCL_ipd, CLK_ipd, PAD_delayed, IDE_delayed),
				NumStates          => 1,
				Result             => BIECTL_TAB_Result,
				PreviousDataIn     => PrevData_BIECTL_TAB
		);	--End VitalStateTable
		BIECTL_TABStateReg(0)     := BIECTL_TAB_Result(2);
		Q_zd                      := BIECTL_TAB_Result(1);
		--
		PAD_zd := VitalBUFIF0 (data => D_ipd, enable => (NOT E_ipd));
		IDE_delayed := IDE_ipd;
		PAD_delayed := PAD_ipd;


		
		
		-----------------------------------------------
		-- Path Delay Section
		-----------------------------------------------
		VitalPathDelay01 (
				OutSignal          => Q,
				OutSignalName      => "Q",
				OutTemp            => Q_zd,
				DefaultDelay       => VitalZeroDelay01,
				MsgSeverity        => WARNING,
				Paths              => (
				                 0 => (
							InputChangeTime => IOPCL_ipd'LAST_EVENT,
							PathDelay       => tpd_IOPCL_Q,
							PathCondition   => TRUE
				                      ),
				                 1 => (
							InputChangeTime => CLK_ipd'LAST_EVENT,
							PathDelay       => tpd_CLK_Q,
							PathCondition   => TRUE
				                      )
				                      ),
				GlitchData         => Q_GlitchData,
				Mode               => OnDetect,
				XOn                => XOn,
				MsgOn              => MsgOn
		);	--End VitalPathDelay
		VitalPathDelay01Z (
				OutSignal          => PAD,
				OutSignalName      => "PAD",
				OutTemp            => PAD_zd,
				DefaultDelay       => VitalZeroDelay01Z,
				MsgSeverity        => WARNING,
				Paths              => (
				                 0 => (
							InputChangeTime => D_ipd'LAST_EVENT,
							PathDelay       => VitalExtendToFillDelay(tpd_D_PAD),
							PathCondition   => TRUE
				                      ),
				                 1 => (
							InputChangeTime => E_ipd'LAST_EVENT,
							PathDelay       => tpd_E_PAD,
							PathCondition   => TRUE
				                      )
				                      ),
				GlitchData         => PAD_GlitchData,
				Mode               => OnDetect,
				XOn                => XOn,
				MsgOn              => MsgOn,
				OutputMap          => "UX01ZWLH-"
		);	--End VitalPathDelay
		
	END PROCESS VITALBehavior;

END VITAL_ACT;

configuration CFG_BIECTL_VITAL of BIECTL is
   for VITAL_ACT
   end for;
end CFG_BIECTL_VITAL;
----- CELL BIEPTH -----
LIBRARY   IEEE;
USE       IEEE.std_logic_1164.all;
USE       IEEE.VITAL_Timing.all;
USE       IEEE.VITAL_Primitives.all;
	
entity BIEPTH IS
	GENERIC (
		--
		-- PinToPinDelay Generics Declaration(s)
		tpd_IOPCL_Q          : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input IOPCL to output Q
		tpd_CLK_Q            : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input CLK to output Q
		tpd_D_PAD            : VitalDelayType01 := (1.000 ns, 1.000 ns); 	-- Path delay from input D to output PAD
		tpd_E_PAD            : VitalDelayType01z := (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns); -- Path delay from input E to output PAD

		--
		-- Interconnect Path Delay Generics Declaration(s)
		tipd_CLK             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port CLK
		tipd_D               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port D
		tipd_E               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port E
		tipd_IDE             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port IDE
		tipd_IOPCL           : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port IOPCL
		tipd_PAD             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port PAD
		--
		-- Setup Generics Declaration(s)
		tsetup_PAD_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between PAD and CLK
		tsetup_IDE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between IDE and CLK
		--
		-- Hold Generics Declaration(s)
		thold_PAD_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between PAD and CLK
		thold_IDE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between IDE and CLK
		thold_IOPCL_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between IOPCL and CLK
		--
		-- Recovery Generics Declaration(s)
		trecovery_IOPCL_CLK_posedge_posedge : VitalDelayType   := 0.000 ns;	-- Recovery time between IOPCL and CLK
		--
		-- Period Check Generics Declaration(s)
		tperiod_CLK_posedge          : VitalDelayType   := 0.000 ns;	-- Minimum period time for CLK
		tpw_CLK_posedge      : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for CLK
		tpw_CLK_negedge      : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for CLK
		tperiod_IOPCL        : VitalDelayType   := 0.000 ns;	-- Minimum period time for IOPCL
		tpw_IOPCL_posedge    : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for IOPCL
		tpw_IOPCL_negedge    : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for IOPCL
		--
		-- InstancePath Will Accompany Any Assertion Messages in the Model
		InstancePath         : STRING           := "*";
		--
		-- 'X' generation control parameter for timing checks and path delay
		XOn                  : BOOLEAN          := TRUE;
		--
		-- Assertion messages generation control parameter for violation of timing checks
		MsgOn                : BOOLEAN          := TRUE;
		--
		-- VitalTimingCheck Switch
		TimingChecksOn       : BOOLEAN          := TRUE
	);
	PORT (
		CLK                 : IN      STD_ULOGIC := 'X';
		D                   : IN      STD_ULOGIC := 'X';
		E                   : IN      STD_ULOGIC := 'X';
		IDE                 : IN      STD_ULOGIC := 'X';
		IOPCL               : IN      STD_ULOGIC := 'X';
		PAD                 : INOUT   STD_ULOGIC := 'X';
		Q                   : OUT     STD_ULOGIC := 'X'
		
	);
	--
	attribute Vital_Level0 OF BIEPTH : ENTITY IS TRUE;
	--
end BIEPTH;

ARCHITECTURE VITAL_ACT OF BIEPTH IS
	--
	ATTRIBUTE Vital_Level1 OF VITAL_ACT : ARCHITECTURE IS TRUE;
	--
	--
	--Internal Delay Signals - delayed be the interconnect path delay
	SIGNAL    CLK_ipd                   : STD_ULOGIC := 'U';
	SIGNAL    D_ipd                     : STD_ULOGIC := 'U';
	SIGNAL    E_ipd                     : STD_ULOGIC := 'U';
	SIGNAL    IDE_ipd                   : STD_ULOGIC := 'U';
	SIGNAL    IOPCL_ipd                 : STD_ULOGIC := 'U';
	SIGNAL    PAD_ipd                   : STD_ULOGIC := 'U';
	
	BEGIN
	-----------------------------------------------
	-- Input Path Delay Section
	-----------------------------------------------
	WireDelay : BLOCK
	BEGIN
		VitalWireDelay (
				OutSig             => CLK_ipd,
				InSig              => CLK,
				twire              => tipd_CLK
		);
		VitalWireDelay (
				OutSig             => D_ipd,
				InSig              => D,
				twire              => tipd_D
		);
		VitalWireDelay (
				OutSig             => E_ipd,
				InSig              => E,
				twire              => tipd_E
		);
		VitalWireDelay (
				OutSig             => IDE_ipd,
				InSig              => IDE,
				twire              => tipd_IDE
		);
		VitalWireDelay (
				OutSig             => IOPCL_ipd,
				InSig              => IOPCL,
				twire              => tipd_IOPCL
		);
		VitalWireDelay (
				OutSig             => PAD_ipd,
				InSig              => PAD,
				twire              => tipd_PAD
		);
	
	END BLOCK WireDelay;
	
	-----------------------------------------------
	-- Behavior Section
	-----------------------------------------------
	VITALBehavior : PROCESS (CLK_ipd, D_ipd, E_ipd, IDE_ipd, IOPCL_ipd, PAD_ipd	
	                        )
		--
		-- Variable(s) for internal use in VitalPeriodPulseCheck
		VARIABLE  CLK_PeriodData            : VitalPeriodDataType := VitalPeriodDataInit;
		VARIABLE  IOPCL_PeriodData          : VitalPeriodDataType := VitalPeriodDataInit;
		--
		-- Variable(s) for internal use in VitalRecoveryRemovalCheck
		VARIABLE  IOPCL_CLK_TimingDataRR    : VitalTimingDataType := VitalTimingDataInit;
		--
		-- Variable(s) for internal use in VitalSetupHoldCheck
		VARIABLE  PAD_CLK_TimingDataSH      : VitalTimingDataType := VitalTimingDataInit;
		VARIABLE  IDE_CLK_TimingDataSH      : VitalTimingDataType := VitalTimingDataInit;
		--
		-- Variable(s) used in VitalPathDelay to Store GlitchData
		VARIABLE  Q_GlitchData              : VitalGlitchDataType;
		VARIABLE  PAD_GlitchData            : VitalGlitchDataType;
		--
		-- Variable(s) generated by VitalTimingCheck violation flags and/or user
		VARIABLE  SHVF_D_CLK                : STD_ULOGIC := '0';
		VARIABLE  SHVF_PAD_CLK              : STD_ULOGIC := '0';
		VARIABLE  SHVF_IDE_CLK              : STD_ULOGIC := '0';
		VARIABLE  PDVF_CLK                  : STD_ULOGIC := '0';
		VARIABLE  PDVF_IOPCL                : STD_ULOGIC := '0';
		VARIABLE  RRVF_IOPCL_CLK            : STD_ULOGIC := '0';
		VARIABLE  Violation                 : STD_ULOGIC := 'X';
		VARIABLE  DFE3CStateReg             : STD_LOGIC_VECTOR(0 DOWNTO 0) := (OTHERS => 'X');
		VARIABLE  IQ                        : STD_LOGIC_VECTOR(0 DOWNTO 0) := (OTHERS => 'X');
		VARIABLE  BIEPTH_TABStateReg        : STD_LOGIC_VECTOR(0 DOWNTO 0) := (OTHERS => 'X');
		--
		-- Variable(s) used in VitalStateTable to store functional result
		VARIABLE  DFE3C_Result              : STD_LOGIC_VECTOR(2 DOWNTO 1) := (OTHERS => 'X');
		VARIABLE  BIEPTH_TAB_Result         : STD_LOGIC_VECTOR(2 DOWNTO 1) := (OTHERS => 'X');
		--
		-- Variable(s) used in VitalTruthTable to store functional result
		VARIABLE  BIEPTH_TTAB_Result        : STD_LOGIC_VECTOR(1 DOWNTO 1) := (OTHERS => 'X');
		--
		-- Variable(s) used in VitalStateTable to keep track of the previous values
		--VARIABLE  PrevData_DFE3C            : STD_LOGIC_VECTOR(0 TO 5);
		--VARIABLE  PrevData_BIEPTH_TAB       : STD_LOGIC_VECTOR(0 TO 5);
		VARIABLE  PrevData_DFE3C            : STD_LOGIC_VECTOR(0 TO 4);
		VARIABLE  PrevData_BIEPTH_TAB       : STD_LOGIC_VECTOR(0 TO 4);
		--
		-- Variable(s) used in VitalStateTable and VitalPropagatePathDelay
		VARIABLE  Q_zd                      : STD_ULOGIC;
		VARIABLE  PAD_zd                    : STD_ULOGIC;
		VARIABLE  IDE_delayed               : STD_ULOGIC;
		VARIABLE  PAD_delayed               : STD_ULOGIC;
		--
		-- State Table : BIEPTH_TAB Declaration
		CONSTANT  BIEPTH_TAB : VitalStateTableType (1 to 14, 1 to 8) := (
--          Violation, IOPCL, CLK, D, ODE
		( '0', '0', '-', '-', '-',  '-',  '1',  '1' ),
		( '0', '1', '/', '0', '0',  '-',  '0',  '0' ),
		( '0', '1', '/', '1', '0',  '-',  '1',  '1' ),
		( '0', '1', '/', '0', '-',  '0',  '0',  '0' ),
		( '0', '1', '-', '0', '-',  '0',  '0',  '0' ),
		( '0', '-', '-', '1', '-',  '1',  '1',  '1' ),
		( '0', '-', '-', '-', '1',  '1',  '1',  '1' ),
		( '0', '1', '/', '1', '-',  '1',  '1',  '1' ),
		( '0', '1', '-', '1', '-',  '1',  '1',  '1' ),
		( '0', '1', '/', '-', '1',  '-',  'S',  'S' ),
		( '0', '1', 'F', '-', '-',  '-',  'S',  'S' ),
		( '0', '1', 'S', '-', '-',  '-',  'S',  'S' ),
		( '0', '1', '-', '-', '1',  '-',  'S',  'S' ),
		( 'X', '-', '-', '-', '-',  '-',  'X',  'X' ) );
	
	BEGIN
		-----------------------------------------------
		-- Timing Check Section
		-----------------------------------------------
		IF (TimingChecksOn) THEN
			-- Perform Setup/Hold Check
			--	TestSignal : PAD
			--	RefSignal  : CLK
			VitalSetupHoldCheck (
				Violation          => SHVF_PAD_CLK,
				TimingData         => PAD_CLK_TimingDataSH,
				TestSignal         => PAD_ipd,
				TestSignalName     => "PAD",
				TestDelay          => 0 ns,
				RefSignal          => CLK_ipd,
				RefSignalName      => "CLK",
				RefDelay           => 0 ns,
				SetupHigh          => tsetup_PAD_CLK_noedge_posedge,
				SetupLow           => tsetup_PAD_CLK_noedge_posedge,
				HoldHigh           => thold_PAD_CLK_noedge_posedge,
				HoldLow            => thold_PAD_CLK_noedge_posedge,
				CheckEnabled       => TO_X01 ( ( NOT IOPCL_ipd ) OR IDE_ipd ) /= '1',
				RefTransition      => '/',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalSetupHoldCheck
			-- Perform Setup/Hold Check
			--	TestSignal : IDE
			--	RefSignal  : CLK
			VitalSetupHoldCheck (
				Violation          => SHVF_IDE_CLK,
				TimingData         => IDE_CLK_TimingDataSH,
				TestSignal         => IDE_ipd,
				TestSignalName     => "IDE",
				TestDelay          => 0 ns,
				RefSignal          => CLK_ipd,
				RefSignalName      => "CLK",
				RefDelay           => 0 ns,
				SetupHigh          => tsetup_IDE_CLK_noedge_posedge,
				SetupLow           => tsetup_IDE_CLK_noedge_posedge,
				HoldHigh           => thold_IDE_CLK_noedge_posedge,
				HoldLow            => thold_IDE_CLK_noedge_posedge,
				CheckEnabled       => TO_X01 ( ( NOT IOPCL_ipd ) ) /= '1',
				RefTransition      => '/',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalSetupHoldCheck
			-- Perform Recovery/Removal Check
			--	TestSignal : IOPCL
			--	RefSignal  : CLK
			VitalRecoveryRemovalCheck (
				Violation          => RRVF_IOPCL_CLK,
				TimingData         => IOPCL_CLK_TimingDataRR,
				TestSignal         => IOPCL_ipd,
				TestSignalName     => "IOPCL",
				TestDelay          => 0 ns,
				RefSignal          => CLK_ipd,
				RefSignalName      => "CLK",
				RefDelay           => 0 ns,
				Recovery           => trecovery_IOPCL_CLK_posedge_posedge,
				Removal            => thold_IOPCL_CLK_noedge_posedge,
				ActiveLow          => TRUE,
				CheckEnabled       => TRUE,
				RefTransition      => '/',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalRecoveryRemovalCheck
			-- Perform Minimum and Maximum Periodicity and Pulse Check
			--TestSignal : CLK
			VitalPeriodPulseCheck (
				Violation          => PDVF_CLK,
				PeriodData         => CLK_PeriodData,
				TestSignal         => CLK_ipd,
				TestSignalName     => "CLK",
				TestDelay          => 0 ns,
				Period             => tperiod_CLK_posedge,
				PulseWidthHigh     => tpw_CLK_posedge,
				PulseWidthLow      => tpw_CLK_negedge,
				CheckEnabled       => TO_X01 ( ( NOT IOPCL_ipd ) ) /= '1',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalPeriodPulseCheck
			-- Perform Minimum and Maximum Periodicity and Pulse Check
			--TestSignal : IOPCL
			VitalPeriodPulseCheck (
				Violation          => PDVF_IOPCL,
				PeriodData         => IOPCL_PeriodData,
				TestSignal         => IOPCL_ipd,
				TestSignalName     => "IOPCL",
				TestDelay          => 0 ns,
				Period             => tperiod_IOPCL,
				PulseWidthHigh     => tpw_IOPCL_posedge,
				PulseWidthLow      => tpw_IOPCL_negedge,
				CheckEnabled       => TRUE,
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalPeriodPulseCheck
		
		END IF;	--Timing Check Section
		
		-----------------------------------------------
		-- Functionality Section
		-----------------------------------------------
		

		Violation                 := PDVF_CLK or PDVF_IOPCL or RRVF_IOPCL_CLK or 
				SHVF_D_CLK or SHVF_IDE_CLK or SHVF_PAD_CLK ;
		--
		--Implement Functionality for State Table : BIEPTH_TAB
		VitalStateTable (
				StateTable         => BIEPTH_TAB,
				DataIn             => (Violation, IOPCL_ipd, CLK_ipd, PAD_delayed, IDE_delayed),
				NumStates          => 1,
				Result             => BIEPTH_TAB_Result,
				PreviousDataIn     => PrevData_BIEPTH_TAB
		);	--End VitalStateTable
		BIEPTH_TABStateReg(0)     := BIEPTH_TAB_Result(2);
		Q_zd                      := BIEPTH_TAB_Result(1);
		--
		PAD_zd := VitalBUFIF0 (data => D_ipd, enable => (NOT E_ipd));
		IDE_delayed := IDE_ipd;
		PAD_delayed := PAD_ipd;

		
		
		-----------------------------------------------
		-- Path Delay Section
		-----------------------------------------------
		VitalPathDelay01 (
				OutSignal          => Q,
				OutSignalName      => "Q",
				OutTemp            => Q_zd,
				DefaultDelay       => VitalZeroDelay01,
				MsgSeverity        => WARNING,
				Paths              => (
				                 0 => (
							InputChangeTime => IOPCL_ipd'LAST_EVENT,
							PathDelay       => tpd_IOPCL_Q,
							PathCondition   => TRUE
				                      ),
				                 1 => (
							InputChangeTime => CLK_ipd'LAST_EVENT,
							PathDelay       => tpd_CLK_Q,
							PathCondition   => TRUE
				                      )
				                      ),
				GlitchData         => Q_GlitchData,
				Mode               => OnDetect,
				XOn                => XOn,
				MsgOn              => MsgOn
		);	--End VitalPathDelay
		VitalPathDelay01Z (
				OutSignal          => PAD,
				OutSignalName      => "PAD",
				OutTemp            => PAD_zd,
				DefaultDelay       => VitalZeroDelay01Z,
				MsgSeverity        => WARNING,
				Paths              => (
				                 0 => (
							InputChangeTime => D_ipd'LAST_EVENT,
							PathDelay       => VitalExtendToFillDelay(tpd_D_PAD),
							PathCondition   => TRUE
				                      ),
				                 1 => (
							InputChangeTime => E_ipd'LAST_EVENT,
							PathDelay       => tpd_E_PAD,
							PathCondition   => TRUE
				                      )
				                      ),
				GlitchData         => PAD_GlitchData,
				Mode               => OnDetect,
				XOn                => XOn,
				MsgOn              => MsgOn,
				OutputMap          => "UX01ZWLH-"
		);	--End VitalPathDelay
		
	END PROCESS VITALBehavior;

END VITAL_ACT;

configuration CFG_BIEPTH_VITAL of BIEPTH is
   for VITAL_ACT
   end for;
end CFG_BIEPTH_VITAL;
----- CELL BIEPTL -----
LIBRARY   IEEE;
USE       IEEE.std_logic_1164.all;
USE       IEEE.VITAL_Timing.all;
USE       IEEE.VITAL_Primitives.all;
	
entity BIEPTL IS
	GENERIC (
		--
		-- PinToPinDelay Generics Declaration(s)
		tpd_IOPCL_Q          : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input IOPCL to output Q
		tpd_CLK_Q            : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input CLK to output Q
		tpd_D_PAD            : VitalDelayType01 := (1.000 ns, 1.000 ns); 	-- Path delay from input D to output PAD
		tpd_E_PAD            : VitalDelayType01z := (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns); -- Path delay from input E to output PAD

		--
		-- Interconnect Path Delay Generics Declaration(s)
		tipd_CLK             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port CLK
		tipd_D               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port D
		tipd_E               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port E
		tipd_IDE             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port IDE
		tipd_IOPCL           : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port IOPCL
		tipd_PAD             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port PAD
		--
		-- Setup Generics Declaration(s)
		tsetup_PAD_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between PAD and CLK
		tsetup_IDE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between IDE and CLK
		--
		-- Hold Generics Declaration(s)
		thold_PAD_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between PAD and CLK
		thold_IDE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between IDE and CLK
		thold_IOPCL_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between IOPCL and CLK
		--
		-- Recovery Generics Declaration(s)
		trecovery_IOPCL_CLK_posedge_posedge : VitalDelayType   := 0.000 ns;	-- Recovery time between IOPCL and CLK
		--
		-- Period Check Generics Declaration(s)
		tperiod_CLK_posedge          : VitalDelayType   := 0.000 ns;	-- Minimum period time for CLK
		tpw_CLK_posedge      : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for CLK
		tpw_CLK_negedge      : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for CLK
		tperiod_IOPCL        : VitalDelayType   := 0.000 ns;	-- Minimum period time for IOPCL
		tpw_IOPCL_posedge    : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for IOPCL
		tpw_IOPCL_negedge    : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for IOPCL
		--
		-- InstancePath Will Accompany Any Assertion Messages in the Model
		InstancePath         : STRING           := "*";
		--
		-- 'X' generation control parameter for timing checks and path delay
		XOn                  : BOOLEAN          := TRUE;
		--
		-- Assertion messages generation control parameter for violation of timing checks
		MsgOn                : BOOLEAN          := TRUE;
		--
		-- VitalTimingCheck Switch
		TimingChecksOn       : BOOLEAN          := TRUE
	);
	PORT (
		CLK                 : IN      STD_ULOGIC := 'X';
		D                   : IN      STD_ULOGIC := 'X';
		E                   : IN      STD_ULOGIC := 'X';
		IDE                 : IN      STD_ULOGIC := 'X';
		IOPCL               : IN      STD_ULOGIC := 'X';
		PAD                 : INOUT   STD_ULOGIC := 'X';
		Q                   : OUT     STD_ULOGIC := 'X'
		
	);
	--
	attribute Vital_Level0 OF BIEPTL : ENTITY IS TRUE;
	--
end BIEPTL;

ARCHITECTURE VITAL_ACT OF BIEPTL IS
	--
	ATTRIBUTE Vital_Level1 OF VITAL_ACT : ARCHITECTURE IS TRUE;
	--
	--
	--Internal Delay Signals - delayed be the interconnect path delay
	SIGNAL    CLK_ipd                   : STD_ULOGIC := 'U';
	SIGNAL    D_ipd                     : STD_ULOGIC := 'U';
	SIGNAL    E_ipd                     : STD_ULOGIC := 'U';
	SIGNAL    IDE_ipd                   : STD_ULOGIC := 'U';
	SIGNAL    IOPCL_ipd                 : STD_ULOGIC := 'U';
	SIGNAL    PAD_ipd                   : STD_ULOGIC := 'U';
	
	BEGIN
	-----------------------------------------------
	-- Input Path Delay Section
	-----------------------------------------------
	WireDelay : BLOCK
	BEGIN
		VitalWireDelay (
				OutSig             => CLK_ipd,
				InSig              => CLK,
				twire              => tipd_CLK
		);
		VitalWireDelay (
				OutSig             => D_ipd,
				InSig              => D,
				twire              => tipd_D
		);
		VitalWireDelay (
				OutSig             => E_ipd,
				InSig              => E,
				twire              => tipd_E
		);
		VitalWireDelay (
				OutSig             => IDE_ipd,
				InSig              => IDE,
				twire              => tipd_IDE
		);
		VitalWireDelay (
				OutSig             => IOPCL_ipd,
				InSig              => IOPCL,
				twire              => tipd_IOPCL
		);
		VitalWireDelay (
				OutSig             => PAD_ipd,
				InSig              => PAD,
				twire              => tipd_PAD
		);
	
	END BLOCK WireDelay;
	
	-----------------------------------------------
	-- Behavior Section
	-----------------------------------------------
	VITALBehavior : PROCESS (CLK_ipd, D_ipd, E_ipd, IDE_ipd, IOPCL_ipd, PAD_ipd	
	                        )
		--
		-- Variable(s) for internal use in VitalPeriodPulseCheck
		VARIABLE  CLK_PeriodData            : VitalPeriodDataType := VitalPeriodDataInit;
		VARIABLE  IOPCL_PeriodData          : VitalPeriodDataType := VitalPeriodDataInit;
		--
		-- Variable(s) for internal use in VitalRecoveryRemovalCheck
		VARIABLE  IOPCL_CLK_TimingDataRR    : VitalTimingDataType := VitalTimingDataInit;
		--
		-- Variable(s) for internal use in VitalSetupHoldCheck
		VARIABLE  PAD_CLK_TimingDataSH      : VitalTimingDataType := VitalTimingDataInit;
		VARIABLE  IDE_CLK_TimingDataSH      : VitalTimingDataType := VitalTimingDataInit;
		--
		-- Variable(s) used in VitalPathDelay to Store GlitchData
		VARIABLE  Q_GlitchData              : VitalGlitchDataType;
		VARIABLE  PAD_GlitchData            : VitalGlitchDataType;
		--
		-- Variable(s) generated by VitalTimingCheck violation flags and/or user
		VARIABLE  SHVF_D_CLK                : STD_ULOGIC := '0';
		VARIABLE  SHVF_PAD_CLK              : STD_ULOGIC := '0';
		VARIABLE  SHVF_IDE_CLK              : STD_ULOGIC := '0';
		VARIABLE  PDVF_CLK                  : STD_ULOGIC := '0';
		VARIABLE  PDVF_IOPCL                : STD_ULOGIC := '0';
		VARIABLE  RRVF_IOPCL_CLK            : STD_ULOGIC := '0';
		VARIABLE  Violation                 : STD_ULOGIC := 'X';
		VARIABLE  DFE3CStateReg             : STD_LOGIC_VECTOR(0 DOWNTO 0) := (OTHERS => 'X');
		VARIABLE  IQ                        : STD_LOGIC_VECTOR(0 DOWNTO 0) := (OTHERS => 'X');
		VARIABLE  BIEPTL_TABStateReg        : STD_LOGIC_VECTOR(0 DOWNTO 0) := (OTHERS => 'X');
		--
		-- Variable(s) used in VitalStateTable to store functional result
		VARIABLE  DFE3C_Result              : STD_LOGIC_VECTOR(2 DOWNTO 1) := (OTHERS => 'X');
		VARIABLE  BIEPTL_TAB_Result         : STD_LOGIC_VECTOR(2 DOWNTO 1) := (OTHERS => 'X');
		--
		-- Variable(s) used in VitalTruthTable to store functional result
		VARIABLE  BIEPTL_TTAB_Result        : STD_LOGIC_VECTOR(1 DOWNTO 1) := (OTHERS => 'X');
		--
		-- Variable(s) used in VitalStateTable to keep track of the previous values
		--VARIABLE  PrevData_DFE3C            : STD_LOGIC_VECTOR(0 TO 5);
		--VARIABLE  PrevData_BIEPTL_TAB       : STD_LOGIC_VECTOR(0 TO 5);
		VARIABLE  PrevData_DFE3C            : STD_LOGIC_VECTOR(0 TO 4);
		VARIABLE  PrevData_BIEPTL_TAB       : STD_LOGIC_VECTOR(0 TO 4);
		--
		-- Variable(s) used in VitalStateTable and VitalPropagatePathDelay
		VARIABLE  Q_zd                      : STD_ULOGIC;
		VARIABLE  PAD_zd                    : STD_ULOGIC;
		VARIABLE  IDE_delayed               : STD_ULOGIC;
		VARIABLE  PAD_delayed               : STD_ULOGIC;
		--
		-- State Table : BIEPTL_TAB Declaration
		CONSTANT  BIEPTL_TAB : VitalStateTableType (1 to 14, 1 to 8) := (
--          Violation, IOPCL, CLK, D, ODE
		( '0', '0', '-', '-', '-',  '-',  '1',  '1' ),
		( '0', '1', '/', '0', '0',  '-',  '0',  '0' ),
		( '0', '1', '/', '1', '0',  '-',  '1',  '1' ),
		( '0', '1', '/', '0', '-',  '0',  '0',  '0' ),
		( '0', '1', '-', '0', '-',  '0',  '0',  '0' ),
		( '0', '-', '-', '1', '-',  '1',  '1',  '1' ),
		( '0', '-', '-', '-', '1',  '1',  '1',  '1' ),
		( '0', '1', '/', '1', '-',  '1',  '1',  '1' ),
		( '0', '1', '-', '1', '-',  '1',  '1',  '1' ),
		( '0', '1', '/', '-', '1',  '-',  'S',  'S' ),
		( '0', '1', 'F', '-', '-',  '-',  'S',  'S' ),
		( '0', '1', 'S', '-', '-',  '-',  'S',  'S' ),
		( '0', '1', '-', '-', '1',  '-',  'S',  'S' ),
		( 'X', '-', '-', '-', '-',  '-',  'X',  'X' ) );
	
	BEGIN
		-----------------------------------------------
		-- Timing Check Section
		-----------------------------------------------
		IF (TimingChecksOn) THEN
			-- Perform Setup/Hold Check
			--	TestSignal : PAD
			--	RefSignal  : CLK
			VitalSetupHoldCheck (
				Violation          => SHVF_PAD_CLK,
				TimingData         => PAD_CLK_TimingDataSH,
				TestSignal         => PAD_ipd,
				TestSignalName     => "PAD",
				TestDelay          => 0 ns,
				RefSignal          => CLK_ipd,
				RefSignalName      => "CLK",
				RefDelay           => 0 ns,
				SetupHigh          => tsetup_PAD_CLK_noedge_posedge,
				SetupLow           => tsetup_PAD_CLK_noedge_posedge,
				HoldHigh           => thold_PAD_CLK_noedge_posedge,
				HoldLow            => thold_PAD_CLK_noedge_posedge,
				CheckEnabled       => TO_X01 ( ( NOT IOPCL_ipd ) OR IDE_ipd ) /= '1',
				RefTransition      => '/',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalSetupHoldCheck
			-- Perform Setup/Hold Check
			--	TestSignal : IDE
			--	RefSignal  : CLK
			VitalSetupHoldCheck (
				Violation          => SHVF_IDE_CLK,
				TimingData         => IDE_CLK_TimingDataSH,
				TestSignal         => IDE_ipd,
				TestSignalName     => "IDE",
				TestDelay          => 0 ns,
				RefSignal          => CLK_ipd,
				RefSignalName      => "CLK",
				RefDelay           => 0 ns,
				SetupHigh          => tsetup_IDE_CLK_noedge_posedge,
				SetupLow           => tsetup_IDE_CLK_noedge_posedge,
				HoldHigh           => thold_IDE_CLK_noedge_posedge,
				HoldLow            => thold_IDE_CLK_noedge_posedge,
				CheckEnabled       => TO_X01 ( ( NOT IOPCL_ipd ) ) /= '1',
				RefTransition      => '/',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalSetupHoldCheck
			-- Perform Recovery/Removal Check
			--	TestSignal : IOPCL
			--	RefSignal  : CLK
			VitalRecoveryRemovalCheck (
				Violation          => RRVF_IOPCL_CLK,
				TimingData         => IOPCL_CLK_TimingDataRR,
				TestSignal         => IOPCL_ipd,
				TestSignalName     => "IOPCL",
				TestDelay          => 0 ns,
				RefSignal          => CLK_ipd,
				RefSignalName      => "CLK",
				RefDelay           => 0 ns,
				Recovery           => trecovery_IOPCL_CLK_posedge_posedge,
				Removal            => thold_IOPCL_CLK_noedge_posedge,
				ActiveLow          => TRUE,
				CheckEnabled       => TRUE,
				RefTransition      => '/',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalRecoveryRemovalCheck
			-- Perform Minimum and Maximum Periodicity and Pulse Check
			--TestSignal : CLK
			VitalPeriodPulseCheck (
				Violation          => PDVF_CLK,
				PeriodData         => CLK_PeriodData,
				TestSignal         => CLK_ipd,
				TestSignalName     => "CLK",
				TestDelay          => 0 ns,
				Period             => tperiod_CLK_posedge,
				PulseWidthHigh     => tpw_CLK_posedge,
				PulseWidthLow      => tpw_CLK_negedge,
				CheckEnabled       => TO_X01 ( ( NOT IOPCL_ipd ) ) /= '1',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalPeriodPulseCheck
			-- Perform Minimum and Maximum Periodicity and Pulse Check
			--TestSignal : IOPCL
			VitalPeriodPulseCheck (
				Violation          => PDVF_IOPCL,
				PeriodData         => IOPCL_PeriodData,
				TestSignal         => IOPCL_ipd,
				TestSignalName     => "IOPCL",
				TestDelay          => 0 ns,
				Period             => tperiod_IOPCL,
				PulseWidthHigh     => tpw_IOPCL_posedge,
				PulseWidthLow      => tpw_IOPCL_negedge,
				CheckEnabled       => TRUE,
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalPeriodPulseCheck
		
		END IF;	--Timing Check Section
		
		-----------------------------------------------
		-- Functionality Section
		-----------------------------------------------
		

		Violation                 := PDVF_CLK or PDVF_IOPCL or RRVF_IOPCL_CLK or 
				SHVF_D_CLK or SHVF_IDE_CLK or SHVF_PAD_CLK ;
		--
		--Implement Functionality for State Table : BIEPTL_TAB
		VitalStateTable (
				StateTable         => BIEPTL_TAB,
				DataIn             => (Violation, IOPCL_ipd, CLK_ipd, PAD_delayed, IDE_delayed),
				NumStates          => 1,
				Result             => BIEPTL_TAB_Result,
				PreviousDataIn     => PrevData_BIEPTL_TAB
		);	--End VitalStateTable
		BIEPTL_TABStateReg(0)     := BIEPTL_TAB_Result(2);
		Q_zd                      := BIEPTL_TAB_Result(1);
		--
		PAD_zd := VitalBUFIF0 (data => D_ipd, enable => (NOT E_ipd));
		IDE_delayed := IDE_ipd;
		PAD_delayed := PAD_ipd;

		
		
		-----------------------------------------------
		-- Path Delay Section
		-----------------------------------------------
		VitalPathDelay01 (
				OutSignal          => Q,
				OutSignalName      => "Q",
				OutTemp            => Q_zd,
				DefaultDelay       => VitalZeroDelay01,
				MsgSeverity        => WARNING,
				Paths              => (
				                 0 => (
							InputChangeTime => IOPCL_ipd'LAST_EVENT,
							PathDelay       => tpd_IOPCL_Q,
							PathCondition   => TRUE
				                      ),
				                 1 => (
							InputChangeTime => CLK_ipd'LAST_EVENT,
							PathDelay       => tpd_CLK_Q,
							PathCondition   => TRUE
				                      )
				                      ),
				GlitchData         => Q_GlitchData,
				Mode               => OnDetect,
				XOn                => XOn,
				MsgOn              => MsgOn
		);	--End VitalPathDelay
		VitalPathDelay01Z (
				OutSignal          => PAD,
				OutSignalName      => "PAD",
				OutTemp            => PAD_zd,
				DefaultDelay       => VitalZeroDelay01Z,
				MsgSeverity        => WARNING,
				Paths              => (
				                 0 => (
							InputChangeTime => D_ipd'LAST_EVENT,
							PathDelay       => VitalExtendToFillDelay(tpd_D_PAD),
							PathCondition   => TRUE
				                      ),
				                 1 => (
							InputChangeTime => E_ipd'LAST_EVENT,
							PathDelay       => tpd_E_PAD,
							PathCondition   => TRUE
				                      )
				                      ),
				GlitchData         => PAD_GlitchData,
				Mode               => OnDetect,
				XOn                => XOn,
				MsgOn              => MsgOn,
				OutputMap          => "UX01ZWLH-"
		);	--End VitalPathDelay
		
	END PROCESS VITALBehavior;

END VITAL_ACT;

configuration CFG_BIEPTL_VITAL of BIEPTL is
   for VITAL_ACT
   end for;
end CFG_BIEPTL_VITAL;
----- CELL BRECTH -----
LIBRARY   IEEE;
USE       IEEE.std_logic_1164.all;
USE       IEEE.VITAL_Timing.all;
USE       IEEE.VITAL_Primitives.all;
	
entity BRECTH IS
	GENERIC (
		--
		-- PinToPinDelay Generics Declaration(s)
		tpd_PAD_Y            : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input PAD to output Y
		tpd_IOPCL_PAD        : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input IOPCL to output PAD
		tpd_CLK_PAD          : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input CLK to output PAD
		tpd_E_PAD            : VitalDelayType01z := (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns); -- Path delay from input E to output PAD

		--
		-- Interconnect Path Delay Generics Declaration(s)
		tipd_CLK             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port CLK
		tipd_D               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port D
		tipd_E               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port E
		tipd_IOPCL           : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port IOPCL
		tipd_ODE             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port ODE
		tipd_PAD             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port PAD
		--
		-- Setup Generics Declaration(s)
		tsetup_D_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between D and CLK
		tsetup_ODE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between ODE and CLK
		--
		-- Hold Generics Declaration(s)
		thold_D_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between D and CLK
		thold_ODE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between ODE and CLK
		thold_IOPCL_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between IOPCL and CLK
		--
		-- Recovery Generics Declaration(s)
		trecovery_IOPCL_CLK_posedge_posedge : VitalDelayType   := 0.000 ns;	-- Recovery time between IOPCL and CLK
		--
		-- Period Check Generics Declaration(s)
		tperiod_CLK_posedge          : VitalDelayType   := 0.000 ns;	-- Minimum period time for CLK
		tpw_CLK_posedge      : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for CLK
		tpw_CLK_negedge      : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for CLK
		tperiod_IOPCL        : VitalDelayType   := 0.000 ns;	-- Minimum period time for IOPCL
		tpw_IOPCL_posedge    : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for IOPCL
		tpw_IOPCL_negedge    : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for IOPCL
		--
		-- InstancePath Will Accompany Any Assertion Messages in the Model
		InstancePath         : STRING           := "*";
		--
		-- 'X' generation control parameter for timing checks and path delay
		XOn                  : BOOLEAN          := TRUE;
		--
		-- Assertion messages generation control parameter for violation of timing checks
		MsgOn                : BOOLEAN          := TRUE;
		--
		-- VitalTimingCheck Switch
		TimingChecksOn       : BOOLEAN          := TRUE
	);
	PORT (
		CLK                 : IN      STD_ULOGIC := 'X';
		D                   : IN      STD_ULOGIC := 'X';
		E                   : IN      STD_ULOGIC := 'X';
		IOPCL               : IN      STD_ULOGIC := 'X';
		ODE                 : IN      STD_ULOGIC := 'X';
		PAD                 : INOUT   STD_ULOGIC := 'X';
		Y                   : OUT     STD_ULOGIC := 'X'
		
	);
	--
	attribute Vital_Level0 OF BRECTH : ENTITY IS TRUE;
	--
end BRECTH;

ARCHITECTURE VITAL_ACT OF BRECTH IS
	--
	ATTRIBUTE Vital_Level1 OF VITAL_ACT : ARCHITECTURE IS TRUE;
	--
	--
	--Internal Delay Signals - delayed be the interconnect path delay
	SIGNAL    CLK_ipd                   : STD_ULOGIC := 'U';
	SIGNAL    D_ipd                     : STD_ULOGIC := 'U';
	SIGNAL    E_ipd                     : STD_ULOGIC := 'U';
	SIGNAL    IOPCL_ipd                 : STD_ULOGIC := 'U';
	SIGNAL    ODE_ipd                   : STD_ULOGIC := 'U';
	SIGNAL    PAD_ipd                   : STD_ULOGIC := 'U';
	
	BEGIN
	-----------------------------------------------
	-- Input Path Delay Section
	-----------------------------------------------
	WireDelay : BLOCK
	BEGIN
		VitalWireDelay (
				OutSig             => CLK_ipd,
				InSig              => CLK,
				twire              => tipd_CLK
		);
		VitalWireDelay (
				OutSig             => D_ipd,
				InSig              => D,
				twire              => tipd_D
		);
		VitalWireDelay (
				OutSig             => E_ipd,
				InSig              => E,
				twire              => tipd_E
		);
		VitalWireDelay (
				OutSig             => IOPCL_ipd,
				InSig              => IOPCL,
				twire              => tipd_IOPCL
		);
		VitalWireDelay (
				OutSig             => ODE_ipd,
				InSig              => ODE,
				twire              => tipd_ODE
		);
		VitalWireDelay (
				OutSig             => PAD_ipd,
				InSig              => PAD,
				twire              => tipd_PAD
		);
	
	END BLOCK WireDelay;
	
	-----------------------------------------------
	-- Behavior Section
	-----------------------------------------------
	VITALBehavior : PROCESS (CLK_ipd, D_ipd, E_ipd, IOPCL_ipd, ODE_ipd, PAD_ipd	
	                        )
		--
		-- Variable(s) for internal use in VitalPeriodPulseCheck
		VARIABLE  CLK_PeriodData            : VitalPeriodDataType := VitalPeriodDataInit;
		VARIABLE  IOPCL_PeriodData          : VitalPeriodDataType := VitalPeriodDataInit;
		--
		-- Variable(s) for internal use in VitalRecoveryRemovalCheck
		VARIABLE  IOPCL_CLK_TimingDataRR    : VitalTimingDataType := VitalTimingDataInit;
		--
		-- Variable(s) for internal use in VitalSetupHoldCheck
		VARIABLE  D_CLK_TimingDataSH        : VitalTimingDataType := VitalTimingDataInit;
		VARIABLE  ODE_CLK_TimingDataSH      : VitalTimingDataType := VitalTimingDataInit;
		--
		-- Variable(s) used in VitalPathDelay to Store GlitchData
		VARIABLE  Y_GlitchData              : VitalGlitchDataType;
		VARIABLE  PAD_GlitchData            : VitalGlitchDataType;
		--
		-- Variable(s) generated by VitalTimingCheck violation flags and/or user
		VARIABLE  SHVF_D_CLK                : STD_ULOGIC := '0';
		VARIABLE  SHVF_ODE_CLK              : STD_ULOGIC := '0';
		VARIABLE  PDVF_CLK                  : STD_ULOGIC := '0';
		VARIABLE  PDVF_IOPCL                : STD_ULOGIC := '0';
		VARIABLE  RRVF_IOPCL_CLK            : STD_ULOGIC := '0';
		VARIABLE  Violation                 : STD_ULOGIC := 'X';
		VARIABLE  BRECTH_TABStateReg        : STD_LOGIC_VECTOR(0 DOWNTO 0) := (OTHERS => 'X');
		VARIABLE  IQ                        : STD_LOGIC_VECTOR(0 DOWNTO 0) := (OTHERS => 'X');
		--
		-- Variable(s) used in VitalStateTable to store functional result
		VARIABLE  BRECTH_TAB_Result         : STD_LOGIC_VECTOR(2 DOWNTO 1) := (OTHERS => 'X');
		--
		-- Variable(s) used in VitalTruthTable to store functional result
		VARIABLE  BRECTH_TTAB_Result        : STD_LOGIC_VECTOR(1 DOWNTO 1) := (OTHERS => 'X');
		--
		-- Variable(s) used in VitalStateTable to keep track of the previous values
		--VARIABLE  PrevData_BRECTH_TAB       : STD_LOGIC_VECTOR(0 TO 5);
		VARIABLE  PrevData_BRECTH_TAB       : STD_LOGIC_VECTOR(0 TO 4);
		--
		-- Variable(s) used in VitalStateTable and VitalPropagatePathDelay
		VARIABLE  Y_zd                      : STD_ULOGIC;
		VARIABLE  PAD_zd                    : STD_ULOGIC;
		VARIABLE  D_delayed                 : STD_ULOGIC;
		VARIABLE  ODE_delayed               : STD_ULOGIC;
		--
		-- State Table : BRECTH_TAB Declaration
		CONSTANT  BRECTH_TAB : VitalStateTableType (1 to 14, 1 to 8) := (
		( '0', '0', '-', '-', '-',  '-',  '0',  '0' ),
		( '0', '1', '/', '0', '0',  '-',  '0',  '0' ),
		( '0', '1', '/', '1', '0',  '-',  '1',  '1' ),
		( '0', '1', '/', '0', '-',  '0',  '0',  '0' ),
		( '0', '1', '-', '0', '-',  '0',  '0',  '0' ),
		( '0', '-', '-', '0', '-',  '0',  '0',  '0' ),
		( '0', '-', '-', '-', '1',  '0',  '0',  '0' ),
		( '0', '1', '/', '1', '-',  '1',  '1',  '1' ),
		( '0', '1', '-', '1', '-',  '1',  '1',  '1' ),
		( '0', '1', '/', '-', '1',  '-',  'S',  'S' ),
		( '0', '1', 'F', '-', '-',  '-',  'S',  'S' ),
		( '0', '1', 'S', '-', '-',  '-',  'S',  'S' ),
		( '0', '1', '-', '-', '1',  '-',  'S',  'S' ),
		( 'X', '-', '-', '-', '-',  '-',  'X',  'X' ) );
	
	BEGIN
		-----------------------------------------------
		-- Timing Check Section
		-----------------------------------------------
		IF (TimingChecksOn) THEN
			-- Perform Setup/Hold Check
			--	TestSignal : D
			--	RefSignal  : CLK
			VitalSetupHoldCheck (
				Violation          => SHVF_D_CLK,
				TimingData         => D_CLK_TimingDataSH,
				TestSignal         => D_ipd,
				TestSignalName     => "D",
				TestDelay          => 0 ns,
				RefSignal          => CLK_ipd,
				RefSignalName      => "CLK",
				RefDelay           => 0 ns,
				SetupHigh          => tsetup_D_CLK_noedge_posedge,
				SetupLow           => tsetup_D_CLK_noedge_posedge,
				HoldHigh           => thold_D_CLK_noedge_posedge,
				HoldLow            => thold_D_CLK_noedge_posedge,
				CheckEnabled       => TO_X01 ( ( NOT IOPCL_ipd ) OR ODE_ipd ) /= '1',
				RefTransition      => '/',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalSetupHoldCheck
			-- Perform Setup/Hold Check
			--	TestSignal : ODE
			--	RefSignal  : CLK
			VitalSetupHoldCheck (
				Violation          => SHVF_ODE_CLK,
				TimingData         => ODE_CLK_TimingDataSH,
				TestSignal         => ODE_ipd,
				TestSignalName     => "ODE",
				TestDelay          => 0 ns,
				RefSignal          => CLK_ipd,
				RefSignalName      => "CLK",
				RefDelay           => 0 ns,
				SetupHigh          => tsetup_ODE_CLK_noedge_posedge,
				SetupLow           => tsetup_ODE_CLK_noedge_posedge,
				HoldHigh           => thold_ODE_CLK_noedge_posedge,
				HoldLow            => thold_ODE_CLK_noedge_posedge,
				CheckEnabled       => TO_X01 ( ( NOT IOPCL_ipd ) ) /= '1',
				RefTransition      => '/',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalSetupHoldCheck
			-- Perform Recovery/Removal Check
			--	TestSignal : IOPCL
			--	RefSignal  : CLK
			VitalRecoveryRemovalCheck (
				Violation          => RRVF_IOPCL_CLK,
				TimingData         => IOPCL_CLK_TimingDataRR,
				TestSignal         => IOPCL_ipd,
				TestSignalName     => "IOPCL",
				TestDelay          => 0 ns,
				RefSignal          => CLK_ipd,
				RefSignalName      => "CLK",
				RefDelay           => 0 ns,
				Recovery           => trecovery_IOPCL_CLK_posedge_posedge,
				Removal            => thold_IOPCL_CLK_noedge_posedge,
				ActiveLow          => TRUE,
				CheckEnabled       => TRUE,
				RefTransition      => '/',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalRecoveryRemovalCheck
			-- Perform Minimum and Maximum Periodicity and Pulse Check
			--TestSignal : CLK
			VitalPeriodPulseCheck (
				Violation          => PDVF_CLK,
				PeriodData         => CLK_PeriodData,
				TestSignal         => CLK_ipd,
				TestSignalName     => "CLK",
				TestDelay          => 0 ns,
				Period             => tperiod_CLK_posedge,
				PulseWidthHigh     => tpw_CLK_posedge,
				PulseWidthLow      => tpw_CLK_negedge,
				CheckEnabled       => TO_X01 ( ( NOT IOPCL_ipd ) ) /= '1',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalPeriodPulseCheck
			-- Perform Minimum and Maximum Periodicity and Pulse Check
			--TestSignal : IOPCL
			VitalPeriodPulseCheck (
				Violation          => PDVF_IOPCL,
				PeriodData         => IOPCL_PeriodData,
				TestSignal         => IOPCL_ipd,
				TestSignalName     => "IOPCL",
				TestDelay          => 0 ns,
				Period             => tperiod_IOPCL,
				PulseWidthHigh     => tpw_IOPCL_posedge,
				PulseWidthLow      => tpw_IOPCL_negedge,
				CheckEnabled       => TRUE,
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalPeriodPulseCheck
		
		END IF;	--Timing Check Section
		
		-----------------------------------------------
		-- Functionality Section
		-----------------------------------------------
		

		Violation                 := PDVF_CLK or PDVF_IOPCL or RRVF_IOPCL_CLK or 
				SHVF_D_CLK or SHVF_ODE_CLK ;
		--
		--Implement Functionality for State Table : BRECTH_TAB
		VitalStateTable (
				StateTable         => BRECTH_TAB,
				--DataIn             => (Violation & IOPCL_ipd & CLK_ipd & D_ipd & ODE_ipd),
				--DataIn             => (Violation, IOPCL_ipd, CLK_ipd, D_ipd, ODE_ipd),
				DataIn             => (Violation, IOPCL_ipd, CLK_ipd, D_delayed, ODE_delayed),
				NumStates          => 1,
				Result             => BRECTH_TAB_Result,
				PreviousDataIn     => PrevData_BRECTH_TAB
		);	--End VitalStateTable
		BRECTH_TABStateReg(0)     := BRECTH_TAB_Result(2);
		IQ(0)                     := BRECTH_TAB_Result(1);
		Y_zd                      := TO_X01(PAD_ipd);
		--
		PAD_zd := VitalBUFIF0 (data => IQ(0), enable => (NOT E_ipd));
		D_delayed := D_ipd;
		ODE_delayed := ODE_ipd;

		
		
		-----------------------------------------------
		-- Path Delay Section
		-----------------------------------------------
		VitalPathDelay01 (
				OutSignal          => Y,
				OutSignalName      => "Y",
				OutTemp            => Y_zd,
				DefaultDelay       => VitalZeroDelay01,
				MsgSeverity        => WARNING,
				Paths              => (
				                 0 => (
							InputChangeTime => PAD_ipd'LAST_EVENT,
							PathDelay       => tpd_PAD_Y,
							PathCondition   => TRUE
				                      )
				                      ),
				GlitchData         => Y_GlitchData,
				Mode               => OnDetect,
				XOn                => XOn,
				MsgOn              => MsgOn
		);	--End VitalPathDelay
		VitalPathDelay01Z (
				OutSignal          => PAD,
				OutSignalName      => "PAD",
				OutTemp            => PAD_zd,
				DefaultDelay       => VitalZeroDelay01Z,
				MsgSeverity        => WARNING,
				Paths              => (
				                 0 => (
							InputChangeTime => IOPCL_ipd'LAST_EVENT,
							PathDelay       => VitalExtendToFillDelay(tpd_IOPCL_PAD),
							PathCondition   => TRUE
				                      ),
				                 1 => (
							InputChangeTime => CLK_ipd'LAST_EVENT,
							PathDelay       => VitalExtendToFillDelay(tpd_CLK_PAD),
							PathCondition   => TRUE
				                      ),
				                 2 => (
							InputChangeTime => E_ipd'LAST_EVENT,
							PathDelay       => tpd_E_PAD,
							PathCondition   => TRUE
				                      )
				                      ),
				GlitchData         => PAD_GlitchData,
				Mode               => OnDetect,
				XOn                => XOn,
				MsgOn              => MsgOn,
				OutputMap          => "UX01ZWLH-"
		);	--End VitalPathDelay
		
	END PROCESS VITALBehavior;

END VITAL_ACT;

configuration CFG_BRECTH_VITAL of BRECTH is
   for VITAL_ACT
   end for;
end CFG_BRECTH_VITAL;
----- CELL BRECTL -----
LIBRARY   IEEE;
USE       IEEE.std_logic_1164.all;
USE       IEEE.VITAL_Timing.all;
USE       IEEE.VITAL_Primitives.all;
	
entity BRECTL IS
	GENERIC (
		--
		-- PinToPinDelay Generics Declaration(s)
		tpd_PAD_Y            : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input PAD to output Y
		tpd_IOPCL_PAD        : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input IOPCL to output PAD
		tpd_CLK_PAD          : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input CLK to output PAD
		tpd_E_PAD            : VitalDelayType01z := (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns); -- Path delay from input E to output PAD

		--
		-- Interconnect Path Delay Generics Declaration(s)
		tipd_CLK             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port CLK
		tipd_D               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port D
		tipd_E               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port E
		tipd_IOPCL           : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port IOPCL
		tipd_ODE             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port ODE
		tipd_PAD             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port PAD
		--
		-- Setup Generics Declaration(s)
		tsetup_D_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between D and CLK
		tsetup_ODE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between ODE and CLK
		--
		-- Hold Generics Declaration(s)
		thold_D_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between D and CLK
		thold_ODE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between ODE and CLK
		thold_IOPCL_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between IOPCL and CLK
		--
		-- Recovery Generics Declaration(s)
		trecovery_IOPCL_CLK_posedge_posedge : VitalDelayType   := 0.000 ns;	-- Recovery time between IOPCL and CLK
		--
		-- Period Check Generics Declaration(s)
		tperiod_CLK_posedge          : VitalDelayType   := 0.000 ns;	-- Minimum period time for CLK
		tpw_CLK_posedge      : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for CLK
		tpw_CLK_negedge      : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for CLK
		tperiod_IOPCL        : VitalDelayType   := 0.000 ns;	-- Minimum period time for IOPCL
		tpw_IOPCL_posedge    : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for IOPCL
		tpw_IOPCL_negedge    : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for IOPCL
		--
		-- InstancePath Will Accompany Any Assertion Messages in the Model
		InstancePath         : STRING           := "*";
		--
		-- 'X' generation control parameter for timing checks and path delay
		XOn                  : BOOLEAN          := TRUE;
		--
		-- Assertion messages generation control parameter for violation of timing checks
		MsgOn                : BOOLEAN          := TRUE;
		--
		-- VitalTimingCheck Switch
		TimingChecksOn       : BOOLEAN          := TRUE
	);
	PORT (
		CLK                 : IN      STD_ULOGIC := 'X';
		D                   : IN      STD_ULOGIC := 'X';
		E                   : IN      STD_ULOGIC := 'X';
		IOPCL               : IN      STD_ULOGIC := 'X';
		ODE                 : IN      STD_ULOGIC := 'X';
		PAD                 : INOUT   STD_ULOGIC := 'X';
		Y                   : OUT     STD_ULOGIC := 'X'
		
	);
	--
	attribute Vital_Level0 OF BRECTL : ENTITY IS TRUE;
	--
end BRECTL;

ARCHITECTURE VITAL_ACT OF BRECTL IS
	--
	ATTRIBUTE Vital_Level1 OF VITAL_ACT : ARCHITECTURE IS TRUE;
	--
	--
	--Internal Delay Signals - delayed be the interconnect path delay
	SIGNAL    CLK_ipd                   : STD_ULOGIC := 'U';
	SIGNAL    D_ipd                     : STD_ULOGIC := 'U';
	SIGNAL    E_ipd                     : STD_ULOGIC := 'U';
	SIGNAL    IOPCL_ipd                 : STD_ULOGIC := 'U';
	SIGNAL    ODE_ipd                   : STD_ULOGIC := 'U';
	SIGNAL    PAD_ipd                   : STD_ULOGIC := 'U';
	
	BEGIN
	-----------------------------------------------
	-- Input Path Delay Section
	-----------------------------------------------
	WireDelay : BLOCK
	BEGIN
		VitalWireDelay (
				OutSig             => CLK_ipd,
				InSig              => CLK,
				twire              => tipd_CLK
		);
		VitalWireDelay (
				OutSig             => D_ipd,
				InSig              => D,
				twire              => tipd_D
		);
		VitalWireDelay (
				OutSig             => E_ipd,
				InSig              => E,
				twire              => tipd_E
		);
		VitalWireDelay (
				OutSig             => IOPCL_ipd,
				InSig              => IOPCL,
				twire              => tipd_IOPCL
		);
		VitalWireDelay (
				OutSig             => ODE_ipd,
				InSig              => ODE,
				twire              => tipd_ODE
		);
		VitalWireDelay (
				OutSig             => PAD_ipd,
				InSig              => PAD,
				twire              => tipd_PAD
		);
	
	END BLOCK WireDelay;
	
	-----------------------------------------------
	-- Behavior Section
	-----------------------------------------------
	VITALBehavior : PROCESS (CLK_ipd, D_ipd, E_ipd, IOPCL_ipd, ODE_ipd, PAD_ipd	
	                        )
		--
		-- Variable(s) for internal use in VitalPeriodPulseCheck
		VARIABLE  CLK_PeriodData            : VitalPeriodDataType := VitalPeriodDataInit;
		VARIABLE  IOPCL_PeriodData          : VitalPeriodDataType := VitalPeriodDataInit;
		--
		-- Variable(s) for internal use in VitalRecoveryRemovalCheck
		VARIABLE  IOPCL_CLK_TimingDataRR    : VitalTimingDataType := VitalTimingDataInit;
		--
		-- Variable(s) for internal use in VitalSetupHoldCheck
		VARIABLE  D_CLK_TimingDataSH        : VitalTimingDataType := VitalTimingDataInit;
		VARIABLE  ODE_CLK_TimingDataSH      : VitalTimingDataType := VitalTimingDataInit;
		--
		-- Variable(s) used in VitalPathDelay to Store GlitchData
		VARIABLE  Y_GlitchData              : VitalGlitchDataType;
		VARIABLE  PAD_GlitchData            : VitalGlitchDataType;
		--
		-- Variable(s) generated by VitalTimingCheck violation flags and/or user
		VARIABLE  SHVF_D_CLK                : STD_ULOGIC := '0';
		VARIABLE  SHVF_ODE_CLK              : STD_ULOGIC := '0';
		VARIABLE  PDVF_CLK                  : STD_ULOGIC := '0';
		VARIABLE  PDVF_IOPCL                : STD_ULOGIC := '0';
		VARIABLE  RRVF_IOPCL_CLK            : STD_ULOGIC := '0';
		VARIABLE  Violation                 : STD_ULOGIC := 'X';
		VARIABLE  BRECTL_TABStateReg        : STD_LOGIC_VECTOR(0 DOWNTO 0) := (OTHERS => 'X');
		VARIABLE  IQ                        : STD_LOGIC_VECTOR(0 DOWNTO 0) := (OTHERS => 'X');
		--
		-- Variable(s) used in VitalStateTable to store functional result
		VARIABLE  BRECTL_TAB_Result         : STD_LOGIC_VECTOR(2 DOWNTO 1) := (OTHERS => 'X');
		--
		-- Variable(s) used in VitalTruthTable to store functional result
		VARIABLE  BRECTL_TTAB_Result        : STD_LOGIC_VECTOR(1 DOWNTO 1) := (OTHERS => 'X');
		--
		-- Variable(s) used in VitalStateTable to keep track of the previous values
		--VARIABLE  PrevData_BRECTL_TAB       : STD_LOGIC_VECTOR(0 TO 5);
		VARIABLE  PrevData_BRECTL_TAB       : STD_LOGIC_VECTOR(0 TO 4);
		--
		-- Variable(s) used in VitalStateTable and VitalPropagatePathDelay
		VARIABLE  Y_zd                      : STD_ULOGIC;
		VARIABLE  PAD_zd                    : STD_ULOGIC;
		VARIABLE  D_delayed                 : STD_ULOGIC;
		VARIABLE  ODE_delayed               : STD_ULOGIC;
		--
		-- State Table : BRECTL_TAB Declaration
		CONSTANT  BRECTL_TAB : VitalStateTableType (1 to 14, 1 to 8) := (
		( '0', '0', '-', '-', '-',  '-',  '0',  '0' ),
		( '0', '1', '/', '0', '0',  '-',  '0',  '0' ),
		( '0', '1', '/', '1', '0',  '-',  '1',  '1' ),
		( '0', '1', '/', '0', '-',  '0',  '0',  '0' ),
		( '0', '1', '-', '0', '-',  '0',  '0',  '0' ),
		( '0', '-', '-', '0', '-',  '0',  '0',  '0' ),
		( '0', '-', '-', '-', '1',  '0',  '0',  '0' ),
		( '0', '1', '/', '1', '-',  '1',  '1',  '1' ),
		( '0', '1', '-', '1', '-',  '1',  '1',  '1' ),
		( '0', '1', '/', '-', '1',  '-',  'S',  'S' ),
		( '0', '1', 'F', '-', '-',  '-',  'S',  'S' ),
		( '0', '1', 'S', '-', '-',  '-',  'S',  'S' ),
		( '0', '1', '-', '-', '1',  '-',  'S',  'S' ),
		( 'X', '-', '-', '-', '-',  '-',  'X',  'X' ) );
	
	BEGIN
		-----------------------------------------------
		-- Timing Check Section
		-----------------------------------------------
		IF (TimingChecksOn) THEN
			-- Perform Setup/Hold Check
			--	TestSignal : D
			--	RefSignal  : CLK
			VitalSetupHoldCheck (
				Violation          => SHVF_D_CLK,
				TimingData         => D_CLK_TimingDataSH,
				TestSignal         => D_ipd,
				TestSignalName     => "D",
				TestDelay          => 0 ns,
				RefSignal          => CLK_ipd,
				RefSignalName      => "CLK",
				RefDelay           => 0 ns,
				SetupHigh          => tsetup_D_CLK_noedge_posedge,
				SetupLow           => tsetup_D_CLK_noedge_posedge,
				HoldHigh           => thold_D_CLK_noedge_posedge,
				HoldLow            => thold_D_CLK_noedge_posedge,
				CheckEnabled       => TO_X01 ( ( NOT IOPCL_ipd ) OR ODE_ipd ) /= '1',
				RefTransition      => '/',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalSetupHoldCheck
			-- Perform Setup/Hold Check
			--	TestSignal : ODE
			--	RefSignal  : CLK
			VitalSetupHoldCheck (
				Violation          => SHVF_ODE_CLK,
				TimingData         => ODE_CLK_TimingDataSH,
				TestSignal         => ODE_ipd,
				TestSignalName     => "ODE",
				TestDelay          => 0 ns,
				RefSignal          => CLK_ipd,
				RefSignalName      => "CLK",
				RefDelay           => 0 ns,
				SetupHigh          => tsetup_ODE_CLK_noedge_posedge,
				SetupLow           => tsetup_ODE_CLK_noedge_posedge,
				HoldHigh           => thold_ODE_CLK_noedge_posedge,
				HoldLow            => thold_ODE_CLK_noedge_posedge,
				CheckEnabled       => TO_X01 ( ( NOT IOPCL_ipd ) ) /= '1',
				RefTransition      => '/',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalSetupHoldCheck
			-- Perform Recovery/Removal Check
			--	TestSignal : IOPCL
			--	RefSignal  : CLK
			VitalRecoveryRemovalCheck (
				Violation          => RRVF_IOPCL_CLK,
				TimingData         => IOPCL_CLK_TimingDataRR,
				TestSignal         => IOPCL_ipd,
				TestSignalName     => "IOPCL",
				TestDelay          => 0 ns,
				RefSignal          => CLK_ipd,
				RefSignalName      => "CLK",
				RefDelay           => 0 ns,
				Recovery           => trecovery_IOPCL_CLK_posedge_posedge,
				Removal            => thold_IOPCL_CLK_noedge_posedge,
				ActiveLow          => TRUE,
				CheckEnabled       => TRUE,
				RefTransition      => '/',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalRecoveryRemovalCheck
			-- Perform Minimum and Maximum Periodicity and Pulse Check
			--TestSignal : CLK
			VitalPeriodPulseCheck (
				Violation          => PDVF_CLK,
				PeriodData         => CLK_PeriodData,
				TestSignal         => CLK_ipd,
				TestSignalName     => "CLK",
				TestDelay          => 0 ns,
				Period             => tperiod_CLK_posedge,
				PulseWidthHigh     => tpw_CLK_posedge,
				PulseWidthLow      => tpw_CLK_negedge,
				CheckEnabled       => TO_X01 ( ( NOT IOPCL_ipd ) ) /= '1',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalPeriodPulseCheck
			-- Perform Minimum and Maximum Periodicity and Pulse Check
			--TestSignal : IOPCL
			VitalPeriodPulseCheck (
				Violation          => PDVF_IOPCL,
				PeriodData         => IOPCL_PeriodData,
				TestSignal         => IOPCL_ipd,
				TestSignalName     => "IOPCL",
				TestDelay          => 0 ns,
				Period             => tperiod_IOPCL,
				PulseWidthHigh     => tpw_IOPCL_posedge,
				PulseWidthLow      => tpw_IOPCL_negedge,
				CheckEnabled       => TRUE,
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalPeriodPulseCheck
		
		END IF;	--Timing Check Section
		
		-----------------------------------------------
		-- Functionality Section
		-----------------------------------------------
		

		Violation                 := PDVF_CLK or PDVF_IOPCL or RRVF_IOPCL_CLK or 
				SHVF_D_CLK or SHVF_ODE_CLK ;
		--
		--Implement Functionality for State Table : BRECTL_TAB
		VitalStateTable (
				StateTable         => BRECTL_TAB,
				--DataIn             => (Violation & IOPCL_ipd & CLK_ipd & D_ipd & ODE_ipd),
				--DataIn             => (Violation, IOPCL_ipd, CLK_ipd, D_ipd, ODE_ipd),
				DataIn             => (Violation, IOPCL_ipd, CLK_ipd, D_delayed, ODE_delayed),
				NumStates          => 1,
				Result             => BRECTL_TAB_Result,
				PreviousDataIn     => PrevData_BRECTL_TAB
		);	--End VitalStateTable
		BRECTL_TABStateReg(0)     := BRECTL_TAB_Result(2);
		IQ(0)                     := BRECTL_TAB_Result(1);
		Y_zd                      := TO_X01(PAD_ipd);
		--
		PAD_zd := VitalBUFIF0 (data => IQ(0), enable => (NOT E_ipd));
		D_delayed := D_ipd;
		ODE_delayed := ODE_ipd;

		
		
		-----------------------------------------------
		-- Path Delay Section
		-----------------------------------------------
		VitalPathDelay01 (
				OutSignal          => Y,
				OutSignalName      => "Y",
				OutTemp            => Y_zd,
				DefaultDelay       => VitalZeroDelay01,
				MsgSeverity        => WARNING,
				Paths              => (
				                 0 => (
							InputChangeTime => PAD_ipd'LAST_EVENT,
							PathDelay       => tpd_PAD_Y,
							PathCondition   => TRUE
				                      )
				                      ),
				GlitchData         => Y_GlitchData,
				Mode               => OnDetect,
				XOn                => XOn,
				MsgOn              => MsgOn
		);	--End VitalPathDelay
		VitalPathDelay01Z (
				OutSignal          => PAD,
				OutSignalName      => "PAD",
				OutTemp            => PAD_zd,
				DefaultDelay       => VitalZeroDelay01Z,
				MsgSeverity        => WARNING,
				Paths              => (
				                 0 => (
							InputChangeTime => IOPCL_ipd'LAST_EVENT,
							PathDelay       => VitalExtendToFillDelay(tpd_IOPCL_PAD),
							PathCondition   => TRUE
				                      ),
				                 1 => (
							InputChangeTime => CLK_ipd'LAST_EVENT,
							PathDelay       => VitalExtendToFillDelay(tpd_CLK_PAD),
							PathCondition   => TRUE
				                      ),
				                 2 => (
							InputChangeTime => E_ipd'LAST_EVENT,
							PathDelay       => tpd_E_PAD,
							PathCondition   => TRUE
				                      )
				                      ),
				GlitchData         => PAD_GlitchData,
				Mode               => OnDetect,
				XOn                => XOn,
				MsgOn              => MsgOn,
				OutputMap          => "UX01ZWLH-"
		);	--End VitalPathDelay
		
	END PROCESS VITALBehavior;

END VITAL_ACT;

configuration CFG_BRECTL_VITAL of BRECTL is
   for VITAL_ACT
   end for;
end CFG_BRECTL_VITAL;
----- CELL BREPTH -----
LIBRARY   IEEE;
USE       IEEE.std_logic_1164.all;
USE       IEEE.VITAL_Timing.all;
USE       IEEE.VITAL_Primitives.all;
	
entity BREPTH IS
	GENERIC (
		--
		-- PinToPinDelay Generics Declaration(s)
		tpd_PAD_Y            : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input PAD to output Y
		tpd_IOPCL_PAD        : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input IOPCL to output PAD
		tpd_CLK_PAD          : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input CLK to output PAD
		tpd_E_PAD            : VitalDelayType01z := (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns); -- Path delay from input E to output PAD

		--
		-- Interconnect Path Delay Generics Declaration(s)
		tipd_CLK             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port CLK
		tipd_D               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port D
		tipd_E               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port E
		tipd_IOPCL           : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port IOPCL
		tipd_ODE             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port ODE
		tipd_PAD             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port PAD
		--
		-- Setup Generics Declaration(s)
		tsetup_D_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between D and CLK
		tsetup_ODE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between ODE and CLK
		--
		-- Hold Generics Declaration(s)
		thold_D_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between D and CLK
		thold_ODE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between ODE and CLK
		thold_IOPCL_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between IOPCL and CLK
		--
		-- Recovery Generics Declaration(s)
		trecovery_IOPCL_CLK_posedge_posedge : VitalDelayType   := 0.000 ns;	-- Recovery time between IOPCL and CLK
		--
		-- Period Check Generics Declaration(s)
		tperiod_CLK_posedge          : VitalDelayType   := 0.000 ns;	-- Minimum period time for CLK
		tpw_CLK_posedge      : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for CLK
		tpw_CLK_negedge      : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for CLK
		tperiod_IOPCL        : VitalDelayType   := 0.000 ns;	-- Minimum period time for IOPCL
		tpw_IOPCL_posedge    : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for IOPCL
		tpw_IOPCL_negedge    : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for IOPCL
		--
		-- InstancePath Will Accompany Any Assertion Messages in the Model
		InstancePath         : STRING           := "*";
		--
		-- 'X' generation control parameter for timing checks and path delay
		XOn                  : BOOLEAN          := TRUE;
		--
		-- Assertion messages generation control parameter for violation of timing checks
		MsgOn                : BOOLEAN          := TRUE;
		--
		-- VitalTimingCheck Switch
		TimingChecksOn       : BOOLEAN          := TRUE
	);
	PORT (
		CLK                 : IN      STD_ULOGIC := 'X';
		D                   : IN      STD_ULOGIC := 'X';
		E                   : IN      STD_ULOGIC := 'X';
		IOPCL               : IN      STD_ULOGIC := 'X';
		ODE                 : IN      STD_ULOGIC := 'X';
		PAD                 : INOUT   STD_ULOGIC := 'X';
		Y                   : OUT     STD_ULOGIC := 'X'
		
	);
	--
	attribute Vital_Level0 OF BREPTH : ENTITY IS TRUE;
	--
end BREPTH;

ARCHITECTURE VITAL_ACT OF BREPTH IS
	--
	ATTRIBUTE Vital_Level1 OF VITAL_ACT : ARCHITECTURE IS TRUE;
	--
	--
	--Internal Delay Signals - delayed be the interconnect path delay
	SIGNAL    CLK_ipd                   : STD_ULOGIC := 'U';
	SIGNAL    D_ipd                     : STD_ULOGIC := 'U';
	SIGNAL    E_ipd                     : STD_ULOGIC := 'U';
	SIGNAL    IOPCL_ipd                 : STD_ULOGIC := 'U';
	SIGNAL    ODE_ipd                   : STD_ULOGIC := 'U';
	SIGNAL    PAD_ipd                   : STD_ULOGIC := 'U';
	
	BEGIN
	-----------------------------------------------
	-- Input Path Delay Section
	-----------------------------------------------
	WireDelay : BLOCK
	BEGIN
		VitalWireDelay (
				OutSig             => CLK_ipd,
				InSig              => CLK,
				twire              => tipd_CLK
		);
		VitalWireDelay (
				OutSig             => D_ipd,
				InSig              => D,
				twire              => tipd_D
		);
		VitalWireDelay (
				OutSig             => E_ipd,
				InSig              => E,
				twire              => tipd_E
		);
		VitalWireDelay (
				OutSig             => IOPCL_ipd,
				InSig              => IOPCL,
				twire              => tipd_IOPCL
		);
		VitalWireDelay (
				OutSig             => ODE_ipd,
				InSig              => ODE,
				twire              => tipd_ODE
		);
		VitalWireDelay (
				OutSig             => PAD_ipd,
				InSig              => PAD,
				twire              => tipd_PAD
		);
	
	END BLOCK WireDelay;
	
	-----------------------------------------------
	-- Behavior Section
	-----------------------------------------------
	VITALBehavior : PROCESS (CLK_ipd, D_ipd, E_ipd, IOPCL_ipd, ODE_ipd, PAD_ipd	
	                        )
		--
		-- Variable(s) for internal use in VitalPeriodPulseCheck
		VARIABLE  CLK_PeriodData            : VitalPeriodDataType := VitalPeriodDataInit;
		VARIABLE  IOPCL_PeriodData          : VitalPeriodDataType := VitalPeriodDataInit;
		--
		-- Variable(s) for internal use in VitalRecoveryRemovalCheck
		VARIABLE  IOPCL_CLK_TimingDataRR    : VitalTimingDataType := VitalTimingDataInit;
		--
		-- Variable(s) for internal use in VitalSetupHoldCheck
		VARIABLE  D_CLK_TimingDataSH        : VitalTimingDataType := VitalTimingDataInit;
		VARIABLE  ODE_CLK_TimingDataSH      : VitalTimingDataType := VitalTimingDataInit;
		--
		-- Variable(s) used in VitalPathDelay to Store GlitchData
		VARIABLE  Y_GlitchData              : VitalGlitchDataType;
		VARIABLE  PAD_GlitchData            : VitalGlitchDataType;
		--
		-- Variable(s) generated by VitalTimingCheck violation flags and/or user
		VARIABLE  SHVF_D_CLK                : STD_ULOGIC := '0';
		VARIABLE  SHVF_ODE_CLK              : STD_ULOGIC := '0';
		VARIABLE  PDVF_CLK                  : STD_ULOGIC := '0';
		VARIABLE  PDVF_IOPCL                : STD_ULOGIC := '0';
		VARIABLE  RRVF_IOPCL_CLK            : STD_ULOGIC := '0';
		VARIABLE  Violation                 : STD_ULOGIC := 'X';
		VARIABLE  BREPTH_TABStateReg        : STD_LOGIC_VECTOR(0 DOWNTO 0) := (OTHERS => 'X');
		VARIABLE  IQ                        : STD_LOGIC_VECTOR(0 DOWNTO 0) := (OTHERS => 'X');
		--
		-- Variable(s) used in VitalStateTable to store functional result
		VARIABLE  BREPTH_TAB_Result         : STD_LOGIC_VECTOR(2 DOWNTO 1) := (OTHERS => 'X');
		--
		-- Variable(s) used in VitalTruthTable to store functional result
		VARIABLE  BREPTH_TTAB_Result        : STD_LOGIC_VECTOR(1 DOWNTO 1) := (OTHERS => 'X');
		--
		-- Variable(s) used in VitalStateTable to keep track of the previous values
		--VARIABLE  PrevData_BREPTH_TAB       : STD_LOGIC_VECTOR(0 TO 5);
		VARIABLE  PrevData_BREPTH_TAB       : STD_LOGIC_VECTOR(0 TO 4);
		--
		-- Variable(s) used in VitalStateTable and VitalPropagatePathDelay
		VARIABLE  Y_zd                      : STD_ULOGIC;
		VARIABLE  PAD_zd                    : STD_ULOGIC;
		VARIABLE  D_delayed                 : STD_ULOGIC;
		VARIABLE  ODE_delayed               : STD_ULOGIC;
		--
		-- State Table : BREPTH_TAB Declaration
		CONSTANT  BREPTH_TAB : VitalStateTableType (1 to 14, 1 to 8) := (
		( '0', '0', '-', '-', '-',  '-',  '1',  '1' ),
		( '0', '1', '/', '0', '0',  '-',  '0',  '0' ),
		( '0', '1', '/', '1', '0',  '-',  '1',  '1' ),
		( '0', '1', '/', '0', '-',  '0',  '0',  '0' ),
		( '0', '1', '-', '0', '-',  '0',  '0',  '0' ),
		( '0', '-', '-', '1', '-',  '1',  '1',  '1' ),
		( '0', '-', '-', '-', '1',  '1',  '1',  '1' ),
		( '0', '1', '/', '1', '-',  '1',  '1',  '1' ),
		( '0', '1', '-', '1', '-',  '1',  '1',  '1' ),
		( '0', '1', '/', '-', '1',  '-',  'S',  'S' ),
		( '0', '1', 'F', '-', '-',  '-',  'S',  'S' ),
		( '0', '1', 'S', '-', '-',  '-',  'S',  'S' ),
		( '0', '1', '-', '-', '1',  '-',  'S',  'S' ),
		( 'X', '-', '-', '-', '-',  '-',  'X',  'X' ) );
	
	BEGIN
		-----------------------------------------------
		-- Timing Check Section
		-----------------------------------------------
		IF (TimingChecksOn) THEN
			-- Perform Setup/Hold Check
			--	TestSignal : D
			--	RefSignal  : CLK
			VitalSetupHoldCheck (
				Violation          => SHVF_D_CLK,
				TimingData         => D_CLK_TimingDataSH,
				TestSignal         => D_ipd,
				TestSignalName     => "D",
				TestDelay          => 0 ns,
				RefSignal          => CLK_ipd,
				RefSignalName      => "CLK",
				RefDelay           => 0 ns,
				SetupHigh          => tsetup_D_CLK_noedge_posedge,
				SetupLow           => tsetup_D_CLK_noedge_posedge,
				HoldHigh           => thold_D_CLK_noedge_posedge,
				HoldLow            => thold_D_CLK_noedge_posedge,
				CheckEnabled       => TO_X01 ( ( NOT IOPCL_ipd ) OR ODE_ipd ) /= '1',
				RefTransition      => '/',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalSetupHoldCheck
			-- Perform Setup/Hold Check
			--	TestSignal : ODE
			--	RefSignal  : CLK
			VitalSetupHoldCheck (
				Violation          => SHVF_ODE_CLK,
				TimingData         => ODE_CLK_TimingDataSH,
				TestSignal         => ODE_ipd,
				TestSignalName     => "ODE",
				TestDelay          => 0 ns,
				RefSignal          => CLK_ipd,
				RefSignalName      => "CLK",
				RefDelay           => 0 ns,
				SetupHigh          => tsetup_ODE_CLK_noedge_posedge,
				SetupLow           => tsetup_ODE_CLK_noedge_posedge,
				HoldHigh           => thold_ODE_CLK_noedge_posedge,
				HoldLow            => thold_ODE_CLK_noedge_posedge,
				CheckEnabled       => TO_X01 ( ( NOT IOPCL_ipd ) ) /= '1',
				RefTransition      => '/',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalSetupHoldCheck
			-- Perform Recovery/Removal Check
			--	TestSignal : IOPCL
			--	RefSignal  : CLK
			VitalRecoveryRemovalCheck (
				Violation          => RRVF_IOPCL_CLK,
				TimingData         => IOPCL_CLK_TimingDataRR,
				TestSignal         => IOPCL_ipd,
				TestSignalName     => "IOPCL",
				TestDelay          => 0 ns,
				RefSignal          => CLK_ipd,
				RefSignalName      => "CLK",
				RefDelay           => 0 ns,
				Recovery           => trecovery_IOPCL_CLK_posedge_posedge,
				Removal            => thold_IOPCL_CLK_noedge_posedge,
				ActiveLow          => TRUE,
				CheckEnabled       => TRUE,
				RefTransition      => '/',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalRecoveryRemovalCheck
			-- Perform Minimum and Maximum Periodicity and Pulse Check
			--TestSignal : CLK
			VitalPeriodPulseCheck (
				Violation          => PDVF_CLK,
				PeriodData         => CLK_PeriodData,
				TestSignal         => CLK_ipd,
				TestSignalName     => "CLK",
				TestDelay          => 0 ns,
				Period             => tperiod_CLK_posedge,
				PulseWidthHigh     => tpw_CLK_posedge,
				PulseWidthLow      => tpw_CLK_negedge,
				CheckEnabled       => TO_X01 ( ( NOT IOPCL_ipd ) ) /= '1',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalPeriodPulseCheck
			-- Perform Minimum and Maximum Periodicity and Pulse Check
			--TestSignal : IOPCL
			VitalPeriodPulseCheck (
				Violation          => PDVF_IOPCL,
				PeriodData         => IOPCL_PeriodData,
				TestSignal         => IOPCL_ipd,
				TestSignalName     => "IOPCL",
				TestDelay          => 0 ns,
				Period             => tperiod_IOPCL,
				PulseWidthHigh     => tpw_IOPCL_posedge,
				PulseWidthLow      => tpw_IOPCL_negedge,
				CheckEnabled       => TRUE,
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalPeriodPulseCheck
		
		END IF;	--Timing Check Section
		
		-----------------------------------------------
		-- Functionality Section
		-----------------------------------------------
		

		Violation                 := PDVF_CLK or PDVF_IOPCL or RRVF_IOPCL_CLK or 
				SHVF_D_CLK or SHVF_ODE_CLK ;
		--
		--Implement Functionality for State Table : BREPTH_TAB
		VitalStateTable (
				StateTable         => BREPTH_TAB,
				--DataIn             => (Violation & IOPCL_ipd & CLK_ipd & D_ipd & ODE_ipd),
				--DataIn             => (Violation, IOPCL_ipd, CLK_ipd, D_ipd, ODE_ipd),
				DataIn             => (Violation, IOPCL_ipd, CLK_ipd, D_delayed, ODE_delayed),
				NumStates          => 1,
				Result             => BREPTH_TAB_Result,
				PreviousDataIn     => PrevData_BREPTH_TAB
		);	--End VitalStateTable
		BREPTH_TABStateReg(0)     := BREPTH_TAB_Result(2);
		IQ(0)                     := BREPTH_TAB_Result(1);
		Y_zd                      := TO_X01(PAD_ipd);
		--
		PAD_zd := VitalBUFIF0 (data => IQ(0), enable => (NOT E_ipd));
		D_delayed := D_ipd;
		ODE_delayed := ODE_ipd;

		
		
		-----------------------------------------------
		-- Path Delay Section
		-----------------------------------------------
		VitalPathDelay01 (
				OutSignal          => Y,
				OutSignalName      => "Y",
				OutTemp            => Y_zd,
				DefaultDelay       => VitalZeroDelay01,
				MsgSeverity        => WARNING,
				Paths              => (
				                 0 => (
							InputChangeTime => PAD_ipd'LAST_EVENT,
							PathDelay       => tpd_PAD_Y,
							PathCondition   => TRUE
				                      )
				                      ),
				GlitchData         => Y_GlitchData,
				Mode               => OnDetect,
				XOn                => XOn,
				MsgOn              => MsgOn
		);	--End VitalPathDelay
		VitalPathDelay01Z (
				OutSignal          => PAD,
				OutSignalName      => "PAD",
				OutTemp            => PAD_zd,
				DefaultDelay       => VitalZeroDelay01Z,
				MsgSeverity        => WARNING,
				Paths              => (
				                 0 => (
							InputChangeTime => IOPCL_ipd'LAST_EVENT,
							PathDelay       => VitalExtendToFillDelay(tpd_IOPCL_PAD),
							PathCondition   => TRUE
				                      ),
				                 1 => (
							InputChangeTime => CLK_ipd'LAST_EVENT,
							PathDelay       => VitalExtendToFillDelay(tpd_CLK_PAD),
							PathCondition   => TRUE
				                      ),
				                 2 => (
							InputChangeTime => E_ipd'LAST_EVENT,
							PathDelay       => tpd_E_PAD,
							PathCondition   => TRUE
				                      )
				                      ),
				GlitchData         => PAD_GlitchData,
				Mode               => OnDetect,
				XOn                => XOn,
				MsgOn              => MsgOn,
				OutputMap          => "UX01ZWLH-"
		);	--End VitalPathDelay
		
	END PROCESS VITALBehavior;

END VITAL_ACT;

configuration CFG_BREPTH_VITAL of BREPTH is
   for VITAL_ACT
   end for;
end CFG_BREPTH_VITAL;
----- CELL BREPTL -----
LIBRARY   IEEE;
USE       IEEE.std_logic_1164.all;
USE       IEEE.VITAL_Timing.all;
USE       IEEE.VITAL_Primitives.all;
	
entity BREPTL IS
	GENERIC (
		--
		-- PinToPinDelay Generics Declaration(s)
		tpd_PAD_Y            : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input PAD to output Y
		tpd_IOPCL_PAD        : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input IOPCL to output PAD
		tpd_CLK_PAD          : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input CLK to output PAD
		tpd_E_PAD            : VitalDelayType01z := (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns); -- Path delay from input E to output PAD

		--
		-- Interconnect Path Delay Generics Declaration(s)
		tipd_CLK             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port CLK
		tipd_D               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port D
		tipd_E               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port E
		tipd_IOPCL           : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port IOPCL
		tipd_ODE             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port ODE
		tipd_PAD             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port PAD
		--
		-- Setup Generics Declaration(s)
		tsetup_D_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between D and CLK
		tsetup_ODE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between ODE and CLK
		--
		-- Hold Generics Declaration(s)
		thold_D_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between D and CLK
		thold_ODE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between ODE and CLK
		thold_IOPCL_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between IOPCL and CLK
		--
		-- Recovery Generics Declaration(s)
		trecovery_IOPCL_CLK_posedge_posedge : VitalDelayType   := 0.000 ns;	-- Recovery time between IOPCL and CLK
		--
		-- Period Check Generics Declaration(s)
		tperiod_CLK_posedge          : VitalDelayType   := 0.000 ns;	-- Minimum period time for CLK
		tpw_CLK_posedge      : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for CLK
		tpw_CLK_negedge      : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for CLK
		tperiod_IOPCL        : VitalDelayType   := 0.000 ns;	-- Minimum period time for IOPCL
		tpw_IOPCL_posedge    : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for IOPCL
		tpw_IOPCL_negedge    : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for IOPCL
		--
		-- InstancePath Will Accompany Any Assertion Messages in the Model
		InstancePath         : STRING           := "*";
		--
		-- 'X' generation control parameter for timing checks and path delay
		XOn                  : BOOLEAN          := TRUE;
		--
		-- Assertion messages generation control parameter for violation of timing checks
		MsgOn                : BOOLEAN          := TRUE;
		--
		-- VitalTimingCheck Switch
		TimingChecksOn       : BOOLEAN          := TRUE
	);
	PORT (
		CLK                 : IN      STD_ULOGIC := 'X';
		D                   : IN      STD_ULOGIC := 'X';
		E                   : IN      STD_ULOGIC := 'X';
		IOPCL               : IN      STD_ULOGIC := 'X';
		ODE                 : IN      STD_ULOGIC := 'X';
		PAD                 : INOUT   STD_ULOGIC := 'X';
		Y                   : OUT     STD_ULOGIC := 'X'
		
	);
	--
	attribute Vital_Level0 OF BREPTL : ENTITY IS TRUE;
	--
end BREPTL;

ARCHITECTURE VITAL_ACT OF BREPTL IS
	--
	ATTRIBUTE Vital_Level1 OF VITAL_ACT : ARCHITECTURE IS TRUE;
	--
	--
	--Internal Delay Signals - delayed be the interconnect path delay
	SIGNAL    CLK_ipd                   : STD_ULOGIC := 'U';
	SIGNAL    D_ipd                     : STD_ULOGIC := 'U';
	SIGNAL    E_ipd                     : STD_ULOGIC := 'U';
	SIGNAL    IOPCL_ipd                 : STD_ULOGIC := 'U';
	SIGNAL    ODE_ipd                   : STD_ULOGIC := 'U';
	SIGNAL    PAD_ipd                   : STD_ULOGIC := 'U';
	
	BEGIN
	-----------------------------------------------
	-- Input Path Delay Section
	-----------------------------------------------
	WireDelay : BLOCK
	BEGIN
		VitalWireDelay (
				OutSig             => CLK_ipd,
				InSig              => CLK,
				twire              => tipd_CLK
		);
		VitalWireDelay (
				OutSig             => D_ipd,
				InSig              => D,
				twire              => tipd_D
		);
		VitalWireDelay (
				OutSig             => E_ipd,
				InSig              => E,
				twire              => tipd_E
		);
		VitalWireDelay (
				OutSig             => IOPCL_ipd,
				InSig              => IOPCL,
				twire              => tipd_IOPCL
		);
		VitalWireDelay (
				OutSig             => ODE_ipd,
				InSig              => ODE,
				twire              => tipd_ODE
		);
		VitalWireDelay (
				OutSig             => PAD_ipd,
				InSig              => PAD,
				twire              => tipd_PAD
		);
	
	END BLOCK WireDelay;
	
	-----------------------------------------------
	-- Behavior Section
	-----------------------------------------------
	VITALBehavior : PROCESS (CLK_ipd, D_ipd, E_ipd, IOPCL_ipd, ODE_ipd, PAD_ipd	
	                        )
		--
		-- Variable(s) for internal use in VitalPeriodPulseCheck
		VARIABLE  CLK_PeriodData            : VitalPeriodDataType := VitalPeriodDataInit;
		VARIABLE  IOPCL_PeriodData          : VitalPeriodDataType := VitalPeriodDataInit;
		--
		-- Variable(s) for internal use in VitalRecoveryRemovalCheck
		VARIABLE  IOPCL_CLK_TimingDataRR    : VitalTimingDataType := VitalTimingDataInit;
		--
		-- Variable(s) for internal use in VitalSetupHoldCheck
		VARIABLE  D_CLK_TimingDataSH        : VitalTimingDataType := VitalTimingDataInit;
		VARIABLE  ODE_CLK_TimingDataSH      : VitalTimingDataType := VitalTimingDataInit;
		--
		-- Variable(s) used in VitalPathDelay to Store GlitchData
		VARIABLE  Y_GlitchData              : VitalGlitchDataType;
		VARIABLE  PAD_GlitchData            : VitalGlitchDataType;
		--
		-- Variable(s) generated by VitalTimingCheck violation flags and/or user
		VARIABLE  SHVF_D_CLK                : STD_ULOGIC := '0';
		VARIABLE  SHVF_ODE_CLK              : STD_ULOGIC := '0';
		VARIABLE  PDVF_CLK                  : STD_ULOGIC := '0';
		VARIABLE  PDVF_IOPCL                : STD_ULOGIC := '0';
		VARIABLE  RRVF_IOPCL_CLK            : STD_ULOGIC := '0';
		VARIABLE  Violation                 : STD_ULOGIC := 'X';
		VARIABLE  BREPTL_TABStateReg        : STD_LOGIC_VECTOR(0 DOWNTO 0) := (OTHERS => 'X');
		VARIABLE  IQ                        : STD_LOGIC_VECTOR(0 DOWNTO 0) := (OTHERS => 'X');
		--
		-- Variable(s) used in VitalStateTable to store functional result
		VARIABLE  BREPTL_TAB_Result         : STD_LOGIC_VECTOR(2 DOWNTO 1) := (OTHERS => 'X');
		--
		-- Variable(s) used in VitalTruthTable to store functional result
		VARIABLE  BREPTL_TTAB_Result        : STD_LOGIC_VECTOR(1 DOWNTO 1) := (OTHERS => 'X');
		--
		-- Variable(s) used in VitalStateTable to keep track of the previous values
		--VARIABLE  PrevData_BREPTL_TAB       : STD_LOGIC_VECTOR(0 TO 5);
		VARIABLE  PrevData_BREPTL_TAB       : STD_LOGIC_VECTOR(0 TO 4);
		--
		-- Variable(s) used in VitalStateTable and VitalPropagatePathDelay
		VARIABLE  Y_zd                      : STD_ULOGIC;
		VARIABLE  PAD_zd                    : STD_ULOGIC;
		VARIABLE  D_delayed                 : STD_ULOGIC;
		VARIABLE  ODE_delayed               : STD_ULOGIC;
		--
		-- State Table : BREPTL_TAB Declaration
		CONSTANT  BREPTL_TAB : VitalStateTableType (1 to 14, 1 to 8) := (
		( '0', '0', '-', '-', '-',  '-',  '1',  '1' ),
		( '0', '1', '/', '0', '0',  '-',  '0',  '0' ),
		( '0', '1', '/', '1', '0',  '-',  '1',  '1' ),
		( '0', '1', '/', '0', '-',  '0',  '0',  '0' ),
		( '0', '1', '-', '0', '-',  '0',  '0',  '0' ),
		( '0', '-', '-', '1', '-',  '1',  '1',  '1' ),
		( '0', '-', '-', '-', '1',  '1',  '1',  '1' ),
		( '0', '1', '/', '1', '-',  '1',  '1',  '1' ),
		( '0', '1', '-', '1', '-',  '1',  '1',  '1' ),
		( '0', '1', '/', '-', '1',  '-',  'S',  'S' ),
		( '0', '1', 'F', '-', '-',  '-',  'S',  'S' ),
		( '0', '1', 'S', '-', '-',  '-',  'S',  'S' ),
		( '0', '1', '-', '-', '1',  '-',  'S',  'S' ),
		( 'X', '-', '-', '-', '-',  '-',  'X',  'X' ) );
	
	BEGIN
		-----------------------------------------------
		-- Timing Check Section
		-----------------------------------------------
		IF (TimingChecksOn) THEN
			-- Perform Setup/Hold Check
			--	TestSignal : D
			--	RefSignal  : CLK
			VitalSetupHoldCheck (
				Violation          => SHVF_D_CLK,
				TimingData         => D_CLK_TimingDataSH,
				TestSignal         => D_ipd,
				TestSignalName     => "D",
				TestDelay          => 0 ns,
				RefSignal          => CLK_ipd,
				RefSignalName      => "CLK",
				RefDelay           => 0 ns,
				SetupHigh          => tsetup_D_CLK_noedge_posedge,
				SetupLow           => tsetup_D_CLK_noedge_posedge,
				HoldHigh           => thold_D_CLK_noedge_posedge,
				HoldLow            => thold_D_CLK_noedge_posedge,
				CheckEnabled       => TO_X01 ( ( NOT IOPCL_ipd ) OR ODE_ipd ) /= '1',
				RefTransition      => '/',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalSetupHoldCheck
			-- Perform Setup/Hold Check
			--	TestSignal : ODE
			--	RefSignal  : CLK
			VitalSetupHoldCheck (
				Violation          => SHVF_ODE_CLK,
				TimingData         => ODE_CLK_TimingDataSH,
				TestSignal         => ODE_ipd,
				TestSignalName     => "ODE",
				TestDelay          => 0 ns,
				RefSignal          => CLK_ipd,
				RefSignalName      => "CLK",
				RefDelay           => 0 ns,
				SetupHigh          => tsetup_ODE_CLK_noedge_posedge,
				SetupLow           => tsetup_ODE_CLK_noedge_posedge,
				HoldHigh           => thold_ODE_CLK_noedge_posedge,
				HoldLow            => thold_ODE_CLK_noedge_posedge,
				CheckEnabled       => TO_X01 ( ( NOT IOPCL_ipd ) ) /= '1',
				RefTransition      => '/',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalSetupHoldCheck
			-- Perform Recovery/Removal Check
			--	TestSignal : IOPCL
			--	RefSignal  : CLK
			VitalRecoveryRemovalCheck (
				Violation          => RRVF_IOPCL_CLK,
				TimingData         => IOPCL_CLK_TimingDataRR,
				TestSignal         => IOPCL_ipd,
				TestSignalName     => "IOPCL",
				TestDelay          => 0 ns,
				RefSignal          => CLK_ipd,
				RefSignalName      => "CLK",
				RefDelay           => 0 ns,
				Recovery           => trecovery_IOPCL_CLK_posedge_posedge,
				Removal            => thold_IOPCL_CLK_noedge_posedge,
				ActiveLow          => TRUE,
				CheckEnabled       => TRUE,
				RefTransition      => '/',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalRecoveryRemovalCheck
			-- Perform Minimum and Maximum Periodicity and Pulse Check
			--TestSignal : CLK
			VitalPeriodPulseCheck (
				Violation          => PDVF_CLK,
				PeriodData         => CLK_PeriodData,
				TestSignal         => CLK_ipd,
				TestSignalName     => "CLK",
				TestDelay          => 0 ns,
				Period             => tperiod_CLK_posedge,
				PulseWidthHigh     => tpw_CLK_posedge,
				PulseWidthLow      => tpw_CLK_negedge,
				CheckEnabled       => TO_X01 ( ( NOT IOPCL_ipd ) ) /= '1',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalPeriodPulseCheck
			-- Perform Minimum and Maximum Periodicity and Pulse Check
			--TestSignal : IOPCL
			VitalPeriodPulseCheck (
				Violation          => PDVF_IOPCL,
				PeriodData         => IOPCL_PeriodData,
				TestSignal         => IOPCL_ipd,
				TestSignalName     => "IOPCL",
				TestDelay          => 0 ns,
				Period             => tperiod_IOPCL,
				PulseWidthHigh     => tpw_IOPCL_posedge,
				PulseWidthLow      => tpw_IOPCL_negedge,
				CheckEnabled       => TRUE,
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalPeriodPulseCheck
		
		END IF;	--Timing Check Section
		
		-----------------------------------------------
		-- Functionality Section
		-----------------------------------------------
		

		Violation                 := PDVF_CLK or PDVF_IOPCL or RRVF_IOPCL_CLK or 
				SHVF_D_CLK or SHVF_ODE_CLK ;
		--
		--Implement Functionality for State Table : BREPTL_TAB
		VitalStateTable (
				StateTable         => BREPTL_TAB,
				--DataIn             => (Violation & IOPCL_ipd & CLK_ipd & D_ipd & ODE_ipd),
				--DataIn             => (Violation, IOPCL_ipd, CLK_ipd, D_ipd, ODE_ipd),
				DataIn             => (Violation, IOPCL_ipd, CLK_ipd, D_delayed, ODE_delayed),
				NumStates          => 1,
				Result             => BREPTL_TAB_Result,
				PreviousDataIn     => PrevData_BREPTL_TAB
		);	--End VitalStateTable
		BREPTL_TABStateReg(0)     := BREPTL_TAB_Result(2);
		IQ(0)                     := BREPTL_TAB_Result(1);
		Y_zd                      := TO_X01(PAD_ipd);
		--
		PAD_zd := VitalBUFIF0 (data => IQ(0), enable => (NOT E_ipd));
		D_delayed := D_ipd;
		ODE_delayed := ODE_ipd;

		
		
		-----------------------------------------------
		-- Path Delay Section
		-----------------------------------------------
		VitalPathDelay01 (
				OutSignal          => Y,
				OutSignalName      => "Y",
				OutTemp            => Y_zd,
				DefaultDelay       => VitalZeroDelay01,
				MsgSeverity        => WARNING,
				Paths              => (
				                 0 => (
							InputChangeTime => PAD_ipd'LAST_EVENT,
							PathDelay       => tpd_PAD_Y,
							PathCondition   => TRUE
				                      )
				                      ),
				GlitchData         => Y_GlitchData,
				Mode               => OnDetect,
				XOn                => XOn,
				MsgOn              => MsgOn
		);	--End VitalPathDelay
		VitalPathDelay01Z (
				OutSignal          => PAD,
				OutSignalName      => "PAD",
				OutTemp            => PAD_zd,
				DefaultDelay       => VitalZeroDelay01Z,
				MsgSeverity        => WARNING,
				Paths              => (
				                 0 => (
							InputChangeTime => IOPCL_ipd'LAST_EVENT,
							PathDelay       => VitalExtendToFillDelay(tpd_IOPCL_PAD),
							PathCondition   => TRUE
				                      ),
				                 1 => (
							InputChangeTime => CLK_ipd'LAST_EVENT,
							PathDelay       => VitalExtendToFillDelay(tpd_CLK_PAD),
							PathCondition   => TRUE
				                      ),
				                 2 => (
							InputChangeTime => E_ipd'LAST_EVENT,
							PathDelay       => tpd_E_PAD,
							PathCondition   => TRUE
				                      )
				                      ),
				GlitchData         => PAD_GlitchData,
				Mode               => OnDetect,
				XOn                => XOn,
				MsgOn              => MsgOn,
				OutputMap          => "UX01ZWLH-"
		);	--End VitalPathDelay
		
	END PROCESS VITALBehavior;

END VITAL_ACT;

configuration CFG_BREPTL_VITAL of BREPTL is
   for VITAL_ACT
   end for;
end CFG_BREPTL_VITAL;
----- CELL BUFA -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity BUFA is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of BUFA : entity is TRUE;
end BUFA;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of BUFA is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := TO_X01(A_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (A_ipd'last_event, tpd_A_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_BUFA_VITAL of BUFA is
   for VITAL_ACT
   end for;
end CFG_BUFA_VITAL;


----- CELL BUFD -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity BUFD is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of BUFD : entity is TRUE;
end BUFD;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of BUFD is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := TO_X01(A_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (A_ipd'last_event, tpd_A_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_BUFD_VITAL of BUFD is
   for VITAL_ACT
   end for;
end CFG_BUFD_VITAL;


----- CELL BUFF -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity BUFF is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of BUFF : entity is TRUE;
end BUFF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of BUFF is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := TO_X01(A_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (A_ipd'last_event, tpd_A_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_BUFF_VITAL of BUFF is
   for VITAL_ACT
   end for;
end CFG_BUFF_VITAL;


----- CELL CLKBIBUF -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CLKBIBUF is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_E_PAD                      :	VitalDelayType01z := 
               (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns);
      tpd_D_PAD                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_PAD_Y                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PAD                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      PAD                            :	inout STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CLKBIBUF : entity is TRUE;
end CLKBIBUF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of CLKBIBUF is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL E_ipd	 : STD_ULOGIC := 'X';
   SIGNAL PAD_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (E_ipd, E, tipd_E);
   VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS PAD_zd : STD_LOGIC is Results(1);
   ALIAS Y_zd : STD_LOGIC is Results(2);

   -- output glitch detection variables
   VARIABLE PAD_GlitchData	: VitalGlitchDataType;
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      PAD_zd := VitalBUFIF0 (data => D_ipd,
              enable => (NOT E_ipd));
      Y_zd := TO_X01(PAD_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01Z (
       OutSignal => PAD,
       GlitchData => PAD_GlitchData,
       OutSignalName => "PAD",
       OutTemp => PAD_zd,
       Paths => (0 => (E_ipd'last_event, tpd_E_PAD, TRUE),
                 1 => (D_ipd'last_event, VitalExtendToFillDelay(tpd_D_PAD), TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING,
       OutputMap => "UX01ZWLH-");
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (PAD_ipd'last_event, tpd_PAD_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_CLKBIBUF_VITAL of CLKBIBUF is
   for VITAL_ACT
   end for;
end CFG_CLKBIBUF_VITAL;


----- CELL CLKBUF -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CLKBUF is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_PAD_Y                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_PAD                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      PAD                            :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CLKBUF : entity is TRUE;
end CLKBUF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of CLKBUF is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL PAD_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (PAD_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := TO_X01(PAD_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (PAD_ipd'last_event, tpd_PAD_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_CLKBUF_VITAL of CLKBUF is
   for VITAL_ACT
   end for;
end CFG_CLKBUF_VITAL;


----- CELL CLKINT -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CLKINT is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CLKINT : entity is TRUE;
end CLKINT;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of CLKINT is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := TO_X01(A_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (A_ipd'last_event, tpd_A_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_CLKINT_VITAL of CLKINT is
   for VITAL_ACT
   end for;
end CFG_CLKINT_VITAL;


----- CELL CM7 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CM7 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_S11_Y                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_S10_Y                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_S0_Y                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D3_Y                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D2_Y                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D1_Y                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D0_Y                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S10                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S11                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D0                             :	in    STD_ULOGIC;
      D1                             :	in    STD_ULOGIC;
      D2                             :	in    STD_ULOGIC;
      D3                             :	in    STD_ULOGIC;
      S0                             :	in    STD_ULOGIC;
      S10                            :	in    STD_ULOGIC;
      S11                            :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CM7 : entity is TRUE;
end CM7;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL_ACT of CM7 is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL D0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S10_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S11_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D0_ipd, D0, tipd_D0);
   VitalWireDelay (D1_ipd, D1, tipd_D1);
   VitalWireDelay (D2_ipd, D2, tipd_D2);
   VitalWireDelay (D3_ipd, D3, tipd_D3);
   VitalWireDelay (S0_ipd, S0, tipd_S0);
   VitalWireDelay (S10_ipd, S10, tipd_S10);
   VitalWireDelay (S11_ipd, S11, tipd_S11);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D0_ipd, D1_ipd, D2_ipd, D3_ipd, S0_ipd, S10_ipd, S11_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);
   VARIABLE OR_Out, MUX1_Out, MUX2_Out : std_ulogic;

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      --Y_zd :=
      -- (((S11_ipd) OR (S10_ipd)) AND (((S0_ipd) AND (D3_ipd)) OR (((NOT
      --   S0_ipd)) AND (D2_ipd)))) OR (((NOT ((S11_ipd) OR (S10_ipd)))) AND
      --   (((S0_ipd) AND (D1_ipd)) OR (((NOT S0_ipd)) AND (D0_ipd))));
      OR_Out := VitalOR2(S10_ipd, S11_ipd);
      MUX1_Out := VitalMUX2(D1_ipd, D0_ipd, S0_ipd);
      MUX2_Out := VitalMUX2(D3_ipd, D2_ipd, S0_ipd);
      Y_zd := VitalMUX2(MUX2_Out, MUX1_Out, OR_Out);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (S11_ipd'last_event, tpd_S11_Y, TRUE),
                 1 => (S10_ipd'last_event, tpd_S10_Y, TRUE),
                 2 => (S0_ipd'last_event, tpd_S0_Y, TRUE),
                 3 => (D3_ipd'last_event, tpd_D3_Y, TRUE),
                 4 => (D2_ipd'last_event, tpd_D2_Y, TRUE),
                 5 => (D1_ipd'last_event, tpd_D1_Y, TRUE),
                 6 => (D0_ipd'last_event, tpd_D0_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_CM7_VITAL of CM7 is
   for VITAL_ACT
   end for;
end CFG_CM7_VITAL;


----- CELL CM8 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CM8 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_S11_Y                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_S10_Y                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_S01_Y                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_S00_Y                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D3_Y                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D2_Y                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D1_Y                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D0_Y                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_D0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S00                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S01                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S10                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S11                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D0                             :	in    STD_ULOGIC;
      D1                             :	in    STD_ULOGIC;
      D2                             :	in    STD_ULOGIC;
      D3                             :	in    STD_ULOGIC;
      S00                            :	in    STD_ULOGIC;
      S01                            :	in    STD_ULOGIC;
      S10                            :	in    STD_ULOGIC;
      S11                            :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CM8 : entity is TRUE;
end CM8;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL_ACT of CM8 is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL D0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S00_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S01_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S10_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S11_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D0_ipd, D0, tipd_D0);
   VitalWireDelay (D1_ipd, D1, tipd_D1);
   VitalWireDelay (D2_ipd, D2, tipd_D2);
   VitalWireDelay (D3_ipd, D3, tipd_D3);
   VitalWireDelay (S00_ipd, S00, tipd_S00);
   VitalWireDelay (S01_ipd, S01, tipd_S01);
   VitalWireDelay (S10_ipd, S10, tipd_S10);
   VitalWireDelay (S11_ipd, S11, tipd_S11);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D0_ipd, D1_ipd, D2_ipd, D3_ipd, S00_ipd, S01_ipd, S10_ipd, S11_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);
   VARIABLE AND_Out, OR_Out, MUX1_Out, MUX2_Out : std_ulogic;

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      --Y_zd :=
      -- (((S11_ipd) OR (S10_ipd)) AND (((S01_ipd) AND (S00_ipd) AND (D3_ipd))
      --   OR (((NOT ((S01_ipd) AND (S00_ipd)))) AND (D2_ipd)))) OR (((NOT
      --   ((S11_ipd) OR (S10_ipd)))) AND (((S01_ipd) AND (S00_ipd) AND
      --   (D1_ipd)) OR (((NOT ((S01_ipd) AND (S00_ipd)))) AND (D0_ipd))));
      AND_Out := VitalAND2(S00_ipd, S01_ipd);
      OR_Out := VitalOR2(S10_ipd, S11_ipd);
      MUX1_Out := VitalMUX2(D1_ipd, D0_ipd, AND_Out);
      MUX2_Out := VitalMUX2(D3_ipd, D2_ipd, AND_Out);
      Y_zd := VitalMUX2(MUX2_Out, MUX1_Out, OR_Out);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (S11_ipd'last_event, tpd_S11_Y, TRUE),
                 1 => (S10_ipd'last_event, tpd_S10_Y, TRUE),
                 2 => (S01_ipd'last_event, tpd_S01_Y, TRUE),
                 3 => (S00_ipd'last_event, tpd_S00_Y, TRUE),
                 4 => (D3_ipd'last_event, tpd_D3_Y, TRUE),
                 5 => (D2_ipd'last_event, tpd_D2_Y, TRUE),
                 6 => (D1_ipd'last_event, tpd_D1_Y, TRUE),
                 7 => (D0_ipd'last_event, tpd_D0_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_CM8_VITAL of CM8 is
   for VITAL_ACT
   end for;
end CFG_CM8_VITAL;


----- CELL CS1 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CS1 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_S_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CS1 : entity is TRUE;
end CS1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL_ACT of CS1 is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';
   SIGNAL C_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   VitalWireDelay (C_ipd, C, tipd_C);
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (S_ipd, S, tipd_S);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd, S_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);
   VARIABLE AND_Out, OR_Out : std_ulogic;

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      --Y_zd :=
      -- ((((B_ipd) AND (S_ipd)) OR (A_ipd)) AND (D_ipd)) OR ((C_ipd) AND
      --   ((NOT (((B_ipd) AND (S_ipd)) OR (A_ipd)))));
      AND_Out := VitalAND2(B_ipd, S_ipd);
      OR_Out := VitalOR2(A_ipd, AND_Out);
      Y_zd := VitalMUX2(D_ipd, C_ipd, OR_Out);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (S_ipd'last_event, tpd_S_Y, TRUE),
                 1 => (B_ipd'last_event, tpd_B_Y, TRUE),
                 2 => (A_ipd'last_event, tpd_A_Y, TRUE),
                 3 => (D_ipd'last_event, tpd_D_Y, TRUE),
                 4 => (C_ipd'last_event, tpd_C_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_CS1_VITAL of CS1 is
   for VITAL_ACT
   end for;
end CFG_CS1_VITAL;


----- CELL CS2 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CS2 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_S_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_D_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_C_Y                        :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_C                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A                              :	in    STD_ULOGIC;
      B                              :	in    STD_ULOGIC;
      C                              :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CS2 : entity is TRUE;
end CS2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL_ACT of CS2 is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B_ipd	 : STD_ULOGIC := 'X';
   SIGNAL C_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A_ipd, A, tipd_A);
   VitalWireDelay (B_ipd, B, tipd_B);
   VitalWireDelay (C_ipd, C, tipd_C);
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (S_ipd, S, tipd_S);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd, S_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);
   VARIABLE AND_Out, OR_Out : std_ulogic;

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      --Y_zd :=
      -- ((B_ipd) AND ((S_ipd) OR (A_ipd)) AND (D_ipd)) OR ((C_ipd) AND ((NOT
      --   ((B_ipd) AND ((S_ipd) OR (A_ipd))))));
      OR_Out := VitalOR2(A_ipd, S_ipd);
      AND_Out := VitalAND2(B_ipd, OR_Out);
      Y_zd := VitalMUX2(D_ipd, C_ipd, AND_Out);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (S_ipd'last_event, tpd_S_Y, TRUE),
                 1 => (B_ipd'last_event, tpd_B_Y, TRUE),
                 2 => (A_ipd'last_event, tpd_A_Y, TRUE),
                 3 => (D_ipd'last_event, tpd_D_Y, TRUE),
                 4 => (C_ipd'last_event, tpd_C_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_CS2_VITAL of CS2 is
   for VITAL_ACT
   end for;
end CFG_CS2_VITAL;


----- CELL CY2A -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CY2A is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_B1_Y                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B0_Y                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A1_Y                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A0_Y                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_A1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A0                             :	in    STD_ULOGIC;
      A1                             :	in    STD_ULOGIC;
      B0                             :	in    STD_ULOGIC;
      B1                             :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CY2A : entity is TRUE;
end CY2A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of CY2A is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL A1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B1_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A0_ipd, A0, tipd_A0);
   VitalWireDelay (A1_ipd, A1, tipd_A1);
   VitalWireDelay (B0_ipd, B0, tipd_B0);
   VitalWireDelay (B1_ipd, B1, tipd_B1);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A0_ipd, A1_ipd, B0_ipd, B1_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd :=
       ((B0_ipd) AND (A0_ipd) AND (A1_ipd)) OR ((B1_ipd) AND (A1_ipd)) OR
         ((B0_ipd) AND (A0_ipd) AND (B1_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (B1_ipd'last_event, tpd_B1_Y, TRUE),
                 1 => (B0_ipd'last_event, tpd_B0_Y, TRUE),
                 2 => (A1_ipd'last_event, tpd_A1_Y, TRUE),
                 3 => (A0_ipd'last_event, tpd_A0_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_CY2A_VITAL of CY2A is
   for VITAL_ACT
   end for;
end CFG_CY2A_VITAL;


----- CELL CY2B -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CY2B is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_B1_Y                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_B0_Y                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A1_Y                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_A0_Y                       :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tipd_A0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_A1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A0                             :	in    STD_ULOGIC;
      A1                             :	in    STD_ULOGIC;
      B0                             :	in    STD_ULOGIC;
      B1                             :	in    STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CY2B : entity is TRUE;
end CY2B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of CY2B is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL A0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL A1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B1_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A0_ipd, A0, tipd_A0);
   VitalWireDelay (A1_ipd, A1, tipd_A1);
   VitalWireDelay (B0_ipd, B0, tipd_B0);
   VitalWireDelay (B1_ipd, B1, tipd_B1);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A0_ipd, A1_ipd, B0_ipd, B1_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd :=
       ((A1_ipd) AND ((B0_ipd) OR (A0_ipd))) OR ((B1_ipd) AND (A1_ipd)) OR
         ((B1_ipd) AND ((B0_ipd) OR (A0_ipd)));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Y,
       GlitchData => Y_GlitchData,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (B1_ipd'last_event, tpd_B1_Y, TRUE),
                 1 => (B0_ipd'last_event, tpd_B0_Y, TRUE),
                 2 => (A1_ipd'last_event, tpd_A1_Y, TRUE),
                 3 => (A0_ipd'last_event, tpd_A0_Y, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_CY2B_VITAL of CY2B is
   for VITAL_ACT
   end for;
end CFG_CY2B_VITAL;










----- CELL DECETH -----
LIBRARY   IEEE;
USE       IEEE.std_logic_1164.all;
USE       IEEE.VITAL_Timing.all;
USE       IEEE.VITAL_Primitives.all;
	
entity DECETH IS
	GENERIC (
		--
		-- PinToPinDelay Generics Declaration(s)
		tpd_IOPCL_Q          : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input IOPCL to output Q
		tpd_CLK_Q            : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input CLK to output Q
		tpd_PAD_Q            : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input PAD to output Q
		tpd_IOPCL_PAD        : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input IOPCL to output PAD
		tpd_CLK_PAD          : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input CLK to output PAD
		tpd_E_PAD            : VitalDelayType01z := (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns); -- Path delay from input E to output PAD

		--
		-- Interconnect Path Delay Generics Declaration(s)
		tipd_CLK             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port CLK
		tipd_D               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port D
		tipd_E               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port E
		tipd_IDE             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port IDE
		tipd_IOPCL           : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port IOPCL
		tipd_ODE             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port ODE
		tipd_PAD             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port PAD
		--
		-- Setup Generics Declaration(s)
		tsetup_D_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between D and CLK
		tsetup_PAD_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between PAD and CLK
		tsetup_IDE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between IDE and CLK
		tsetup_ODE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between ODE and CLK
		--
		-- Hold Generics Declaration(s)
		thold_D_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between D and CLK
		thold_PAD_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between PAD and CLK
		thold_IDE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between IDE and CLK
		thold_ODE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between ODE and CLK
		thold_IOPCL_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Removal time between IOPCL and CLK
		--
		-- Recovery Generics Declaration(s)
		trecovery_IOPCL_CLK_posedge_posedge : VitalDelayType   := 0.000 ns;	-- Recovery time between IOPCL and CLK
		--
		-- Period Check Generics Declaration(s)
		tperiod_CLK_posedge          : VitalDelayType   := 0.000 ns;	-- Minimum period time for CLK
		tpw_CLK_posedge      : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for CLK
		tpw_CLK_negedge      : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for CLK
		tperiod_IOPCL        : VitalDelayType   := 0.000 ns;	-- Minimum period time for IOPCL
		tpw_IOPCL_posedge    : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for IOPCL
		tpw_IOPCL_negedge    : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for IOPCL
		--
		-- InstancePath Will Accompany Any Assertion Messages in the Model
		InstancePath         : STRING           := "*";
		--
		-- 'X' generation control parameter for timing checks and path delay
		XOn                  : BOOLEAN          := TRUE;
		--
		-- Assertion messages generation control parameter for violation of timing checks
		MsgOn                : BOOLEAN          := TRUE;
		--
		-- VitalTimingCheck Switch
		TimingChecksOn       : BOOLEAN          := TRUE
	);
	PORT (
		CLK                 : IN      STD_ULOGIC := 'X';
		D                   : IN      STD_ULOGIC := 'X';
		E                   : IN      STD_ULOGIC := 'X';
		IDE                 : IN      STD_ULOGIC := 'X';
		IOPCL               : IN      STD_ULOGIC := 'X';
		ODE                 : IN      STD_ULOGIC := 'X';
		PAD                 : INOUT   STD_ULOGIC := 'X';
		Q                   : OUT     STD_ULOGIC := 'X'
		
	);
	--
	attribute Vital_Level0 OF DECETH : ENTITY IS TRUE;
	--
end DECETH;

ARCHITECTURE VITAL_ACT OF DECETH IS
	--
	ATTRIBUTE Vital_Level1 OF VITAL_ACT : ARCHITECTURE IS TRUE;
	--
	--
	--Internal Delay Signals - delayed be the interconnect path delay
	SIGNAL    CLK_ipd                   : STD_ULOGIC := 'U';
	SIGNAL    D_ipd                     : STD_ULOGIC := 'U';
	SIGNAL    E_ipd                     : STD_ULOGIC := 'U';
	SIGNAL    IDE_ipd                   : STD_ULOGIC := 'U';
	SIGNAL    IOPCL_ipd                 : STD_ULOGIC := 'U';
	SIGNAL    ODE_ipd                   : STD_ULOGIC := 'U';
	SIGNAL    PAD_ipd                   : STD_ULOGIC := 'U';
	
	BEGIN
	-----------------------------------------------
	-- Input Path Delay Section
	-----------------------------------------------
	WireDelay : BLOCK
	BEGIN
		VitalWireDelay (
				OutSig             => CLK_ipd,
				InSig              => CLK,
				twire              => tipd_CLK
		);
		VitalWireDelay (
				OutSig             => D_ipd,
				InSig              => D,
				twire              => tipd_D
		);
		VitalWireDelay (
				OutSig             => E_ipd,
				InSig              => E,
				twire              => tipd_E
		);
		VitalWireDelay (
				OutSig             => IDE_ipd,
				InSig              => IDE,
				twire              => tipd_IDE
		);
		VitalWireDelay (
				OutSig             => IOPCL_ipd,
				InSig              => IOPCL,
				twire              => tipd_IOPCL
		);
		VitalWireDelay (
				OutSig             => ODE_ipd,
				InSig              => ODE,
				twire              => tipd_ODE
		);
		VitalWireDelay (
				OutSig             => PAD_ipd,
				InSig              => PAD,
				twire              => tipd_PAD
		);
	
	END BLOCK WireDelay;
	
	-----------------------------------------------
	-- Behavior Section
	-----------------------------------------------
	VITALBehavior : PROCESS (CLK_ipd, D_ipd, E_ipd, IDE_ipd, IOPCL_ipd, ODE_ipd, PAD_ipd	
	                        )
		--
		-- Variable(s) for internal use in VitalPeriodPulseCheck
		VARIABLE  CLK_PeriodData            : VitalPeriodDataType := VitalPeriodDataInit;
		VARIABLE  IOPCL_PeriodData          : VitalPeriodDataType := VitalPeriodDataInit;
		--
		-- Variable(s) for internal use in VitalRecoveryRemovalCheck
		VARIABLE  IOPCL_CLK_TimingDataRR    : VitalTimingDataType := VitalTimingDataInit;
		--
		-- Variable(s) for internal use in VitalSetupHoldCheck
		VARIABLE  D_CLK_TimingDataSH        : VitalTimingDataType := VitalTimingDataInit;
		VARIABLE  PAD_CLK_TimingDataSH      : VitalTimingDataType := VitalTimingDataInit;
		VARIABLE  IDE_CLK_TimingDataSH      : VitalTimingDataType := VitalTimingDataInit;
		VARIABLE  ODE_CLK_TimingDataSH      : VitalTimingDataType := VitalTimingDataInit;
		--
		-- Variable(s) used in VitalPathDelay to Store GlitchData
		VARIABLE  Q_GlitchData              : VitalGlitchDataType;
		VARIABLE  PAD_GlitchData            : VitalGlitchDataType;
		--
		-- Variable(s) generated by VitalTimingCheck violation flags and/or user
		VARIABLE  SHVF_D_CLK                : STD_ULOGIC := '0';
		VARIABLE  SHVF_PAD_CLK              : STD_ULOGIC := '0';
		VARIABLE  SHVF_IDE_CLK              : STD_ULOGIC := '0';
		VARIABLE  SHVF_ODE_CLK              : STD_ULOGIC := '0';
		VARIABLE  PDVF_CLK                  : STD_ULOGIC := '0';
		VARIABLE  PDVF_IOPCL                : STD_ULOGIC := '0';
		VARIABLE  RRVF_IOPCL_CLK            : STD_ULOGIC := '0';
		VARIABLE  Violation                 : STD_ULOGIC := 'X';
		VARIABLE  DFE3CStateReg             : STD_LOGIC_VECTOR(0 DOWNTO 0) := (OTHERS => 'X');
		VARIABLE  IQ                        : STD_LOGIC_VECTOR(0 DOWNTO 0) := (OTHERS => 'X');
		VARIABLE  DECETH_TABStateReg        : STD_LOGIC_VECTOR(0 DOWNTO 0) := (OTHERS => 'X');
		--
		-- Variable(s) used in VitalStateTable to store functional result
		VARIABLE  DFE3C_Result              : STD_LOGIC_VECTOR(2 DOWNTO 1) := (OTHERS => 'X');
		VARIABLE  DECETH_TAB_Result         : STD_LOGIC_VECTOR(2 DOWNTO 1) := (OTHERS => 'X');
		--
		-- Variable(s) used in VitalTruthTable to store functional result
		VARIABLE  DECETH_TTAB_Result        : STD_LOGIC_VECTOR(1 DOWNTO 1) := (OTHERS => 'X');
		--
		-- Variable(s) used in VitalStateTable to keep track of the previous values
		--VARIABLE  PrevData_DFE3C            : STD_LOGIC_VECTOR(0 TO 5);
		--VARIABLE  PrevData_DECETH_TAB       : STD_LOGIC_VECTOR(0 TO 5);
		VARIABLE  PrevData_DFE3C            : STD_LOGIC_VECTOR(0 TO 4);
		VARIABLE  PrevData_DECETH_TAB       : STD_LOGIC_VECTOR(0 TO 4);
		--
		-- Variable(s) used in VitalStateTable and VitalPropagatePathDelay
		VARIABLE  Q_zd                      : STD_ULOGIC;
		VARIABLE  PAD_zd                    : STD_ULOGIC;
		VARIABLE  D_delayed                 : STD_ULOGIC;
		VARIABLE  ODE_delayed               : STD_ULOGIC;
		VARIABLE  IDE_delayed               : STD_ULOGIC;
		VARIABLE  PAD_delayed               : STD_ULOGIC;
		--
		-- State Table : DECETH_TAB Declaration
		CONSTANT  DECETH_TAB : VitalStateTableType (1 to 14, 1 to 8) := (
                --Vio, Clr, Clk,   d,   e, prev, next 
		( '0', '0', '-', '-', '-',  '-',  '0',  '0' ),
		( '0', '1', '/', '0', '0',  '-',  '0',  '0' ),
		( '0', '1', '/', '1', '0',  '-',  '1',  '1' ),
		( '0', '1', '/', '0', '-',  '0',  '0',  '0' ),
		( '0', '1', '-', '0', '-',  '0',  '0',  '0' ),
		( '0', '-', '-', '0', '-',  '0',  '0',  '0' ),
		( '0', '-', '-', '-', '1',  '0',  '0',  '0' ),
		( '0', '1', '/', '1', '-',  '1',  '1',  '1' ),
		( '0', '1', '-', '1', '-',  '1',  '1',  '1' ),
		( '0', '1', '/', '-', '1',  '-',  'S',  'S' ),
		( '0', '1', 'F', '-', '-',  '-',  'S',  'S' ),
		( '0', '1', 'S', '-', '-',  '-',  'S',  'S' ),
		( '0', '1', '-', '-', '1',  '-',  'S',  'S' ),
		( 'X', '-', '-', '-', '-',  '-',  'X',  'X' ) );
	
	BEGIN
		-----------------------------------------------
		-- Timing Check Section
		-----------------------------------------------
		IF (TimingChecksOn) THEN
			-- Perform Setup/Hold Check
			--	TestSignal : D
			--	RefSignal  : CLK
			VitalSetupHoldCheck (
				Violation          => SHVF_D_CLK,
				TimingData         => D_CLK_TimingDataSH,
				TestSignal         => D_ipd,
				TestSignalName     => "D",
				TestDelay          => 0 ns,
				RefSignal          => CLK_ipd,
				RefSignalName      => "CLK",
				RefDelay           => 0 ns,
				SetupHigh          => tsetup_D_CLK_noedge_posedge,
				SetupLow           => tsetup_D_CLK_noedge_posedge,
				HoldHigh           => thold_D_CLK_noedge_posedge,
				HoldLow            => thold_D_CLK_noedge_posedge,
				CheckEnabled       => TO_X01 ( ( NOT IOPCL_ipd ) OR ODE_ipd ) /= '1',
				RefTransition      => '/',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalSetupHoldCheck
			-- Perform Setup/Hold Check
			--	TestSignal : PAD
			--	RefSignal  : CLK
			VitalSetupHoldCheck (
				Violation          => SHVF_PAD_CLK,
				TimingData         => PAD_CLK_TimingDataSH,
				TestSignal         => PAD_ipd,
				TestSignalName     => "PAD",
				TestDelay          => 0 ns,
				RefSignal          => CLK_ipd,
				RefSignalName      => "CLK",
				RefDelay           => 0 ns,
				SetupHigh          => tsetup_PAD_CLK_noedge_posedge,
				SetupLow           => tsetup_PAD_CLK_noedge_posedge,
				HoldHigh           => thold_PAD_CLK_noedge_posedge,
				HoldLow            => thold_PAD_CLK_noedge_posedge,
				CheckEnabled       => TO_X01 ( ( NOT IOPCL_ipd ) OR IDE_ipd ) /= '1',
				RefTransition      => '/',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalSetupHoldCheck
			-- Perform Setup/Hold Check
			--	TestSignal : IDE
			--	RefSignal  : CLK
			VitalSetupHoldCheck (
				Violation          => SHVF_IDE_CLK,
				TimingData         => IDE_CLK_TimingDataSH,
				TestSignal         => IDE_ipd,
				TestSignalName     => "IDE",
				TestDelay          => 0 ns,
				RefSignal          => CLK_ipd,
				RefSignalName      => "CLK",
				RefDelay           => 0 ns,
				SetupHigh          => tsetup_IDE_CLK_noedge_posedge,
				SetupLow           => tsetup_IDE_CLK_noedge_posedge,
				HoldHigh           => thold_IDE_CLK_noedge_posedge,
				HoldLow            => thold_IDE_CLK_noedge_posedge,
				CheckEnabled       => TO_X01 ( ( NOT IOPCL_ipd ) ) /= '1',
				RefTransition      => '/',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalSetupHoldCheck
			-- Perform Setup/Hold Check
			--	TestSignal : ODE
			--	RefSignal  : CLK
			VitalSetupHoldCheck (
				Violation          => SHVF_ODE_CLK,
				TimingData         => ODE_CLK_TimingDataSH,
				TestSignal         => ODE_ipd,
				TestSignalName     => "ODE",
				TestDelay          => 0 ns,
				RefSignal          => CLK_ipd,
				RefSignalName      => "CLK",
				RefDelay           => 0 ns,
				SetupHigh          => tsetup_ODE_CLK_noedge_posedge,
				SetupLow           => tsetup_ODE_CLK_noedge_posedge,
				HoldHigh           => thold_ODE_CLK_noedge_posedge,
				HoldLow            => thold_ODE_CLK_noedge_posedge,
				CheckEnabled       => TO_X01 ( ( NOT IOPCL_ipd ) ) /= '1',
				RefTransition      => '/',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalSetupHoldCheck
			-- Perform Recovery/Removal Check
			--	TestSignal : IOPCL
			--	RefSignal  : CLK
			VitalRecoveryRemovalCheck (
				Violation          => RRVF_IOPCL_CLK,
				TimingData         => IOPCL_CLK_TimingDataRR,
				TestSignal         => IOPCL_ipd,
				TestSignalName     => "IOPCL",
				TestDelay          => 0 ns,
				RefSignal          => CLK_ipd,
				RefSignalName      => "CLK",
				RefDelay           => 0 ns,
				Recovery           => trecovery_IOPCL_CLK_posedge_posedge,
				Removal            => thold_IOPCL_CLK_noedge_posedge,
				ActiveLow          => TRUE,
				CheckEnabled       => TRUE,
				RefTransition      => '/',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalRecoveryRemovalCheck
			-- Perform Minimum and Maximum Periodicity and Pulse Check
			--TestSignal : CLK
			VitalPeriodPulseCheck (
				Violation          => PDVF_CLK,
				PeriodData         => CLK_PeriodData,
				TestSignal         => CLK_ipd,
				TestSignalName     => "CLK",
				TestDelay          => 0 ns,
				Period             => tperiod_CLK_posedge,
				PulseWidthHigh     => tpw_CLK_posedge,
				PulseWidthLow      => tpw_CLK_negedge,
				CheckEnabled       => TO_X01 ( ( NOT IOPCL_ipd ) ) /= '1',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalPeriodPulseCheck
			-- Perform Minimum and Maximum Periodicity and Pulse Check
			--TestSignal : IOPCL
			VitalPeriodPulseCheck (
				Violation          => PDVF_IOPCL,
				PeriodData         => IOPCL_PeriodData,
				TestSignal         => IOPCL_ipd,
				TestSignalName     => "IOPCL",
				TestDelay          => 0 ns,
				Period             => tperiod_IOPCL,
				PulseWidthHigh     => tpw_IOPCL_posedge,
				PulseWidthLow      => tpw_IOPCL_negedge,
				CheckEnabled       => TRUE,
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalPeriodPulseCheck
		
		END IF;	--Timing Check Section
		
		-----------------------------------------------
		-- Functionality Section
		-----------------------------------------------
		

		Violation                 := PDVF_CLK or PDVF_IOPCL or RRVF_IOPCL_CLK or 
				SHVF_D_CLK or SHVF_IDE_CLK or SHVF_ODE_CLK or 
				SHVF_PAD_CLK ;
		--
		--Implement Functionality for State Table : DECETH_TAB
		VitalStateTable (
				StateTable         => DECETH_TAB,
				--DataIn             => (Violation & IOPCL_ipd & CLK_ipd & D_ipd & ODE_ipd),
				--DataIn             => (Violation, IOPCL_ipd, CLK_ipd, D_ipd, ODE_ipd),
				DataIn             => (Violation, IOPCL_ipd, CLK_ipd, D_delayed, ODE_delayed),
				NumStates          => 1,
				Result             => DFE3C_Result,
				PreviousDataIn     => PrevData_DFE3C
		);	--End VitalStateTable
		DFE3CStateReg(0)          := DFE3C_Result(2);
		IQ(0)                     := DFE3C_Result(1);
		--
		--Implement Functionality for State Table : DECETH_TAB
		VitalStateTable (
				StateTable         => DECETH_TAB,
				--DataIn             => (Violation & IOPCL_ipd & CLK_ipd & PAD_ipd & IDE_ipd),
				--DataIn             => (Violation, IOPCL_ipd, CLK_ipd, PAD_ipd, IDE_ipd),
				DataIn             => (Violation, IOPCL_ipd, CLK_ipd, PAD_delayed, IDE_delayed),
				NumStates          => 1,
				Result             => DECETH_TAB_Result,
				PreviousDataIn     => PrevData_DECETH_TAB
		);	--End VitalStateTable
		DECETH_TABStateReg(0)     := DECETH_TAB_Result(2);
		Q_zd                      := DECETH_TAB_Result(1);
		--
		PAD_zd := VitalBUFIF0 (data => IQ(0), enable => (NOT E_ipd));
		D_delayed := D_ipd;
		ODE_delayed := ODE_ipd;
		IDE_delayed := IDE_ipd;
		PAD_delayed := PAD_ipd;


		
		
		-----------------------------------------------
		-- Path Delay Section
		-----------------------------------------------
		VitalPathDelay01 (
				OutSignal          => Q,
				OutSignalName      => "Q",
				OutTemp            => Q_zd,
				DefaultDelay       => VitalZeroDelay01,
				MsgSeverity        => WARNING,
				Paths              => (
				                 0 => (
							InputChangeTime => IOPCL_ipd'LAST_EVENT,
							PathDelay       => tpd_IOPCL_Q,
							PathCondition   => TRUE
				                      ),
				                 1 => (
							InputChangeTime => CLK_ipd'LAST_EVENT,
							PathDelay       => tpd_CLK_Q,
							PathCondition   => TRUE
				                      ),
				                 2 => (
							InputChangeTime => PAD_ipd'LAST_EVENT,
							PathDelay       => tpd_PAD_Q,
							PathCondition   => TRUE
				                      )
				                      ),
				GlitchData         => Q_GlitchData,
				Mode               => OnDetect,
				XOn                => XOn,
				MsgOn              => MsgOn
		);	--End VitalPathDelay
		VitalPathDelay01Z (
				OutSignal          => PAD,
				OutSignalName      => "PAD",
				OutTemp            => PAD_zd,
				DefaultDelay       => VitalZeroDelay01Z,
				MsgSeverity        => WARNING,
				Paths              => (
				                 0 => (
							InputChangeTime => IOPCL_ipd'LAST_EVENT,
							PathDelay       => VitalExtendToFillDelay(tpd_IOPCL_PAD),
							PathCondition   => TRUE
				                      ),
				                 1 => (
							InputChangeTime => CLK_ipd'LAST_EVENT,
							PathDelay       => VitalExtendToFillDelay(tpd_CLK_PAD),
							PathCondition   => TRUE
				                      ),
				                 2 => (
							InputChangeTime => E_ipd'LAST_EVENT,
							PathDelay       => tpd_E_PAD,
							PathCondition   => TRUE
				                      )
				                      ),
				GlitchData         => PAD_GlitchData,
				Mode               => OnDetect,
				XOn                => XOn,
				MsgOn              => MsgOn,
				OutputMap          => "UX01ZWLH-"
		);	--End VitalPathDelay
		
	END PROCESS VITALBehavior;

END VITAL_ACT;

configuration CFG_DECETH_VITAL of DECETH is
   for VITAL_ACT
   end for;
end CFG_DECETH_VITAL;
----- CELL DECETL -----
LIBRARY   IEEE;
USE       IEEE.std_logic_1164.all;
USE       IEEE.VITAL_Timing.all;
USE       IEEE.VITAL_Primitives.all;
	
entity DECETL IS
	GENERIC (
		--
		-- PinToPinDelay Generics Declaration(s)
		tpd_IOPCL_Q          : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input IOPCL to output Q
		tpd_CLK_Q            : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input CLK to output Q
		tpd_PAD_Q            : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input PAD to output Q
		tpd_IOPCL_PAD        : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input IOPCL to output PAD
		tpd_CLK_PAD          : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input CLK to output PAD
		tpd_E_PAD            : VitalDelayType01z := (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns); -- Path delay from input E to output PAD

		--
		-- Interconnect Path Delay Generics Declaration(s)
		tipd_CLK             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port CLK
		tipd_D               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port D
		tipd_E               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port E
		tipd_IDE             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port IDE
		tipd_IOPCL           : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port IOPCL
		tipd_ODE             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port ODE
		tipd_PAD             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port PAD
		--
		-- Setup Generics Declaration(s)
		tsetup_D_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between D and CLK
		tsetup_PAD_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between PAD and CLK
		tsetup_IDE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between IDE and CLK
		tsetup_ODE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between ODE and CLK
		--
		-- Hold Generics Declaration(s)
		thold_D_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between D and CLK
		thold_PAD_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between PAD and CLK
		thold_IDE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between IDE and CLK
		thold_ODE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between ODE and CLK
		thold_IOPCL_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Removal time between IOPCL and CLK
		--
		-- Recovery Generics Declaration(s)
		trecovery_IOPCL_CLK_posedge_posedge : VitalDelayType   := 0.000 ns;	-- Recovery time between IOPCL and CLK
		--
		-- Period Check Generics Declaration(s)
		tperiod_CLK_posedge          : VitalDelayType   := 0.000 ns;	-- Minimum period time for CLK
		tpw_CLK_posedge      : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for CLK
		tpw_CLK_negedge      : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for CLK
		tperiod_IOPCL        : VitalDelayType   := 0.000 ns;	-- Minimum period time for IOPCL
		tpw_IOPCL_posedge    : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for IOPCL
		tpw_IOPCL_negedge    : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for IOPCL
		--
		-- InstancePath Will Accompany Any Assertion Messages in the Model
		InstancePath         : STRING           := "*";
		--
		-- 'X' generation control parameter for timing checks and path delay
		XOn                  : BOOLEAN          := TRUE;
		--
		-- Assertion messages generation control parameter for violation of timing checks
		MsgOn                : BOOLEAN          := TRUE;
		--
		-- VitalTimingCheck Switch
		TimingChecksOn       : BOOLEAN          := TRUE
	);
	PORT (
		CLK                 : IN      STD_ULOGIC := 'X';
		D                   : IN      STD_ULOGIC := 'X';
		E                   : IN      STD_ULOGIC := 'X';
		IDE                 : IN      STD_ULOGIC := 'X';
		IOPCL               : IN      STD_ULOGIC := 'X';
		ODE                 : IN      STD_ULOGIC := 'X';
		PAD                 : INOUT   STD_ULOGIC := 'X';
		Q                   : OUT     STD_ULOGIC := 'X'
		
	);
	--
	attribute Vital_Level0 OF DECETL : ENTITY IS TRUE;
	--
end DECETL;

ARCHITECTURE VITAL_ACT OF DECETL IS
	--
	ATTRIBUTE Vital_Level1 OF VITAL_ACT : ARCHITECTURE IS TRUE;
	--
	--
	--Internal Delay Signals - delayed be the interconnect path delay
	SIGNAL    CLK_ipd                   : STD_ULOGIC := 'U';
	SIGNAL    D_ipd                     : STD_ULOGIC := 'U';
	SIGNAL    E_ipd                     : STD_ULOGIC := 'U';
	SIGNAL    IDE_ipd                   : STD_ULOGIC := 'U';
	SIGNAL    IOPCL_ipd                 : STD_ULOGIC := 'U';
	SIGNAL    ODE_ipd                   : STD_ULOGIC := 'U';
	SIGNAL    PAD_ipd                   : STD_ULOGIC := 'U';
	
	BEGIN
	-----------------------------------------------
	-- Input Path Delay Section
	-----------------------------------------------
	WireDelay : BLOCK
	BEGIN
		VitalWireDelay (
				OutSig             => CLK_ipd,
				InSig              => CLK,
				twire              => tipd_CLK
		);
		VitalWireDelay (
				OutSig             => D_ipd,
				InSig              => D,
				twire              => tipd_D
		);
		VitalWireDelay (
				OutSig             => E_ipd,
				InSig              => E,
				twire              => tipd_E
		);
		VitalWireDelay (
				OutSig             => IDE_ipd,
				InSig              => IDE,
				twire              => tipd_IDE
		);
		VitalWireDelay (
				OutSig             => IOPCL_ipd,
				InSig              => IOPCL,
				twire              => tipd_IOPCL
		);
		VitalWireDelay (
				OutSig             => ODE_ipd,
				InSig              => ODE,
				twire              => tipd_ODE
		);
		VitalWireDelay (
				OutSig             => PAD_ipd,
				InSig              => PAD,
				twire              => tipd_PAD
		);
	
	END BLOCK WireDelay;
	
	-----------------------------------------------
	-- Behavior Section
	-----------------------------------------------
	VITALBehavior : PROCESS (CLK_ipd, D_ipd, E_ipd, IDE_ipd, IOPCL_ipd, ODE_ipd, PAD_ipd	
	                        )
		--
		-- Variable(s) for internal use in VitalPeriodPulseCheck
		VARIABLE  CLK_PeriodData            : VitalPeriodDataType := VitalPeriodDataInit;
		VARIABLE  IOPCL_PeriodData          : VitalPeriodDataType := VitalPeriodDataInit;
		--
		-- Variable(s) for internal use in VitalRecoveryRemovalCheck
		VARIABLE  IOPCL_CLK_TimingDataRR    : VitalTimingDataType := VitalTimingDataInit;
		--
		-- Variable(s) for internal use in VitalSetupHoldCheck
		VARIABLE  D_CLK_TimingDataSH        : VitalTimingDataType := VitalTimingDataInit;
		VARIABLE  PAD_CLK_TimingDataSH      : VitalTimingDataType := VitalTimingDataInit;
		VARIABLE  IDE_CLK_TimingDataSH      : VitalTimingDataType := VitalTimingDataInit;
		VARIABLE  ODE_CLK_TimingDataSH      : VitalTimingDataType := VitalTimingDataInit;
		--
		-- Variable(s) used in VitalPathDelay to Store GlitchData
		VARIABLE  Q_GlitchData              : VitalGlitchDataType;
		VARIABLE  PAD_GlitchData            : VitalGlitchDataType;
		--
		-- Variable(s) generated by VitalTimingCheck violation flags and/or user
		VARIABLE  SHVF_D_CLK                : STD_ULOGIC := '0';
		VARIABLE  SHVF_PAD_CLK              : STD_ULOGIC := '0';
		VARIABLE  SHVF_IDE_CLK              : STD_ULOGIC := '0';
		VARIABLE  SHVF_ODE_CLK              : STD_ULOGIC := '0';
		VARIABLE  PDVF_CLK                  : STD_ULOGIC := '0';
		VARIABLE  PDVF_IOPCL                : STD_ULOGIC := '0';
		VARIABLE  RRVF_IOPCL_CLK            : STD_ULOGIC := '0';
		VARIABLE  Violation                 : STD_ULOGIC := 'X';
		VARIABLE  DFE3CStateReg             : STD_LOGIC_VECTOR(0 DOWNTO 0) := (OTHERS => 'X');
		VARIABLE  IQ                        : STD_LOGIC_VECTOR(0 DOWNTO 0) := (OTHERS => 'X');
		VARIABLE  DECETL_TABStateReg        : STD_LOGIC_VECTOR(0 DOWNTO 0) := (OTHERS => 'X');
		--
		-- Variable(s) used in VitalStateTable to store functional result
		VARIABLE  DFE3C_Result              : STD_LOGIC_VECTOR(2 DOWNTO 1) := (OTHERS => 'X');
		VARIABLE  DECETL_TAB_Result         : STD_LOGIC_VECTOR(2 DOWNTO 1) := (OTHERS => 'X');
		--
		-- Variable(s) used in VitalTruthTable to store functional result
		VARIABLE  DECETL_TTAB_Result        : STD_LOGIC_VECTOR(1 DOWNTO 1) := (OTHERS => 'X');
		--
		-- Variable(s) used in VitalStateTable to keep track of the previous values
		--VARIABLE  PrevData_DFE3C            : STD_LOGIC_VECTOR(0 TO 5);
		--VARIABLE  PrevData_DECETL_TAB       : STD_LOGIC_VECTOR(0 TO 5);
		VARIABLE  PrevData_DFE3C            : STD_LOGIC_VECTOR(0 TO 4);
		VARIABLE  PrevData_DECETL_TAB       : STD_LOGIC_VECTOR(0 TO 4);
		--
		-- Variable(s) used in VitalStateTable and VitalPropagatePathDelay
		VARIABLE  Q_zd                      : STD_ULOGIC;
		VARIABLE  PAD_zd                    : STD_ULOGIC;
		VARIABLE  D_delayed                 : STD_ULOGIC;
		VARIABLE  ODE_delayed               : STD_ULOGIC;
		VARIABLE  IDE_delayed               : STD_ULOGIC;
		VARIABLE  PAD_delayed               : STD_ULOGIC;
		--
		-- State Table : DECETL_TAB Declaration
		CONSTANT  DECETL_TAB : VitalStateTableType (1 to 14, 1 to 8) := (
		( '0', '0', '-', '-', '-',  '-',  '0',  '0' ),
		( '0', '1', '/', '0', '0',  '-',  '0',  '0' ),
		( '0', '1', '/', '1', '0',  '-',  '1',  '1' ),
		( '0', '1', '/', '0', '-',  '0',  '0',  '0' ),
		( '0', '1', '-', '0', '-',  '0',  '0',  '0' ),
		( '0', '-', '-', '0', '-',  '0',  '0',  '0' ),
		( '0', '-', '-', '-', '1',  '0',  '0',  '0' ),
		( '0', '1', '/', '1', '-',  '1',  '1',  '1' ),
		( '0', '1', '-', '1', '-',  '1',  '1',  '1' ),
		( '0', '1', '/', '-', '1',  '-',  'S',  'S' ),
		( '0', '1', 'F', '-', '-',  '-',  'S',  'S' ),
		( '0', '1', 'S', '-', '-',  '-',  'S',  'S' ),
		( '0', '1', '-', '-', '1',  '-',  'S',  'S' ),
		( 'X', '-', '-', '-', '-',  '-',  'X',  'X' ) );
	
	BEGIN
		-----------------------------------------------
		-- Timing Check Section
		-----------------------------------------------
		IF (TimingChecksOn) THEN
			-- Perform Setup/Hold Check
			--	TestSignal : D
			--	RefSignal  : CLK
			VitalSetupHoldCheck (
				Violation          => SHVF_D_CLK,
				TimingData         => D_CLK_TimingDataSH,
				TestSignal         => D_ipd,
				TestSignalName     => "D",
				TestDelay          => 0 ns,
				RefSignal          => CLK_ipd,
				RefSignalName      => "CLK",
				RefDelay           => 0 ns,
				SetupHigh          => tsetup_D_CLK_noedge_posedge,
				SetupLow           => tsetup_D_CLK_noedge_posedge,
				HoldHigh           => thold_D_CLK_noedge_posedge,
				HoldLow            => thold_D_CLK_noedge_posedge,
				CheckEnabled       => TO_X01 ( ( NOT IOPCL_ipd ) OR ODE_ipd ) /= '1',
				RefTransition      => '/',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalSetupHoldCheck
			-- Perform Setup/Hold Check
			--	TestSignal : PAD
			--	RefSignal  : CLK
			VitalSetupHoldCheck (
				Violation          => SHVF_PAD_CLK,
				TimingData         => PAD_CLK_TimingDataSH,
				TestSignal         => PAD_ipd,
				TestSignalName     => "PAD",
				TestDelay          => 0 ns,
				RefSignal          => CLK_ipd,
				RefSignalName      => "CLK",
				RefDelay           => 0 ns,
				SetupHigh          => tsetup_PAD_CLK_noedge_posedge,
				SetupLow           => tsetup_PAD_CLK_noedge_posedge,
				HoldHigh           => thold_PAD_CLK_noedge_posedge,
				HoldLow            => thold_PAD_CLK_noedge_posedge,
				CheckEnabled       => TO_X01 ( ( NOT IOPCL_ipd ) OR IDE_ipd ) /= '1',
				RefTransition      => '/',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalSetupHoldCheck
			-- Perform Setup/Hold Check
			--	TestSignal : IDE
			--	RefSignal  : CLK
			VitalSetupHoldCheck (
				Violation          => SHVF_IDE_CLK,
				TimingData         => IDE_CLK_TimingDataSH,
				TestSignal         => IDE_ipd,
				TestSignalName     => "IDE",
				TestDelay          => 0 ns,
				RefSignal          => CLK_ipd,
				RefSignalName      => "CLK",
				RefDelay           => 0 ns,
				SetupHigh          => tsetup_IDE_CLK_noedge_posedge,
				SetupLow           => tsetup_IDE_CLK_noedge_posedge,
				HoldHigh           => thold_IDE_CLK_noedge_posedge,
				HoldLow            => thold_IDE_CLK_noedge_posedge,
				CheckEnabled       => TO_X01 ( ( NOT IOPCL_ipd ) ) /= '1',
				RefTransition      => '/',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalSetupHoldCheck
			-- Perform Setup/Hold Check
			--	TestSignal : ODE
			--	RefSignal  : CLK
			VitalSetupHoldCheck (
				Violation          => SHVF_ODE_CLK,
				TimingData         => ODE_CLK_TimingDataSH,
				TestSignal         => ODE_ipd,
				TestSignalName     => "ODE",
				TestDelay          => 0 ns,
				RefSignal          => CLK_ipd,
				RefSignalName      => "CLK",
				RefDelay           => 0 ns,
				SetupHigh          => tsetup_ODE_CLK_noedge_posedge,
				SetupLow           => tsetup_ODE_CLK_noedge_posedge,
				HoldHigh           => thold_ODE_CLK_noedge_posedge,
				HoldLow            => thold_ODE_CLK_noedge_posedge,
				CheckEnabled       => TO_X01 ( ( NOT IOPCL_ipd ) ) /= '1',
				RefTransition      => '/',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalSetupHoldCheck
			-- Perform Recovery/Removal Check
			--	TestSignal : IOPCL
			--	RefSignal  : CLK
			VitalRecoveryRemovalCheck (
				Violation          => RRVF_IOPCL_CLK,
				TimingData         => IOPCL_CLK_TimingDataRR,
				TestSignal         => IOPCL_ipd,
				TestSignalName     => "IOPCL",
				TestDelay          => 0 ns,
				RefSignal          => CLK_ipd,
				RefSignalName      => "CLK",
				RefDelay           => 0 ns,
				Recovery           => trecovery_IOPCL_CLK_posedge_posedge,
				Removal            => thold_IOPCL_CLK_noedge_posedge,
				ActiveLow          => TRUE,
				CheckEnabled       => TRUE,
				RefTransition      => '/',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalRecoveryRemovalCheck
			-- Perform Minimum and Maximum Periodicity and Pulse Check
			--TestSignal : CLK
			VitalPeriodPulseCheck (
				Violation          => PDVF_CLK,
				PeriodData         => CLK_PeriodData,
				TestSignal         => CLK_ipd,
				TestSignalName     => "CLK",
				TestDelay          => 0 ns,
				Period             => tperiod_CLK_posedge,
				PulseWidthHigh     => tpw_CLK_posedge,
				PulseWidthLow      => tpw_CLK_negedge,
				CheckEnabled       => TO_X01 ( ( NOT IOPCL_ipd ) ) /= '1',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalPeriodPulseCheck
			-- Perform Minimum and Maximum Periodicity and Pulse Check
			--TestSignal : IOPCL
			VitalPeriodPulseCheck (
				Violation          => PDVF_IOPCL,
				PeriodData         => IOPCL_PeriodData,
				TestSignal         => IOPCL_ipd,
				TestSignalName     => "IOPCL",
				TestDelay          => 0 ns,
				Period             => tperiod_IOPCL,
				PulseWidthHigh     => tpw_IOPCL_posedge,
				PulseWidthLow      => tpw_IOPCL_negedge,
				CheckEnabled       => TRUE,
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalPeriodPulseCheck
		
		END IF;	--Timing Check Section
		
		-----------------------------------------------
		-- Functionality Section
		-----------------------------------------------
		

		Violation                 := PDVF_CLK or PDVF_IOPCL or RRVF_IOPCL_CLK or 
				SHVF_D_CLK or SHVF_IDE_CLK or SHVF_ODE_CLK or 
				SHVF_PAD_CLK ;
		--
		--Implement Functionality for State Table : DECETL_TAB
		VitalStateTable (
				StateTable         => DECETL_TAB,
				--DataIn             => (Violation & IOPCL_ipd & CLK_ipd & D_ipd & ODE_ipd),
				--DataIn             => (Violation, IOPCL_ipd, CLK_ipd, D_ipd, ODE_ipd),
				DataIn             => (Violation, IOPCL_ipd, CLK_ipd, D_delayed, ODE_delayed),
				NumStates          => 1,
				Result             => DFE3C_Result,
				PreviousDataIn     => PrevData_DFE3C
		);	--End VitalStateTable
		DFE3CStateReg(0)          := DFE3C_Result(2);
		IQ(0)                     := DFE3C_Result(1);
		--
		--Implement Functionality for State Table : DECETL_TAB
		VitalStateTable (
				StateTable         => DECETL_TAB,
				--DataIn             => (Violation & IOPCL_ipd & CLK_ipd & PAD_ipd & IDE_ipd),
				--DataIn             => (Violation, IOPCL_ipd, CLK_ipd, PAD_ipd, IDE_ipd),
				DataIn             => (Violation, IOPCL_ipd, CLK_ipd, PAD_delayed, IDE_delayed),
				NumStates          => 1,
				Result             => DECETL_TAB_Result,
				PreviousDataIn     => PrevData_DECETL_TAB
		);	--End VitalStateTable
		DECETL_TABStateReg(0)     := DECETL_TAB_Result(2);
		Q_zd                      := DECETL_TAB_Result(1);
		--
		PAD_zd := VitalBUFIF0 (data => IQ(0), enable => (NOT E_ipd));
		D_delayed := D_ipd;
		ODE_delayed := ODE_ipd;
		IDE_delayed := IDE_ipd;
		PAD_delayed := PAD_ipd;

		
		
		-----------------------------------------------
		-- Path Delay Section
		-----------------------------------------------
		VitalPathDelay01 (
				OutSignal          => Q,
				OutSignalName      => "Q",
				OutTemp            => Q_zd,
				DefaultDelay       => VitalZeroDelay01,
				MsgSeverity        => WARNING,
				Paths              => (
				                 0 => (
							InputChangeTime => IOPCL_ipd'LAST_EVENT,
							PathDelay       => tpd_IOPCL_Q,
							PathCondition   => TRUE
				                      ),
				                 1 => (
							InputChangeTime => CLK_ipd'LAST_EVENT,
							PathDelay       => tpd_CLK_Q,
							PathCondition   => TRUE
				                      ),
				                 2 => (
							InputChangeTime => PAD_ipd'LAST_EVENT,
							PathDelay       => tpd_PAD_Q,
							PathCondition   => TRUE
				                      )
				                      ),
				GlitchData         => Q_GlitchData,
				Mode               => OnDetect,
				XOn                => XOn,
				MsgOn              => MsgOn
		);	--End VitalPathDelay
		VitalPathDelay01Z (
				OutSignal          => PAD,
				OutSignalName      => "PAD",
				OutTemp            => PAD_zd,
				DefaultDelay       => VitalZeroDelay01Z,
				MsgSeverity        => WARNING,
				Paths              => (
				                 0 => (
							InputChangeTime => IOPCL_ipd'LAST_EVENT,
							PathDelay       => VitalExtendToFillDelay(tpd_IOPCL_PAD),
							PathCondition   => TRUE
				                      ),
				                 1 => (
							InputChangeTime => CLK_ipd'LAST_EVENT,
							PathDelay       => VitalExtendToFillDelay(tpd_CLK_PAD),
							PathCondition   => TRUE
				                      ),
				                 2 => (
							InputChangeTime => E_ipd'LAST_EVENT,
							PathDelay       => tpd_E_PAD,
							PathCondition   => TRUE
				                      )
				                      ),
				GlitchData         => PAD_GlitchData,
				Mode               => OnDetect,
				XOn                => XOn,
				MsgOn              => MsgOn,
				OutputMap          => "UX01ZWLH-"
		);	--End VitalPathDelay
		
	END PROCESS VITALBehavior;

END VITAL_ACT;

configuration CFG_DECETL_VITAL of DECETL is
   for VITAL_ACT
   end for;
end CFG_DECETL_VITAL;
----- CELL DEPETH -----
LIBRARY   IEEE;
USE       IEEE.std_logic_1164.all;
USE       IEEE.VITAL_Timing.all;
USE       IEEE.VITAL_Primitives.all;
	
entity DEPETH IS
	GENERIC (
		--
		-- PinToPinDelay Generics Declaration(s)
		tpd_IOPCL_Q          : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input IOPCL to output Q
		tpd_CLK_Q            : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input CLK to output Q
		tpd_PAD_Q            : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input PAD to output Q
		tpd_IOPCL_PAD        : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input IOPCL to output PAD
		tpd_CLK_PAD          : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input CLK to output PAD
		tpd_E_PAD            : VitalDelayType01z := (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns); -- Path delay from input E to output PAD

		--
		-- Interconnect Path Delay Generics Declaration(s)
		tipd_CLK             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port CLK
		tipd_D               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port D
		tipd_E               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port E
		tipd_IDE             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port IDE
		tipd_IOPCL           : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port IOPCL
		tipd_ODE             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port ODE
		tipd_PAD             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port PAD
		--
		-- Setup Generics Declaration(s)
		tsetup_D_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between D and CLK
		tsetup_PAD_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between PAD and CLK
		tsetup_IDE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between IDE and CLK
		tsetup_ODE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between ODE and CLK
		--
		-- Hold Generics Declaration(s)
		thold_D_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between D and CLK
		thold_PAD_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between PAD and CLK
		thold_IDE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between IDE and CLK
		thold_ODE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between ODE and CLK
		thold_IOPCL_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between IOPCL and CLK
		--
		-- Recovery Generics Declaration(s)
		trecovery_IOPCL_CLK_posedge_posedge : VitalDelayType   := 0.000 ns;	-- Recovery time between IOPCL and CLK
		--
		-- Period Check Generics Declaration(s)
		tperiod_CLK_posedge          : VitalDelayType   := 0.000 ns;	-- Minimum period time for CLK
		tpw_CLK_posedge      : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for CLK
		tpw_CLK_negedge      : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for CLK
		tperiod_IOPCL        : VitalDelayType   := 0.000 ns;	-- Minimum period time for IOPCL
		tpw_IOPCL_posedge    : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for IOPCL
		tpw_IOPCL_negedge    : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for IOPCL
		--
		-- InstancePath Will Accompany Any Assertion Messages in the Model
		InstancePath         : STRING           := "*";
		--
		-- 'X' generation control parameter for timing checks and path delay
		XOn                  : BOOLEAN          := TRUE;
		--
		-- Assertion messages generation control parameter for violation of timing checks
		MsgOn                : BOOLEAN          := TRUE;
		--
		-- VitalTimingCheck Switch
		TimingChecksOn       : BOOLEAN          := TRUE
	);
	PORT (
		CLK                 : IN      STD_ULOGIC := 'X';
		D                   : IN      STD_ULOGIC := 'X';
		E                   : IN      STD_ULOGIC := 'X';
		IDE                 : IN      STD_ULOGIC := 'X';
		IOPCL               : IN      STD_ULOGIC := 'X';
		ODE                 : IN      STD_ULOGIC := 'X';
		PAD                 : INOUT   STD_ULOGIC := 'X';
		Q                   : OUT     STD_ULOGIC := 'X'
		
	);
	--
	attribute Vital_Level0 OF DEPETH : ENTITY IS TRUE;
	--
end DEPETH;

ARCHITECTURE VITAL_ACT OF DEPETH IS
	--
	ATTRIBUTE Vital_Level1 OF VITAL_ACT : ARCHITECTURE IS TRUE;
	--
	--
	--Internal Delay Signals - delayed be the interconnect path delay
	SIGNAL    CLK_ipd                   : STD_ULOGIC := 'U';
	SIGNAL    D_ipd                     : STD_ULOGIC := 'U';
	SIGNAL    E_ipd                     : STD_ULOGIC := 'U';
	SIGNAL    IDE_ipd                   : STD_ULOGIC := 'U';
	SIGNAL    IOPCL_ipd                 : STD_ULOGIC := 'U';
	SIGNAL    ODE_ipd                   : STD_ULOGIC := 'U';
	SIGNAL    PAD_ipd                   : STD_ULOGIC := 'U';
	
	BEGIN
	-----------------------------------------------
	-- Input Path Delay Section
	-----------------------------------------------
	WireDelay : BLOCK
	BEGIN
		VitalWireDelay (
				OutSig             => CLK_ipd,
				InSig              => CLK,
				twire              => tipd_CLK
		);
		VitalWireDelay (
				OutSig             => D_ipd,
				InSig              => D,
				twire              => tipd_D
		);
		VitalWireDelay (
				OutSig             => E_ipd,
				InSig              => E,
				twire              => tipd_E
		);
		VitalWireDelay (
				OutSig             => IDE_ipd,
				InSig              => IDE,
				twire              => tipd_IDE
		);
		VitalWireDelay (
				OutSig             => IOPCL_ipd,
				InSig              => IOPCL,
				twire              => tipd_IOPCL
		);
		VitalWireDelay (
				OutSig             => ODE_ipd,
				InSig              => ODE,
				twire              => tipd_ODE
		);
		VitalWireDelay (
				OutSig             => PAD_ipd,
				InSig              => PAD,
				twire              => tipd_PAD
		);
	
	END BLOCK WireDelay;
	
	-----------------------------------------------
	-- Behavior Section
	-----------------------------------------------
	VITALBehavior : PROCESS (CLK_ipd, D_ipd, E_ipd, IDE_ipd, IOPCL_ipd, ODE_ipd, PAD_ipd	
	                        )
		--
		-- Variable(s) for internal use in VitalPeriodPulseCheck
		VARIABLE  CLK_PeriodData            : VitalPeriodDataType := VitalPeriodDataInit;
		VARIABLE  IOPCL_PeriodData          : VitalPeriodDataType := VitalPeriodDataInit;
		--
		-- Variable(s) for internal use in VitalRecoveryRemovalCheck
		VARIABLE  IOPCL_CLK_TimingDataRR    : VitalTimingDataType := VitalTimingDataInit;
		--
		-- Variable(s) for internal use in VitalSetupHoldCheck
		VARIABLE  D_CLK_TimingDataSH        : VitalTimingDataType := VitalTimingDataInit;
		VARIABLE  PAD_CLK_TimingDataSH      : VitalTimingDataType := VitalTimingDataInit;
		VARIABLE  IDE_CLK_TimingDataSH      : VitalTimingDataType := VitalTimingDataInit;
		VARIABLE  ODE_CLK_TimingDataSH      : VitalTimingDataType := VitalTimingDataInit;
		--
		-- Variable(s) used in VitalPathDelay to Store GlitchData
		VARIABLE  Q_GlitchData              : VitalGlitchDataType;
		VARIABLE  PAD_GlitchData            : VitalGlitchDataType;
		--
		-- Variable(s) generated by VitalTimingCheck violation flags and/or user
		VARIABLE  SHVF_D_CLK                : STD_ULOGIC := '0';
		VARIABLE  SHVF_PAD_CLK              : STD_ULOGIC := '0';
		VARIABLE  SHVF_IDE_CLK              : STD_ULOGIC := '0';
		VARIABLE  SHVF_ODE_CLK              : STD_ULOGIC := '0';
		VARIABLE  PDVF_CLK                  : STD_ULOGIC := '0';
		VARIABLE  PDVF_IOPCL                : STD_ULOGIC := '0';
		VARIABLE  RRVF_IOPCL_CLK            : STD_ULOGIC := '0';
		VARIABLE  Violation                 : STD_ULOGIC := 'X';
		VARIABLE  DFE3CStateReg             : STD_LOGIC_VECTOR(0 DOWNTO 0) := (OTHERS => 'X');
		VARIABLE  IQ                        : STD_LOGIC_VECTOR(0 DOWNTO 0) := (OTHERS => 'X');
		VARIABLE  DEPETH_TABStateReg        : STD_LOGIC_VECTOR(0 DOWNTO 0) := (OTHERS => 'X');
		--
		-- Variable(s) used in VitalStateTable to store functional result
		VARIABLE  DFE3C_Result              : STD_LOGIC_VECTOR(2 DOWNTO 1) := (OTHERS => 'X');
		VARIABLE  DEPETH_TAB_Result         : STD_LOGIC_VECTOR(2 DOWNTO 1) := (OTHERS => 'X');
		--
		-- Variable(s) used in VitalTruthTable to store functional result
		VARIABLE  DEPETH_TTAB_Result        : STD_LOGIC_VECTOR(1 DOWNTO 1) := (OTHERS => 'X');
		--
		-- Variable(s) used in VitalStateTable to keep track of the previous values
		--VARIABLE  PrevData_DFE3C            : STD_LOGIC_VECTOR(0 TO 5);
		--VARIABLE  PrevData_DEPETH_TAB       : STD_LOGIC_VECTOR(0 TO 5);
		VARIABLE  PrevData_DFE3C            : STD_LOGIC_VECTOR(0 TO 4);
		VARIABLE  PrevData_DEPETH_TAB       : STD_LOGIC_VECTOR(0 TO 4);
		--
		-- Variable(s) used in VitalStateTable and VitalPropagatePathDelay
		VARIABLE  Q_zd                      : STD_ULOGIC;
		VARIABLE  PAD_zd                    : STD_ULOGIC;
		VARIABLE  D_delayed                 : STD_ULOGIC;
		VARIABLE  ODE_delayed               : STD_ULOGIC;
		VARIABLE  IDE_delayed               : STD_ULOGIC;
		VARIABLE  PAD_delayed               : STD_ULOGIC;
		--
		-- State Table : DEPETH_TAB Declaration
		CONSTANT  DEPETH_TAB : VitalStateTableType (1 to 14, 1 to 8) := (
--          Violation, IOPCL, CLK, D, ODE
		( '0', '0', '-', '-', '-',  '-',  '1',  '1' ),
		( '0', '1', '/', '0', '0',  '-',  '0',  '0' ),
		( '0', '1', '/', '1', '0',  '-',  '1',  '1' ),
		( '0', '1', '/', '0', '-',  '0',  '0',  '0' ),
		( '0', '1', '-', '0', '-',  '0',  '0',  '0' ),
		( '0', '-', '-', '1', '-',  '1',  '1',  '1' ),
		( '0', '-', '-', '-', '1',  '1',  '1',  '1' ),
		( '0', '1', '/', '1', '-',  '1',  '1',  '1' ),
		( '0', '1', '-', '1', '-',  '1',  '1',  '1' ),
		( '0', '1', '/', '-', '1',  '-',  'S',  'S' ),
		( '0', '1', 'F', '-', '-',  '-',  'S',  'S' ),
		( '0', '1', 'S', '-', '-',  '-',  'S',  'S' ),
		( '0', '1', '-', '-', '1',  '-',  'S',  'S' ),
		( 'X', '-', '-', '-', '-',  '-',  'X',  'X' ) );
	
	BEGIN
		-----------------------------------------------
		-- Timing Check Section
		-----------------------------------------------
		IF (TimingChecksOn) THEN
			-- Perform Setup/Hold Check
			--	TestSignal : D
			--	RefSignal  : CLK
			VitalSetupHoldCheck (
				Violation          => SHVF_D_CLK,
				TimingData         => D_CLK_TimingDataSH,
				TestSignal         => D_ipd,
				TestSignalName     => "D",
				TestDelay          => 0 ns,
				RefSignal          => CLK_ipd,
				RefSignalName      => "CLK",
				RefDelay           => 0 ns,
				SetupHigh          => tsetup_D_CLK_noedge_posedge,
				SetupLow           => tsetup_D_CLK_noedge_posedge,
				HoldHigh           => thold_D_CLK_noedge_posedge,
				HoldLow            => thold_D_CLK_noedge_posedge,
				CheckEnabled       => TO_X01 ( ( NOT IOPCL_ipd ) OR ODE_ipd ) /= '1',
				RefTransition      => '/',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalSetupHoldCheck
			-- Perform Setup/Hold Check
			--	TestSignal : PAD
			--	RefSignal  : CLK
			VitalSetupHoldCheck (
				Violation          => SHVF_PAD_CLK,
				TimingData         => PAD_CLK_TimingDataSH,
				TestSignal         => PAD_ipd,
				TestSignalName     => "PAD",
				TestDelay          => 0 ns,
				RefSignal          => CLK_ipd,
				RefSignalName      => "CLK",
				RefDelay           => 0 ns,
				SetupHigh          => tsetup_PAD_CLK_noedge_posedge,
				SetupLow           => tsetup_PAD_CLK_noedge_posedge,
				HoldHigh           => thold_PAD_CLK_noedge_posedge,
				HoldLow            => thold_PAD_CLK_noedge_posedge,
				CheckEnabled       => TO_X01 ( ( NOT IOPCL_ipd ) OR IDE_ipd ) /= '1',
				RefTransition      => '/',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalSetupHoldCheck
			-- Perform Setup/Hold Check
			--	TestSignal : IDE
			--	RefSignal  : CLK
			VitalSetupHoldCheck (
				Violation          => SHVF_IDE_CLK,
				TimingData         => IDE_CLK_TimingDataSH,
				TestSignal         => IDE_ipd,
				TestSignalName     => "IDE",
				TestDelay          => 0 ns,
				RefSignal          => CLK_ipd,
				RefSignalName      => "CLK",
				RefDelay           => 0 ns,
				SetupHigh          => tsetup_IDE_CLK_noedge_posedge,
				SetupLow           => tsetup_IDE_CLK_noedge_posedge,
				HoldHigh           => thold_IDE_CLK_noedge_posedge,
				HoldLow            => thold_IDE_CLK_noedge_posedge,
				CheckEnabled       => TO_X01 ( ( NOT IOPCL_ipd ) ) /= '1',
				RefTransition      => '/',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalSetupHoldCheck
			-- Perform Setup/Hold Check
			--	TestSignal : ODE
			--	RefSignal  : CLK
			VitalSetupHoldCheck (
				Violation          => SHVF_ODE_CLK,
				TimingData         => ODE_CLK_TimingDataSH,
				TestSignal         => ODE_ipd,
				TestSignalName     => "ODE",
				TestDelay          => 0 ns,
				RefSignal          => CLK_ipd,
				RefSignalName      => "CLK",
				RefDelay           => 0 ns,
				SetupHigh          => tsetup_ODE_CLK_noedge_posedge,
				SetupLow           => tsetup_ODE_CLK_noedge_posedge,
				HoldHigh           => thold_ODE_CLK_noedge_posedge,
				HoldLow            => thold_ODE_CLK_noedge_posedge,
				CheckEnabled       => TO_X01 ( ( NOT IOPCL_ipd ) ) /= '1',
				RefTransition      => '/',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalSetupHoldCheck
			-- Perform Recovery/Removal Check
			--	TestSignal : IOPCL
			--	RefSignal  : CLK
			VitalRecoveryRemovalCheck (
				Violation          => RRVF_IOPCL_CLK,
				TimingData         => IOPCL_CLK_TimingDataRR,
				TestSignal         => IOPCL_ipd,
				TestSignalName     => "IOPCL",
				TestDelay          => 0 ns,
				RefSignal          => CLK_ipd,
				RefSignalName      => "CLK",
				RefDelay           => 0 ns,
				Recovery           => trecovery_IOPCL_CLK_posedge_posedge,
				Removal            => thold_IOPCL_CLK_noedge_posedge,
				ActiveLow          => TRUE,
				CheckEnabled       => TRUE,
				RefTransition      => '/',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalRecoveryRemovalCheck
			-- Perform Minimum and Maximum Periodicity and Pulse Check
			--TestSignal : CLK
			VitalPeriodPulseCheck (
				Violation          => PDVF_CLK,
				PeriodData         => CLK_PeriodData,
				TestSignal         => CLK_ipd,
				TestSignalName     => "CLK",
				TestDelay          => 0 ns,
				Period             => tperiod_CLK_posedge,
				PulseWidthHigh     => tpw_CLK_posedge,
				PulseWidthLow      => tpw_CLK_negedge,
				CheckEnabled       => TO_X01 ( ( NOT IOPCL_ipd ) ) /= '1',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalPeriodPulseCheck
			-- Perform Minimum and Maximum Periodicity and Pulse Check
			--TestSignal : IOPCL
			VitalPeriodPulseCheck (
				Violation          => PDVF_IOPCL,
				PeriodData         => IOPCL_PeriodData,
				TestSignal         => IOPCL_ipd,
				TestSignalName     => "IOPCL",
				TestDelay          => 0 ns,
				Period             => tperiod_IOPCL,
				PulseWidthHigh     => tpw_IOPCL_posedge,
				PulseWidthLow      => tpw_IOPCL_negedge,
				CheckEnabled       => TRUE,
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalPeriodPulseCheck
		
		END IF;	--Timing Check Section
		
		-----------------------------------------------
		-- Functionality Section
		-----------------------------------------------
		

		Violation                 := PDVF_CLK or PDVF_IOPCL or RRVF_IOPCL_CLK or 
				SHVF_D_CLK or SHVF_IDE_CLK or SHVF_ODE_CLK or 
				SHVF_PAD_CLK ;
		--
		--Implement Functionality for State Table : DEPETH_TAB
		VitalStateTable (
				StateTable         => DEPETH_TAB,
				--DataIn             => (Violation & IOPCL_ipd & CLK_ipd & D_ipd & ODE_ipd),
				--DataIn             => (Violation, IOPCL_ipd, CLK_ipd, D_ipd, ODE_ipd),
				DataIn             => (Violation, IOPCL_ipd, CLK_ipd, D_delayed, ODE_delayed),
				NumStates          => 1,
				Result             => DFE3C_Result,
				PreviousDataIn     => PrevData_DFE3C
		);	--End VitalStateTable
		DFE3CStateReg(0)          := DFE3C_Result(2);
		IQ(0)                     := DFE3C_Result(1);
		--
		--Implement Functionality for State Table : DEPETH_TAB
		VitalStateTable (
				StateTable         => DEPETH_TAB,
				--DataIn             => (Violation & IOPCL_ipd & CLK_ipd & PAD_ipd & IDE_ipd),
				--DataIn             => (Violation, IOPCL_ipd, CLK_ipd, PAD_ipd, IDE_ipd),
				DataIn             => (Violation, IOPCL_ipd, CLK_ipd, PAD_delayed, IDE_delayed),
				NumStates          => 1,
				Result             => DEPETH_TAB_Result,
				PreviousDataIn     => PrevData_DEPETH_TAB
		);	--End VitalStateTable
		DEPETH_TABStateReg(0)     := DEPETH_TAB_Result(2);
		Q_zd                      := DEPETH_TAB_Result(1);
		--
		PAD_zd := VitalBUFIF0 (data => IQ(0), enable => (NOT E_ipd));
		D_delayed := D_ipd;
		ODE_delayed := ODE_ipd;
		IDE_delayed := IDE_ipd;
		PAD_delayed := PAD_ipd;

		
		
		-----------------------------------------------
		-- Path Delay Section
		-----------------------------------------------
		VitalPathDelay01 (
				OutSignal          => Q,
				OutSignalName      => "Q",
				OutTemp            => Q_zd,
				DefaultDelay       => VitalZeroDelay01,
				MsgSeverity        => WARNING,
				Paths              => (
				                 0 => (
							InputChangeTime => IOPCL_ipd'LAST_EVENT,
							PathDelay       => tpd_IOPCL_Q,
							PathCondition   => TRUE
				                      ),
				                 1 => (
							InputChangeTime => CLK_ipd'LAST_EVENT,
							PathDelay       => tpd_CLK_Q,
							PathCondition   => TRUE
				                      ),
				                 2 => (
							InputChangeTime => PAD_ipd'LAST_EVENT,
							PathDelay       => tpd_PAD_Q,
							PathCondition   => TRUE
				                      )
				                      ),
				GlitchData         => Q_GlitchData,
				Mode               => OnDetect,
				XOn                => XOn,
				MsgOn              => MsgOn
		);	--End VitalPathDelay
		VitalPathDelay01Z (
				OutSignal          => PAD,
				OutSignalName      => "PAD",
				OutTemp            => PAD_zd,
				DefaultDelay       => VitalZeroDelay01Z,
				MsgSeverity        => WARNING,
				Paths              => (
				                 0 => (
							InputChangeTime => IOPCL_ipd'LAST_EVENT,
							PathDelay       => VitalExtendToFillDelay(tpd_IOPCL_PAD),
							PathCondition   => TRUE
				                      ),
				                 1 => (
							InputChangeTime => CLK_ipd'LAST_EVENT,
							PathDelay       => VitalExtendToFillDelay(tpd_CLK_PAD),
							PathCondition   => TRUE
				                      ),
				                 2 => (
							InputChangeTime => E_ipd'LAST_EVENT,
							PathDelay       => tpd_E_PAD,
							PathCondition   => TRUE
				                      )
				                      ),
				GlitchData         => PAD_GlitchData,
				Mode               => OnDetect,
				XOn                => XOn,
				MsgOn              => MsgOn,
				OutputMap          => "UX01ZWLH-"
		);	--End VitalPathDelay
		
	END PROCESS VITALBehavior;

END VITAL_ACT;

configuration CFG_DEPETH_VITAL of DEPETH is
   for VITAL_ACT
   end for;
end CFG_DEPETH_VITAL;
----- CELL DEPETL -----
LIBRARY   IEEE;
USE       IEEE.std_logic_1164.all;
USE       IEEE.VITAL_Timing.all;
USE       IEEE.VITAL_Primitives.all;
	
entity DEPETL IS
	GENERIC (
		--
		-- PinToPinDelay Generics Declaration(s)
		tpd_IOPCL_Q          : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input IOPCL to output Q
		tpd_CLK_Q            : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input CLK to output Q
		tpd_PAD_Q            : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input PAD to output Q
		tpd_IOPCL_PAD        : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input IOPCL to output PAD
		tpd_CLK_PAD          : VitalDelayType01 := (1.000 ns, 1.000 ns);	-- Path delay from input CLK to output PAD
		tpd_E_PAD            : VitalDelayType01z := (0.000 ns, 0.000 ns, 1.000 ns, 1.000 ns, 1.000 ns, 1.000 ns); -- Path delay from input E to output PAD

		--
		-- Interconnect Path Delay Generics Declaration(s)
		tipd_CLK             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port CLK
		tipd_D               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port D
		tipd_E               : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port E
		tipd_IDE             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port IDE
		tipd_IOPCL           : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port IOPCL
		tipd_ODE             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port ODE
		tipd_PAD             : VitalDelayType01 := (0.000 ns, 0.000 ns);	-- Input wire delay on port PAD
		--
		-- Setup Generics Declaration(s)
		tsetup_D_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between D and CLK
		tsetup_PAD_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between PAD and CLK
		tsetup_IDE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between IDE and CLK
		tsetup_ODE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Setup Hi time between ODE and CLK
		--
		-- Hold Generics Declaration(s)
		thold_D_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between D and CLK
		thold_PAD_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between PAD and CLK
		thold_IDE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between IDE and CLK
		thold_ODE_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between ODE and CLK
		thold_IOPCL_CLK_noedge_posedge : VitalDelayType   := 0.000 ns;	-- Hold Hi time between IOPCL and CLK
		--
		-- Recovery Generics Declaration(s)
		trecovery_IOPCL_CLK_posedge_posedge : VitalDelayType   := 0.000 ns;	-- Recovery time between IOPCL and CLK
		--
		-- Period Check Generics Declaration(s)
		tperiod_CLK_posedge          : VitalDelayType   := 0.000 ns;	-- Minimum period time for CLK
		tpw_CLK_posedge      : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for CLK
		tpw_CLK_negedge      : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for CLK
		tperiod_IOPCL        : VitalDelayType   := 0.000 ns;	-- Minimum period time for IOPCL
		tpw_IOPCL_posedge    : VitalDelayType   := 0.000 ns;	-- Minimum high pulse width for IOPCL
		tpw_IOPCL_negedge    : VitalDelayType   := 0.000 ns;	-- Minimum low pulse width for IOPCL
		--
		-- InstancePath Will Accompany Any Assertion Messages in the Model
		InstancePath         : STRING           := "*";
		--
		-- 'X' generation control parameter for timing checks and path delay
		XOn                  : BOOLEAN          := TRUE;
		--
		-- Assertion messages generation control parameter for violation of timing checks
		MsgOn                : BOOLEAN          := TRUE;
		--
		-- VitalTimingCheck Switch
		TimingChecksOn       : BOOLEAN          := TRUE
	);
	PORT (
		CLK                 : IN      STD_ULOGIC := 'X';
		D                   : IN      STD_ULOGIC := 'X';
		E                   : IN      STD_ULOGIC := 'X';
		IDE                 : IN      STD_ULOGIC := 'X';
		IOPCL               : IN      STD_ULOGIC := 'X';
		ODE                 : IN      STD_ULOGIC := 'X';
		PAD                 : INOUT   STD_ULOGIC := 'X';
		Q                   : OUT     STD_ULOGIC := 'X'
		
	);
	--
	attribute Vital_Level0 OF DEPETL : ENTITY IS TRUE;
	--
end DEPETL;

ARCHITECTURE VITAL_ACT OF DEPETL IS
	--
	ATTRIBUTE Vital_Level1 OF VITAL_ACT : ARCHITECTURE IS TRUE;
	--
	--
	--Internal Delay Signals - delayed be the interconnect path delay
	SIGNAL    CLK_ipd                   : STD_ULOGIC := 'U';
	SIGNAL    D_ipd                     : STD_ULOGIC := 'U';
	SIGNAL    E_ipd                     : STD_ULOGIC := 'U';
	SIGNAL    IDE_ipd                   : STD_ULOGIC := 'U';
	SIGNAL    IOPCL_ipd                 : STD_ULOGIC := 'U';
	SIGNAL    ODE_ipd                   : STD_ULOGIC := 'U';
	SIGNAL    PAD_ipd                   : STD_ULOGIC := 'U';
	
	BEGIN
	-----------------------------------------------
	-- Input Path Delay Section
	-----------------------------------------------
	WireDelay : BLOCK
	BEGIN
		VitalWireDelay (
				OutSig             => CLK_ipd,
				InSig              => CLK,
				twire              => tipd_CLK
		);
		VitalWireDelay (
				OutSig             => D_ipd,
				InSig              => D,
				twire              => tipd_D
		);
		VitalWireDelay (
				OutSig             => E_ipd,
				InSig              => E,
				twire              => tipd_E
		);
		VitalWireDelay (
				OutSig             => IDE_ipd,
				InSig              => IDE,
				twire              => tipd_IDE
		);
		VitalWireDelay (
				OutSig             => IOPCL_ipd,
				InSig              => IOPCL,
				twire              => tipd_IOPCL
		);
		VitalWireDelay (
				OutSig             => ODE_ipd,
				InSig              => ODE,
				twire              => tipd_ODE
		);
		VitalWireDelay (
				OutSig             => PAD_ipd,
				InSig              => PAD,
				twire              => tipd_PAD
		);
	
	END BLOCK WireDelay;
	
	-----------------------------------------------
	-- Behavior Section
	-----------------------------------------------
	VITALBehavior : PROCESS (CLK_ipd, D_ipd, E_ipd, IDE_ipd, IOPCL_ipd, ODE_ipd, PAD_ipd	
	                        )
		--
		-- Variable(s) for internal use in VitalPeriodPulseCheck
		VARIABLE  CLK_PeriodData            : VitalPeriodDataType := VitalPeriodDataInit;
		VARIABLE  IOPCL_PeriodData          : VitalPeriodDataType := VitalPeriodDataInit;
		--
		-- Variable(s) for internal use in VitalRecoveryRemovalCheck
		VARIABLE  IOPCL_CLK_TimingDataRR    : VitalTimingDataType := VitalTimingDataInit;
		--
		-- Variable(s) for internal use in VitalSetupHoldCheck
		VARIABLE  D_CLK_TimingDataSH        : VitalTimingDataType := VitalTimingDataInit;
		VARIABLE  PAD_CLK_TimingDataSH      : VitalTimingDataType := VitalTimingDataInit;
		VARIABLE  IDE_CLK_TimingDataSH      : VitalTimingDataType := VitalTimingDataInit;
		VARIABLE  ODE_CLK_TimingDataSH      : VitalTimingDataType := VitalTimingDataInit;
		--
		-- Variable(s) used in VitalPathDelay to Store GlitchData
		VARIABLE  Q_GlitchData              : VitalGlitchDataType;
		VARIABLE  PAD_GlitchData            : VitalGlitchDataType;
		--
		-- Variable(s) generated by VitalTimingCheck violation flags and/or user
		VARIABLE  SHVF_D_CLK                : STD_ULOGIC := '0';
		VARIABLE  SHVF_PAD_CLK              : STD_ULOGIC := '0';
		VARIABLE  SHVF_IDE_CLK              : STD_ULOGIC := '0';
		VARIABLE  SHVF_ODE_CLK              : STD_ULOGIC := '0';
		VARIABLE  PDVF_CLK                  : STD_ULOGIC := '0';
		VARIABLE  PDVF_IOPCL                : STD_ULOGIC := '0';
		VARIABLE  RRVF_IOPCL_CLK            : STD_ULOGIC := '0';
		VARIABLE  Violation                 : STD_ULOGIC := 'X';
		VARIABLE  DFE3CStateReg             : STD_LOGIC_VECTOR(0 DOWNTO 0) := (OTHERS => 'X');
		VARIABLE  IQ                        : STD_LOGIC_VECTOR(0 DOWNTO 0) := (OTHERS => 'X');
		VARIABLE  DEPETL_TABStateReg        : STD_LOGIC_VECTOR(0 DOWNTO 0) := (OTHERS => 'X');
		--
		-- Variable(s) used in VitalStateTable to store functional result
		VARIABLE  DFE3C_Result              : STD_LOGIC_VECTOR(2 DOWNTO 1) := (OTHERS => 'X');
		VARIABLE  DEPETL_TAB_Result         : STD_LOGIC_VECTOR(2 DOWNTO 1) := (OTHERS => 'X');
		--
		-- Variable(s) used in VitalTruthTable to store functional result
		VARIABLE  DEPETL_TTAB_Result        : STD_LOGIC_VECTOR(1 DOWNTO 1) := (OTHERS => 'X');
		--
		-- Variable(s) used in VitalStateTable to keep track of the previous values
		--VARIABLE  PrevData_DFE3C            : STD_LOGIC_VECTOR(0 TO 5);
		--VARIABLE  PrevData_DEPETL_TAB       : STD_LOGIC_VECTOR(0 TO 5);
		VARIABLE  PrevData_DFE3C            : STD_LOGIC_VECTOR(0 TO 4);
		VARIABLE  PrevData_DEPETL_TAB       : STD_LOGIC_VECTOR(0 TO 4);
		--
		-- Variable(s) used in VitalStateTable and VitalPropagatePathDelay
		VARIABLE  Q_zd                      : STD_ULOGIC;
		VARIABLE  PAD_zd                    : STD_ULOGIC;
		VARIABLE  D_delayed                 : STD_ULOGIC;
		VARIABLE  ODE_delayed               : STD_ULOGIC;
		VARIABLE  IDE_delayed               : STD_ULOGIC;
		VARIABLE  PAD_delayed               : STD_ULOGIC;
		--
		-- State Table : DEPETL_TAB Declaration
		CONSTANT  DEPETL_TAB : VitalStateTableType (1 to 14, 1 to 8) := (
--          Violation, IOPCL, CLK, D, ODE
		( '0', '0', '-', '-', '-',  '-',  '1',  '1' ),
		( '0', '1', '/', '0', '0',  '-',  '0',  '0' ),
		( '0', '1', '/', '1', '0',  '-',  '1',  '1' ),
		( '0', '1', '/', '0', '-',  '0',  '0',  '0' ),
		( '0', '1', '-', '0', '-',  '0',  '0',  '0' ),
		( '0', '-', '-', '1', '-',  '1',  '1',  '1' ),
		( '0', '-', '-', '-', '1',  '1',  '1',  '1' ),
		( '0', '1', '/', '1', '-',  '1',  '1',  '1' ),
		( '0', '1', '-', '1', '-',  '1',  '1',  '1' ),
		( '0', '1', '/', '-', '1',  '-',  'S',  'S' ),
		( '0', '1', 'F', '-', '-',  '-',  'S',  'S' ),
		( '0', '1', 'S', '-', '-',  '-',  'S',  'S' ),
		( '0', '1', '-', '-', '1',  '-',  'S',  'S' ),
		( 'X', '-', '-', '-', '-',  '-',  'X',  'X' ) );
	
	BEGIN
		-----------------------------------------------
		-- Timing Check Section
		-----------------------------------------------
		IF (TimingChecksOn) THEN
			-- Perform Setup/Hold Check
			--	TestSignal : D
			--	RefSignal  : CLK
			VitalSetupHoldCheck (
				Violation          => SHVF_D_CLK,
				TimingData         => D_CLK_TimingDataSH,
				TestSignal         => D_ipd,
				TestSignalName     => "D",
				TestDelay          => 0 ns,
				RefSignal          => CLK_ipd,
				RefSignalName      => "CLK",
				RefDelay           => 0 ns,
				SetupHigh          => tsetup_D_CLK_noedge_posedge,
				SetupLow           => tsetup_D_CLK_noedge_posedge,
				HoldHigh           => thold_D_CLK_noedge_posedge,
				HoldLow            => thold_D_CLK_noedge_posedge,
				CheckEnabled       => TO_X01 ( ( NOT IOPCL_ipd ) OR ODE_ipd ) /= '1',
				RefTransition      => '/',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalSetupHoldCheck
			-- Perform Setup/Hold Check
			--	TestSignal : PAD
			--	RefSignal  : CLK
			VitalSetupHoldCheck (
				Violation          => SHVF_PAD_CLK,
				TimingData         => PAD_CLK_TimingDataSH,
				TestSignal         => PAD_ipd,
				TestSignalName     => "PAD",
				TestDelay          => 0 ns,
				RefSignal          => CLK_ipd,
				RefSignalName      => "CLK",
				RefDelay           => 0 ns,
				SetupHigh          => tsetup_PAD_CLK_noedge_posedge,
				SetupLow           => tsetup_PAD_CLK_noedge_posedge,
				HoldHigh           => thold_PAD_CLK_noedge_posedge,
				HoldLow            => thold_PAD_CLK_noedge_posedge,
				CheckEnabled       => TO_X01 ( ( NOT IOPCL_ipd ) OR IDE_ipd ) /= '1',
				RefTransition      => '/',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalSetupHoldCheck
			-- Perform Setup/Hold Check
			--	TestSignal : IDE
			--	RefSignal  : CLK
			VitalSetupHoldCheck (
				Violation          => SHVF_IDE_CLK,
				TimingData         => IDE_CLK_TimingDataSH,
				TestSignal         => IDE_ipd,
				TestSignalName     => "IDE",
				TestDelay          => 0 ns,
				RefSignal          => CLK_ipd,
				RefSignalName      => "CLK",
				RefDelay           => 0 ns,
				SetupHigh          => tsetup_IDE_CLK_noedge_posedge,
				SetupLow           => tsetup_IDE_CLK_noedge_posedge,
				HoldHigh           => thold_IDE_CLK_noedge_posedge,
				HoldLow            => thold_IDE_CLK_noedge_posedge,
				CheckEnabled       => TO_X01 ( ( NOT IOPCL_ipd ) ) /= '1',
				RefTransition      => '/',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalSetupHoldCheck
			-- Perform Setup/Hold Check
			--	TestSignal : ODE
			--	RefSignal  : CLK
			VitalSetupHoldCheck (
				Violation          => SHVF_ODE_CLK,
				TimingData         => ODE_CLK_TimingDataSH,
				TestSignal         => ODE_ipd,
				TestSignalName     => "ODE",
				TestDelay          => 0 ns,
				RefSignal          => CLK_ipd,
				RefSignalName      => "CLK",
				RefDelay           => 0 ns,
				SetupHigh          => tsetup_ODE_CLK_noedge_posedge,
				SetupLow           => tsetup_ODE_CLK_noedge_posedge,
				HoldHigh           => thold_ODE_CLK_noedge_posedge,
				HoldLow            => thold_ODE_CLK_noedge_posedge,
				CheckEnabled       => TO_X01 ( ( NOT IOPCL_ipd ) ) /= '1',
				RefTransition      => '/',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalSetupHoldCheck
			-- Perform Recovery/Removal Check
			--	TestSignal : IOPCL
			--	RefSignal  : CLK
			VitalRecoveryRemovalCheck (
				Violation          => RRVF_IOPCL_CLK,
				TimingData         => IOPCL_CLK_TimingDataRR,
				TestSignal         => IOPCL_ipd,
				TestSignalName     => "IOPCL",
				TestDelay          => 0 ns,
				RefSignal          => CLK_ipd,
				RefSignalName      => "CLK",
				RefDelay           => 0 ns,
				Recovery           => trecovery_IOPCL_CLK_posedge_posedge,
				Removal            => thold_IOPCL_CLK_noedge_posedge,
				ActiveLow          => TRUE,
				CheckEnabled       => TRUE,
				RefTransition      => '/',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalRecoveryRemovalCheck
			-- Perform Minimum and Maximum Periodicity and Pulse Check
			--TestSignal : CLK
			VitalPeriodPulseCheck (
				Violation          => PDVF_CLK,
				PeriodData         => CLK_PeriodData,
				TestSignal         => CLK_ipd,
				TestSignalName     => "CLK",
				TestDelay          => 0 ns,
				Period             => tperiod_CLK_posedge,
				PulseWidthHigh     => tpw_CLK_posedge,
				PulseWidthLow      => tpw_CLK_negedge,
				CheckEnabled       => TO_X01 ( ( NOT IOPCL_ipd ) ) /= '1',
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalPeriodPulseCheck
			-- Perform Minimum and Maximum Periodicity and Pulse Check
			--TestSignal : IOPCL
			VitalPeriodPulseCheck (
				Violation          => PDVF_IOPCL,
				PeriodData         => IOPCL_PeriodData,
				TestSignal         => IOPCL_ipd,
				TestSignalName     => "IOPCL",
				TestDelay          => 0 ns,
				Period             => tperiod_IOPCL,
				PulseWidthHigh     => tpw_IOPCL_posedge,
				PulseWidthLow      => tpw_IOPCL_negedge,
				CheckEnabled       => TRUE,
				HeaderMsg          => InstancePath,
				XOn                => XOn,
				MsgOn              => MsgOn,
				MsgSeverity        => WARNING
			);	--End VitalPeriodPulseCheck
		
		END IF;	--Timing Check Section
		
		-----------------------------------------------
		-- Functionality Section
		-----------------------------------------------
		

		Violation                 := PDVF_CLK or PDVF_IOPCL or RRVF_IOPCL_CLK or 
				SHVF_D_CLK or SHVF_IDE_CLK or SHVF_ODE_CLK or 
				SHVF_PAD_CLK ;
		--
		--Implement Functionality for State Table : DEPETL_TAB
		VitalStateTable (
				StateTable         => DEPETL_TAB,
				--DataIn             => (Violation & IOPCL_ipd & CLK_ipd & D_ipd & ODE_ipd),
				--DataIn             => (Violation, IOPCL_ipd, CLK_ipd, D_ipd, ODE_ipd),
				DataIn             => (Violation, IOPCL_ipd, CLK_ipd, D_delayed, ODE_delayed),
				NumStates          => 1,
				Result             => DFE3C_Result,
				PreviousDataIn     => PrevData_DFE3C
		);	--End VitalStateTable
		DFE3CStateReg(0)          := DFE3C_Result(2);
		IQ(0)                     := DFE3C_Result(1);
		--
		--Implement Functionality for State Table : DEPETL_TAB
		VitalStateTable (
				StateTable         => DEPETL_TAB,
				--DataIn             => (Violation & IOPCL_ipd & CLK_ipd & PAD_ipd & IDE_ipd),
				--DataIn             => (Violation, IOPCL_ipd, CLK_ipd, PAD_ipd, IDE_ipd),
				DataIn             => (Violation, IOPCL_ipd, CLK_ipd, PAD_delayed, IDE_delayed),
				NumStates          => 1,
				Result             => DEPETL_TAB_Result,
				PreviousDataIn     => PrevData_DEPETL_TAB
		);	--End VitalStateTable
		DEPETL_TABStateReg(0)     := DEPETL_TAB_Result(2);
		Q_zd                      := DEPETL_TAB_Result(1);
		--
		PAD_zd := VitalBUFIF0 (data => IQ(0), enable => (NOT E_ipd));
		D_delayed := D_ipd;
		ODE_delayed := ODE_ipd;
		IDE_delayed := IDE_ipd;
		PAD_delayed := PAD_ipd;

		
		
		-----------------------------------------------
		-- Path Delay Section
		-----------------------------------------------
		VitalPathDelay01 (
				OutSignal          => Q,
				OutSignalName      => "Q",
				OutTemp            => Q_zd,
				DefaultDelay       => VitalZeroDelay01,
				MsgSeverity        => WARNING,
				Paths              => (
				                 0 => (
							InputChangeTime => IOPCL_ipd'LAST_EVENT,
							PathDelay       => tpd_IOPCL_Q,
							PathCondition   => TRUE
				                      ),
				                 1 => (
							InputChangeTime => CLK_ipd'LAST_EVENT,
							PathDelay       => tpd_CLK_Q,
							PathCondition   => TRUE
				                      ),
				                 2 => (
							InputChangeTime => PAD_ipd'LAST_EVENT,
							PathDelay       => tpd_PAD_Q,
							PathCondition   => TRUE
				                      )
				                      ),
				GlitchData         => Q_GlitchData,
				Mode               => OnDetect,
				XOn                => XOn,
				MsgOn              => MsgOn
		);	--End VitalPathDelay
		VitalPathDelay01Z (
				OutSignal          => PAD,
				OutSignalName      => "PAD",
				OutTemp            => PAD_zd,
				DefaultDelay       => VitalZeroDelay01Z,
				MsgSeverity        => WARNING,
				Paths              => (
				                 0 => (
							InputChangeTime => IOPCL_ipd'LAST_EVENT,
							PathDelay       => VitalExtendToFillDelay(tpd_IOPCL_PAD),
							PathCondition   => TRUE
				                      ),
				                 1 => (
							InputChangeTime => CLK_ipd'LAST_EVENT,
							PathDelay       => VitalExtendToFillDelay(tpd_CLK_PAD),
							PathCondition   => TRUE
				                      ),
				                 2 => (
							InputChangeTime => E_ipd'LAST_EVENT,
							PathDelay       => tpd_E_PAD,
							PathCondition   => TRUE
				                      )
				                      ),
				GlitchData         => PAD_GlitchData,
				Mode               => OnDetect,
				XOn                => XOn,
				MsgOn              => MsgOn,
				OutputMap          => "UX01ZWLH-"
		);	--End VitalPathDelay
		
	END PROCESS VITALBehavior;

END VITAL_ACT;

configuration CFG_DEPETL_VITAL of DEPETL is
   for VITAL_ACT
   end for;
end CFG_DEPETL_VITAL;
----- CELL DF1 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity DF1 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DF1 : entity is TRUE;
end DF1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of DF1 is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, CLK_ipd)

   -- timing check results
   VARIABLE Tviol_D_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 2);
   VARIABLE D_delayed : STD_ULOGIC := 'X';
   VARIABLE CLK_delayed : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_posedge,
          TimingData              => Tmkr_D_CLK_posedge,
          TestSignal              => D_ipd,
          TestSignalName          => "D",
          TestDelay               => 0 ns,
          RefSignal               => CLK_ipd,
          RefSignalName          => "CLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => 
                           TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DF1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK,
          PeriodData              => PInfo_CLK,
          TestSignal              => CLK_ipd,
          TestSignalName          => "CLK",
          TestDelay               => 0 ns,
          Period                  => 0 ns,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => tpw_CLK_negedge,
          CheckEnabled            => 
                           TRUE,
          HeaderMsg               => InstancePath &"/DF1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_posedge or Pviol_CLK;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => DF1_Q_tab,
        DataIn => (
               CLK_delayed, D_delayed, CLK_ipd));
      Q_zd := Violation XOR Q_zd;
      D_delayed := D_ipd;
      CLK_delayed := CLK_ipd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (CLK_ipd'last_event, tpd_CLK_Q, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_DF1_VITAL of DF1 is
   for VITAL_ACT
   end for;
end CFG_DF1_VITAL;


----- CELL DF1_CC -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity DF1_CC is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DF1_CC : entity is TRUE;
end DF1_CC;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of DF1_CC is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, CLK_ipd)

   -- timing check results
   VARIABLE Tviol_D_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 2);
   VARIABLE D_delayed : STD_ULOGIC := 'X';
   VARIABLE CLK_delayed : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_posedge,
          TimingData              => Tmkr_D_CLK_posedge,
          TestSignal              => D_ipd,
          TestSignalName          => "D",
          TestDelay               => 0 ns,
          RefSignal               => CLK_ipd,
          RefSignalName          => "CLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => 
                           TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DF1_CC",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK,
          PeriodData              => PInfo_CLK,
          TestSignal              => CLK_ipd,
          TestSignalName          => "CLK",
          TestDelay               => 0 ns,
          Period                  => 0 ns,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => tpw_CLK_negedge,
          CheckEnabled            => 
                           TRUE,
          HeaderMsg               => InstancePath &"/DF1_CC",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_posedge or Pviol_CLK;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => DF1_Q_tab,
        DataIn => (
               CLK_delayed, D_delayed, CLK_ipd));
      Q_zd := Violation XOR Q_zd;
      D_delayed := D_ipd;
      CLK_delayed := CLK_ipd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (CLK_ipd'last_event, tpd_CLK_Q, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_DF1_CC_VITAL of DF1_CC is
   for VITAL_ACT
   end for;
end CFG_DF1_CC_VITAL;


----- CELL DF1A -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity DF1A is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLK_QN                     :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      QN                             :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DF1A : entity is TRUE;
end DF1A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of DF1A is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, CLK_ipd)

   -- timing check results
   VARIABLE Tviol_D_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_QN : STD_LOGIC_VECTOR(0 to 2);
   VARIABLE D_delayed : STD_ULOGIC := 'X';
   VARIABLE CLK_delayed : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS QN_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE QN_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_posedge,
          TimingData              => Tmkr_D_CLK_posedge,
          TestSignal              => D_ipd,
          TestSignalName          => "D",
          TestDelay               => 0 ns,
          RefSignal               => CLK_ipd,
          RefSignalName          => "CLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => 
                           TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DF1A",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK,
          PeriodData              => PInfo_CLK,
          TestSignal              => CLK_ipd,
          TestSignalName          => "CLK",
          TestDelay               => 0 ns,
          Period                  => 0 ns,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => tpw_CLK_negedge,
          CheckEnabled            => 
                           TRUE,
          HeaderMsg               => InstancePath &"/DF1A",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_posedge or Pviol_CLK;
      VitalStateTable(
        Result => QN_zd,
        PreviousDataIn => PrevData_QN,
        StateTable => DF1A_QN_tab,
        DataIn => (
               CLK_delayed, D_delayed, CLK_ipd));
      QN_zd := Violation XOR QN_zd;
      D_delayed := D_ipd;
      CLK_delayed := CLK_ipd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => QN,
       GlitchData => QN_GlitchData,
       OutSignalName => "QN",
       OutTemp => QN_zd,
       Paths => (0 => (CLK_ipd'last_event, tpd_CLK_QN, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_DF1A_VITAL of DF1A is
   for VITAL_ACT
   end for;
end CFG_DF1A_VITAL;


----- CELL DF1A_CC -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity DF1A_CC is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLK_QN                     :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      QN                             :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DF1A_CC : entity is TRUE;
end DF1A_CC;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of DF1A_CC is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, CLK_ipd)

   -- timing check results
   VARIABLE Tviol_D_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_QN : STD_LOGIC_VECTOR(0 to 2);
   VARIABLE D_delayed : STD_ULOGIC := 'X';
   VARIABLE CLK_delayed : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS QN_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE QN_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_posedge,
          TimingData              => Tmkr_D_CLK_posedge,
          TestSignal              => D_ipd,
          TestSignalName          => "D",
          TestDelay               => 0 ns,
          RefSignal               => CLK_ipd,
          RefSignalName          => "CLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => 
                           TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DF1A_CC",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK,
          PeriodData              => PInfo_CLK,
          TestSignal              => CLK_ipd,
          TestSignalName          => "CLK",
          TestDelay               => 0 ns,
          Period                  => 0 ns,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => tpw_CLK_negedge,
          CheckEnabled            => 
                           TRUE,
          HeaderMsg               => InstancePath &"/DF1A_CC",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_posedge or Pviol_CLK;
      VitalStateTable(
        Result => QN_zd,
        PreviousDataIn => PrevData_QN,
        StateTable => DF1A_QN_tab,
        DataIn => (
               CLK_delayed, D_delayed, CLK_ipd));
      QN_zd := Violation XOR QN_zd;
      D_delayed := D_ipd;
      CLK_delayed := CLK_ipd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => QN,
       GlitchData => QN_GlitchData,
       OutSignalName => "QN",
       OutTemp => QN_zd,
       Paths => (0 => (CLK_ipd'last_event, tpd_CLK_QN, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_DF1A_CC_VITAL of DF1A_CC is
   for VITAL_ACT
   end for;
end CFG_DF1A_CC_VITAL;


----- CELL DF1B -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity DF1B is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DF1B : entity is TRUE;
end DF1B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of DF1B is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, CLK_ipd)

   -- timing check results
   VARIABLE Tviol_D_CLK_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 2);
   VARIABLE D_delayed : STD_ULOGIC := 'X';
   VARIABLE CLK_delayed : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_negedge,
          TimingData              => Tmkr_D_CLK_negedge,
          TestSignal              => D_ipd,
          TestSignalName          => "D",
          TestDelay               => 0 ns,
          RefSignal               => CLK_ipd,
          RefSignalName          => "CLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_D_CLK_noedge_negedge,
          SetupLow                => tsetup_D_CLK_noedge_negedge,
          HoldHigh                => thold_D_CLK_noedge_negedge,
          HoldLow                 => thold_D_CLK_noedge_negedge,
          CheckEnabled            => 
                           TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DF1B",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK,
          PeriodData              => PInfo_CLK,
          TestSignal              => CLK_ipd,
          TestSignalName          => "CLK",
          TestDelay               => 0 ns,
          Period                  => 0 ns,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => tpw_CLK_negedge,
          CheckEnabled            => 
                           TRUE,
          HeaderMsg               => InstancePath &"/DF1B",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_negedge or Pviol_CLK;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => DF1_Q_tab,
        DataIn => (
               CLK_ipd, D_delayed, CLK_delayed));
      Q_zd := Violation XOR Q_zd;
      D_delayed := D_ipd;
      CLK_delayed := CLK_ipd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (CLK_ipd'last_event, tpd_CLK_Q, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_DF1B_VITAL of DF1B is
   for VITAL_ACT
   end for;
end CFG_DF1B_VITAL;


----- CELL DF1B_CC -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity DF1B_CC is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DF1B_CC : entity is TRUE;
end DF1B_CC;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of DF1B_CC is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, CLK_ipd)

   -- timing check results
   VARIABLE Tviol_D_CLK_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 2);
   VARIABLE D_delayed : STD_ULOGIC := 'X';
   VARIABLE CLK_delayed : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_negedge,
          TimingData              => Tmkr_D_CLK_negedge,
          TestSignal              => D_ipd,
          TestSignalName          => "D",
          TestDelay               => 0 ns,
          RefSignal               => CLK_ipd,
          RefSignalName          => "CLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_D_CLK_noedge_negedge,
          SetupLow                => tsetup_D_CLK_noedge_negedge,
          HoldHigh                => thold_D_CLK_noedge_negedge,
          HoldLow                 => thold_D_CLK_noedge_negedge,
          CheckEnabled            => 
                           TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DF1B_CC",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK,
          PeriodData              => PInfo_CLK,
          TestSignal              => CLK_ipd,
          TestSignalName          => "CLK",
          TestDelay               => 0 ns,
          Period                  => 0 ns,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => tpw_CLK_negedge,
          CheckEnabled            => 
                           TRUE,
          HeaderMsg               => InstancePath &"/DF1B_CC",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_negedge or Pviol_CLK;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => DF1_Q_tab,
        DataIn => (
               CLK_ipd, D_delayed, CLK_delayed));
      Q_zd := Violation XOR Q_zd;
      D_delayed := D_ipd;
      CLK_delayed := CLK_ipd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (CLK_ipd'last_event, tpd_CLK_Q, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_DF1B_CC_VITAL of DF1B_CC is
   for VITAL_ACT
   end for;
end CFG_DF1B_CC_VITAL;


----- CELL DF1C -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity DF1C is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLK_QN                     :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      QN                             :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DF1C : entity is TRUE;
end DF1C;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of DF1C is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, CLK_ipd)

   -- timing check results
   VARIABLE Tviol_D_CLK_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_QN : STD_LOGIC_VECTOR(0 to 2);
   VARIABLE D_delayed : STD_ULOGIC := 'X';
   VARIABLE CLK_delayed : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS QN_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE QN_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_negedge,
          TimingData              => Tmkr_D_CLK_negedge,
          TestSignal              => D_ipd,
          TestSignalName          => "D",
          TestDelay               => 0 ns,
          RefSignal               => CLK_ipd,
          RefSignalName          => "CLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_D_CLK_noedge_negedge,
          SetupLow                => tsetup_D_CLK_noedge_negedge,
          HoldHigh                => thold_D_CLK_noedge_negedge,
          HoldLow                 => thold_D_CLK_noedge_negedge,
          CheckEnabled            => 
                           TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DF1C",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK,
          PeriodData              => PInfo_CLK,
          TestSignal              => CLK_ipd,
          TestSignalName          => "CLK",
          TestDelay               => 0 ns,
          Period                  => 0 ns,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => tpw_CLK_negedge,
          CheckEnabled            => 
                           TRUE,
          HeaderMsg               => InstancePath &"/DF1C",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_negedge or Pviol_CLK;
      VitalStateTable(
        Result => QN_zd,
        PreviousDataIn => PrevData_QN,
        StateTable => DF1A_QN_tab,
        DataIn => (
               CLK_ipd, D_delayed, CLK_delayed));
      QN_zd := Violation XOR QN_zd;
      D_delayed := D_ipd;
      CLK_delayed := CLK_ipd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => QN,
       GlitchData => QN_GlitchData,
       OutSignalName => "QN",
       OutTemp => QN_zd,
       Paths => (0 => (CLK_ipd'last_event, tpd_CLK_QN, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_DF1C_VITAL of DF1C is
   for VITAL_ACT
   end for;
end CFG_DF1C_VITAL;


----- CELL DF1C_CC -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity DF1C_CC is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLK_QN                     :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      QN                             :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DF1C_CC : entity is TRUE;
end DF1C_CC;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library act3;
use act3.VTABLES.all;
architecture VITAL_ACT of DF1C_CC is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, CLK_ipd)

   -- timing check results
   VARIABLE Tviol_D_CLK_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_QN : STD_LOGIC_VECTOR(0 to 2);
   VARIABLE D_delayed : STD_ULOGIC := 'X';
   VARIABLE CLK_delayed : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS QN_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE QN_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_negedge,
          TimingData              => Tmkr_D_CLK_negedge,
          TestSignal              => D_ipd,
          TestSignalName          => "D",
          TestDelay               => 0 ns,
          RefSignal               => CLK_ipd,
          RefSignalName          => "CLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_D_CLK_noedge_negedge,
          SetupLow                => tsetup_D_CLK_noedge_negedge,
          HoldHigh                => thold_D_CLK_noedge_negedge,
          HoldLow                 => thold_D_CLK_noedge_negedge,
          CheckEnabled            => 
                           TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DF1C_CC",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK,
          PeriodData              => PInfo_CLK,
          TestSignal              => CLK_ipd,
          TestSignalName          => "CLK",
          TestDelay               => 0 ns,
          Period                  => 0 ns,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => tpw_CLK_negedge,
          CheckEnabled            => 
                           TRUE,
          HeaderMsg               => InstancePath &"/DF1C_CC",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_negedge or Pviol_CLK;
      VitalStateTable(
        Result => QN_zd,
        PreviousDataIn => PrevData_QN,
        StateTable => DF1A_QN_tab,
        DataIn => (
               CLK_ipd, D_delayed, CLK_delayed));
      QN_zd := Violation XOR QN_zd;
      D_delayed := D_ipd;
      CLK_delayed := CLK_ipd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => QN,
       GlitchData => QN_GlitchData,
       OutSignalName => "QN",
       OutTemp => QN_zd,
       Paths => (0 => (CLK_ipd'last_event, tpd_CLK_QN, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_DF1C_CC_VITAL of DF1C_CC is
   for VITAL_ACT
   end for;
end CFG_DF1C_CC_VITAL;


----- CELL DFC1 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity DFC1 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLR_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_CLR_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      trecovery_CLR_CLK_negedge_posedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLR_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFC1 : entity is TRUE;
end DFC1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL_ACT of DFC1 is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLR_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (CLR_ipd, CLR, tipd_CLR);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, CLK_ipd, CLR_ipd)

   -- timing check results
   VARIABLE Tviol_D_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_CLR_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_CLR_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE Pviol_CLR	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLR	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE D_delayed : STD_ULOGIC := 'X';
   VARIABLE CLK_delayed : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   CONSTANT L : VitalTableSymbolType := '0';
   CONSTANT H : VitalTableSymbolType := '1';
   CONSTANT x : VitalTableSymbolType := '-';
   CONSTANT S : VitalTableSymbolType := 'S';
   CONSTANT R : VitalTableSymbolType := '/';
   CONSTANT U : VitalTableSymbolType := 'X';
   CONSTANT V : VitalTableSymbolType := 'B'; -- valid clock signal (non-rising)


   CONSTANT DFC1_Q_tab : VitalStateTableType := (
    ( L,  L,  H,  x,  x,  L ),
    ( L,  H,  H,  L,  x,  H ),
    ( H,  x,  x,  L,  x,  S ),
    ( x,  x,  L,  L,  x,  S ),
    ( x,  x,  x,  H,  x,  L ),
    ( x,  x,  x,  U,  L,  L ));

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_posedge,
          TimingData              => Tmkr_D_CLK_posedge,
          TestSignal              => D_ipd,
          TestSignalName          => "D",
          TestDelay               => 0 ns,
          RefSignal               => CLK_ipd,
          RefSignalName          => "CLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01(CLR_ipd ) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFC1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_CLR_CLK_posedge,
          TimingData              => Tmkr_CLR_CLK_posedge,
          TestSignal              => CLR_ipd,
          TestSignalName          => "CLR",
          TestDelay               => 0 ns,
          RefSignal               => CLK_ipd,
          RefSignalName          => "CLK",
          RefDelay                => 0 ns,
          Recovery                => trecovery_CLR_CLK_negedge_posedge,
          Removal                 => thold_CLR_CLK_noedge_posedge,
          ActiveLow               => FALSE,
          CheckEnabled            => 
                           TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFC1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK,
          PeriodData              => PInfo_CLK,
          TestSignal              => CLK_ipd,
          TestSignalName          => "CLK",
          TestDelay               => 0 ns,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => tpw_CLK_negedge,
          CheckEnabled            => 
                           TO_X01(CLR_ipd ) /= '1',
          HeaderMsg               => InstancePath &"/DFC1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLR,
          PeriodData              => PInfo_CLR,
          TestSignal              => CLR_ipd,
          TestSignalName          => "CLR",
          TestDelay               => 0 ns,
          Period                  => 0 ns,
          PulseWidthHigh          => tpw_CLR_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TRUE,
          HeaderMsg               => InstancePath &"/DFC1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_posedge or Tviol_CLR_CLK_posedge or Pviol_CLK or Pviol_CLR;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => DFC1_Q_tab,
        DataIn => (
               CLK_delayed, D_delayed, CLK_ipd, CLR_ipd));
      Q_zd := Violation XOR Q_zd;
      D_delayed := D_ipd;
      CLK_delayed := CLK_ipd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (CLR_ipd'last_event, tpd_CLR_Q, TRUE),
                 1 => (CLK_ipd'last_event, tpd_CLK_Q, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_DFC1_VITAL of DFC1 is
   for VITAL_ACT
   end for;
end CFG_DFC1_VITAL;


----- CELL DFC1_CC -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity DFC1_CC is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLR_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_CLR_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      trecovery_CLR_CLK_negedge_posedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLR_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFC1_CC : entity is TRUE;
end DFC1_CC;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL_ACT of DFC1_CC is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLR_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (CLR_ipd, CLR, tipd_CLR);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, CLK_ipd, CLR_ipd)

   -- timing check results
   VARIABLE Tviol_D_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_CLR_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_CLR_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE Pviol_CLR	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLR	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE D_delayed : STD_ULOGIC := 'X';
   VARIABLE CLK_delayed : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   CONSTANT L : VitalTableSymbolType := '0';
   CONSTANT H : VitalTableSymbolType := '1';
   CONSTANT x : VitalTableSymbolType := '-';
   CONSTANT S : VitalTableSymbolType := 'S';
   CONSTANT R : VitalTableSymbolType := '/';
   CONSTANT U : VitalTableSymbolType := 'X';
   CONSTANT V : VitalTableSymbolType := 'B'; -- valid clock signal (non-rising)

   CONSTANT DFC1_Q_tab : VitalStateTableType := (
    ( L,  L,  H,  x,  x,  L ),
    ( L,  H,  H,  L,  x,  H ),
    ( H,  x,  x,  L,  x,  S ),
    ( x,  x,  L,  L,  x,  S ),
    ( x,  x,  x,  H,  x,  L ),
    ( x,  x,  x,  U,  L,  L ));

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_posedge,
          TimingData              => Tmkr_D_CLK_posedge,
          TestSignal              => D_ipd,
          TestSignalName          => "D",
          TestDelay               => 0 ns,
          RefSignal               => CLK_ipd,
          RefSignalName          => "CLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01(CLR_ipd ) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFC1_CC",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_CLR_CLK_posedge,
          TimingData              => Tmkr_CLR_CLK_posedge,
          TestSignal              => CLR_ipd,
          TestSignalName          => "CLR",
          TestDelay               => 0 ns,
          RefSignal               => CLK_ipd,
          RefSignalName          => "CLK",
          RefDelay                => 0 ns,
          Recovery                => trecovery_CLR_CLK_negedge_posedge,
          Removal                 => thold_CLR_CLK_noedge_posedge,
          ActiveLow               => FALSE,
          CheckEnabled            => 
                           TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFC1_CC",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK,
          PeriodData              => PInfo_CLK,
          TestSignal              => CLK_ipd,
          TestSignalName          => "CLK",
          TestDelay               => 0 ns,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => tpw_CLK_negedge,
          CheckEnabled            => 
                           TO_X01(CLR_ipd ) /= '1',
          HeaderMsg               => InstancePath &"/DFC1_CC",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLR,
          PeriodData              => PInfo_CLR,
          TestSignal              => CLR_ipd,
          TestSignalName          => "CLR",
          TestDelay               => 0 ns,
          Period                  => 0 ns,
          PulseWidthHigh          => tpw_CLR_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TRUE,
          HeaderMsg               => InstancePath &"/DFC1_CC",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_posedge or Tviol_CLR_CLK_posedge or Pviol_CLK or Pviol_CLR;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => DFC1_Q_tab,
        DataIn => (
               CLK_delayed, D_delayed, CLK_ipd, CLR_ipd));
      Q_zd := Violation XOR Q_zd;
      D_delayed := D_ipd;
      CLK_delayed := CLK_ipd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (CLR_ipd'last_event, tpd_CLR_Q, TRUE),
                 1 => (CLK_ipd'last_event, tpd_CLK_Q, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_DFC1_CC_VITAL of DFC1_CC is
   for VITAL_ACT
   end for;
end CFG_DFC1_CC_VITAL;


----- CELL DFC1A -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity DFC1A is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLR_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_CLR_CLK_noedge_negedge                  :	VitalDelayType := 0.000 ns;
      trecovery_CLR_CLK_negedge_negedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_negedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLR_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFC1A : entity is TRUE;
end DFC1A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL_ACT of DFC1A is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLR_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (CLR_ipd, CLR, tipd_CLR);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, CLK_ipd, CLR_ipd)

   -- timing check results
   VARIABLE Tviol_D_CLK_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_CLR_CLK_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_CLR_CLK_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE Pviol_CLR	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLR	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE D_delayed : STD_ULOGIC := 'X';
   VARIABLE CLK_delayed : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   CONSTANT L : VitalTableSymbolType := '0';
   CONSTANT H : VitalTableSymbolType := '1';
   CONSTANT x : VitalTableSymbolType := '-';
   CONSTANT S : VitalTableSymbolType := 'S';
   CONSTANT R : VitalTableSymbolType := '/';
   CONSTANT U : VitalTableSymbolType := 'X';
   CONSTANT V : VitalTableSymbolType := 'B'; -- valid clock signal (non-rising)

   CONSTANT DFC1_Q_tab : VitalStateTableType := (
    ( L,  L,  H,  x,  x,  L ),
    ( L,  H,  H,  L,  x,  H ),
    ( H,  x,  x,  L,  x,  S ),
    ( x,  x,  L,  L,  x,  S ),
    ( x,  x,  x,  H,  x,  L ),
    ( x,  x,  x,  U,  L,  L ));

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_negedge,
          TimingData              => Tmkr_D_CLK_negedge,
          TestSignal              => D_ipd,
          TestSignalName          => "D",
          TestDelay               => 0 ns,
          RefSignal               => CLK_ipd,
          RefSignalName          => "CLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_D_CLK_noedge_negedge,
          SetupLow                => tsetup_D_CLK_noedge_negedge,
          HoldHigh                => thold_D_CLK_noedge_negedge,
          HoldLow                 => thold_D_CLK_noedge_negedge,
          CheckEnabled            => 
                           TO_X01(CLR_ipd ) /= '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DFC1A",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_CLR_CLK_negedge,
          TimingData              => Tmkr_CLR_CLK_negedge,
          TestSignal              => CLR_ipd,
          TestSignalName          => "CLR",
          TestDelay               => 0 ns,
          RefSignal               => CLK_ipd,
          RefSignalName          => "CLK",
          RefDelay                => 0 ns,
          Recovery                => trecovery_CLR_CLK_negedge_negedge,
          Removal                 => thold_CLR_CLK_noedge_negedge,
          ActiveLow               => FALSE,
          CheckEnabled            => 
                           TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DFC1A",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK,
          PeriodData              => PInfo_CLK,
          TestSignal              => CLK_ipd,
          TestSignalName          => "CLK",
          TestDelay               => 0 ns,
          Period                  => tperiod_CLK_negedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => tpw_CLK_negedge,
          CheckEnabled            => 
                           TO_X01(CLR_ipd ) /= '1',
          HeaderMsg               => InstancePath &"/DFC1A",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLR,
          PeriodData              => PInfo_CLR,
          TestSignal              => CLR_ipd,
          TestSignalName          => "CLR",
          TestDelay               => 0 ns,
          Period                  => 0 ns,
          PulseWidthHigh          => tpw_CLR_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TRUE,
          HeaderMsg               => InstancePath &"/DFC1A",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_negedge or Tviol_CLR_CLK_negedge or Pviol_CLR or Pviol_CLK;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => DFC1_Q_tab,
        DataIn => (
               CLK_ipd, D_delayed, CLK_delayed, CLR_ipd));
      Q_zd := Violation XOR Q_zd;
      D_delayed := D_ipd;
      CLK_delayed := CLK_ipd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (CLR_ipd'last_event, tpd_CLR_Q, TRUE),
                 1 => (CLK_ipd'last_event, tpd_CLK_Q, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_DFC1A_VITAL of DFC1A is
   for VITAL_ACT
   end for;
end CFG_DFC1A_VITAL;


----- CELL DFC1A_CC -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity DFC1A_CC is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLR_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_CLR_CLK_noedge_negedge                  :	VitalDelayType := 0.000 ns;
      trecovery_CLR_CLK_negedge_negedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_negedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLR_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFC1A_CC : entity is TRUE;
end DFC1A_CC;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL_ACT of DFC1A_CC is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLR_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (CLR_ipd, CLR, tipd_CLR);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, CLK_ipd, CLR_ipd)

   -- timing check results
   VARIABLE Tviol_D_CLK_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_CLR_CLK_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_CLR_CLK_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE Pviol_CLR	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLR	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE D_delayed : STD_ULOGIC := 'X';
   VARIABLE CLK_delayed : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   CONSTANT L : VitalTableSymbolType := '0';
   CONSTANT H : VitalTableSymbolType := '1';
   CONSTANT x : VitalTableSymbolType := '-';
   CONSTANT S : VitalTableSymbolType := 'S';
   CONSTANT R : VitalTableSymbolType := '/';
   CONSTANT U : VitalTableSymbolType := 'X';
   CONSTANT V : VitalTableSymbolType := 'B'; -- valid clock signal (non-rising)

   CONSTANT DFC1_Q_tab : VitalStateTableType := (
    ( L,  L,  H,  x,  x,  L ),
    ( L,  H,  H,  L,  x,  H ),
    ( H,  x,  x,  L,  x,  S ),
    ( x,  x,  L,  L,  x,  S ),
    ( x,  x,  x,  H,  x,  L ),
    ( x,  x,  x,  U,  L,  L ));

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_negedge,
          TimingData              => Tmkr_D_CLK_negedge,
          TestSignal              => D_ipd,
          TestSignalName          => "D",
          TestDelay               => 0 ns,
          RefSignal               => CLK_ipd,
          RefSignalName          => "CLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_D_CLK_noedge_negedge,
          SetupLow                => tsetup_D_CLK_noedge_negedge,
          HoldHigh                => thold_D_CLK_noedge_negedge,
          HoldLow                 => thold_D_CLK_noedge_negedge,
          CheckEnabled            => 
                           TO_X01(CLR_ipd ) /= '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DFC1A_CC",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_CLR_CLK_negedge,
          TimingData              => Tmkr_CLR_CLK_negedge,
          TestSignal              => CLR_ipd,
          TestSignalName          => "CLR",
          TestDelay               => 0 ns,
          RefSignal               => CLK_ipd,
          RefSignalName          => "CLK",
          RefDelay                => 0 ns,
          Recovery                => trecovery_CLR_CLK_negedge_negedge,
          Removal                 => thold_CLR_CLK_noedge_negedge,
          ActiveLow               => FALSE,
          CheckEnabled            => 
                           TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DFC1A_CC",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK,
          PeriodData              => PInfo_CLK,
          TestSignal              => CLK_ipd,
          TestSignalName          => "CLK",
          TestDelay               => 0 ns,
          Period                  => tperiod_CLK_negedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => tpw_CLK_negedge,
          CheckEnabled            => 
                           TO_X01(CLR_ipd ) /= '1',
          HeaderMsg               => InstancePath &"/DFC1A_CC",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLR,
          PeriodData              => PInfo_CLR,
          TestSignal              => CLR_ipd,
          TestSignalName          => "CLR",
          TestDelay               => 0 ns,
          Period                  => 0 ns,
          PulseWidthHigh          => tpw_CLR_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TRUE,
          HeaderMsg               => InstancePath &"/DFC1A_CC",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_negedge or Tviol_CLR_CLK_negedge or Pviol_CLR or Pviol_CLK;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => DFC1_Q_tab,
        DataIn => (
               CLK_ipd, D_delayed, CLK_delayed, CLR_ipd));
      Q_zd := Violation XOR Q_zd;
      D_delayed := D_ipd;
      CLK_delayed := CLK_ipd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (CLR_ipd'last_event, tpd_CLR_Q, TRUE),
                 1 => (CLK_ipd'last_event, tpd_CLK_Q, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_DFC1A_CC_VITAL of DFC1A_CC is
   for VITAL_ACT
   end for;
end CFG_DFC1A_CC_VITAL;


----- CELL DFC1B -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity DFC1B is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLR_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_CLR_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      trecovery_CLR_CLK_posedge_posedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tpw_CLR_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFC1B : entity is TRUE;
end DFC1B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL_ACT of DFC1B is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLR_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (CLR_ipd, CLR, tipd_CLR);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, CLK_ipd, CLR_ipd)

   -- timing check results
   VARIABLE Tviol_D_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_CLR_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_CLR_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE Pviol_CLR	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLR	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE D_delayed : STD_ULOGIC := 'X';
   VARIABLE CLK_delayed : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   CONSTANT L : VitalTableSymbolType := '0';
   CONSTANT H : VitalTableSymbolType := '1';
   CONSTANT x : VitalTableSymbolType := '-';
   CONSTANT S : VitalTableSymbolType := 'S';
   CONSTANT R : VitalTableSymbolType := '/';
   CONSTANT U : VitalTableSymbolType := 'X';
   CONSTANT V : VitalTableSymbolType := 'B'; -- valid clock signal (non-rising)

   CONSTANT DFC1B_Q_tab : VitalStateTableType := (
    ( L,  x,  x,  x,  x,  L ),
    ( H,  L,  H,  H,  x,  H ),
    ( H,  H,  x,  x,  x,  S ),
    ( H,  x,  x,  L,  x,  S ),
    ( x,  L,  L,  H,  x,  L ),
    ( U,  x,  x,  x,  L,  L ));

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_posedge,
          TimingData              => Tmkr_D_CLK_posedge,
          TestSignal              => D_ipd,
          TestSignalName          => "D",
          TestDelay               => 0 ns,
          RefSignal               => CLK_ipd,
          RefSignalName          => "CLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01((NOT CLR_ipd) ) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFC1B",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_CLR_CLK_posedge,
          TimingData              => Tmkr_CLR_CLK_posedge,
          TestSignal              => CLR_ipd,
          TestSignalName          => "CLR",
          TestDelay               => 0 ns,
          RefSignal               => CLK_ipd,
          RefSignalName          => "CLK",
          RefDelay                => 0 ns,
          Recovery                => trecovery_CLR_CLK_posedge_posedge,
          Removal                 => thold_CLR_CLK_noedge_posedge,
          ActiveLow               => TRUE,
          CheckEnabled            => 
                           TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFC1B",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK,
          PeriodData              => PInfo_CLK,
          TestSignal              => CLK_ipd,
          TestSignalName          => "CLK",
          TestDelay               => 0 ns,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => tpw_CLK_negedge,
          CheckEnabled            => 
                           TO_X01((NOT CLR_ipd) ) /= '1',
          HeaderMsg               => InstancePath &"/DFC1B",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLR,
          PeriodData              => PInfo_CLR,
          TestSignal              => CLR_ipd,
          TestSignalName          => "CLR",
          TestDelay               => 0 ns,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_CLR_negedge,
          CheckEnabled            => 
                           TRUE,
          HeaderMsg               => InstancePath &"/DFC1B",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_posedge or Tviol_CLR_CLK_posedge or Pviol_CLK or Pviol_CLR;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => DFC1B_Q_tab,
        DataIn => (
               CLR_ipd, CLK_delayed, D_delayed, CLK_ipd));
      Q_zd := Violation XOR Q_zd;
      D_delayed := D_ipd;
      CLK_delayed := CLK_ipd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (CLR_ipd'last_event, tpd_CLR_Q, TRUE),
                 1 => (CLK_ipd'last_event, tpd_CLK_Q, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_DFC1B_VITAL of DFC1B is
   for VITAL_ACT
   end for;
end CFG_DFC1B_VITAL;


----- CELL DFC1B_CC -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity DFC1B_CC is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLR_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_CLR_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      trecovery_CLR_CLK_posedge_posedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tpw_CLR_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFC1B_CC : entity is TRUE;
end DFC1B_CC;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL_ACT of DFC1B_CC is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLR_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (CLR_ipd, CLR, tipd_CLR);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, CLK_ipd, CLR_ipd)

   -- timing check results
   VARIABLE Tviol_D_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_CLR_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_CLR_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE Pviol_CLR	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLR	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE D_delayed : STD_ULOGIC := 'X';
   VARIABLE CLK_delayed : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   CONSTANT L : VitalTableSymbolType := '0';
   CONSTANT H : VitalTableSymbolType := '1';
   CONSTANT x : VitalTableSymbolType := '-';
   CONSTANT S : VitalTableSymbolType := 'S';
   CONSTANT R : VitalTableSymbolType := '/';
   CONSTANT U : VitalTableSymbolType := 'X';
   CONSTANT V : VitalTableSymbolType := 'B'; -- valid clock signal (non-rising)

   CONSTANT DFC1B_CC_Q_tab : VitalStateTableType := (
    ( L,  x,  x,  x,  x,  L ),
    ( H,  L,  H,  H,  x,  H ),
    ( H,  H,  x,  x,  x,  S ),
    ( H,  x,  x,  L,  x,  S ),
    ( x,  L,  L,  H,  x,  L ),
    ( U,  x,  x,  x,  L,  L ));

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_posedge,
          TimingData              => Tmkr_D_CLK_posedge,
          TestSignal              => D_ipd,
          TestSignalName          => "D",
          TestDelay               => 0 ns,
          RefSignal               => CLK_ipd,
          RefSignalName          => "CLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01((NOT CLR_ipd) ) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFC1B_CC",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_CLR_CLK_posedge,
          TimingData              => Tmkr_CLR_CLK_posedge,
          TestSignal              => CLR_ipd,
          TestSignalName          => "CLR",
          TestDelay               => 0 ns,
          RefSignal               => CLK_ipd,
          RefSignalName          => "CLK",
          RefDelay                => 0 ns,
          Recovery                => trecovery_CLR_CLK_posedge_posedge,
          Removal                 => thold_CLR_CLK_noedge_posedge,
          ActiveLow               => TRUE,
          CheckEnabled            => 
                           TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFC1B_CC",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK,
          PeriodData              => PInfo_CLK,
          TestSignal              => CLK_ipd,
          TestSignalName          => "CLK",
          TestDelay               => 0 ns,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => tpw_CLK_negedge,
          CheckEnabled            => 
                           TO_X01((NOT CLR_ipd) ) /= '1',
          HeaderMsg               => InstancePath &"/DFC1B_CC",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLR,
          PeriodData              => PInfo_CLR,
          TestSignal              => CLR_ipd,
          TestSignalName          => "CLR",
          TestDelay               => 0 ns,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_CLR_negedge,
          CheckEnabled            => 
                           TRUE,
          HeaderMsg               => InstancePath &"/DFC1B_CC",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_posedge or Tviol_CLR_CLK_posedge or Pviol_CLK or Pviol_CLR;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => DFC1B_CC_Q_tab,
        DataIn => (
               CLR_ipd, CLK_delayed, D_delayed, CLK_ipd));
      Q_zd := Violation XOR Q_zd;
      D_delayed := D_ipd;
      CLK_delayed := CLK_ipd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (CLR_ipd'last_event, tpd_CLR_Q, TRUE),
                 1 => (CLK_ipd'last_event, tpd_CLK_Q, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_DFC1B_CC_VITAL of DFC1B_CC is
   for VITAL_ACT
   end for;
end CFG_DFC1B_CC_VITAL;


----- CELL DFC1D -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity DFC1D is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLR_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_CLR_CLK_noedge_negedge                  :	VitalDelayType := 0.000 ns;
      trecovery_CLR_CLK_posedge_negedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_negedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tpw_CLR_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFC1D : entity is TRUE;
end DFC1D;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL_ACT of DFC1D is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLR_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (CLR_ipd, CLR, tipd_CLR);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, CLK_ipd, CLR_ipd)

   -- timing check results
   VARIABLE Tviol_D_CLK_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_CLR_CLK_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_CLR_CLK_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE Pviol_CLR	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLR	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE D_delayed : STD_ULOGIC := 'X';
   VARIABLE CLK_delayed : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   CONSTANT L : VitalTableSymbolType := '0';
   CONSTANT H : VitalTableSymbolType := '1';
   CONSTANT x : VitalTableSymbolType := '-';
   CONSTANT S : VitalTableSymbolType := 'S';
   CONSTANT R : VitalTableSymbolType := '/';
   CONSTANT U : VitalTableSymbolType := 'X';
   CONSTANT V : VitalTableSymbolType := 'B'; -- valid clock signal (non-rising)

   CONSTANT DFC1B_Q_tab : VitalStateTableType := (
    ( L,  x,  x,  x,  x,  L ),
    ( H,  L,  H,  H,  x,  H ),
    ( H,  H,  x,  x,  x,  S ),
    ( H,  x,  x,  L,  x,  S ),
    ( x,  L,  L,  H,  x,  L ),
    ( U,  x,  x,  x,  L,  L ));

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_negedge,
          TimingData              => Tmkr_D_CLK_negedge,
          TestSignal              => D_ipd,
          TestSignalName          => "D",
          TestDelay               => 0 ns,
          RefSignal               => CLK_ipd,
          RefSignalName          => "CLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_D_CLK_noedge_negedge,
          SetupLow                => tsetup_D_CLK_noedge_negedge,
          HoldHigh                => thold_D_CLK_noedge_negedge,
          HoldLow                 => thold_D_CLK_noedge_negedge,
          CheckEnabled            => 
                           TO_X01((NOT CLR_ipd) ) /= '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DFC1D",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_CLR_CLK_negedge,
          TimingData              => Tmkr_CLR_CLK_negedge,
          TestSignal              => CLR_ipd,
          TestSignalName          => "CLR",
          TestDelay               => 0 ns,
          RefSignal               => CLK_ipd,
          RefSignalName          => "CLK",
          RefDelay                => 0 ns,
          Recovery                => trecovery_CLR_CLK_posedge_negedge,
          Removal                 => thold_CLR_CLK_noedge_negedge,
          ActiveLow               => TRUE,
          CheckEnabled            => 
                           TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DFC1D",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK,
          PeriodData              => PInfo_CLK,
          TestSignal              => CLK_ipd,
          TestSignalName          => "CLK",
          TestDelay               => 0 ns,
          Period                  => tperiod_CLK_negedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => tpw_CLK_negedge,
          CheckEnabled            => 
                           TO_X01((NOT CLR_ipd) ) /= '1',
          HeaderMsg               => InstancePath &"/DFC1D",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLR,
          PeriodData              => PInfo_CLR,
          TestSignal              => CLR_ipd,
          TestSignalName          => "CLR",
          TestDelay               => 0 ns,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_CLR_negedge,
          CheckEnabled            => 
                           TRUE,
          HeaderMsg               => InstancePath &"/DFC1D",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_negedge or Tviol_CLR_CLK_negedge or Pviol_CLR or Pviol_CLK;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => DFC1B_Q_tab,
        DataIn => (
               CLR_ipd, CLK_ipd, D_delayed, CLK_delayed));
      Q_zd := Violation XOR Q_zd;
      D_delayed := D_ipd;
      CLK_delayed := CLK_ipd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (CLR_ipd'last_event, tpd_CLR_Q, TRUE),
                 1 => (CLK_ipd'last_event, tpd_CLK_Q, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_DFC1D_VITAL of DFC1D is
   for VITAL_ACT
   end for;
end CFG_DFC1D_VITAL;


----- CELL DFC1D_CC -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity DFC1D_CC is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLR_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_negedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_negedge                   :	VitalDelayType := 0.000 ns;
      thold_CLR_CLK_noedge_negedge                  :	VitalDelayType := 0.000 ns;
      trecovery_CLR_CLK_posedge_negedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_negedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tpw_CLR_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFC1D_CC : entity is TRUE;
end DFC1D_CC;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL_ACT of DFC1D_CC is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLR_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (CLR_ipd, CLR, tipd_CLR);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, CLK_ipd, CLR_ipd)

   -- timing check results
   VARIABLE Tviol_D_CLK_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_CLR_CLK_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_CLR_CLK_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE Pviol_CLR	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLR	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE D_delayed : STD_ULOGIC := 'X';
   VARIABLE CLK_delayed : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   CONSTANT L : VitalTableSymbolType := '0';
   CONSTANT H : VitalTableSymbolType := '1';
   CONSTANT x : VitalTableSymbolType := '-';
   CONSTANT S : VitalTableSymbolType := 'S';
   CONSTANT R : VitalTableSymbolType := '/';
   CONSTANT U : VitalTableSymbolType := 'X';
   CONSTANT V : VitalTableSymbolType := 'B'; -- valid clock signal (non-rising)

   CONSTANT DFC1B_Q_tab : VitalStateTableType := (
    ( L,  x,  x,  x,  x,  L ),
    ( H,  L,  H,  H,  x,  H ),
    ( H,  H,  x,  x,  x,  S ),
    ( H,  x,  x,  L,  x,  S ),
    ( x,  L,  L,  H,  x,  L ),
    ( U,  x,  x,  x,  L,  L ));


   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_negedge,
          TimingData              => Tmkr_D_CLK_negedge,
          TestSignal              => D_ipd,
          TestSignalName          => "D",
          TestDelay               => 0 ns,
          RefSignal               => CLK_ipd,
          RefSignalName          => "CLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_D_CLK_noedge_negedge,
          SetupLow                => tsetup_D_CLK_noedge_negedge,
          HoldHigh                => thold_D_CLK_noedge_negedge,
          HoldLow                 => thold_D_CLK_noedge_negedge,
          CheckEnabled            => 
                           TO_X01((NOT CLR_ipd) ) /= '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DFC1D_CC",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_CLR_CLK_negedge,
          TimingData              => Tmkr_CLR_CLK_negedge,
          TestSignal              => CLR_ipd,
          TestSignalName          => "CLR",
          TestDelay               => 0 ns,
          RefSignal               => CLK_ipd,
          RefSignalName          => "CLK",
          RefDelay                => 0 ns,
          Recovery                => trecovery_CLR_CLK_posedge_negedge,
          Removal                 => thold_CLR_CLK_noedge_negedge,
          ActiveLow               => TRUE,
          CheckEnabled            => 
                           TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DFC1D_CC",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK,
          PeriodData              => PInfo_CLK,
          TestSignal              => CLK_ipd,
          TestSignalName          => "CLK",
          TestDelay               => 0 ns,
          Period                  => tperiod_CLK_negedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => tpw_CLK_negedge,
          CheckEnabled            => 
                           TO_X01((NOT CLR_ipd) ) /= '1',
          HeaderMsg               => InstancePath &"/DFC1D_CC",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLR,
          PeriodData              => PInfo_CLR,
          TestSignal              => CLR_ipd,
          TestSignalName          => "CLR",
          TestDelay               => 0 ns,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_CLR_negedge,
          CheckEnabled            => 
                           TRUE,
          HeaderMsg               => InstancePath &"/DFC1D_CC",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_negedge or Tviol_CLR_CLK_negedge or Pviol_CLR or Pviol_CLK;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => DFC1B_Q_tab,
        DataIn => (
               CLR_ipd, CLK_ipd, D_delayed, CLK_delayed));
      Q_zd := Violation XOR Q_zd;
      D_delayed := D_ipd;
      CLK_delayed := CLK_ipd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (CLR_ipd'last_event, tpd_CLR_Q, TRUE),
                 1 => (CLK_ipd'last_event, tpd_CLK_Q, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL_ACT;

configuration CFG_DFC1D_CC_VITAL of DFC1D_CC is
   for VITAL_ACT
   end for;
end CFG_DFC1D_CC_VITAL;


----- CELL DFC1E -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity DFC1E is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CLR_QN                     :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      tpd_CLK_QN                     :	VitalDelayType01 := (1.000 ns, 1.000 ns);
      thold_D_CLK_noedge_posedge                    :	VitalDelayType := 0.000 ns;
      tsetup_D_CLK_noedge_posedge                   :	VitalDelayType := 0.000 ns;
      thold_CLR_CLK_noedge_posedge                  :	VitalDelayType := 0.000 ns;
      trecovery_CLR_CLK_posedge_posedge              :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      tpw_CLR_negedge                :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      CLR                            :	in    STD_ULOGIC;
      QN                             :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFC1E : entity is TRUE;
end DFC1E;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL_ACT of DFC1E is
   attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLR_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (CLR_ipd, CLR, tipd_CLR);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, CLK_ipd, CLR_ipd)

   -- timing check results
   VARIABLE Tviol_D_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_CLR_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_CLR_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE Pviol_CLR	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLR	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_QN : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE D_delayed : STD_ULOGIC := 'X';
   VARIABLE CLK_delayed : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS QN_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE QN_GlitchData	: VitalGlitchDataType;

   CONSTANT L : VitalTableSymbolType := '0';
   CONSTANT H : VitalTableSymbolType := '1';
   CONSTANT x : VitalTableSymbolType := '-';
   CONSTANT S : VitalTableSymbolType := 'S';
   CONSTANT R : VitalTableSymbolType := '/';
   CONSTANT U : VitalTableSymbolType := 'X';
   CONSTANT V : VitalTableSymbolType := 'B'; -- valid clock signal (non-rising)

   CONSTANT DFC1E_QN_tab : VitalStateTableType := (
    ( L,  H,  H,  H,  x,  L ),
    ( L,  x,  L,  H,  x,  H ),
    ( H,  H,  x,  x,  x,  S ),
    ( x,  L,  x,  x,  x,  H ),
    ( x,  H,  x,  L,  x,  S ),
    ( x,  U,  x,  x,  H,  H ));

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_posedge,
          TimingData              => Tmkr_D_CLK_posedge,
          TestSignal              => D_ipd,
          TestSignalName          => "D",
          TestDelay               => 0 ns,
          RefSignal               => CLK_ipd,
          RefSignalName          => "CLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01((NOT C